/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class RemoteServiceAccessPointInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
            String expValue = null;
            if (null != expectedValues) {
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                expValue = (String)expectedValues.get("Name");
            }
            for (RMIObjectMapping device : devices) {
                CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
                if (null != expValue && !expValue.equals(ci.getPropertyValue("Name"))) continue;
                if (null != refInfo) {
                    refInfo.addReference(iter, ci.getObjectPath());
                    continue;
                }
                if (isObjectPath) {
                    iter.add(ci.getObjectPath());
                    continue;
                }
                iter.add(ci);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String URL2 = "http://" + op.getHost() + ":22015/DeviceManagerWebService/index.jsp";
        CIMProperty[] keys = retOP.getKeys();
        String sysName = rmiObj.getSMISMappingContainer().getStorageSystemName();
        CIMProperty[] props = new CIMProperty[]{keys[0], keys[1], keys[2], keys[3], new CIMProperty("AccessInfo", CIMDataType.STRING_T, (Object)URL2, false), new CIMProperty("InfoFormat", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(200), false), new CIMProperty("EnabledState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("RequestedState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWELVE, false), new CIMProperty("EnabledDefault", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)new String[]{"OK"}, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_FIVE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)sysName, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)sysName, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)sysName, false)};
        return new CIMInstance(retOP, props).filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_RemoteServiceAccessPoint");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String key = rmiObj.getSMISMappingContainer().getMgtConsoleName();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("Name", CIMDataType.STRING_T, (Object)key, true), new CIMProperty("CreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_RemoteServiceAccessPoint", true), new CIMProperty("SystemCreationClassName", CIMDataType.STRING_T, (Object)"HITACHI_StorageSystem", true), new CIMProperty("SystemName", CIMDataType.STRING_T, (Object)rmiObj.getSMISMappingContainer().getStorageSystemName(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_RemoteServiceAccessPoint", keys);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "SystemName");
        try {
            CIMInstance ci = this.generateInstance(op, propertyList, device.getRMIObject());
            if (op.equalsModelPath(ci.getObjectPath())) {
                return ci;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

