/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.ReplicationServiceInstrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMArgument;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;

public class ReplicationServiceCapabilitiesInstrumentation
extends BaseInstrumentation {
    private static final UnsignedInteger16[] SYNC_ASYNC_ACTIONS = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_FIVE};

    private String createInstanceID(RMIObjectCache rmiObj) throws Exception {
        StringBuilder ret = new StringBuilder(rmiObj.getSMISMappingContainer().getStorageSystemName());
        return ret.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues);
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private Object extrinsic_convertSyncTypeToReplicationType(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        UnsignedInteger32 ret = null;
        UnsignedInteger16 localOrRemote = null;
        UnsignedInteger16 mode = null;
        UnsignedInteger16 syncType = null;
        for (int x = 0; x < inArgs.length && ret == null; ++x) {
            CIMArgument<?> arg = inArgs[x];
            String argName = arg.getName();
            if (argName.equals("LocalOrRemote")) {
                localOrRemote = (UnsignedInteger16)arg.getValue();
            } else if (argName.equals("Mode")) {
                mode = (UnsignedInteger16)arg.getValue();
            }
            if (!argName.equals("SyncType")) continue;
            syncType = (UnsignedInteger16)arg.getValue();
        }
        if (localOrRemote == null || localOrRemote.intValue() != 2) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("LocalOrRemote has value " + localOrRemote + " but this method requires a value of 2");
        } else if (mode == null || mode.intValue() != 2) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("Mode has value " + mode + " but this method requires a value of 2");
        } else if (syncType == null || syncType.intValue() != 7) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("SyncType has value " + syncType + " but this method requires a value of 7");
        }
        if (ret == null) {
            CIMArgument outVal = new CIMArgument("SupportedReplicationTypes", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_SIX);
            if (outArgs != null && outArgs.length > 0) {
                outArgs[0] = outVal;
                ret = ProviderConstants.UINT32_ZED;
            } else {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.severe("invalid out arguments in ConvertReplicationTypeToSyncType, outArgs:\n" + Arrays.toString(outArgs));
            }
        }
        return ret;
    }

    private Object extrinsic_convetReplicationTypeToSyncType(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = null;
        UnsignedInteger16 replicationType = null;
        for (int x = 0; x < inArgs.length && ret == null; ++x) {
            CIMArgument<?> arg = inArgs[x];
            if (!arg.getName().equals("ReplicationType")) continue;
            replicationType = (UnsignedInteger16)arg.getValue();
        }
        if (replicationType == null || replicationType.intValue() != 6) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("ReplicationType has value " + replicationType + " but this method requires a value of 6");
        }
        if (ret == null) {
            if (outArgs != null && outArgs.length >= 3) {
                outArgs[0] = new CIMArgument("SyncType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_SEVEN);
                outArgs[1] = new CIMArgument("Mode", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO);
                outArgs[2] = new CIMArgument("LocalOrRemote", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO);
                ret = ProviderConstants.UINT32_ZED;
            } else {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.severe("invalid out arguments in ConvertSyncTypeToReplicationType, outArgs:\n" + Arrays.toString(outArgs));
            }
        }
        return ret;
    }

    private Object extrinsic_getSupportedCompressionFeatures(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        outArgs[0] = new CIMArgument("SupportedStorageCompressionFeatures", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_ONE});
        return ProviderConstants.UINT16_ZED;
    }

    private Object extrinsic_getSupportedCopyStates(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = null;
        UnsignedInteger16 replicationType = null;
        for (int x = 0; x < inArgs.length && ret == null; ++x) {
            CIMArgument<?> arg = inArgs[x];
            if (!arg.getName().equals("ReplicationType")) continue;
            replicationType = (UnsignedInteger16)arg.getValue();
        }
        if (replicationType == null || replicationType.intValue() != 6) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("ReplicationType has value " + replicationType + " but this method requires a value of 6");
        }
        if (ret == null) {
            if (outArgs != null && outArgs.length >= 2) {
                outArgs[0] = new CIMArgument("SupportedCopyStates", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO, ProviderConstants.UINT16_THREE, ProviderConstants.UINT16_FOUR, ProviderConstants.UINT16_FIVE});
                outArgs[1] = new CIMArgument("HostAccessible", CIMDataType.BOOLEAN_ARRAY_T, (Object)new Boolean[]{false, false, true, false});
                ret = ProviderConstants.UINT32_ZED;
            } else {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.severe("invalid out arguments in GetSupportedCopyStates, outArgs:\n" + Arrays.toString(outArgs));
            }
        }
        return ret;
    }

    private Object extrinsic_getSupportedFeatures(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = null;
        UnsignedInteger16 replicationType = null;
        for (int x = 0; x < inArgs.length && ret == null; ++x) {
            CIMArgument<?> arg = inArgs[x];
            if (!arg.getName().equals("ReplicationType")) continue;
            replicationType = (UnsignedInteger16)arg.getValue();
        }
        if (replicationType == null || replicationType.intValue() != 7) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("ReplicationType has value " + replicationType + " but this method requires a value of 6");
        }
        if (ret == null) {
            if (outArgs != null && outArgs.length >= 1) {
                outArgs[0] = new CIMArgument("Features", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_NINE, ProviderConstants.UINT16_TWELVE});
                ret = ProviderConstants.UINT32_ZED;
            } else {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.severe("invalid out arguments in GetSupportedFeatures, outArgs:\n" + Arrays.toString(outArgs));
            }
        }
        return ret;
    }

    private Object extrinsic_getSupportedOperations(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) {
        UnsignedInteger32 ret = null;
        UnsignedInteger16 replicationtype = null;
        for (int x = 0; x < inArgs.length && ret == null; ++x) {
            CIMArgument<?> arg = inArgs[x];
            if (!arg.getName().equals("ReplicationType")) continue;
            replicationtype = (UnsignedInteger16)arg.getValue();
        }
        if (replicationtype == null || replicationtype.intValue() != 7) {
            ret = ProviderConstants.UINT32_FIVE;
            mLogger.severe("ReplicationType has value " + replicationtype + " but this method requires a value of 7");
        }
        if (ret == null) {
            if (outArgs != null && outArgs.length >= 1) {
                outArgs[0] = new CIMArgument("SupportedOperations", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{new UnsignedInteger16(19)});
                ret = ProviderConstants.UINT32_ZED;
            } else {
                ret = ProviderConstants.UINT32_FIVE;
                mLogger.severe("invalid out arguments in GetSupportedOperations, outArgs:\n" + Arrays.toString(outArgs));
            }
        }
        return ret;
    }

    private Object extrinsic_getSynchronizationSupported(CIMObjectPath op, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        DeviceNumber localDN = null;
        DeviceNumber otherDN = null;
        int methodName = -1;
        for (CIMArgument<?> arg : inArgs) {
            UnsignedInteger16 meth;
            CIMObjectPath obj;
            if (arg.getName().equalsIgnoreCase("LocalElement")) {
                obj = (CIMObjectPath)arg.getValue();
                try {
                    localDN = ProviderLibs.getDeviceNumberFromOP(obj);
                    if (null != localDN) continue;
                    mLogger.log(Level.SEVERE, "Could not find Volume for LocalElement: {0}", obj);
                    return ProviderConstants.UINT32_FIVE;
                }
                catch (WBEMException we) {
                    mLogger.log(Level.SEVERE, "Error getting Volume for LocalElement: " + obj, we);
                    return ProviderConstants.UINT32_FOUR;
                }
                catch (Throwable t) {
                    while (null != t.getCause()) {
                        t = t.getCause();
                    }
                    mLogger.log(Level.SEVERE, "Unexpected error getting Volume for LocalElement: " + obj, t);
                    return ProviderConstants.UINT32_FOUR;
                }
            }
            if (arg.getName().equalsIgnoreCase("OtherElement")) {
                obj = (CIMObjectPath)arg.getValue();
                try {
                    otherDN = ProviderLibs.getDeviceNumberFromOP(obj);
                    if (null != otherDN) continue;
                    mLogger.log(Level.SEVERE, "Could not find Volume for OtherElement: {0}", obj);
                    return ProviderConstants.UINT32_FIVE;
                }
                catch (WBEMException we) {
                    mLogger.log(Level.SEVERE, "Error getting Volume for OtherElement: " + obj, we);
                    return ProviderConstants.UINT32_FOUR;
                }
                catch (Throwable t) {
                    while (null != t.getCause()) {
                        t = t.getCause();
                    }
                    mLogger.log(Level.SEVERE, "Unexpected error getting Volume for OtherElement: " + obj, t);
                    return ProviderConstants.UINT32_FOUR;
                }
            }
            if (!arg.getName().equalsIgnoreCase("MethodName") || 2 == (methodName = (meth = (UnsignedInteger16)arg.getValue()).intValue())) continue;
            mLogger.log(Level.SEVERE, "'MethodName' must be 2 but was {0}", methodName);
            return ProviderConstants.UINT32_FIVE;
        }
        if (null == localDN) {
            mLogger.log(Level.SEVERE, "'LocalElement' can not be null");
            return ProviderConstants.UINT32_FIVE;
        }
        if (-1 == methodName && null == otherDN) {
            mLogger.log(Level.SEVERE, "Must specify 'OtherElement' if 'MethodName' is not specified");
            return ProviderConstants.UINT32_FIVE;
        }
        ArrayList out = new ArrayList();
        out.add(new CIMArgument("Modes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}));
        if (null == otherDN || otherDN.isQSVvol() || localDN.isQSVvol()) {
            ret = this.handleNormalPair(localDN, otherDN, out);
        } else if (!localDN.isQSVvol() && !otherDN.isQSVvol() && (localDN.isAOUVol() || otherDN.isAOUVol())) {
            ret = this.handleSnapOnSnapOrFastClone(localDN, otherDN, out);
        } else {
            mLogger.log(Level.SEVERE, "'LocalElement' or 'OtherElement' must be a Snapshot or DP V-Vol{0}Local:{1}{0}Other:", new Object[]{System.lineSeparator(), localDN, otherDN});
            ret = ProviderConstants.UINT32_FIVE;
        }
        if (ProviderConstants.UINT32_ZED.equals((Object)ret)) {
            System.arraycopy(out.toArray(new CIMArgument[out.size()]), 0, outArgs, 0, out.size());
        }
        return ret;
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        CIMProperty[] keys = retOP.getKeys();
        String RepSrvcStr = "HITACHI_ReplicationServiceCapabilities".substring("HITACHI_".length());
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("SupportedSynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[0], false), new CIMProperty("SupportedAsynchronousActions", CIMDataType.UINT16_ARRAY_T, (Object)SYNC_ASYNC_ACTIONS, false), new CIMProperty("SupportedReplicationTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_SIX, ProviderConstants.UINT16_TEN}, false), new CIMProperty("SupportedStorageObjects", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_TWO}, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)RepSrvcStr, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)RepSrvcStr, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)RepSrvcStr, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_ReplicationServiceCapabilities");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String instID = this.createInstanceID(rmiObj);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ReplicationServiceCapabilities", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            CIMInstance ret = this.generateInstance(op, null, device.getRMIObject());
            String thisInstID = (String)ret.getPropertyValue("InstanceID");
            String otherInstID = (String)op.getKey("InstanceID").getValue();
            if (thisInstID.equalsIgnoreCase(otherInstID)) {
                return ret;
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private UnsignedInteger32 handleNormalPair(DeviceNumber localDN, DeviceNumber otherDN, List<CIMArgument<?>> out) throws WBEMException {
        int isValid;
        UnsignedInteger32 ret = ProviderConstants.UINT32_ZED;
        try {
            if (localDN.isQSVvol() && (null == otherDN || !otherDN.isQSVvol())) {
                if (localDN.hasPaths() && (null == otherDN || otherDN.hasPaths())) {
                    isValid = 0;
                } else {
                    mLogger.log(Level.SEVERE, "{0} returned error {1} (\"Invalid_Parameter\") because the {2} does not have any paths", new Object[]{"GetSynchronizationSupported", 5, localDN.hasPaths() ? "OtherElement" : "LocalElement"});
                    isValid = 5;
                }
            } else {
                isValid = ReplicationServiceInstrumentation.validateSourceElement(localDN, 0 == localDN.getVolType() ? true : (null == otherDN ? false : otherDN.isQSVvol()), "GetSynchronizationSupported");
            }
        }
        catch (Exception e) {
            isValid = 5;
            mLogger.log(Level.SEVERE, "Exception determining if DN (" + localDN.getDn() + ") is a valid source volume", e);
        }
        if (0 == isValid) {
            if (null != otherDN && !this.isNormalTargetCandidate(localDN.isQSVvol() ? localDN : otherDN, localDN.isQSVvol() ? otherDN : localDN)) {
                mLogger.log(Level.SEVERE, "LocalElment, \"{0}\", is a {1} but OtherElement, \"{2}\", is not a {3}", new Object[]{localDN.getDn(), localDN.isQSVvol() ? "target" : "source", otherDN.getDn(), !otherDN.isQSVvol() ? "source" : "target"});
                ret = ProviderConstants.UINT32_FIVE;
            } else {
                out.add(new CIMArgument("LocalElementRole", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{!localDN.isQSVvol() ? ProviderConstants.UINT16_TWO : ProviderConstants.UINT16_THREE}));
                UnsignedInteger16[] syncTypes = !localDN.isAOUVol() ? new UnsignedInteger16[]{ProviderConstants.UINT16_SEVEN} : (localDN.hasPaths() ? (null == otherDN ? new UnsignedInteger16[]{ProviderConstants.UINT16_SEVEN, ProviderConstants.UINT16_EIGHT} : (otherDN.isQSVvol() ? new UnsignedInteger16[]{ProviderConstants.UINT16_SEVEN} : new UnsignedInteger16[]{ProviderConstants.UINT16_EIGHT})) : new UnsignedInteger16[]{ProviderConstants.UINT16_EIGHT});
                out.add(new CIMArgument("SyncTypes", CIMDataType.UINT16_ARRAY_T, (Object)syncTypes));
            }
        } else if (this.isNormalTargetCandidate(localDN, null)) {
            if (null != otherDN && !otherDN.isTargetCandidate()) {
                mLogger.log(Level.SEVERE, "LocalElment, {0}, is a target but OtherElement, {1}, is not a source", new Object[]{localDN.getDn(), otherDN.getDn()});
                ret = ProviderConstants.UINT32_FIVE;
            } else {
                out.add(new CIMArgument("LocalElementRole", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_THREE}));
            }
        } else {
            mLogger.log(Level.SEVERE, "'LocalElement', {0}, is niether a source or target", localDN.getDn());
            ret = ProviderConstants.UINT32_FIVE;
        }
        return ret;
    }

    private UnsignedInteger32 handleSnapOnSnapOrFastClone(DeviceNumber localDN, DeviceNumber otherDN, List<CIMArgument<?>> out) {
        UnsignedInteger32 ret;
        block11: {
            ret = ProviderConstants.UINT32_FOUR;
            if (otherDN.getDn() != localDN.getDn()) {
                if (otherDN.getNumOfKBytes() == localDN.getNumOfKBytes()) {
                    boolean isUnPaired = true;
                    try {
                        isUnPaired = SnapshotInfo2.isVolumeUnpaired(otherDN, Boolean.FALSE);
                        if (isUnPaired) {
                            UnsignedInteger16[] unsignedInteger16Array;
                            mLogger.log(Level.FINE, "'OtherElement' can be Snap On Snap or FastClone of 'LocalElement' {0}{1}{0}{2}", new Object[]{System.lineSeparator(), otherDN, localDN});
                            if (localDN.isAOUVol() && otherDN.isAOUVol()) {
                                UnsignedInteger16[] unsignedInteger16Array2 = new UnsignedInteger16[2];
                                unsignedInteger16Array2[0] = ProviderConstants.UINT16_TWO;
                                unsignedInteger16Array = unsignedInteger16Array2;
                                unsignedInteger16Array2[1] = ProviderConstants.UINT16_THREE;
                            } else if (localDN.isAOUVol()) {
                                UnsignedInteger16[] unsignedInteger16Array3 = new UnsignedInteger16[1];
                                unsignedInteger16Array = unsignedInteger16Array3;
                                unsignedInteger16Array3[0] = ProviderConstants.UINT16_THREE;
                            } else {
                                UnsignedInteger16[] unsignedInteger16Array4 = new UnsignedInteger16[1];
                                unsignedInteger16Array = unsignedInteger16Array4;
                                unsignedInteger16Array4[0] = ProviderConstants.UINT16_TWO;
                            }
                            out.add(new CIMArgument("LocalElementRole", CIMDataType.UINT16_ARRAY_T, (Object)unsignedInteger16Array));
                            out.add(new CIMArgument("SyncTypes", CIMDataType.UINT16_ARRAY_T, (Object)new UnsignedInteger16[]{ProviderConstants.UINT16_SEVEN, ProviderConstants.UINT16_EIGHT}));
                            ret = ProviderConstants.UINT32_ZED;
                            break block11;
                        }
                        mLogger.log(Level.SEVERE, "'OtherElement' must be unpaired {0}{1}", new Object[]{System.lineSeparator(), otherDN});
                        ret = ProviderConstants.UINT32_FIVE;
                    }
                    catch (WBEMException e) {
                        mLogger.log(Level.SEVERE, "Error determining if 'OtherElement' is already paired{0}{1}", new Object[]{System.lineSeparator(), otherDN});
                        ret = ProviderConstants.UINT32_FOUR;
                    }
                } else {
                    mLogger.log(Level.SEVERE, "'LocalElement' must be the same size as 'OtherElement'{0}{1}{0}{2}", new Object[]{System.lineSeparator(), localDN, otherDN});
                    ret = ProviderConstants.UINT32_FIVE;
                }
            } else {
                mLogger.log(Level.SEVERE, "'LocalElement' can not be the same as 'OtherElement'{0}{1}{0}{2}", new Object[]{System.lineSeparator(), localDN, otherDN});
                ret = ProviderConstants.UINT32_FIVE;
            }
        }
        return ret;
    }

    public Object invokeMethod(CIMObjectPath op, String methodName, CIMArgument<?>[] inArgs, CIMArgument<?>[] outArgs) throws WBEMException {
        Object oRet = null;
        if (inArgs == null || inArgs.length == 0) {
            mLogger.log(Level.WARNING, "input arguments are null or empty");
            return ProviderConstants.UINT32_FIVE;
        }
        if ("ConvertSyncTypeToReplicationType".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_convertSyncTypeToReplicationType(op, inArgs, outArgs);
        } else if ("ConvertReplicationTypeToSyncType".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_convetReplicationTypeToSyncType(op, inArgs, outArgs);
        } else if ("GetSupportedCopyStates".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_getSupportedCopyStates(op, inArgs, outArgs);
        } else if ("GetSupportedFeatures".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_getSupportedFeatures(op, inArgs, outArgs);
        } else if ("GetSupportedOperations".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_getSupportedOperations(op, inArgs, outArgs);
        } else if ("GetSupportedStorageCompressionFeatures".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_getSupportedCompressionFeatures(op, inArgs, outArgs);
        } else if ("GetSynchronizationSupported".equalsIgnoreCase(methodName)) {
            oRet = this.extrinsic_getSynchronizationSupported(op, inArgs, outArgs);
        } else {
            throw new WBEMException(17, "HITACHI_ReplicationServiceCapabilities doesn't know the method: " + methodName);
        }
        return oRet;
    }

    private boolean isNormalTargetCandidate(DeviceNumber targetDN, DeviceNumber sourceDN) {
        boolean ret = false;
        try {
            boolean isQSVvol = targetDN.isQSVvol();
            boolean hasPaths = targetDN.hasPaths();
            boolean isUnpaired = SnapshotInfo2.isVolumeUnpaired(targetDN, Boolean.TRUE);
            if (isQSVvol && hasPaths && isUnpaired) {
                if (null != sourceDN) {
                    if (sourceDN.hasPaths()) {
                        if (targetDN.getNumOfKBytes() == sourceDN.getNumOfKBytes()) {
                            ret = true;
                        } else {
                            mLogger.log(Level.INFO, "Target volume, {0}, is not the same size as source volume, {1}", new Object[]{targetDN.getDn(), sourceDN.getDn()});
                        }
                    } else {
                        mLogger.log(Level.INFO, "Source volume, {0}, has no LU paths and can not be used.", new Object[]{sourceDN.getDn()});
                    }
                } else {
                    ret = true;
                }
            } else {
                mLogger.log(Level.SEVERE, "Volume, {0}, is not a valid target. isQSVvol: {1}, hasPaths: {2}, isUnpaired: {3}", new Object[]{targetDN.getDn(), isQSVvol, hasPaths, isUnpaired});
            }
        }
        catch (NullPointerException npe) {
            mLogger.log(Level.SEVERE, "Target DN is null", npe);
        }
        catch (WBEMException e) {
            mLogger.log(Level.SEVERE, "Exception determining if DN (" + targetDN.getDn() + ") is a valid target for " + sourceDN, e);
        }
        return ret;
    }
}

