/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class SCSIProtocolEndpointAvailableForImportingProtocolControllerInstrumentation
extends BaseAssocInstrumentation
implements CacheUpdateNotifier {
    protected SCSIProtocolEndpointAvailableForImportingProtocolControllerInstrumentation() {
        super("HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController", "HITACHI_ImportingSCSIProtocolController", "ManagedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportingSCSIProtocolControllerInstrumentation"), "HITACHI_SCSIProtocolEndpoint", "AvailableSAP", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolEndpointInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, boolean shouldTestInst) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instImportingSCSIProtocolController = null;
                    try {
                        instImportingSCSIProtocolController = this.getReference1Instrumentation().getInstance(objectName, propertyList);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instImportingSCSIProtocolController) {
                        CIMObjectPath opSCSIProtocolEndpoint = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                        Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                        expValues.put("ElementName", objectName.getKeyValue("SystemName"));
                        CustomCloseableIterator iterSCSIProtocolEndpoint = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterSCSIProtocolEndpoint, opSCSIProtocolEndpoint, null, null, null, false, false, expValues, null);
                        while (iterSCSIProtocolEndpoint.hasNext()) {
                            CIMInstance instSCSIProtocolEndpoint = (CIMInstance)iterSCSIProtocolEndpoint.next();
                            if (!ProviderConstants.UINT16_TWO.equals(instSCSIProtocolEndpoint.getPropertyValue("Role"))) continue;
                            if (isObjectPath) {
                                iter.add(instSCSIProtocolEndpoint.getObjectPath());
                                continue;
                            }
                            iter.add(instSCSIProtocolEndpoint.filterProperties(propertyList));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMInstance instSCSIProtocolEndpoint = null;
                    try {
                        instSCSIProtocolEndpoint = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instSCSIProtocolEndpoint && new UnsignedInteger16(2).equals(instSCSIProtocolEndpoint.getPropertyValue("Role"))) {
                        if (isObjectPath) {
                            iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                        } else {
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        try {
            CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            FCPort port = (FCPort)pObj;
            if (!ProviderConstants.UINT16_TWO.equals((Object)port.getPortRole())) {
                return;
            }
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
            CIMInstance instImportingSCSIProtocolController = this.getReference1Instrumentation().generateInstance(op, null, device.getRMIObject());
            CIMInstance instSCSIProtocolEndPt = this.getReference2Instrumentation().generateInstance(op, null, pObj);
            CIMInstance sourceInstance = this.generateInstance(op, null, instImportingSCSIProtocolController.getObjectPath(), instSCSIProtocolEndPt.getObjectPath());
            IndicationHelper helper = new IndicationHelper(mHandle);
            CIMInstance indication = helper.createInstCreationInstance(sourceInstance);
            mHandle.deliverEvent(indication, null);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController added indication instance", t);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        try {
            CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            FCPort port = (FCPort)pObj;
            if (!ProviderConstants.UINT16_TWO.equals((Object)port.getPortRole())) {
                return;
            }
            RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(port.getSerialNumber());
            CIMInstance instImportingSCSIProtocolController = this.getReference1Instrumentation().generateInstance(op, null, device.getRMIObject());
            CIMInstance instSCSIProtocolEndPt = this.getReference2Instrumentation().generateInstance(op, null, pObj);
            CIMInstance sourceInstance = this.generateInstance(op, null, instImportingSCSIProtocolController.getObjectPath(), instSCSIProtocolEndPt.getObjectPath());
            IndicationHelper helper = new IndicationHelper(mHandle);
            CIMInstance indication = helper.createInstDeletionInstance(sourceInstance);
            mHandle.deliverEvent(indication, null);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController deleted indication instance", t);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath objectName, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                Hashtable<String, Object> eValues = new Hashtable<String, Object>();
                eValues.put("ElementName", device.getStorageSystemName());
                CIMObjectPath opImportingSCSIProtocolController = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                CustomCloseableIterator iterSCSIProtocolEndpoint = new CustomCloseableIterator();
                CIMObjectPath opSCSIProtocolEndpoint = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                this.getReference2Instrumentation().enumerate(iterSCSIProtocolEndpoint, opSCSIProtocolEndpoint, null, filterQueryLanguage, filterQuery, continueOnError, false, eValues, null);
                while (iterSCSIProtocolEndpoint.hasNext()) {
                    CIMInstance instSCSIProtocolEndpoint = (CIMInstance)iterSCSIProtocolEndpoint.next();
                    if (!ProviderConstants.UINT16_TWO.equals(instSCSIProtocolEndpoint.getPropertyValue("Role"))) continue;
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opImportingSCSIProtocolController, instSCSIProtocolEndpoint.getObjectPath()));
                        continue;
                    }
                    iter.add(this.generateInstance(objectName, propertyList, opImportingSCSIProtocolController, instSCSIProtocolEndpoint.getObjectPath()));
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_SAPAvailableForElement".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstAdd(true);
            } else {
                this.setListen4InstAdd(false);
            }
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_SAPAvailableForElement".equalsIgnoreCase(query)) {
            if (startListening) {
                this.setListen4InstDel(true);
            } else {
                this.setListen4InstDel(true);
            }
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.PORT, this, null);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SCSIProtocolEndpointAvailableForImportingProtocolController".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instImportingSCSIProtocolController = null;
                    try {
                        instImportingSCSIProtocolController = this.getReference1Instrumentation().getInstance(objectName, new String[0]);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instImportingSCSIProtocolController) {
                        CIMObjectPath opSCSIProtocolEndpoint = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                        Hashtable<String, Object> expValues = new Hashtable<String, Object>();
                        expValues.put("ElementName", objectName.getKeyValue("SystemName"));
                        CustomCloseableIterator iterSCSIProtocolEndpoint = new CustomCloseableIterator();
                        this.getReference2Instrumentation().enumerate(iterSCSIProtocolEndpoint, opSCSIProtocolEndpoint, null, null, null, false, false, expValues, null);
                        while (iterSCSIProtocolEndpoint.hasNext()) {
                            CIMInstance instSCSIProtocolEndpoint = (CIMInstance)iterSCSIProtocolEndpoint.next();
                            if (!ProviderConstants.UINT16_TWO.equals(instSCSIProtocolEndpoint.getPropertyValue("Role"))) continue;
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, instImportingSCSIProtocolController.getObjectPath(), instSCSIProtocolEndpoint.getObjectPath()));
                                continue;
                            }
                            iter.add(this.generateInstance(objectName, propertyList, instImportingSCSIProtocolController.getObjectPath(), instSCSIProtocolEndpoint.getObjectPath()));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    CIMInstance instSCSIProtocolEndpoint = null;
                    try {
                        instSCSIProtocolEndpoint = this.getReference2Instrumentation().getInstance(objectName, null);
                    }
                    catch (WBEMException we) {
                        // empty catch block
                    }
                    if (null != instSCSIProtocolEndpoint && ProviderConstants.UINT16_TWO.equals(instSCSIProtocolEndpoint.getPropertyValue("Role"))) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(objectName, this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), instSCSIProtocolEndpoint.getObjectPath()));
                        } else {
                            iter.add(this.generateInstance(objectName, propertyList, this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()), instSCSIProtocolEndpoint.getObjectPath()));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

