/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IndicationHelper;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import com.ws.wbem.jserver.JServerProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public final class SnapshotSynchronizedInstrumentation
extends BaseAssocInstrumentation
implements CacheUpdateNotifier {
    private static UnsignedInteger16 getCopyState(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no CopyState mapping", new Object[]{pairStatus});
                break;
            }
            case 528: 
            case 544: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 560: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 576: 
            case 584: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 592: {
                ret = ProviderConstants.UINT16_FIVE;
                break;
            }
            case 593: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown CopyState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static UnsignedInteger16 getProgressStatus(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no ProgressStatus mapping", new Object[]{pairStatus});
                break;
            }
            case 528: 
            case 544: {
                ret = ProviderConstants.UINT16_SIX;
                break;
            }
            case 560: {
                ret = ProviderConstants.UINT16_TWO;
                break;
            }
            case 576: {
                ret = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case 584: {
                ret = ProviderConstants.UINT16_EIGHT;
                break;
            }
            case 592: 
            case 593: {
                ret = new UnsignedInteger16(15);
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown ProgressStatus", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static UnsignedInteger16 getRequestedCopyState(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) fhas no CopyState mapping", new Object[]{pairStatus});
                break;
            }
            case 528: 
            case 544: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 560: {
                ret = new UnsignedInteger16(15);
                break;
            }
            case 576: 
            case 584: {
                ret = ProviderConstants.UINT16_FOUR;
                break;
            }
            case 592: 
            case 593: {
                ret = new UnsignedInteger16(15);
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown CopyState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static UnsignedInteger16 getSyncState(int pairStatus) {
        UnsignedInteger16 ret = null;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 528: 
            case 544: {
                ret = ProviderConstants.UINT16_THREE;
                break;
            }
            case 560: {
                ret = ProviderConstants.UINT16_SIX;
                break;
            }
            case 576: {
                ret = ProviderConstants.UINT16_FIVE;
                break;
            }
            case 584: {
                ret = ProviderConstants.UINT16_TEN;
                break;
            }
            case 592: {
                ret = ProviderConstants.UINT16_TWELVE;
                break;
            }
            case 593: {
                ret = new UnsignedInteger16(16);
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    private static Boolean isSyncMaintained(int pairStatus) {
        boolean ret = false;
        Logger logger = Logger.getLogger("com.hitachi.smis.logger.provider");
        switch (pairStatus) {
            case 0: {
                logger.log(Level.WARNING, "Status ({0}) has no SyncState mapping", new Object[]{pairStatus});
                break;
            }
            case 528: 
            case 544: 
            case 560: 
            case 584: {
                ret = true;
                break;
            }
            case 513: 
            case 592: 
            case 593: {
                ret = false;
                break;
            }
            default: {
                logger.log(Level.WARNING, "Status ({0}) is an unknown SyncState", new Object[]{pairStatus});
            }
        }
        return ret;
    }

    protected SnapshotSynchronizedInstrumentation() {
        super("HITACHI_SnapshotSynchronized", "HITACHI_StorageVolume", "SystemElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"), "HITACHI_StorageVolume", "SyncedElement", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotSynchronized".equalsIgnoreCase(assocName.getObjectName())) {
                SnapshotInfo2 pairData;
                LinkedList<SnapshotInfo2> pairDataList;
                CommonClassAsList<SnapshotInfo2> callback;
                String deviceNum;
                CIMProperty cpDeviceID;
                RMIObjectMapping device;
                if ((objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && null == role || role.equalsIgnoreCase("SystemElement") && (null == resultRole || resultRole.equalsIgnoreCase("SyncedElement"))) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        deviceNum = (String)cpDeviceID.getValue();
                        callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.TRUE);
                        pairDataList = callback.getReturnValue();
                        while (null != (pairData = (SnapshotInfo2)pairDataList.poll())) {
                            DeviceNumber sVolIndex = pairData.getSVol();
                            if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(objectName, sVolIndex));
                                continue;
                            }
                            iter.add(this.getReference2Instrumentation().generateInstance(objectName, propertyList, sVolIndex));
                        }
                    }
                }
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("SyncedElement")) && (null == resultRole || resultRole.equalsIgnoreCase("SystemElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        deviceNum = (String)cpDeviceID.getValue();
                        callback = new CommonClassAsList();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.FALSE);
                        pairDataList = callback.getReturnValue();
                        while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                            DeviceNumber dn = pairData.getPVol();
                            if (isObjectPath) {
                                iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, dn));
                                continue;
                            }
                            iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, dn));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
        if (this.isListening()) {
            this.handleCacheUpdate(pObj, true);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        if (this.isListening()) {
            this.handleCacheUpdate(pObj, false);
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
        if (this.isListening()) {
            try {
                CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_StorageVolume", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
                SnapshotInfo2 si = (SnapshotInfo2)pObj;
                RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(si.getSerialNumber());
                CIMObjectPath opPVol = this.getReference1Instrumentation().generateObjectPath(op, si.getPVol());
                CIMObjectPath opSVol = this.getReference2Instrumentation().generateObjectPath(op, si.getSVol());
                CIMInstance prevInstance = this.generateInstance(op, null, opPVol, opSVol, si.getPairStatus());
                opSVol = null;
                opPVol = null;
                CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, si.getSVol().getDNAsString(), Boolean.FALSE);
                LinkedList<SnapshotInfo2> sis = callback.getReturnValue();
                callback = null;
                if (sis.size() != 1) {
                    mLogger.log(Level.SEVERE, "SnapshotSynchronized.cacheItemModified retrived {0} SnapshotInfo2, it should have only returned 1 for SVol {1}", new Object[]{sis.size(), si.getSVolDNString()});
                    return;
                }
                SnapshotInfo2 newSI = (SnapshotInfo2)sis.remove(0);
                opPVol = this.getReference1Instrumentation().generateObjectPath(op, newSI.getPVol());
                opSVol = this.getReference2Instrumentation().generateObjectPath(op, newSI.getSVol());
                CIMInstance sourceInstance = this.generateInstance(op, null, opPVol, opSVol, si.getPairStatus());
                opSVol = null;
                opPVol = null;
                IndicationHelper helper = new IndicationHelper(mHandle);
                CIMInstance indication = helper.createInstModificationInstance(sourceInstance, prevInstance);
                mHandle.deliverEvent(indication, null);
            }
            catch (Throwable t) {
                mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SnapshotSynchronized modified indication instance", t);
            }
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback);
                CloseableAddableIterator<SnapshotInfo2> pairDataList = callback.getWrappedCloseableAddableIter();
                while (pairDataList.hasNext()) {
                    DeviceNumber sVolDN;
                    SnapshotInfo2 pairData = (SnapshotInfo2)pairDataList.next();
                    DeviceNumber pVolDN = DeviceNumber.find(pairData.getPVol().getDNAsString(), device.getRMIObject());
                    if (null == pVolDN || null == (sVolDN = DeviceNumber.find(pairData.getSVol().getDNAsString(), device.getRMIObject()))) continue;
                    CIMObjectPath opPVol = this.getReference1Instrumentation().generateObjectPath(op, pVolDN);
                    CIMObjectPath opSVol = this.getReference2Instrumentation().generateObjectPath(op, sVolDN);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, opPVol, opSVol));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, opPVol, opSVol, pairData.getPairStatus()));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath objectName, String[] propertyList, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{CIMObjectPath.class, CIMObjectPath.class, Integer.class}, o, "HITACHI_SnapshotSynchronized");
        CIMObjectPath opAssoc = this.generateObjectPath(objectName, o[0], o[1]);
        Integer pairStatus = (Integer)o[2];
        CIMProperty[] props = new CIMProperty[]{opAssoc.getKey("SystemElement"), opAssoc.getKey("SyncedElement"), new CIMProperty("SyncMaintained", CIMDataType.BOOLEAN_T, (Object)SnapshotSynchronizedInstrumentation.isSyncMaintained(pairStatus), false), new CIMProperty("CopyState", CIMDataType.UINT16_T, (Object)SnapshotSynchronizedInstrumentation.getCopyState(pairStatus), false), new CIMProperty("Mode", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("SyncType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_SEVEN, false), new CIMProperty("RequestedCopyState", CIMDataType.UINT16_T, (Object)SnapshotSynchronizedInstrumentation.getRequestedCopyState(pairStatus), false), new CIMProperty("SyncState", CIMDataType.UINT16_T, (Object)SnapshotSynchronizedInstrumentation.getSyncState(pairStatus), false), new CIMProperty("ProgressStatus", CIMDataType.UINT16_T, (Object)SnapshotSynchronizedInstrumentation.getProgressStatus(pairStatus), false)};
        return new CIMInstance(opAssoc, props).filterProperties(propertyList);
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block12: {
            try {
                String pnSystemElement = this.getReference1PropertyName();
                CIMObjectPath opSystemElement = opObjectName.getKey(pnSystemElement) != null ? (CIMObjectPath)opObjectName.getKey(pnSystemElement).getValue() : null;
                CIMInstance instSystemElement = null;
                try {
                    instSystemElement = this.getReference1Instrumentation().getInstance(opSystemElement, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opSystemElement, "SystemName");
                if (null == instSystemElement) break block12;
                String pnSyncedElement = this.getReference2PropertyName();
                CIMObjectPath opSyncedElement = opObjectName.getKey(pnSyncedElement) != null ? (CIMObjectPath)opObjectName.getKey(pnSyncedElement).getValue() : null;
                CIMInstance instSyncedElement = null;
                try {
                    instSyncedElement = this.getReference2Instrumentation().getInstance(opSyncedElement, new String[0]);
                }
                catch (WBEMException we) {
                    // empty catch block
                }
                if (null != instSyncedElement) {
                    String dnStringSyncedElement;
                    opSystemElement = instSystemElement.getObjectPath();
                    opSyncedElement = instSyncedElement.getObjectPath();
                    String dnStringSystemElement = null != opSystemElement.getKey("DeviceID") ? (String)opSystemElement.getKey("DeviceID").getValue() : null;
                    String string = dnStringSyncedElement = null != opSyncedElement.getKey("DeviceID") ? (String)opSyncedElement.getKey("DeviceID").getValue() : null;
                    if (null != dnStringSystemElement && null != dnStringSyncedElement) {
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, dnStringSyncedElement, Boolean.FALSE);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        if (pairDataList.size() == 1) {
                            SnapshotInfo2 pd = (SnapshotInfo2)pairDataList.poll();
                            DeviceNumber pVolDN = pd.getPVol();
                            if (null != pVolDN && dnStringSystemElement.equals(pVolDN.getDNAsString())) {
                                CIMObjectPath opPVol = this.getReference1Instrumentation().generateObjectPath(opObjectName, pVolDN);
                                CIMObjectPath opSVol = this.getReference2Instrumentation().generateObjectPath(opObjectName, pd.getSVol());
                                return this.generateInstance(opObjectName, propertyList, opPVol, opSVol, pd.getPairStatus());
                            }
                        } else {
                            mLogger.log(Level.SEVERE, "There is more then 1  PairData for sync'd DN: ", dnStringSyncedElement);
                        }
                    }
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    private <T extends Serializable> void handleCacheUpdate(T pObj, boolean createEvent) {
        try {
            CIMObjectPath op = new CIMObjectPath(null, JServerProperties.getServerHost(), null, ProviderLibs.getImplementationNamespace(), "HITACHI_SnapshotSynchronized", null, "http://schemas.hitachi.com/wbem/wsman/1/vsp");
            SnapshotInfo2 si = (SnapshotInfo2)pObj;
            CIMObjectPath opPVol = this.getReference1Instrumentation().generateObjectPath(op, si.getPVol());
            CIMObjectPath opSVol = this.getReference2Instrumentation().generateObjectPath(op, si.getSVol());
            CIMInstance sourceInstance = this.generateInstance(op, null, opPVol, opSVol, si.getPairStatus());
            IndicationHelper helper = new IndicationHelper(mHandle);
            CIMInstance indication = createEvent ? helper.createInstCreationInstance(sourceInstance) : helper.createInstDeletionInstance(sourceInstance);
            mHandle.deliverEvent(indication, null);
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Caught exception trying to generate a HITACHI_SnapshotSynchronized" + (createEvent ? " added" : " deleted") + " indication instance", t);
        }
    }

    @Override
    public void processIndicationFilter(String query, boolean startListening) {
        boolean oldListenState = this.isListening();
        if ("SELECT * FROM CIM_InstCreation WHERE SourceInstance ISA CIM_StorageSynchronized".equalsIgnoreCase(query)) {
            this.setListen4InstAdd(startListening);
        } else if ("SELECT * FROM CIM_InstDeletion WHERE SourceInstance ISA CIM_StorageSynchronized".equalsIgnoreCase(query)) {
            this.setListen4InstDel(startListening);
        } else if ("SELECT * FROM CIM_InstModification WHERE SourceInstance ISA CIM_StorageSynchronized AND SourceInstance.SyncState <> PreviousInstance.SyncState".equalsIgnoreCase(query)) {
            this.setListen4InstMod(startListening);
        }
        if (!oldListenState && this.isListening()) {
            CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.SNAPSHOT, this, null);
        } else if (oldListenState && !this.isListening()) {
            CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.SNAPSHOT, this, null);
        }
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_SnapshotSynchronized".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && null == role || role.equalsIgnoreCase("SystemElement")) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                        CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                        if (null != cpDeviceID) {
                            SnapshotInfo2 pairData;
                            String deviceNum = (String)cpDeviceID.getValue();
                            CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                            SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.TRUE);
                            LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                            while ((pairData = (SnapshotInfo2)pairDataList.poll()) != null) {
                                DeviceNumber sVolDN;
                                DeviceNumber pVolDN = pairData.getPVol();
                                if (null == pVolDN || null == (sVolDN = pairData.getSVol())) continue;
                                CIMObjectPath opPVol = this.getReference1Instrumentation().generateObjectPath(objectName, pVolDN);
                                CIMObjectPath opSVol = this.getReference2Instrumentation().generateObjectPath(objectName, sVolDN);
                                if (isObjectPath) {
                                    iter.add(this.generateObjectPath(objectName, opPVol, opSVol));
                                    continue;
                                }
                                iter.add(this.generateInstance(objectName, propertyList, opPVol, opSVol, pairData.getPairStatus()));
                            }
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageVolume") && (null == role || role.equalsIgnoreCase("SyncedElement")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty cpDeviceID = objectName.getKey("DeviceID");
                    if (null != cpDeviceID) {
                        DeviceNumber sVolDN;
                        SnapshotInfo2 pd;
                        DeviceNumber pVolDN;
                        String deviceNum = (String)cpDeviceID.getValue();
                        CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                        SnapshotInfo2.getSnapshotInfo2(device.getRMIObject(), callback, deviceNum, Boolean.FALSE);
                        LinkedList<SnapshotInfo2> pairDataList = callback.getReturnValue();
                        if (pairDataList.size() == 1 && null != (pVolDN = (pd = (SnapshotInfo2)pairDataList.poll()).getPVol()) && null != (sVolDN = pd.getSVol())) {
                            CIMObjectPath opPVol = this.getReference1Instrumentation().generateObjectPath(objectName, pVolDN);
                            CIMObjectPath opSVol = this.getReference2Instrumentation().generateObjectPath(objectName, sVolDN);
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(objectName, opPVol, opSVol));
                            } else {
                                iter.add(this.generateInstance(objectName, propertyList, opPVol, opSVol, pd.getPairStatus()));
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

