/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class SnapshotVolumeSettingInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
        try {
            short poolID = -1;
            String devNum = null;
            if (expectedValues != null) {
                if (1 != devices.size()) {
                    throw new WBEMException("Asscoiation request made but incorrect # of managed devices: " + devices.size() + " expectedVals: " + expectedValues);
                }
                String instID = (String)expectedValues.get("InstanceID");
                if (instID != null) {
                    if ((instID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR)) != null) {
                        poolID = Short.parseShort(instID);
                    }
                } else {
                    devNum = (String)expectedValues.get("DeviceID");
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<DeviceNumber> callback = new CallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, device.getStorageSystemName());
                if (poolID != -1 || devNum == null) {
                    DeviceNumber.getDNs(device.getRMIObject(), callback, poolID, false, VolumeTypeEnum.QSVVOL);
                    continue;
                }
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, true, devNum);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath newOP = this.generateObjectPath(op, o);
        DeviceNumber dn = (DeviceNumber)o[0];
        CIMProperty<?>[] props = this.getProperties(propList, newOP.getKeys(), dn);
        CIMInstance ci = new CIMInstance(newOP, props);
        return ci.filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        String sysName;
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_SnapshotVolumeSetting");
        DeviceNumber dn = (DeviceNumber)o[0];
        try {
            sysName = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName();
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        String keyValue = ProviderLibs.createInstanceID("HITACHI_SnapshotVolumeSetting", sysName, null, BigInteger.valueOf(dn.getDn()), null);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SnapshotVolumeSetting", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID", ".", 2);
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String ret = ProviderLibs.getEndString(instID);
            DeviceNumber dn = DeviceNumber.find(ret, device.getRMIObject());
            if (dn != null && dn.isQSVvol()) {
                return this.generateInstance(op, propertyList, dn);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private CIMProperty<?>[] getProperties(String[] propertyList, CIMProperty<?>[] keys, DeviceNumber dn) throws Exception {
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
        props.add(new CIMProperty("CUImage", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("SubsystemID", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("ThinProvisionedPoolType", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("ThinProvisionedInitialReserve", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)false, false));
        props.add(new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false));
        props.add(new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false));
        props.add(new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ONE, false));
        props.add(new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        props.add(new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        props.add(new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        props.add(new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false));
        props.add(new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false));
        props.add(new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false));
        props.add(new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        Object cvExtentStripeLn = null;
        props.add(new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, cvExtentStripeLn, false));
        props.add(new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, cvExtentStripeLn, false));
        props.add(new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, cvExtentStripeLn, false));
        props.add(new CIMProperty("ParityLayout", CIMDataType.UINT16_T, null, false));
        props.add(new CIMProperty("UserDataStripeDepth", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("UserDataStripeDepthMin", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("UserDataStripeDepthMax", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"UNKNOWN", false));
        String value = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber()).getStorageSystemName() + "." + dn.getDNAsString();
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)value, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)value, false));
        props.add(new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
        return props.toArray(new CIMProperty[props.size()]);
    }

    private class CallbackHandler<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String sysName) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E dn = item;
                    if (((DeviceNumber)dn).isQSVvol()) {
                        CIMObjectPath retOP = SnapshotVolumeSettingInstrumentation.this.generateObjectPath(this.mOP, dn);
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, retOP);
                        } else if (this.mIsObjectPath) {
                            this.mIter.add(retOP);
                        } else {
                            this.mIter.add(SnapshotVolumeSettingInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                        }
                    }
                }
                catch (WBEMException we) {
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return true;
        }
    }
}

