/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_DISKgetSubsystemInfoEx2;

public class SoftwareIdentityInstrumentation
extends BaseInstrumentation {
    private static final UnsignedInteger16[] CPV_CLASSIFICATIONS = new UnsignedInteger16[]{ProviderConstants.UINT16_TEN};
    private static final String[] CPV_CLASSIFICATIONSDESC = new String[]{"Firmware"};
    private static final String CPV_GENERAL = "DKC Main Microcode";
    private static final UnsignedInteger16 CPV_HEALTHSTATE = ProviderConstants.UINT16_FIVE;
    private static final UnsignedInteger16[] CPV_OPERATIONALSTATUS = new UnsignedInteger16[]{ProviderConstants.UINT16_TWO};
    private static final String[] CPV_STATUSDESC = new String[]{"OK"};
    private static final String[] CPV_TARGETOS = new String[]{"Dedicated"};

    public static String getVersionValue(RMIObjectCache rmiObj) {
        StringBuilder ret = new StringBuilder();
        try {
            RMIObjectMapping device = rmiObj.getSMISMappingContainer();
            ret = ret.append(device.getStorageSystemName());
            ret = ret.append(ProviderConstants.ID_SEPERATOR_AS_CHAR);
            Robj_interface_DISKgetSubsystemInfoEx2 sysInfo = rmiObj.getSMISMappingContainer().getSubsystemInfo();
            if (sysInfo != null) {
                ret = ret.append(sysInfo.getStrDKCMainVersion());
            }
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Exception getting subsystem info", e);
        }
        if (ret.length() < 1) {
            ret = ret.append("UNKNOWN");
        }
        return ret.toString();
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"SystemName", "InstanceID"});
            for (RMIObjectMapping device : devices) {
                if (null != refInfo) {
                    refInfo.addReference(iter, this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                if (isObjectPath) {
                    iter.add(this.generateObjectPath(op, device.getRMIObject()));
                    continue;
                }
                iter.add(this.generateInstance(op, propertyList, device.getRMIObject()));
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        String version = SoftwareIdentityInstrumentation.getVersionValue(rmiObj);
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("VersionString", CIMDataType.STRING_T, (Object)version, false), new CIMProperty("TargetOperatingSystems", CIMDataType.STRING_ARRAY_T, (Object)CPV_TARGETOS, false), new CIMProperty("Manufacturer", CIMDataType.STRING_T, (Object)"HITACHI", false), new CIMProperty("Classifications", CIMDataType.UINT16_ARRAY_T, (Object)CPV_CLASSIFICATIONS, false), new CIMProperty("ClassificationDescriptions", CIMDataType.STRING_ARRAY_T, (Object)CPV_CLASSIFICATIONSDESC, false), new CIMProperty("Name", CIMDataType.STRING_T, (Object)CPV_GENERAL, false), new CIMProperty("OperationalStatus", CIMDataType.UINT16_ARRAY_T, (Object)CPV_OPERATIONALSTATUS, false), new CIMProperty("StatusDescriptions", CIMDataType.STRING_ARRAY_T, (Object)CPV_STATUSDESC, false), new CIMProperty("HealthState", CIMDataType.UINT16_T, (Object)CPV_HEALTHSTATE, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)CPV_GENERAL, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)CPV_GENERAL, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)CPV_GENERAL, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectCache.class}, o, "HITACHI_SoftwareIdentity");
        RMIObjectCache rmiObj = (RMIObjectCache)o[0];
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)SoftwareIdentityInstrumentation.getVersionValue(rmiObj), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_SoftwareIdentity", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID");
        try {
            String cvInstanceID;
            CIMInstance ret = this.generateInstance(op, propertyList, device.getRMIObject());
            CIMProperty cpInstID = op.getKey("InstanceID");
            if (null != cpInstID && null != (cvInstanceID = (String)cpInstID.getValue()) && cvInstanceID.equalsIgnoreCase((String)ret.getObjectPath().getKeyValue("InstanceID"))) {
                return ret;
            }
            throw new WBEMException(6);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
    }
}

