/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class StoragePoolDiskDriveInstrumentation
extends BaseAssocInstrumentation {
    protected StoragePoolDiskDriveInstrumentation() {
        super("HITACHI_StoragePoolDiskDrive", "HITACHI_DiskDrive", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveInstrumentation"), "HITACHI_StoragePool", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StoragePoolDiskDrive".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    ChassisArrayGroup cag;
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMProperty deDeviceID = objectName.getKey("DeviceID");
                    if (null != deDeviceID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)deDeviceID.getValue())) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && -1 != entry.getFb4() && -1 != entry.getPg() && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), entry.getFb4(), entry.getPg(), isObjectPath))) {
                        CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        if (isObjectPath) {
                            iter.add(this.getReference2Instrumentation().generateObjectPath(newOP, cag));
                        } else {
                            iter.add(this.getReference2Instrumentation().generateInstance(newOP, propertyList, cag));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName()))) {
                    CIMInstance instArrayGroup;
                    block21: {
                        instArrayGroup = null;
                        try {
                            instArrayGroup = this.getReference2Instrumentation().getInstance(objectName, new String[0]);
                        }
                        catch (WBEMException e) {
                            if (e.getID() == 6) break block21;
                            throw e;
                        }
                    }
                    if (null != instArrayGroup) {
                        String cpvDeviceID;
                        CIMObjectPath opArrayGroup = instArrayGroup.getObjectPath();
                        String string = cpvDeviceID = opArrayGroup.getKey("InstanceID") != null ? (String)opArrayGroup.getKey("InstanceID").getValue() : null;
                        if (null != cpvDeviceID) {
                            Integer[] fbpg = ProviderLibs.getFBPGFromDeviceID(cpvDeviceID);
                            int fb4 = fbpg[0];
                            int pg = fbpg[1];
                            if (-1 != fb4 && -1 != pg) {
                                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                                callback = null;
                                CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                                for (PDEVInfoEntry pdev : pdevs) {
                                    if (fb4 != pdev.getFb4() || pg != pdev.getPg()) continue;
                                    if (isObjectPath) {
                                        iter.add(this.getReference1Instrumentation().generateObjectPath(newOP, pdev));
                                        continue;
                                    }
                                    iter.add(this.getReference1Instrumentation().generateInstance(newOP, propertyList, pdev));
                                }
                            }
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                ClosableAddableIteratorCB<PDEVInfoEntry> callback = new ClosableAddableIteratorCB<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                CloseableAddableIterator<PDEVInfoEntry> pdevs = callback.getWrappedCloseableAddableIter();
                while (pdevs.hasNext()) {
                    PDEVInfoEntry pdev = (PDEVInfoEntry)pdevs.next();
                    int fb4 = pdev.getFb4();
                    int pg = pdev.getPg();
                    if (-1 != fb4 && -1 != pg) {
                        ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), fb4, pg, true);
                        if (null != cag) {
                            CIMObjectPath opDiskExtent = this.getReference1Instrumentation().generateObjectPath(op, pdev);
                            CIMObjectPath opArrayGroup = this.getReference2Instrumentation().generateObjectPath(op, cag);
                            if (isObjectPath) {
                                iter.add(this.generateObjectPath(op, opDiskExtent, opArrayGroup));
                                continue;
                            }
                            iter.add(this.generateInstance(op, propertyList, opDiskExtent, opArrayGroup));
                            continue;
                        }
                        mLogger.log(Level.INFO, "Unable to find CAG with FB4: {0}, PG {1}", new Object[]{fb4, pg});
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "Invalid PDEVInfoEntry: {0}", pdev);
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskExtent;
            String spPropname = this.getReference2PropertyName();
            String dePropName = this.getReference1PropertyName();
            CIMObjectPath opStorePool = op.getKey(spPropname) != null ? (CIMObjectPath)op.getKey(spPropname).getValue() : null;
            CIMObjectPath cIMObjectPath = opDiskExtent = op.getKey(dePropName) != null ? (CIMObjectPath)op.getKey(dePropName).getValue() : null;
            if (null != opStorePool && null != opDiskExtent && this.getReference1Instrumentation().instanceExists(opDiskExtent) && this.getReference2Instrumentation().instanceExists(opStorePool)) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                ChassisArrayGroup cag;
                String spInstID;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorePool, "InstanceID");
                String deDeviceID = opDiskExtent.getKey("DeviceID") != null ? (String)opDiskExtent.getKey("DeviceID").getValue() : null;
                String deSystemName = opDiskExtent.getKey("SystemName") != null && opDiskExtent.getKey("SystemName").getValue() != null ? (String)opDiskExtent.getKey("SystemName").getValue() : null;
                String string = spInstID = null != opStorePool.getKey("InstanceID") ? (String)opStorePool.getKey("InstanceID").getValue() : null;
                if (deDeviceID != null && null != spInstID && null != deSystemName && deSystemName.equals(device.getStorageSystemName()) && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), true, spInstID)) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deDeviceID)) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && cag.getFb4() == entry.getFb4() && cag.getPg() == entry.getPg()) {
                    opStorePool = new CIMObjectPath(opStorePool.getScheme(), op.getHost(), op.getPort(), opStorePool.getNamespace(), opStorePool.getObjectName(), opStorePool.getKeys(), opStorePool.getXmlSchemaName());
                    opDiskExtent = new CIMObjectPath(opDiskExtent.getScheme(), op.getHost(), op.getPort(), opDiskExtent.getNamespace(), opDiskExtent.getObjectName(), opDiskExtent.getKeys(), opDiskExtent.getXmlSchemaName());
                    return this.generateInstance(op, propertyList, opDiskExtent, opStorePool);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null == assocName || !"HITACHI_StoragePoolDiskDrive".equalsIgnoreCase(assocName.getObjectName())) {
                return;
            }
            if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                ChassisArrayGroup cag;
                RMIObjectMapping device;
                PDEVInfoEntry entry;
                CIMProperty deDeviceID = objectName.getKey("DeviceID");
                int[] deviceIDValues = PDEVInfoEntry.parseDeviceID((String)deDeviceID.getValue());
                if (null != deviceIDValues && null != (entry = PDEVInfoEntry.find((device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName")).getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && -1 != entry.getFb4() && -1 != entry.getPg() && null != (cag = ChassisArrayGroup.find(device.getRMIObject(), entry.getFb4(), entry.getPg(), isObjectPath))) {
                    CIMObjectPath newOp = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    CIMObjectPath opSP = this.getReference2Instrumentation().generateObjectPath(newOp, cag);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(assocName, newOp, opSP));
                    } else {
                        iter.add(this.generateInstance(assocName, propertyList, newOp, opSP));
                    }
                }
            } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                String cpInstID = objectName.getKey("InstanceID") != null ? (String)objectName.getKey("InstanceID").getValue() : null;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID");
                ChassisArrayGroup cag = ChassisArrayGroup.find(device.getRMIObject(), true, cpInstID);
                if (null != cag) {
                    PDEVInfoEntry pdev;
                    CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                    PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                    LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                    callback = null;
                    CIMObjectPath newOp = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    while (null != (pdev = pdevs.poll())) {
                        if (cag.getFb4() != pdev.getFb4() || cag.getPg() != pdev.getPg()) continue;
                        CIMObjectPath opDiskExtent = this.getReference1Instrumentation().generateObjectPath(newOp, pdev);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(assocName, opDiskExtent, newOp));
                            continue;
                        }
                        iter.add(this.generateInstance(assocName, propertyList, opDiskExtent, newOp));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }
}

