/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StoragePoolPrimordialDiskDriveViewInstrumentation
extends BaseAssocInstrumentation {
    protected StoragePoolPrimordialDiskDriveViewInstrumentation() {
        super("HITACHI_StoragePoolPrimordialDiskDriveView", "HITACHI_StoragePoolPrimordial", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StoragePoolPrimordialInstrumentation"), "HITACHI_DiskDriveView", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveViewInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StoragePoolPrimordialDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName()))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.getReference2SearchProperties(objectName), null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        CIMInstance instStoragePoolPrimordial = this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject());
                        iter.add(instStoragePoolPrimordial.filterProperties(propertyList));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath sppOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath ddvOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), this.getReference2ClassName(), null);
                ReferenceInfo newRefInfo = new ReferenceInfo(sppOP, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, ddvOP, new String[0], null, null, continueOnError, true, this.getReference2SearchProperties(sppOP), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                String ddvSysName;
                CIMInstance ddvInst;
                CIMInstance sppInst;
                CIMObjectPath ddvOP;
                CIMObjectPath sppOP;
                block7: {
                    String sppPropName = this.getReference1PropertyName();
                    sppOP = op.getKey(sppPropName) != null ? (CIMObjectPath)op.getKey(sppPropName).getValue() : null;
                    String ddvPropName = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = ddvOP = op.getKey(ddvPropName) != null ? (CIMObjectPath)op.getKey(ddvPropName).getValue() : null;
                    if (null == ddvOP || null == sppOP) break block6;
                    sppInst = null;
                    ddvInst = null;
                    try {
                        sppInst = this.getReference1Instrumentation().getInstance(sppOP, new String[0]);
                        sppOP = sppInst.getObjectPath();
                        ddvInst = this.getReference2Instrumentation().getInstance(ddvOP, new String[0]);
                        ddvOP = ddvInst.getObjectPath();
                    }
                    catch (WBEMException we) {
                        if (we.getID() != 6) break block7;
                        throw new WBEMException(we.getID(), "Unable to located endpoint: " + (null == sppInst ? sppOP : ddvOP) + " for op: " + op);
                    }
                }
                ddvInst = null;
                sppInst = null;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(sppOP, "InstanceID");
                CIMProperty sppInstIDProp = sppOP.getKey("InstanceID");
                String sppSysNameName = ProviderLibs.getAllButEndString((String)sppInstIDProp.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String sppPrimordial = ProviderLibs.getEndString((String)sppInstIDProp.getValue(), ProviderConstants.ID_SEPERATOR_AS_CHAR);
                CIMProperty ddvSysNameProp = ddvOP.getKey("DDSystemName");
                String string = ddvSysName = ddvSysNameProp != null ? (String)ddvSysNameProp.getValue() : null;
                if ("Primordial".equals(sppPrimordial) && null != sppSysNameName && null != ddvSysName && sppSysNameName.equals(ddvSysName) && sppSysNameName.equals(device.getStorageSystemName())) {
                    return this.generateInstance(op, propertyList, sppOP, ddvOP);
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        String instID;
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        CIMProperty cpInstID = opRef1.getKey("InstanceID");
        if (null != cpInstID && null != (instID = (String)cpInstID.getValue())) {
            ret.put("SystemName", instID);
        }
        return ret;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StoragePoolPrimordialDiskDriveView".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath ddvOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), this.getReference2ClassName(), null);
                    CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(newOP, null, this.getReference1PropertyName(), this.getReference2PropertyName(), propertyList, isObjectPath, this);
                    this.getReference2Instrumentation().enumerate(iter, ddvOP, new String[0], null, null, continueOnError, true, this.getReference2SearchProperties(objectName), newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "DDSystemName");
                    CIMObjectPath sppOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, sppOP, newOP));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, sppOP, newOP));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

