/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageSettingWithDiskLayoutAssociatedToCapabilitiesOfPrimordialPoolInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSettingWithDiskLayoutAssociatedToCapabilitiesOfPrimordialPoolInstrumentation() {
        super("HITACHI_StorageSettingWithDiskLayoutAssociatedToCapabilitiesOfPrimordialPool", "HITACHI_StorageCapabilitiesOfPrimordialPool", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageCapabilitiesOfPrimordialPoolInstrumentation"), "HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSettingWithDiskLayoutOfPrimordialPoolInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StorageSettingWithDiskLayoutAssociatedToCapabilitiesOfPrimordialPool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && (null == resultRole || resultRole.equalsIgnoreCase("Dependent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        Hashtable<String, Object> searchProps = this.getReference2SearchProperties(objectName);
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, searchProps, null);
                        needToCloseIter = false;
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("Dependent")) && (null == resultRole || resultRole.equalsIgnoreCase("Antecedent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID", ".", 2);
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        try {
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CIMObjectPath opSCPP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath opSSWDLPP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(opSCPP, null, "Antecedent", "Dependent", propertyList, isObjectPath, this);
                Hashtable<String, Object> searchProps = this.getReference2SearchProperties(opSCPP);
                this.getReference2Instrumentation().enumerate(deviceIter, opSSWDLPP, new String[0], null, null, continueOnError, true, searchProps, newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMProperty<?>[] getAdditionalProperties() {
        return new CIMProperty[]{new CIMProperty("DefaultSetting", CIMDataType.BOOLEAN_T, (Object)Boolean.FALSE, false)};
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                CIMInstance instSSWithDiskLayout;
                RMIObjectMapping device;
                CIMObjectPath opStorageCapabilities;
                block7: {
                    String ssNameSSWithDiskLayout;
                    String instanceIDSSWithDiskLayout;
                    CIMObjectPath opSSWithDiskLayout;
                    String cpnStorageCapabilities = this.getReference1PropertyName();
                    opStorageCapabilities = op.getKey(cpnStorageCapabilities) != null ? (CIMObjectPath)op.getKey(cpnStorageCapabilities).getValue() : null;
                    String cpnSSWithDiskLayout = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = opSSWithDiskLayout = op.getKey(cpnSSWithDiskLayout) != null ? (CIMObjectPath)op.getKey(cpnSSWithDiskLayout).getValue() : null;
                    if (null == opSSWithDiskLayout || null == opStorageCapabilities || !this.getReference1Instrumentation().instanceExists(opStorageCapabilities)) break block6;
                    device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageCapabilities, "InstanceID");
                    String StorageCapabilitesInstanceID = opStorageCapabilities.getKey("InstanceID") != null && opStorageCapabilities.getKey("InstanceID").getValue() != null ? (String)opStorageCapabilities.getKey("InstanceID").getValue() : null;
                    String ssNameStorageCapabilities = ProviderLibs.getAllButEndString(StorageCapabilitesInstanceID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                    if (null == ssNameStorageCapabilities) break block6;
                    String string = instanceIDSSWithDiskLayout = opSSWithDiskLayout.getKey("InstanceID") != null && opSSWithDiskLayout.getKey("InstanceID").getValue() != null ? (String)opSSWithDiskLayout.getKey("InstanceID").getValue() : null;
                    if (null == instanceIDSSWithDiskLayout || !ssNameStorageCapabilities.equalsIgnoreCase(ssNameSSWithDiskLayout = ProviderLibs.getTokenString(instanceIDSSWithDiskLayout, ".", 1, 2))) break block6;
                    instSSWithDiskLayout = null;
                    try {
                        instSSWithDiskLayout = this.getReference2Instrumentation().getInstance(opSSWithDiskLayout, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() == 6) break block7;
                        throw we;
                    }
                }
                if (null != instSSWithDiskLayout) {
                    opStorageCapabilities = this.getReference1Instrumentation().generateObjectPath(opStorageCapabilities, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageCapabilities, instSSWithDiskLayout.getObjectPath());
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opRef2) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = (String)opRef2.getKeyValue("InstanceID");
        hTable.put("InstanceID", name.substring(name.indexOf(".") + 1));
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opRef1) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String name = null != opRef1 && null != opRef1.getKey("InstanceID") ? (String)opRef1.getKey("InstanceID").getValue() : null;
        hTable.put("InstanceID", name);
        return hTable;
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            boolean needToCloseIter = true;
            if (null != assocName && "HITACHI_StorageSettingWithDiskLayoutAssociatedToCapabilitiesOfPrimordialPool".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("Antecedent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    CIMObjectPath opDiskExtent = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool", null);
                    CIMObjectPath opStorageSystem = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    ReferenceInfo newRefInfo = new ReferenceInfo(opStorageSystem, null, "Antecedent", "Dependent", propertyList, isObjectPath, this);
                    Hashtable<String, Object> searchProps = this.getReference2SearchProperties(objectName);
                    this.getReference2Instrumentation().enumerate(iter, opDiskExtent, new String[0], null, null, continueOnError, true, searchProps, newRefInfo);
                    needToCloseIter = false;
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool") && (null == role || role.equalsIgnoreCase("Dependent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "InstanceID", ".", 2);
                    CIMObjectPath opStorageSystem = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    CIMObjectPath opDiskExtent = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, opStorageSystem, opDiskExtent));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, opStorageSystem, opDiskExtent));
                    }
                }
            }
            if (null != iter && needToCloseIter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

