/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ChassisArrayGroup;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageSettingWithDiskLayoutInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, new String[]{"InstanceID", "SystemName"});
            int chassis = -1;
            int ag = -1;
            if (expectedValues != null) {
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                String expVal = (String)expectedValues.get("InstanceID");
                if (expVal != null) {
                    Integer[] ints = ProviderLibs.getInstanceIDInts(expVal);
                    chassis = ints[0];
                    ag = ints[1];
                }
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<ChassisArrayGroup> callback = new CallbackHandler<ChassisArrayGroup>(deviceIter, isObjectPath, refInfo, op, propertyList);
                ChassisArrayGroup.getChassisArrayGroup(device.getRMIObject(), callback, isObjectPath, chassis, -1, -1, ag);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        CIMProperty[] keys = retOP.getKeys();
        boolean raid1Plus = true;
        if (cag.getRaidLevel().compareTo("UNKNOWN") == 0 || cag.getRaidLevel().equalsIgnoreCase("RAID0")) {
            raid1Plus = false;
        }
        String rl = cag.getRaidLevel();
        int valDataRedundancy = ProviderLibs.getDataRedudancy(rl);
        UnsignedInteger16 cvDataRedundancy = new UnsignedInteger16(valDataRedundancy);
        int valPackageRedundancy = ProviderLibs.getPackageRedudancy(rl);
        UnsignedInteger16 cvPackageRedundancy = new UnsignedInteger16(valPackageRedundancy);
        int valExtentStripeLength = ProviderLibs.getExtentStripeLen(rl);
        UnsignedInteger16 cvExtentStripeLength = new UnsignedInteger16(valExtentStripeLength);
        UnsignedInteger16 value = ProviderLibs.getParityLayout(rl);
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)cvDataRedundancy, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)new UnsignedInteger16(0), false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, (Object)cvExtentStripeLength, false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)cvExtentStripeLength, false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)cvExtentStripeLength, false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, (Object)value, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)cag.getRaidLevel(), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)cag.getRaidLevel(), false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)cag.getRaidLevel(), false), new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false), new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false)};
        return new CIMInstance(retOP, props).filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{ChassisArrayGroup.class}, o, "HITACHI_StorageSettingWithDiskLayout");
        ChassisArrayGroup cag = (ChassisArrayGroup)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(cag.getSerialNumber());
        String keyValue = ProviderLibs.createInstanceID("HITACHI_StorageSettingWithDiskLayout", device.getStorageSystemName(), (Integer)cag.getChassis(), cag.getArrayGroup(), null);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageSettingWithDiskLayout", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID", ".", 2);
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null != instID) {
                Integer[] intKeys = ProviderLibs.getInstanceIDInts(instID);
                ChassisArrayGroup data = ChassisArrayGroup.find(device.getRMIObject(), null, intKeys[0], intKeys[1], false);
                if (data != null) {
                    return this.generateInstance(op, propertyList, data);
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private class CallbackHandler<E extends ChassisArrayGroup>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret;
            block6: {
                ret = true;
                if (!this.mIter.isClosed()) {
                    try {
                        E cag = item;
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, StorageSettingWithDiskLayoutInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block6;
                        }
                        if (this.mIsObjectPath) {
                            this.mIter.add(StorageSettingWithDiskLayoutInstrumentation.this.generateObjectPath(this.mOP, cag));
                            break block6;
                        }
                        this.mIter.add(StorageSettingWithDiskLayoutInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, cag));
                    }
                    catch (Throwable thrown) {
                        WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                        this.mIter.setException(we);
                        this.mIter.close();
                    }
                } else {
                    ret = false;
                }
            }
            return ret;
        }
    }
}

