/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class StorageSettingWithDiskLayoutOfPrimordialPoolInstrumentation
extends BaseInstrumentation {
    private static String[] raidLevels = new String[]{"RAID1(2D+2P)", "RAID5(3D+1P)", "RAID5(4D+1P)", "RAID5(6D+1P)", "RAID5(7D+1P)", "RAID6(6D+2P)", "RAID6(12D+2P)", "RAID6(14D+2P)"};

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "InstanceID", expectedValues, "InstanceID");
            if (expectedValues != null) {
                if (1 != devices.size()) {
                    throw new WBEMException("Found " + devices.size() + " managed devices, expected 1: " + op);
                }
                String expVal = (String)expectedValues.get("InstanceID");
                if (expVal == null || !expVal.contains("Primordial")) {
                    mLogger.log(Level.SEVERE, "Invalid expected values:{0}{1}", new Object[]{System.lineSeparator(), expectedValues});
                }
            }
            for (RMIObjectMapping device : devices) {
                for (String raidLvl : raidLevels) {
                    if (null != refInfo) {
                        refInfo.addReference(iter, this.generateObjectPath(op, device, raidLvl));
                        continue;
                    }
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(op, device, raidLvl));
                        continue;
                    }
                    iter.add(this.generateInstance(op, propertyList, device, raidLvl));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propertyList, Object ... o) throws Exception {
        UnsignedInteger16 extentStripe;
        UnsignedInteger16 parity;
        UnsignedInteger16 dataRedun;
        UnsignedInteger16 pkgRedun;
        String raidLvl;
        CIMObjectPath retOP = this.generateObjectPath(op, o);
        switch (raidLvl = (String)o[1]) {
            case "RAID1(2D+2P)": {
                pkgRedun = ProviderConstants.UINT16_ONE;
                dataRedun = ProviderConstants.UINT16_TWO;
                parity = null;
                extentStripe = null;
                break;
            }
            case "RAID5(3D+1P)": {
                pkgRedun = ProviderConstants.UINT16_ONE;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = ProviderConstants.UINT16_FOUR;
                break;
            }
            case "RAID5(4D+1P)": {
                pkgRedun = ProviderConstants.UINT16_ONE;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = ProviderConstants.UINT16_FIVE;
                break;
            }
            case "RAID5(6D+1P)": {
                pkgRedun = ProviderConstants.UINT16_ONE;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = ProviderConstants.UINT16_SEVEN;
                break;
            }
            case "RAID5(7D+1P)": {
                pkgRedun = ProviderConstants.UINT16_ONE;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = ProviderConstants.UINT16_EIGHT;
                break;
            }
            case "RAID6(6D+2P)": {
                pkgRedun = ProviderConstants.UINT16_TWO;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = ProviderConstants.UINT16_EIGHT;
                break;
            }
            case "RAID6(12D+2P)": {
                pkgRedun = ProviderConstants.UINT16_TWO;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = new UnsignedInteger16(14);
                break;
            }
            case "RAID6(14D+2P)": {
                pkgRedun = ProviderConstants.UINT16_TWO;
                dataRedun = ProviderConstants.UINT16_ONE;
                parity = ProviderConstants.UINT16_TWO;
                extentStripe = new UnsignedInteger16(16);
                break;
            }
            default: {
                throw new WBEMException(raidLvl + " is an unknown RAID level");
            }
        }
        CIMProperty[] keys = retOP.getKeys();
        CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)true, false), new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)dataRedun, false), new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)dataRedun, false), new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)dataRedun, false), new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)pkgRedun, false), new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)pkgRedun, false), new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)pkgRedun, false), new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false), new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false), new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, (Object)extentStripe, false), new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)extentStripe, false), new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)extentStripe, false), new CIMProperty("ParityLayout", CIMDataType.UINT16_T, (Object)parity, false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)raidLvl, false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)raidLvl, false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)raidLvl, false), new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false)};
        return new CIMInstance(retOP, props).filterProperties(propertyList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{RMIObjectMapping.class, String.class}, o, "HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool");
        RMIObjectMapping device = (RMIObjectMapping)o[0];
        String raidLvl = (String)o[1];
        StringBuffer instID = new StringBuffer("StorageSettingWithDiskLayoutOfPrimordialPool");
        instID.append(".");
        instID.append(device.getStorageSystemName());
        instID.append(".");
        instID.append(raidLvl);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instID.toString(), true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_StorageSettingWithDiskLayoutOfPrimordialPool", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID", ".", 2);
        try {
            String instID;
            String string = instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            if (null == instID) {
                throw new WBEMException(6, op.toString());
            }
            String raidLvl = ProviderLibs.getEndString(instID);
            String systemName = ProviderLibs.getAllButEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            systemName = systemName.substring(systemName.indexOf(ProviderConstants.ID_SEPERATOR_AS_CHAR) + 1);
            if (device.getStorageSystemName().equalsIgnoreCase(systemName)) {
                return this.generateInstance(op, propertyList, device, raidLvl);
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

