/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class StorageSystemDeviceImportedStorageExtentInstrumentation
extends BaseAssocInstrumentation {
    protected StorageSystemDeviceImportedStorageExtentInstrumentation() {
        super("HITACHI_StorageSystemDeviceImportedStorageExtent", "HITACHI_StorageSystem", "GroupComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation"), "HITACHI_ImportedStorageExtent", "PartComponent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.ImportedStorageExtentInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        boolean closeIter = true;
        try {
            if (null != assocName && "HITACHI_StorageSystemDeviceImportedStorageExtent".equalsIgnoreCase(assocName.getObjectName())) {
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase("GroupComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("PartComponent"))) {
                    if (this.getReference1Instrumentation().instanceExists(objectName)) {
                        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                        closeIter = false;
                        this.getReference2Instrumentation().enumerate(iter, objectName, propertyList, filterQueryLanguage, filterQuery, continueOnError, isObjectPath, this.createExpectedVals(device), null);
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase("PartComponent")) && (null == resultRole || resultRole.equalsIgnoreCase("GroupComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    if (isObjectPath) {
                        iter.add(this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject()));
                    } else {
                        iter.add(this.getReference1Instrumentation().generateInstance(objectName, propertyList, device.getRMIObject()));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (closeIter && null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    private Hashtable<String, Object> createExpectedVals(RMIObjectMapping device) throws WBEMException {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        ret.put("SystemName", device.getStorageSystemName());
        return ret;
    }

    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
        PassthruIterator deviceIter = new PassthruIterator(iter);
        try {
            for (RMIObjectMapping device : devices) {
                CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(op, device.getRMIObject());
                CIMObjectPath spOP = new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ImportedStorageExtent", null);
                ReferenceInfo newRefInfo = new ReferenceInfo(ssOP, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                this.getReference2Instrumentation().enumerate(deviceIter, spOP, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isDone()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        block6: {
            try {
                CIMInstance instImportedStorageExtent;
                CIMObjectPath opStorageSystem;
                block7: {
                    String ssNameImportedStorageExtent;
                    String ssName;
                    CIMObjectPath opImportedStorageExtent;
                    String cpnStorageSystem = this.getReference1PropertyName();
                    opStorageSystem = op.getKey(cpnStorageSystem) != null ? (CIMObjectPath)op.getKey(cpnStorageSystem).getValue() : null;
                    String cpnImportedStorageExtent = this.getReference2PropertyName();
                    CIMObjectPath cIMObjectPath = opImportedStorageExtent = op.getKey(cpnImportedStorageExtent) != null ? (CIMObjectPath)op.getKey(cpnImportedStorageExtent).getValue() : null;
                    if (null == opImportedStorageExtent || null == opStorageSystem) break block6;
                    String string = ssName = opStorageSystem.getKey("Name") != null && opStorageSystem.getKey("Name").getValue() != null ? (String)opStorageSystem.getKey("Name").getValue() : null;
                    if (null == ssName) break block6;
                    String string2 = ssNameImportedStorageExtent = opImportedStorageExtent.getKey("SystemName") != null && opImportedStorageExtent.getKey("SystemName").getValue() != null ? (String)opImportedStorageExtent.getKey("SystemName").getValue() : null;
                    if (!ssName.equalsIgnoreCase(ssNameImportedStorageExtent)) break block6;
                    instImportedStorageExtent = null;
                    try {
                        instImportedStorageExtent = this.getReference2Instrumentation().getInstance(opImportedStorageExtent, null);
                    }
                    catch (WBEMException we) {
                        if (we.getID() == 6) break block7;
                        throw we;
                    }
                }
                if (null != instImportedStorageExtent) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorageSystem, "Name");
                    opStorageSystem = this.getReference1Instrumentation().generateObjectPath(opStorageSystem, device.getRMIObject());
                    return this.generateInstance(op, propertyList, opStorageSystem, instImportedStorageExtent.getObjectPath());
                }
            }
            catch (WBEMException we) {
                throw we;
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageSystemDeviceImportedStorageExtent".equalsIgnoreCase(assocName.getObjectName())) {
                CIMObjectPath opRef = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                if (objectName.getObjectName().equalsIgnoreCase("HITACHI_StorageSystem") && (null == role || role.equalsIgnoreCase("GroupComponent")) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "Name");
                    CIMObjectPath spOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), "HITACHI_ImportedStorageExtent", null);
                    ReferenceInfo newRefInfo = new ReferenceInfo(opRef, null, "GroupComponent", "PartComponent", propertyList, isObjectPath, this);
                    this.getReference2Instrumentation().enumerate(iter, spOP, new String[0], null, null, continueOnError, true, this.createExpectedVals(device), newRefInfo);
                } else if (objectName.getObjectName().equalsIgnoreCase("HITACHI_ImportedStorageExtent") && (null == role || role.equalsIgnoreCase("PartComponent")) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                    CIMObjectPath ssOP = this.getReference1Instrumentation().generateObjectPath(objectName, device.getRMIObject());
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(objectName, ssOP, opRef));
                    } else {
                        iter.add(this.generateInstance(objectName, propertyList, ssOP, opRef));
                    }
                    if (null != iter) {
                        iter.done();
                    }
                } else if (null != iter) {
                    iter.done();
                }
            } else if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
    }
}

