/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.PDEVInfoEntry;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public final class StorageVolumeDiskDriveInstrumentation
extends BaseAssocInstrumentation {
    protected StorageVolumeDiskDriveInstrumentation() {
        super("HITACHI_StorageVolumeDiskDrive", "HITACHI_DiskDrive", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.DiskDriveInstrumentation"), "HITACHI_StorageVolume", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation"));
    }

    @Override
    public void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != assocName && "HITACHI_StorageVolumeDiskDrive".equalsIgnoreCase(assocName.getObjectName())) {
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
                if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                    PDEVInfoEntry entry;
                    int[] deviceIDValues;
                    CIMProperty deDeviceID = objectName.getKey("DeviceID");
                    if (null != deDeviceID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)deDeviceID.getValue())) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1])) && -1 != entry.getFb4() && -1 != entry.getPg()) {
                        DeviceNumber dn;
                        CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
                        DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, false, null, entry.getFb4(), entry.getPg(), -1);
                        LinkedList<DeviceNumber> dns = callback.getReturnValue();
                        callback = null;
                        CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        while (null != (dn = dns.poll())) {
                            if (isObjectPath) {
                                iter.add(this.getReference2Instrumentation().generateObjectPath(newOP, dn));
                                continue;
                            }
                            iter.add(this.getReference2Instrumentation().generateInstance(newOP, propertyList, dn));
                        }
                    }
                } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && (null == resultRole || resultRole.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName)) {
                    DeviceNumber dn;
                    String cpvDeviceID;
                    String string = cpvDeviceID = objectName.getKey("DeviceID") != null ? (String)objectName.getKey("DeviceID").getValue() : null;
                    if (null != cpvDeviceID && null != (dn = DeviceNumber.find(cpvDeviceID, device.getRMIObject()))) {
                        PDEVInfoEntry pdev;
                        CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                        PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                        LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                        callback = null;
                        CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                        while (null != (pdev = pdevs.poll())) {
                            if (dn.getFb4() != pdev.getFb4() || dn.getPg() != pdev.getPg()) continue;
                            if (isObjectPath) {
                                iter.add(this.getReference1Instrumentation().generateObjectPath(newOP, pdev));
                                continue;
                            }
                            iter.add(this.getReference1Instrumentation().generateInstance(newOP, propertyList, pdev));
                        }
                    }
                }
            }
            if (null != iter) {
                iter.done();
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                PDEVInfoEntry pdev;
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                callback = null;
                while (null != (pdev = pdevs.poll())) {
                    CIMObjectPath opDiskExtent = this.getReference1Instrumentation().generateObjectPath(op, pdev);
                    CIMObjectPath assocName = new CIMObjectPath("HITACHI_StorageVolumeDiskDrive");
                    CustomCloseableIterator objs = new CustomCloseableIterator();
                    this.assocEnumerate(objs, assocName, opDiskExtent, null, null, null, null, null, null, true, true);
                    while (objs.hasNext()) {
                        CIMObjectPath opSP = (CIMObjectPath)objs.next();
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(op, opDiskExtent, opSP));
                            continue;
                        }
                        iter.add(this.generateInstance(op, propertyList, opDiskExtent, opSP));
                    }
                }
            }
        }
        catch (WBEMException we) {
            iter.setException(we);
            iter.close();
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, "Exception during enum operation: " + th, null, th);
            iter.setException(we);
            iter.close();
        }
        finally {
            if (iter != null && !iter.isDone() && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            CIMObjectPath opDiskExtent;
            String svPropName = this.getReference2PropertyName();
            CIMObjectPath opStorVol = op.getKey(svPropName) != null ? (CIMObjectPath)op.getKey(svPropName).getValue() : null;
            String dePropName = this.getReference1PropertyName();
            CIMObjectPath cIMObjectPath = opDiskExtent = op.getKey(dePropName) != null ? (CIMObjectPath)op.getKey(dePropName).getValue() : null;
            if (null != opStorVol && null != opDiskExtent && this.getReference1Instrumentation().instanceExists(opDiskExtent) && this.getReference2Instrumentation().instanceExists(opStorVol)) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                String svDeviceID;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opStorVol, "SystemName");
                String deDeviceID = opDiskExtent.getKey("DeviceID") != null ? (String)opDiskExtent.getKey("DeviceID").getValue() : null;
                String deSystemName = opDiskExtent.getKey("SystemName") != null && opDiskExtent.getKey("SystemName").getValue() != null ? (String)opDiskExtent.getKey("SystemName").getValue() : null;
                String string = svDeviceID = null != opStorVol.getKey("DeviceID") ? (String)opStorVol.getKey("DeviceID").getValue() : null;
                if (deDeviceID != null && null != svDeviceID && null != deSystemName && deSystemName.equals(device.getStorageSystemName()) && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID(deDeviceID)) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]))) {
                    DeviceNumber dn;
                    CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
                    DeviceNumber.getDNs(device.getRMIObject(), callback, true, false, null, entry.getFb4(), entry.getPg(), -1);
                    LinkedList<DeviceNumber> dns = callback.getReturnValue();
                    callback = null;
                    CIMInstance inst = null;
                    while (null != (dn = dns.poll())) {
                        String dnVal = dn.getDNAsString();
                        if (!svDeviceID.equalsIgnoreCase(dnVal)) continue;
                        inst = this.generateInstance(op, propertyList, opStorVol, opDiskExtent);
                        break;
                    }
                    if (null != inst) {
                        return inst;
                    }
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    @Override
    public void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            String cpvDeviceID;
            DeviceNumber dn;
            if (null == assocName || !"HITACHI_StorageVolumeDiskDrive".equalsIgnoreCase(assocName.getObjectName())) {
                return;
            }
            RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(objectName, "SystemName");
            if (objectName.getObjectName().equalsIgnoreCase(this.getReference1ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference1PropertyName())) && this.getReference1Instrumentation().instanceExists(objectName)) {
                PDEVInfoEntry entry;
                int[] deviceIDValues;
                CIMProperty deDeviceID = objectName.getKey("DeviceID");
                if (null != deDeviceID && null != (deviceIDValues = PDEVInfoEntry.parseDeviceID((String)deDeviceID.getValue())) && null != (entry = PDEVInfoEntry.find(device.getRMIObject(), deviceIDValues[0], deviceIDValues[1]))) {
                    DeviceNumber dn2;
                    CommonClassAsList<DeviceNumber> callback = new CommonClassAsList<DeviceNumber>();
                    DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, false, null, entry.getFb4(), entry.getPg(), -1);
                    LinkedList<DeviceNumber> dns = callback.getReturnValue();
                    callback = null;
                    CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                    while (null != (dn2 = dns.poll())) {
                        CIMObjectPath opSV = this.getReference2Instrumentation().generateObjectPath(newOP, dn2);
                        if (isObjectPath) {
                            iter.add(this.generateObjectPath(assocName, newOP, opSV));
                            continue;
                        }
                        iter.add(this.generateInstance(assocName, propertyList, newOP, opSV));
                    }
                }
            } else if (objectName.getObjectName().equalsIgnoreCase(this.getReference2ClassName()) && (null == role || role.equalsIgnoreCase(this.getReference2PropertyName())) && this.getReference2Instrumentation().instanceExists(objectName) && null != (dn = DeviceNumber.find(cpvDeviceID = (String)objectName.getKey("DeviceID").getValue(), device.getRMIObject()))) {
                PDEVInfoEntry pdev;
                CommonClassAsList<PDEVInfoEntry> callback = new CommonClassAsList<PDEVInfoEntry>();
                PDEVInfoEntry.getPDEVInfoEntry(device.getRMIObject(), callback, -1, -1);
                LinkedList<PDEVInfoEntry> pdevs = callback.getReturnValue();
                callback = null;
                CIMObjectPath newOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), objectName.getObjectName(), objectName.getKeys(), objectName.getXmlSchemaName());
                while (null != (pdev = pdevs.poll())) {
                    if (dn.getFb4() != pdev.getFb4() || dn.getPg() != pdev.getPg()) continue;
                    CIMObjectPath opDiskExtent = this.getReference1Instrumentation().generateObjectPath(objectName, pdev);
                    if (isObjectPath) {
                        iter.add(this.generateObjectPath(assocName, opDiskExtent, newOP));
                        continue;
                    }
                    iter.add(this.generateInstance(assocName, propertyList, opDiskExtent, newOP));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }
}

