/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.IteratorCallbackIMPL;
import com.hitachi.smi.common.PassthruIterator;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.common.VolumeTypeEnum;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.cim.UnsignedInteger16;
import javax.wbem.WBEMException;

public class ThinProvisioningVolumeSettingInstrumentation
extends BaseInstrumentation {
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        List<RMIObjectMapping> devices = null;
        try {
            short poolID = -1;
            String devNum = null;
            if (expectedValues != null) {
                String instID = (String)expectedValues.get("InstanceID");
                if (instID != null) {
                    if ((instID = ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR)) != null) {
                        poolID = Short.parseShort(instID);
                        devices = ProviderLibs.getManagedDevices(op, "InstanceID", ".", 2, expectedValues, "InstanceID", ".", 2);
                    }
                } else {
                    devNum = (String)expectedValues.get("DeviceID");
                    String sysName = (String)expectedValues.get("SystemName");
                    if (null != sysName) {
                        String serialNum = ProviderLibs.getSerialFromString(sysName);
                        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(serialNum);
                        devices = new ArrayList<RMIObjectMapping>(1);
                        devices.add(device);
                    }
                }
                if (null == devices || 1 != devices.size()) {
                    throw new WBEMException("Called for Association but incorrect number of managed devices found. Found " + devices + ", expectedVals: " + expectedValues);
                }
            } else {
                devices = ProviderLibs.getManagedDevices(op, "InstanceID", ".", 2, expectedValues, "InstanceID", ".", 2);
            }
            PassthruIterator deviceIter = new PassthruIterator(iter);
            for (RMIObjectMapping device : devices) {
                CallbackHandler<DeviceNumber> callback = new CallbackHandler<DeviceNumber>(deviceIter, isObjectPath, refInfo, op, propertyList, device.getStorageSystemName());
                if (poolID != -1 || devNum == null) {
                    DeviceNumber.getDNs(device.getRMIObject(), callback, poolID, false, VolumeTypeEnum.AOUVOL);
                    continue;
                }
                DeviceNumber.getDNs(device.getRMIObject(), callback, isObjectPath, true, devNum);
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            WBEMException we = new WBEMException(1, th.toString(), null, th);
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath op, String[] propList, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_ThinProvisioningVolumeSetting");
        DeviceNumber data = (DeviceNumber)o[0];
        CIMObjectPath newOP = this.generateObjectPath(op, o);
        CIMProperty<?>[] props = this.getProperties(propList, newOP.getKeys(), data);
        CIMInstance ci = new CIMInstance(newOP, props);
        return ci.filterProperties(propList);
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{DeviceNumber.class}, o, "HITACHI_ThinProvisioningVolumeSetting");
        DeviceNumber data = (DeviceNumber)o[0];
        CIMProperty<?>[] keys = this.getKeys(data);
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_ThinProvisioningVolumeSetting", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(op, "InstanceID", ".", 2);
        try {
            String instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            String dnString = ProviderLibs.getEndString(instID);
            DeviceNumber data = DeviceNumber.find(dnString, device.getRMIObject());
            if (data != null && data.isAOUVol()) {
                return this.generateInstance(op, propertyList, data);
            }
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }

    private CIMProperty<?>[] getKeys(DeviceNumber dn) throws WBEMException {
        String sysName;
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        try {
            sysName = device.getStorageSystemName();
        }
        catch (Exception e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
        String keyValue = ProviderLibs.createInstanceID("HITACHI_ThinProvisioningVolumeSetting", sysName, null, BigInteger.valueOf(dn.getDn()), null);
        CIMProperty[] ret = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)keyValue, true)};
        return ret;
    }

    private CIMProperty<?>[] getProperties(String[] propertyList, CIMProperty<?>[] keys, DeviceNumber dn) throws Exception {
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(dn.getSerialNumber());
        ArrayList props = new ArrayList();
        ProviderLibs.addKeysToProperties(keys, props);
        props.add(new CIMProperty("DataOrganization", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
        props.add(new CIMProperty("CUImage", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("SubsystemID", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("EmulatedDevice", CIMDataType.STRING_T, null, false));
        props.add(new CIMProperty("ThinProvisionedPoolType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_EIGHT, false));
        props.add(new CIMProperty("ThinProvisionedInitialReserve", CIMDataType.UINT64_T, (Object)ProviderConstants.UINT64_ZED, false));
        String rl = dn.getRaidLevel();
        boolean raid1Plus = true;
        ProviderConstants.RAID_Level raidLvl = ProviderLibs.getRaidLevelFromString(dn.getRaidLevel());
        if (raidLvl == ProviderConstants.RAID_Level.UNKNOWN || raidLvl == ProviderConstants.RAID_Level.RAID0) {
            raid1Plus = false;
        }
        props.add(new CIMProperty("NoSinglePointOfFailure", CIMDataType.BOOLEAN_T, (Object)raid1Plus, false));
        int valDataRedendancy = ProviderLibs.getDataRedudancy(rl);
        UnsignedInteger16 cvDataRedendancy = new UnsignedInteger16(valDataRedendancy);
        props.add(new CIMProperty("DataRedundancyMax", CIMDataType.UINT16_T, (Object)cvDataRedendancy, false));
        props.add(new CIMProperty("DataRedundancyMin", CIMDataType.UINT16_T, (Object)cvDataRedendancy, false));
        props.add(new CIMProperty("DataRedundancyGoal", CIMDataType.UINT16_T, (Object)cvDataRedendancy, false));
        int valPackageRedundancy = ProviderLibs.getPackageRedudancy(rl);
        UnsignedInteger16 cvPackageRedundancy = new UnsignedInteger16(valPackageRedundancy);
        props.add(new CIMProperty("PackageRedundancyMax", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false));
        props.add(new CIMProperty("PackageRedundancyMin", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false));
        props.add(new CIMProperty("PackageRedundancyGoal", CIMDataType.UINT16_T, (Object)cvPackageRedundancy, false));
        props.add(new CIMProperty("DeltaReservationMax", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false));
        props.add(new CIMProperty("DeltaReservationMin", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false));
        props.add(new CIMProperty("DeltaReservationGoal", CIMDataType.UINT8_T, (Object)ProviderConstants.UINT8_100, false));
        props.add(new CIMProperty("ChangeableType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_ZED, false));
        int valExtentStripeLn = ProviderLibs.getExtentStripeLen(rl);
        UnsignedInteger16 cvExtentStripeLn = new UnsignedInteger16(valExtentStripeLn);
        props.add(new CIMProperty("ExtentStripeLength", CIMDataType.UINT16_T, (Object)cvExtentStripeLn, false));
        props.add(new CIMProperty("ExtentStripeLengthMax", CIMDataType.UINT16_T, (Object)cvExtentStripeLn, false));
        props.add(new CIMProperty("ExtentStripeLengthMin", CIMDataType.UINT16_T, (Object)cvExtentStripeLn, false));
        props.add(new CIMProperty("ParityLayout", CIMDataType.UINT16_T, (Object)ProviderLibs.getParityLayout(rl), false));
        props.add(new CIMProperty("UserDataStripeDepth", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("UserDataStripeDepthMin", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("UserDataStripeDepthMax", CIMDataType.UINT64_T, null, false));
        props.add(new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)dn.getRaidLevel(), false));
        String value = device.getStorageSystemName() + "." + dn.getDNAsString();
        props.add(new CIMProperty("Caption", CIMDataType.STRING_T, (Object)value, false));
        props.add(new CIMProperty("Description", CIMDataType.STRING_T, (Object)value, false));
        props.add(new CIMProperty("ExtentType", CIMDataType.UINT16_T, (Object)ProviderConstants.UINT16_TWO, false));
        return props.toArray(new CIMProperty[props.size()]);
    }

    private class CallbackHandler<E extends DeviceNumber>
    extends IteratorCallbackIMPL<E> {
        protected CallbackHandler(CustomCloseableIterator<?> iter, boolean isObjectPath, ReferenceInfo refInfo, CIMObjectPath op, String[] propertyList, String sysName) {
            super(iter, isObjectPath, refInfo, op, propertyList);
        }

        @Override
        public boolean returnItem(E item) {
            boolean ret = true;
            if (!this.mIter.isClosed()) {
                try {
                    E dn = item;
                    if (((DeviceNumber)dn).isAOUVol()) {
                        CIMObjectPath retOP = ThinProvisioningVolumeSettingInstrumentation.this.generateObjectPath(this.mOP, dn);
                        if (null != this.mRefInfo) {
                            this.mRefInfo.addReference(this.mIter, retOP);
                        } else if (this.mIsObjectPath) {
                            this.mIter.add(retOP);
                        } else {
                            this.mIter.add(ThinProvisioningVolumeSettingInstrumentation.this.generateInstance(this.mOP, this.mPropertyList, dn));
                        }
                    }
                }
                catch (WBEMException we) {
                    this.mIter.setException(we);
                    this.mIter.close();
                }
                catch (Throwable thrown) {
                    WBEMException we = new WBEMException(1, thrown.toString(), null, thrown);
                    this.mIter.setException(we);
                    this.mIter.close();
                }
            }
            return true;
        }
    }
}

