/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation;

import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.TierInfo;
import com.hitachi.smi.instrumentation.BaseAssocInstrumentation;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import java.util.Hashtable;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public final class TierDomainStorageTierInstrumentation
extends BaseAssocInstrumentation {
    protected TierDomainStorageTierInstrumentation() {
        super("HITACHI_TierDomainStorageTier", "HITACHI_TierDomain", "Antecedent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.TierDomainInstrumentation"), "HITACHI_StorageTier", "Dependent", BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageTierInstrumentation"));
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath opObjectName, String[] propertyList) throws WBEMException {
        block5: {
            try {
                String tierDomainName;
                CIMObjectPath opStorageTier;
                CIMObjectPath opTierDomain = opObjectName.getKey("Antecedent") != null ? (CIMObjectPath)opObjectName.getKey("Antecedent").getValue() : null;
                CIMObjectPath cIMObjectPath = opStorageTier = opObjectName.getKey("Dependent") != null ? (CIMObjectPath)opObjectName.getKey("Dependent").getValue() : null;
                if (null == opTierDomain || null == opStorageTier) break block5;
                RMIObjectMapping device = ProviderLibs.getManagedDeviceFromObjectPath(opTierDomain, "Name");
                String tierDomainSysName = device.getStorageSystemName();
                String storageTierInstanceID = null != opStorageTier.getKey("InstanceID") ? (String)opStorageTier.getKey("InstanceID").getValue() : null;
                String string = tierDomainName = null != opTierDomain.getKey("Name") ? (String)opTierDomain.getKey("Name").getValue() : null;
                if (null == storageTierInstanceID || null == tierDomainName) break block5;
                String tierDomainPoolID = ProviderLibs.getEndString(tierDomainName, ProviderConstants.ID_SEPERATOR_AS_CHAR);
                String[] storageTierSysName = new String[1];
                short[] storageTierInstanceIDVals = TierInfo.getStorageTierInstanceIDValues(storageTierInstanceID, storageTierSysName);
                String storageTierPoolID = String.valueOf(storageTierInstanceIDVals[0]);
                if (null == tierDomainSysName || !tierDomainSysName.equals(storageTierSysName[0]) || !storageTierPoolID.equals(tierDomainPoolID) || !this.getReference2Instrumentation().instanceExists(opStorageTier)) break block5;
                try {
                    short poolID = storageTierInstanceIDVals[0];
                    if (poolID == Short.parseShort(tierDomainPoolID)) {
                        return this.generateInstance(opObjectName, propertyList, opTierDomain, opStorageTier);
                    }
                }
                catch (NumberFormatException nfe) {}
            }
            catch (Throwable th) {
                throw new WBEMException(1, th.toString(), null, th);
            }
        }
        throw new WBEMException(6, opObjectName.toString());
    }

    @Override
    public Hashtable<String, Object> getReference1SearchProperties(CIMObjectPath opStorageTier) {
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String instanceID = null != opStorageTier && null != opStorageTier.getKey("InstanceID") ? (String)opStorageTier.getKey("InstanceID").getValue() : null;
        try {
            short[] instanceIDVals;
            if (null != instanceID && null != (instanceIDVals = TierInfo.getStorageTierInstanceIDValues(instanceID, null))) {
                hTable.put("SystemName", instanceID);
                String poolID = String.valueOf(instanceIDVals[0]);
                hTable.put("PoolID", poolID);
            }
        }
        catch (WBEMException we) {
            mLogger.warning(we.getMessage());
        }
        return hTable;
    }

    @Override
    public Hashtable<String, Object> getReference2SearchProperties(CIMObjectPath opTierDomain) {
        String name;
        Hashtable<String, Object> hTable = new Hashtable<String, Object>();
        String string = name = null != opTierDomain && null != opTierDomain.getKey("Name") ? (String)opTierDomain.getKey("Name").getValue() : null;
        if (null != name) {
            hTable.put("InstanceID", name);
            String poolID = ProviderLibs.getEndString(name);
            hTable.put("PoolID", poolID);
        }
        return hTable;
    }
}

