/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.instrumentation.iSCSI;

import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.PortStats;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.ReferenceInfo;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.ws.wbem.CloseableAddableIterator;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMDataType;
import javax.cim.CIMDateTimeInterval;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class BlockStatisticalDataEthernetPortInstrumentation
extends BaseInstrumentation {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath, Hashtable<String, Object> expectedValues, ReferenceInfo refInfo) throws WBEMException {
        try {
            List<RMIObjectMapping> devices = ProviderLibs.getManagedDevices(op, "SystemName", expectedValues);
            for (RMIObjectMapping device : devices) {
                CloseableAddableIterator psIter = new CloseableAddableIterator();
                PortStats.getIndividualPortStats(device, (CloseableAddableIterator<PortStats>)psIter);
                while (psIter.hasNext()) {
                    PortStats portStats = (PortStats)psIter.next();
                    FCPort fcPort = FCPort.find(portStats.getPortID(), FCPort.PortTypeRequested.iSCSI, device.getRMIObject());
                    if (null != fcPort) {
                        CIMInstance inst = this.generateInstance(op, propertyList, fcPort, portStats);
                        if (null != refInfo) {
                            refInfo.addReference(iter, inst.getObjectPath());
                            continue;
                        }
                        iter.add(inst);
                        continue;
                    }
                    mLogger.log(Level.SEVERE, "No FCPort associated to {0}", portStats);
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        catch (Throwable th) {
            if (null != iter) {
                WBEMException we = new WBEMException(1, th.toString(), null, th);
                iter.setException(we);
                iter.close();
                throw we;
            }
        }
        finally {
            if (null != iter && !iter.isClosed()) {
                iter.done();
            }
        }
    }

    @Override
    public CIMInstance generateInstance(CIMObjectPath pOP, String[] propList, Object ... o) throws Exception {
        CIMObjectPath retOP = this.generateObjectPath(pOP, o);
        FCPort pInfo = (FCPort)o[0];
        PortStats stats = (PortStats)o[1];
        CIMInstance ret = null;
        try {
            CIMProperty[] keys = retOP.getKeys();
            CIMProperty[] props = new CIMProperty[]{keys[0], new CIMProperty("ElementType", CIMDataType.UINT16_T, (Object)pInfo.getElementType(), false), new CIMProperty("TotalIOs", CIMDataType.UINT64_T, (Object)stats.getIOs(), false), new CIMProperty("KBytesTransferred", CIMDataType.UINT64_T, (Object)stats.getTransRate(), false), new CIMProperty("StatisticTime", CIMDataType.DATETIME_T, (Object)stats.getTargetTime(), false), new CIMProperty("SampleInterval", CIMDataType.DATETIME_T, (Object)new CIMDateTimeInterval("00000000000500.000000:000"), false), new CIMProperty("Caption", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataEthernetPort", false), new CIMProperty("ElementName", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataEthernetPort", false), new CIMProperty("Description", CIMDataType.STRING_T, (Object)"HITACHI_BlockStatisticalDataEthernetPort", false), new CIMProperty("IOTimeCounter", CIMDataType.UINT64_T, (Object)stats.getTotalIOTime(), false)};
            ret = new CIMInstance(retOP, props).filterProperties(propList);
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        return ret;
    }

    @Override
    public CIMObjectPath generateObjectPath(CIMObjectPath op, Object ... o) throws Exception {
        ProviderLibs.validateVARArgs(new Class[]{FCPort.class, PortStats.class}, o, "HITACHI_BlockStatisticalDataEthernetPort");
        FCPort pInfo = (FCPort)o[0];
        RMIObjectMapping device = RMIObjectMapping.getRMIObjectMapping(pInfo.getSerialNumber());
        String instanceID = device.getStorageSystemName() + "." + pInfo.getPortWWN();
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty("InstanceID", CIMDataType.STRING_T, (Object)instanceID, true)};
        return new CIMObjectPath(op.getScheme(), op.getHost(), op.getPort(), op.getNamespace(), "HITACHI_BlockStatisticalDataEthernetPort", keys, op.getXmlSchemaName());
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath op, String[] propertyList) throws WBEMException {
        try {
            FCPort fcPort;
            String serial;
            RMIObjectMapping device;
            String portWWN;
            String instID = null != op.getKey("InstanceID") ? (String)op.getKey("InstanceID").getValue() : null;
            String string = portWWN = null == instID ? null : ProviderLibs.getEndString(instID, ProviderConstants.ID_SEPERATOR_AS_CHAR);
            if (null != portWWN && null != (device = RMIObjectMapping.getRMIObjectMapping(serial = ProviderLibs.getSerialFromString(instID))) && (fcPort = FCPort.find(portWWN, FCPort.PortTypeRequested.iSCSI, device.getRMIObject())) != null) {
                CloseableAddableIterator statIter = new CloseableAddableIterator();
                PortStats.getIndividualPortStats(device, (CloseableAddableIterator<PortStats>)statIter);
                CIMInstance inst = null;
                while (null == inst && statIter.hasNext()) {
                    PortStats stats = (PortStats)statIter.next();
                    if (stats.getPortID() != fcPort.getPort()) continue;
                    inst = this.generateInstance(op, propertyList, fcPort, stats);
                    statIter.done();
                }
                if (null != inst) {
                    return inst;
                }
            }
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable th) {
            throw new WBEMException(1, th.toString(), null, th);
        }
        throw new WBEMException(6, op.toString());
    }
}

