/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import com.hitachi.smi.jobs.HitachiJobIF;
import com.hitachi.smi.jobs.HitachiJobService;
import com.hitachi.smi.jobs.JobQueue;
import com.ws.wbem.provider.jobservice.CIM_ConcreteJob;
import com.ws.wbem.provider.jobservice.CIM_MethodResult;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public abstract class AbstractJobImpl
implements HitachiJobIF {
    protected static final Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.provider");
    protected static final int numMinutes2WaitForCacheUpdate = 10;
    protected static final int waitMillisBetweenCacheChecks = 30000;
    protected static final int maxRetries = 20;
    private String methodName;
    private String userName;
    private String clientIP;
    private List<String> affectedElementClassNames;
    private final String owningJobElementClassName;
    private CIMObjectPath[] affectedElements;
    private CIMObjectPath owningService;
    private HitachiJobService jobService;
    private HitachiJobCallbackIF callback;
    private Object theActionItem;
    private Object rmiResult;
    private int resultIndex;
    private Throwable exception;
    private String deviceSerial;

    protected AbstractJobImpl(String pDeviceSerial, String pMethodName, String pUserName, String pIPAddress, CIMObjectPath pOwningSrvc, String pAffectedElementClassName, String pOwningJobElementClassName, HitachiJobCallbackIF pCallback) throws WBEMException {
        this(pDeviceSerial, pMethodName, pUserName, pIPAddress, pOwningSrvc, new String[]{pAffectedElementClassName}, pOwningJobElementClassName, pCallback);
    }

    protected AbstractJobImpl(String pDeviceSerial, String pMethodName, String pUserName, String pIPAddress, CIMObjectPath pOwningSrvc, String[] pAffectedElementClassNames, String pOwningJobElementClassName, HitachiJobCallbackIF pCallback) throws WBEMException {
        if (pDeviceSerial == null) {
            throw new WBEMException("DeviceSerial can not be null or empty.");
        }
        this.deviceSerial = pDeviceSerial;
        if (pMethodName == null) {
            throw new WBEMException("MethodName can not be null or empty.");
        }
        this.methodName = pMethodName;
        if (pUserName == null) {
            throw new WBEMException("UserName can not be null or empty.");
        }
        this.userName = pUserName;
        if (pIPAddress == null) {
            throw new WBEMException("ClientIP can not be null or empty.");
        }
        this.clientIP = pIPAddress;
        if (pOwningSrvc == null) {
            throw new WBEMException("OwningService can not be null or empty.");
        }
        this.owningService = pOwningSrvc;
        if (pAffectedElementClassNames == null || pAffectedElementClassNames.length <= 0) {
            throw new WBEMException("AffectElementClassName can not be null or empty.");
        }
        this.affectedElementClassNames = Arrays.asList(pAffectedElementClassNames);
        this.jobService = new HitachiJobService();
        if (this.jobService == null) {
            throw new WBEMException("Could not get JobService.");
        }
        this.owningJobElementClassName = pOwningJobElementClassName;
        this.callback = pCallback;
        this.theActionItem = null;
        this.rmiResult = null;
        this.resultIndex = 0;
    }

    private void createConcreteJob() throws WBEMException {
        if (this.jobService == null) {
            this.jobService = new HitachiJobService();
        }
        this.jobService.createConcreteJobInServer(this.getDeviceSerial(), this.methodName, this.userName, this.clientIP, this.owningService.getHost(), this.owningService.getPort(), this);
    }

    protected Object getActionItem() {
        return this.theActionItem;
    }

    public CIMObjectPath[] getAffectedElements() {
        StringBuilder msg = new StringBuilder("getAffectedElements called ");
        msg.append("for job ");
        msg.append(this.jobService.getJobID());
        msg.append(", affected class names are: ");
        msg.append(this.affectedElementClassNames.toString());
        msg.append(", returning the following ObjectPaths ");
        msg.append(this.affectedElements == null ? 0 : this.affectedElements.length);
        msg.append("elements. Elements: ");
        msg.append(Arrays.toString(this.affectedElements));
        mLogger.info(msg.toString());
        return this.affectedElements;
    }

    public String[] getAffectedJobElementClassName() {
        return this.affectedElementClassNames.toArray(new String[this.affectedElementClassNames.size()]);
    }

    public String getAssociatedJobMethodResultClassName() {
        return null;
    }

    protected HitachiJobCallbackIF getCallback() {
        return this.callback;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    protected abstract Coalescable getCoalescableObject();

    public String getDeviceSerial() {
        return this.deviceSerial;
    }

    @Override
    public HitachiJobService getHitachiJobServiceObject() {
        return this.jobService;
    }

    public CIM_ConcreteJob getJob() {
        CIM_ConcreteJob ret = null;
        if (this.jobService != null) {
            ret = this.jobService.getJob();
        }
        return ret;
    }

    public String getJobID() {
        CIM_ConcreteJob jobSvc = this.getJob();
        String ret = jobSvc != null ? jobSvc.getInstanceID() : "UNKNOWN";
        return ret;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public CIM_MethodResult getMethodResult() {
        return null;
    }

    public CIMObjectPath getOwningElement() {
        return this.owningService;
    }

    public String getOwningJobElementClassName() {
        return this.owningJobElementClassName;
    }

    protected int getResultIndex() {
        return this.resultIndex;
    }

    protected Object getRMIResult() throws WBEMException {
        if (this.exception != null) {
            if (this.exception instanceof WBEMException) {
                throw (WBEMException)this.exception;
            }
            if (this.exception instanceof SANRmiException) {
                SANRmiException sre = (SANRmiException)this.exception;
                throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
            }
            throw new WBEMException(1, "Exception from back end: " + this.exception, null, this.exception);
        }
        return this.rmiResult;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setActionItem(Object obj) throws WBEMException {
        if (obj != null) {
            if (this.theActionItem != null) {
                throw new WBEMException("This instance has already been set, it is not changable");
            }
        } else {
            throw new WBEMException("Passed in element is null");
        }
        this.theActionItem = obj;
    }

    protected void setAffectedElements(CIMObjectPath[] paths) {
        this.affectedElements = paths;
        String jobInstanceID = null != this.getJob() ? this.getJob().getInstanceID() : "UNKNOWN";
        try {
            int pathLen;
            int n = pathLen = null != paths ? paths.length : 0;
            String pathStr = null == paths ? "null" : (pathLen > 0 ? paths[0].toString() : "empty");
            mLogger.log(Level.INFO, "Setting Affected elements for job {0}, there are  {1} elements, first one is: {2}. Affected element class: {3}", new Object[]{jobInstanceID, pathLen, pathStr, Arrays.toString(this.getAffectedJobElementClassName())});
        }
        catch (Throwable t) {
            mLogger.log(Level.FINE, "Exception trying to log affected elements for job " + this.getJobID(), t);
        }
    }

    protected void setCallback(HitachiJobCallbackIF pCallback) {
        this.callback = pCallback;
    }

    protected void setError(Throwable error) {
        this.exception = error;
    }

    protected void setResultIndex(int idx) {
        this.resultIndex = idx;
    }

    protected void setRmiResult(Object theResult) {
        this.rmiResult = theResult;
    }

    public CIM_ConcreteJob submitJob() throws WBEMException {
        return this.submitJob(true);
    }

    public CIM_ConcreteJob submitJob(boolean alwaysSubmit) throws WBEMException {
        this.createConcreteJob();
        JobQueue.getJobQ().addJobToQueue(this, alwaysSubmit);
        return this.getJob();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Child job [");
        builder.append(this.getJobID());
        builder.append("]");
        return builder.toString();
    }
}

