/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.ExposeHidePaths;
import com.hitachi.smi.jobs.ExposeHidePathsData;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.serverux.data.SANRmiException;

public class CoalescableExposePathsJob
extends Coalescable {
    boolean exposePaths;
    AbstractMap<String, List<Object>> sortedOperations = new LinkedHashMap<String, List<Object>>();

    public CoalescableExposePathsJob(boolean exposePaths) {
        this.exposePaths = exposePaths;
    }

    private void addProtocolController2ChildAffectElements(AbstractJobImpl job, AbstractBaseCommonObject portInfo) throws Exception {
        CIMObjectPath[] newPaths;
        BaseInstrumentation bi = BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.SCSIProtocolControllerInstrumentation");
        CIMObjectPath opProtocolController = bi.generateObjectPath(this.getOwningElement(), portInfo);
        CIMObjectPath[] childAffectedElements = job.getAffectedElements();
        if (childAffectedElements != null) {
            newPaths = new CIMObjectPath[childAffectedElements.length + 1];
            newPaths[0] = opProtocolController;
            System.arraycopy(childAffectedElements, 0, newPaths, 1, childAffectedElements.length);
        } else {
            newPaths = new CIMObjectPath[]{opProtocolController};
        }
        job.setAffectedElements(newPaths);
    }

    private void applyFCExposePaths(Queue<Object> methodList) throws WBEMException {
        LinkedList<Object> sortedActions = new LinkedList<Object>();
        this.sortChildOperations(methodList);
        Set<String> keys = this.sortedOperations.keySet();
        for (String key : keys) {
            List<Object> actions = this.sortedOperations.get(key);
            sortedActions.addAll(actions);
            mLogger.log(Level.INFO, "Key {0} contains {1} actions", new Object[]{key, actions.size()});
        }
        this.setItemQueue(sortedActions);
        this.apply(false);
    }

    private void checkResponse(SanResponse response, String msg) throws WBEMException {
        try {
            if (0 != response.errorCode()) {
                SanObject errorInfo = response.getObj("ErrorInfo");
                int[] message = errorInfo.getIntArray("MessageId");
                String errMsg = String.format("%s failed with code %d, message %d-%d", msg, response.errorCode(), message[0], message[1]);
                throw new WBEMException(errMsg);
            }
        }
        catch (SanDataException e) {
            throw new WBEMException(1, e.toString(), null, (Throwable)e);
        }
    }

    private Queue<Object> createExposePathsMethodList(boolean[] containsISCSI) throws WBEMException {
        if (null == containsISCSI || containsISCSI.length < 1) {
            throw new WBEMException("Boolean array parameter can not be null and must contain at least 1 element");
        }
        LinkedList<Object> methodList = new LinkedList<Object>();
        try {
            RMIObjectMapping rmiMapping = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
            RMIObjectCache rmiObj = rmiMapping.getRMIObject();
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>();
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            this.updateChildrenJobPercentComplete(15);
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof ExposeHidePaths)) {
                    String msg = "AbstractJob should contain  a ExposehidePaths instance but it contains a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                ExposeHidePathsData data = (ExposeHidePathsData)childJob.getActionItem();
                if (!containsISCSI[0] && !data.isFC()) {
                    containsISCSI[0] = true;
                    mLogger.fine("Job is for iSCSI");
                }
                if (data.isFC()) {
                    this.doFCExposeMethodList(data, (ExposeHidePaths)childJob, rmiMapping, rmiObj, methodList);
                } else {
                    KeyValueExposePathData kvData;
                    if (methodList.isEmpty()) {
                        kvData = new KeyValueExposePathData(rmiObj, childJob);
                        methodList.addFirst(kvData);
                        mLogger.finer("Created new KeyValueExposePathData");
                    } else {
                        kvData = (KeyValueExposePathData)methodList.getFirst();
                        mLogger.finer("Obtained KeyValueExposePathData");
                    }
                    this.iSCSICreateTargets(rmiMapping, data, (ExposeHidePaths)childJob, kvData);
                    this.iSCSIBindTargets(rmiMapping, data, (ExposeHidePaths)childJob, kvData);
                    this.doLUPath(methodList, rmiObj, (ExposeHidePaths)childJob, data);
                }
                affectedElements.add(childJob.getJob().getCIMObjectPath(this.getOwningElement()));
            }
            this.updateChildrenJobPercentComplete(30);
            this.setAffectedElements(affectedElements);
        }
        catch (RemoteException re) {
            throw new WBEMException(1, re.toString(), null, (Throwable)re);
        }
        catch (SANRmiException sre) {
            throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, t.toString(), null, t);
        }
        return methodList;
    }

    private Queue<Object> createHidePathsMethodsList(boolean[] containsISCSI) throws WBEMException {
        if (null == containsISCSI || containsISCSI.length < 1) {
            throw new WBEMException("Boolean array parameter can not be numm and must contain at least 1 element");
        }
        LinkedList<Object> methodList = new LinkedList<Object>();
        try {
            RMIObjectMapping rmiMapping = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
            RMIObjectCache rmiObj = rmiMapping.getRMIObject();
            ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>();
            Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
            boolean kvCreated = false;
            this.updateChildrenJobPercentComplete(15);
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                if (!(childJob instanceof ExposeHidePaths)) {
                    String msg = "AbstractJob should contain  a ExposeHidePaths instance but it contains a " + childJob.getClass().getSimpleName();
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    continue;
                }
                ExposeHidePathsData data = (ExposeHidePathsData)childJob.getActionItem();
                for (short lunNum : data.getsLunNums()) {
                    if (lunNum == -1) continue;
                    int retVal = PortandHostGroupInfo.deleteLUPath(methodList, rmiObj, data.getPortNum(), data.getHostGrp(), lunNum);
                    if (retVal != 0) {
                        throw new WBEMException("Unable to delete LUPath");
                    }
                    ((ExposeHidePaths)childJob).setLuNums(lunNum);
                }
                if (data.getInitiatorPorts() != null && data.getInitiatorPorts().length > 0) {
                    int retVal;
                    if (data.isFC()) {
                        retVal = PortandHostGroupInfo.deleteWWN(methodList, rmiObj, data.getPortNum(), data.getHostGrp(), data.getInitiatorPorts());
                    } else {
                        KeyValueExposePathData kvData;
                        if (!containsISCSI[0] && !data.isFC()) {
                            containsISCSI[0] = true;
                        }
                        if (methodList.isEmpty() || !kvCreated) {
                            kvData = new KeyValueExposePathData(rmiObj, childJob);
                            methodList.addFirst(kvData);
                            kvCreated = true;
                        } else {
                            kvData = (KeyValueExposePathData)methodList.getFirst();
                        }
                        retVal = this.removeISCSIInitiators(kvData, rmiObj, data.portNum, data.hostGrp, data.getInitiatorPorts());
                    }
                    if (retVal != 0) {
                        throw new WBEMException("Unable to create deleteWWN/deleteiScsiName object");
                    }
                }
                if (data.getFCPort() != null) {
                    int retVal;
                    if (data.isFC()) {
                        retVal = PortandHostGroupInfo.deleteHostGroup(methodList, rmiMapping, data.portNum, data.getHostGrp(), mLogger);
                    } else {
                        KeyValueExposePathData kvData;
                        if (!containsISCSI[0] && !data.isFC()) {
                            containsISCSI[0] = true;
                        }
                        if (methodList.isEmpty() || !kvCreated) {
                            kvData = new KeyValueExposePathData(rmiObj, childJob);
                            methodList.addFirst(kvData);
                            kvCreated = true;
                        } else {
                            kvData = (KeyValueExposePathData)methodList.getFirst();
                        }
                        retVal = this.removeISCSITargets(kvData, rmiObj, data.getPortNum(), data.getHostGrp());
                    }
                    if (retVal != 0) {
                        throw new WBEMException("Unable to delete host group/iSCSI Name");
                    }
                }
                affectedElements.add(childJob.getJob().getCIMObjectPath(this.getOwningElement()));
            }
            this.updateChildrenJobPercentComplete(30);
            this.setAffectedElements(affectedElements);
        }
        catch (RemoteException re) {
            throw new WBEMException(1, re.toString(), null, (Throwable)re);
        }
        catch (SANRmiException sre) {
            throw new WBEMException(1, sre.getErrMsgEn(), null, (Throwable)sre);
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, t.toString(), null, t);
        }
        return methodList;
    }

    private void doFCExposeMethodList(ExposeHidePathsData data, ExposeHidePaths childJob, RMIObjectMapping rmiMapping, RMIObjectCache rmiObj, LinkedList<Object> methodList) throws Exception {
        String[] initiatorPorts;
        int retVal;
        PortandHostGroupInfo[] portInfo = new PortandHostGroupInfo[1];
        if (data.getFCPort() != null) {
            retVal = PortandHostGroupInfo.createNewHostGroup(methodList, portInfo, rmiMapping, data.getFCPort(), data.getHostGrp(), data.getHostMode(), data.getElementName(), mLogger);
            if (retVal != 0) {
                throw new WBEMException("Unable to create new host group");
            }
            this.addProtocolController2ChildAffectElements(childJob, portInfo[0]);
        }
        if (null != (initiatorPorts = data.getInitiatorPorts()) && initiatorPorts.length > 0 && (retVal = PortandHostGroupInfo.addWWN(methodList, rmiObj, data.getPortNum(), data.getHostGrp(), data.getInitiatorPorts())) != 0) {
            throw new WBEMException("Unable to add WWN");
        }
        this.updateChildrenJobPercentComplete(20);
        this.doLUPath(methodList, rmiObj, childJob, data);
    }

    private void doLUPath(LinkedList<Object> methodList, RMIObjectCache rmiObj, ExposeHidePaths childJob, ExposeHidePathsData data) throws WBEMException {
        short[][] luValsArray = data.getLuVals();
        short[] lunNums = data.getsLunNums();
        if (null != lunNums && null != luValsArray) {
            mLogger.log(Level.FINE, "Job {0} processing {1} lunNames & luValsArray", new Object[]{this.getJob().getInstanceID(), lunNums.length});
            for (int i = 0; i < lunNums.length; ++i) {
                short lunNum = lunNums[i];
                short[] luVals = luValsArray[i];
                if (luVals != null && lunNum != -1) {
                    int retVal;
                    short port = data.getFCPort() != null ? data.getFCPort().getPort() : data.getPortNum();
                    try {
                        retVal = PortandHostGroupInfo.addLUPath(methodList, rmiObj, port, data.getHostGrp(), luVals[0], luVals[1], luVals[2], lunNum);
                    }
                    catch (RemoteException | SANRmiException e) {
                        throw new WBEMException(1, "Error creating LUPaths " + e, null, e);
                    }
                    HashSet<Short> usedLuns = LUPathObject.getLunNums(childJob.getDeviceSerial(), port, data.getHostGrp());
                    mLogger.log(Level.FINE, "adding addLUPath to method list with:\n\tport = " + port + "\n\t hostgroup = " + data.getHostGrp() + "\n\tlunNum = " + lunNum + ".\nLun" + "Nums currently used on this port are:" + usedLuns.toString());
                    childJob.setLuNums(lunNum);
                    if (retVal == 0) continue;
                    throw new WBEMException("Unable to add LU Path");
                }
                mLogger.log(Level.FINE, "Job {0} luVals[{1}] is{2} null, lunNum is {3}", new Object[]{this.getJob().getInstanceID(), i, null == luVals ? "" : " not", lunNum});
            }
        } else {
            mLogger.log(Level.FINE, "Job {0} no LUN names", this.getJob().getInstanceID());
        }
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
        this.setAbstractJobImpls(actionItems);
        try {
            this.createConcreteJobFromAbstractJobs();
            mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
            this.markServerJobStarted(0);
            boolean[] containsISCSI = new boolean[]{false};
            Queue<Object> methodList = this.exposePaths ? this.createExposePathsMethodList(containsISCSI) : this.createHidePathsMethodsList(containsISCSI);
            this.updateChildrenJobPercentComplete(45);
            if (!methodList.isEmpty()) {
                KeyValueExposePathData kvData = containsISCSI[0] ? (KeyValueExposePathData)methodList.poll() : null;
                mLogger.log(Level.FINE, "Job {0} kvData: {1}", new Object[]{this.getJob().getInstanceID(), kvData});
                if (this.exposePaths) {
                    if (null != kvData) {
                        this.invokeKeyValueAPI(kvData);
                        this.updateChildrenJobPercentComplete(60);
                    }
                    if (!methodList.isEmpty()) {
                        this.applyFCExposePaths(methodList);
                        this.updateChildrenJobPercentComplete(75);
                    }
                } else {
                    if (!methodList.isEmpty()) {
                        this.applyFCExposePaths(methodList);
                        this.updateChildrenJobPercentComplete(60);
                    }
                    if (null != kvData) {
                        this.invokeKeyValueAPI(kvData);
                        this.updateChildrenJobPercentComplete(75);
                    }
                }
            } else {
                mLogger.log(Level.SEVERE, "No methods for RMI call: {0}", actionItems);
                throw new WBEMException("No methods for RMI call");
            }
            this.markServerJobDone();
        }
        catch (WBEMException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WBEMException(1, "Exception doing Expose/Hide paths: " + t, null, t);
        }
    }

    private void invokeKeyValueAPI(KeyValueExposePathData kvData) throws WBEMException {
        RMIObjectMapping rmiMapping = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber());
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        if (this.exposePaths) {
            if (kvData.hasTargets()) {
                this.checkResponse(this.invoke(rmiObj, kvData.getGeneralParam(), kvData.getTargetSanRequest(), kvData.getSanRemote()), "Creating targets ");
            }
            if (kvData.hasBindNames()) {
                this.checkResponse(this.invoke(rmiObj, kvData.getGeneralParam(), kvData.getBindNameSanRequest(), kvData.getSanRemote()), "Binding names ");
            }
        } else {
            if (kvData.hasDeleteNames()) {
                this.checkResponse(this.invoke(rmiObj, kvData.getGeneralParam(), kvData.getDeleteNamesSanRequest(), kvData.getSanRemote()), "Deleting names ");
            }
            if (kvData.hasDeleteTargets()) {
                this.checkResponse(this.invoke(rmiObj, kvData.getGeneralParam(), kvData.getDeleteTargetSanRequest(), kvData.getSanRemote()), "Deleting targets ");
            }
        }
    }

    private void iSCSIBindTargets(RMIObjectMapping device, ExposeHidePathsData data, ExposeHidePaths childJob, KeyValueExposePathData kvData) throws WBEMException {
        RMIObjectCache rmiObj = device.getRMIObject();
        String[] initiatorPorts = data.getInitiatorPorts();
        if (null != initiatorPorts && initiatorPorts.length > 0) {
            FCPort port;
            if (null == data.getFCPort()) {
                port = FCPort.find(data.getPortNum(), FCPort.PortTypeRequested.iSCSI, rmiObj);
                if (null == port) {
                    throw new WBEMException("Unable to find port # " + data.getPortNum());
                }
            } else {
                port = data.getFCPort();
            }
            mLogger.log(Level.FINE, "Job {0} using FCPort: {1}", new Object[]{this.getJob().getInstanceID(), port.getPort()});
            ISCSITargetPort iSCSIPort = ISCSITargetPort.find(rmiObj, port.getPort());
            if (null == iSCSIPort) {
                throw new WBEMException("Unable to find Target port " + port.getPort());
            }
            mLogger.log(Level.FINE, "Job {0} using iSCSIPort: {1}", new Object[]{this.getJob().getInstanceID(), iSCSIPort.getPortId()});
            try {
                SanList nameList = kvData.getBindNameList();
                SanObject kvISCSIPort = nameList.addObj();
                kvISCSIPort.putInt("Id", iSCSIPort.getPortId());
                SanList kviSCSITargets = kvISCSIPort.newList("iScsiTargets");
                SanObject kviSCSITarget = kviSCSITargets.addObj();
                kviSCSITarget.putInt("Id", (int)data.getHostGrp());
                SanList kvRNamesList = kviSCSITarget.newList("RemoteiScsiNames");
                for (String initiator : initiatorPorts) {
                    SanObject kvRName = kvRNamesList.addObj();
                    kvRName.putString("Name", initiator);
                }
            }
            catch (Throwable t) {
                throw new WBEMException(1, "" + t, null, t);
            }
        } else {
            mLogger.log(Level.FINE, "Job {0} no Initiator ports supplied", this.getJob().getInstanceID());
        }
    }

    private void iSCSICreateTargets(RMIObjectMapping rmiMapping, ExposeHidePathsData data, ExposeHidePaths childJob, KeyValueExposePathData kvTargetData) throws WBEMException {
        mLogger.fine("Entering iSCSICreateTargets");
        RMIObjectCache rmiObj = rmiMapping.getRMIObject();
        FCPort fcPort = data.getFCPort();
        if (fcPort != null) {
            ISCSITargetPort iSCSIPort = ISCSITargetPort.find(rmiObj, fcPort.getPort());
            if (null == iSCSIPort) {
                throw new WBEMException("Unable to find Target port " + fcPort.getPort());
            }
            ISCSITargetPort.ISCSITarget[] outArg = new ISCSITargetPort.ISCSITarget[1];
            String targetName = iSCSIPort.createNewTargetName(fcPort.getStrPortDisplayName(), data.getHostGrp(), outArg);
            mLogger.log(Level.FINE, "Job {0} using target name: {1}", new Object[]{this.getJob().getInstanceID(), targetName});
            try {
                SanList targetList = kvTargetData.getTargetList();
                SanObject kvISCSIPort = targetList.addObj();
                kvISCSIPort.putInt("Id", iSCSIPort.getPortId());
                SanList kviSCSITargets = kvISCSIPort.newList("iScsiTargets");
                SanObject kviSCSITarget = kviSCSITargets.addObj();
                kviSCSITarget.putInt("Id", (int)data.getHostGrp());
                kviSCSITarget.putString("Name", targetName);
                String alias = null != data.getElementName() ? data.getElementName() : fcPort.getStrPortDisplayName() + "." + data.getHostGrp();
                kviSCSITarget.putString("Alias", alias);
                kviSCSITarget.putInt("UserAuthSwitch", 2);
                kviSCSITarget.putInt("AuthMode", 0);
                this.addProtocolController2ChildAffectElements(childJob, outArg[0]);
            }
            catch (Throwable e) {
                throw new WBEMException(1, "Error creating method list " + e, null, e);
            }
            finally {
                mLogger.fine("Exiting iSCSICreateTargets");
            }
        } else {
            mLogger.fine("Exiting iSCSICreateTargets, Adding to existing iSCSI target");
        }
    }

    private int removeISCSIInitiators(KeyValueExposePathData kvData, RMIObjectCache rmiObj, short portNum, short hostGrp, String[] initiatorPorts) throws WBEMException {
        boolean retVal = false;
        try {
            SanList delNamesList = kvData.getDeleteNameList();
            SanObject iSCSIPort = delNamesList.addObj();
            iSCSIPort.putInt("Id", (int)portNum);
            SanList iSCSITargets = iSCSIPort.newList("iScsiTargets");
            SanObject iSCSITarget = iSCSITargets.addObj();
            iSCSITarget.putInt("Id", (int)hostGrp);
            SanList iSCSIRNames = iSCSITarget.newList("RemoteiScsiNames");
            for (String initiator : initiatorPorts) {
                SanObject name = iSCSIRNames.addObj();
                name.putString("Name", initiator);
            }
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Error creating method list " + e, null, e);
        }
        return 0;
    }

    private int removeISCSITargets(KeyValueExposePathData kvData, RMIObjectCache rmiObj, short portNum, short hostGrp) throws WBEMException {
        boolean retVal = false;
        try {
            SanList delTargetPortList = kvData.getDeleteTargetList();
            SanObject iSCSIPort = delTargetPortList.addObj();
            iSCSIPort.putInt("Id", (int)portNum);
            SanList iSCSITargets = iSCSIPort.newList("iScsiTargets");
            SanObject iSCSITarget = iSCSITargets.addObj();
            iSCSITarget.putInt("Id", (int)hostGrp);
        }
        catch (Throwable e) {
            throw new WBEMException(1, "Error creating delete target list " + e, null, e);
        }
        return 0;
    }

    private void sortChildOperations(Queue<Object> methodList) {
        for (Object e : methodList) {
            String clzName = e.getClass().getSimpleName();
            List<Object> actions = this.sortedOperations.get(clzName);
            if (actions == null) {
                actions = new ArrayList<Object>();
                this.sortedOperations.put(clzName, actions);
            }
            actions.add(e);
        }
    }

    private static class KeyValueExposePathData {
        private final SanRemote sanRemote;
        private SanData generalParam;
        private SanRequest targetReq;
        private SanRequest bindNameReq;
        private SanRequest delTargetReq;
        private SanRequest delNamesReq;
        private SanList targetList;
        private SanList bindNameList;
        private SanList delTargetList;
        private SanList delNameList;
        private boolean hasTargetList;
        private boolean hasBindNamesList;
        private boolean hasDeleteNamesList;
        private boolean hasDeleteTargetList;

        public KeyValueExposePathData(RMIObjectCache rmiObj, AbstractJobImpl childJob) throws WBEMException {
            this.sanRemote = this.createSanRemote(rmiObj);
            try {
                this.generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(this.sanRemote, childJob.getClientIP());
            }
            catch (SanDataException | SanRmiException | RemoteException e) {
                throw new WBEMException(1, "Error getting general paramter: " + e, null, e);
            }
            this.targetReq = null;
            this.targetList = null;
            this.bindNameReq = null;
            this.bindNameList = null;
            this.delTargetReq = null;
            this.delNamesReq = null;
            this.delTargetList = null;
            this.delNameList = null;
            this.hasTargetList = false;
            this.hasBindNamesList = false;
            this.hasDeleteNamesList = false;
            this.hasDeleteTargetList = false;
        }

        private SanRemote createSanRemote(RMIObjectCache rmiObj) throws WBEMException {
            SanRemote sanRemote;
            try {
                sanRemote = rmiObj.keyValueAPI_GetSanRemote();
            }
            catch (NotBoundException | RemoteException e) {
                Throwable t = e;
                while (null != t.getCause()) {
                    t = t.getCause();
                }
                throw new WBEMException(1, "Error getting SanRemote object", null, t);
            }
            return sanRemote;
        }

        public SanList getBindNameList() throws WBEMException {
            if (null == this.bindNameList) {
                SanRequest req = this.getBindNameSanRequest();
                this.bindNameList = this.makeReqList(req, "iScsiPorts");
                this.hasBindNamesList = true;
            }
            return this.bindNameList;
        }

        public SanRequest getBindNameSanRequest() throws WBEMException {
            if (null == this.bindNameReq) {
                this.bindNameReq = this.makeSanRequest("LUNMcreateiScsiName");
            }
            return this.bindNameReq;
        }

        public SanList getDeleteNameList() throws WBEMException {
            if (null == this.delNameList) {
                SanRequest req = this.getDeleteNamesSanRequest();
                this.delNameList = this.makeReqList(req, "iScsiPorts");
                this.hasDeleteNamesList = true;
            }
            return this.delNameList;
        }

        private SanRequest getDeleteNamesSanRequest() throws WBEMException {
            if (null == this.delNamesReq) {
                this.delNamesReq = this.makeSanRequest("LUNMdeleteiScsiName");
            }
            return this.delNamesReq;
        }

        public SanList getDeleteTargetList() throws WBEMException {
            if (null == this.delTargetList) {
                SanRequest req = this.getDeleteTargetSanRequest();
                this.delTargetList = this.makeReqList(req, "iScsiPorts");
                this.hasDeleteTargetList = true;
            }
            return this.delTargetList;
        }

        private SanRequest getDeleteTargetSanRequest() throws WBEMException {
            if (null == this.delTargetReq) {
                this.delTargetReq = this.makeSanRequest("LUNMdeleteiScsiTarget");
            }
            return this.delTargetReq;
        }

        public final SanData getGeneralParam() {
            return this.generalParam;
        }

        public final SanRemote getSanRemote() {
            return this.sanRemote;
        }

        public SanList getTargetList() throws WBEMException {
            if (null == this.targetList) {
                SanRequest req = this.getTargetSanRequest();
                this.targetList = this.makeReqList(req, "iScsiPorts");
                this.hasTargetList = true;
            }
            return this.targetList;
        }

        public SanRequest getTargetSanRequest() throws WBEMException {
            if (null == this.targetReq) {
                this.targetReq = this.makeSanRequest("LUNMcreateiScsiTarget");
            }
            return this.targetReq;
        }

        public boolean hasBindNames() {
            return this.hasBindNamesList;
        }

        public boolean hasDeleteNames() {
            return this.hasDeleteNamesList;
        }

        public boolean hasDeleteTargets() {
            return this.hasDeleteTargetList;
        }

        public boolean hasTargets() {
            return this.hasTargetList;
        }

        private SanList makeReqList(SanRequest req, String listName) throws WBEMException {
            SanList ret = null;
            try {
                ret = req.newList(listName);
            }
            catch (SanDataException e) {
                throw new WBEMException(1, "Error getting " + listName + " list object", null, (Throwable)e);
            }
            return ret;
        }

        private SanRequest makeSanRequest(String funcName) throws WBEMException {
            SanRequest ret = null;
            try {
                ret = this.sanRemote.newRequest(this.generalParam, funcName);
            }
            catch (SanRmiException | RemoteException e) {
                throw new WBEMException(1, "Error getting " + funcName + ": " + e, null, e);
            }
            return ret;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("KeyValueExposePathData [hasTargetList=");
            builder.append(this.hasTargetList);
            builder.append(", targetList=");
            builder.append(this.targetList);
            builder.append(", hasBindNamesList=");
            builder.append(this.hasBindNamesList);
            builder.append(", bindNameList=");
            builder.append(this.bindNameList);
            builder.append(", hasDeleteTargetList=");
            builder.append(this.hasDeleteTargetList);
            builder.append(", delTargetList=");
            builder.append(this.delTargetList);
            builder.append(", hasDeleteNamesList=");
            builder.append(this.hasDeleteNamesList);
            builder.append(", delNameList=");
            builder.append(this.delNameList);
            builder.append("]");
            return builder.toString();
        }
    }
}

