/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.sanproject.data.SanData;
import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRemote;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import com.hitachi.sanproject.rmi.SanRmiException;
import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.FCPort;
import com.hitachi.smi.common.ISCSITargetPort;
import com.hitachi.smi.common.LUPathObject;
import com.hitachi.smi.common.PortandHostGroupInfo;
import com.hitachi.smi.common.ProviderConstants;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.DeleteProtocolController;
import com.hitachi.smi.jobs.workers.DeleteNormalVolumes;
import com.hitachi.smi.jobs.workers.DeleteThinVolume;
import com.ws.wbem.CloseableAddableIterator;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.cim.UnsignedInteger32;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_EXDsetAOUReleaseVvol_IN;

public class CoalescedDeleteProtocolController
extends Coalescable {
    LinkedList<Object> luPaths = new LinkedList();
    LinkedList<Object> hostGroups = new LinkedList();
    LinkedList<SanData> iSCSITargets = new LinkedList();
    DeleteNormalVolumes delNormalVols = null;
    DeleteThinVolume delThinVols = null;

    private void deleteISCSITargets() throws WBEMException {
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            SanData generalParameter = this.iSCSITargets.poll();
            SanRequest request = (SanRequest)this.iSCSITargets.poll();
            SanResponse response = this.invoke(rmiObj, generalParameter, request, rmiObj.keyValueAPI_GetSanRemote());
            if (0 != response.errorCode()) {
                SanObject errorInfo = response.getObj("ErrorInfo");
                int[] message = errorInfo.getIntArray("MessageId");
                String msg = String.format("Deleting iSCSI Target failed with code %d, message %d-%d", response.errorCode(), message[0], message[1]);
                throw new WBEMException(msg);
            }
        }
        catch (SanDataException | NotBoundException | RemoteException e) {
            throw new WBEMException(1, e.toString(), null, e);
        }
    }

    private void doDeleteNormalVolumes() throws WBEMException {
        if (null == this.delNormalVols) {
            return;
        }
        try {
            SanResponse response = this.invoke(this.delNormalVols.getRmiObject(), this.delNormalVols.getGeneralParameter(), this.delNormalVols.getRequest(), this.delNormalVols.getSanRemote());
            if (0 != response.errorCode()) {
                SanObject errorInfo = response.getObj("ErrorInfo");
                int[] message = errorInfo.getIntArray("MessageId");
                String msg = String.format("Deleting iSCSI Target failed with code %d, message %d-%d", response.errorCode(), message[0], message[1]);
                throw new WBEMException(msg);
            }
        }
        catch (SanDataException e) {
            throw new WBEMException(1, "SanDataException while invoking Key/Value API for deleting norma volumes.", null, (Throwable)e);
        }
    }

    private void doDeleteThinVolumes() throws WBEMException {
        if (null == this.delThinVols) {
            return;
        }
        LinkedList<Robj_interface_EXDsetAOUReleaseVvol_IN> rmiAction = new LinkedList<Robj_interface_EXDsetAOUReleaseVvol_IN>();
        rmiAction.add(this.delThinVols.getReleaseVol());
        this.setItemQueue(rmiAction);
        this.apply2();
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> actionItems) throws WBEMException {
        try {
            this.setAbstractJobImpls(actionItems);
            this.createConcreteJobFromAbstractJobs();
            mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
            this.markServerJobStarted(0);
            this.processChildJobs();
            this.updateChildrenJobPercentComplete(15);
            if (!this.luPaths.isEmpty()) {
                this.setItemQueue(this.luPaths);
                this.apply(false);
            }
            this.updateChildrenJobPercentComplete(30);
            if (!this.hostGroups.isEmpty()) {
                this.setItemQueue(this.hostGroups);
                this.apply(false);
            }
            this.updateChildrenJobPercentComplete(50);
            if (!this.iSCSITargets.isEmpty()) {
                this.deleteISCSITargets();
            }
            this.updateChildrenJobPercentComplete(70);
            this.doDeleteNormalVolumes();
            this.updateChildrenJobPercentComplete(85);
            this.doDeleteThinVolumes();
        }
        catch (Throwable t) {
            mLogger.log(Level.SEVERE, "Exception processing DeleteProtocolController", t);
            for (AbstractJobImpl child : this.getAbstractJobImpls()) {
                ((DeleteProtocolController)child).setRetVal(ProviderConstants.UINT32_TWO);
            }
        }
        this.markServerJobDone();
    }

    private DeleteNormalVolumes getDelNormalVols(RMIObjectCache rmiObj, String clientIP) throws WBEMException {
        if (null == this.delNormalVols) {
            this.delNormalVols = new DeleteNormalVolumes(rmiObj, clientIP);
        }
        return this.delNormalVols;
    }

    private DeleteThinVolume getDelThinVols(RMIObjectCache rmiObj) throws WBEMException {
        if (null == this.delThinVols) {
            this.delThinVols = new DeleteThinVolume(rmiObj);
        }
        return this.delThinVols;
    }

    private void getKeyValueObjects(RMIObjectCache rmiObj, DeleteProtocolController dpc, ISCSITargetPort.ISCSITarget target) throws WBEMException {
        try {
            SanRemote sanRemote = rmiObj.keyValueAPI_GetSanRemote();
            SanData generalParam = null;
            SanRequest sanrequest = null;
            if (this.iSCSITargets.isEmpty()) {
                generalParam = rmiObj.keyValueAPI_GetStorageInfoParam(sanRemote, dpc.getClientIP());
                rmiObj.addAccountInfo(generalParam);
                sanrequest = sanRemote.newRequest(generalParam, "LUNMdeleteiScsiTarget");
            } else {
                generalParam = this.iSCSITargets.poll();
                sanrequest = (SanRequest)this.iSCSITargets.poll();
            }
            this.iSCSITargets.offer(generalParam);
            this.iSCSITargets.offer((SanData)sanrequest);
            SanList iSCSIPorts = sanrequest.getList("iScsiPorts");
            if (null == iSCSIPorts) {
                iSCSIPorts = sanrequest.newList("iScsiPorts");
            }
            SanObject iSCSIPort = iSCSIPorts.addObj();
            iSCSIPort.putInt("Id", target.getPortID());
            SanList targetList = iSCSIPort.newList("iScsiTargets");
            SanObject targetObj = targetList.addObj();
            targetObj.putInt("Id", (int)target.getId());
        }
        catch (SanDataException | SanRmiException | NotBoundException | RemoteException e) {
            Throwable t = e;
            while (null != t.getCause()) {
                t = t.getCause();
            }
            throw new WBEMException(1, "Error getting key/value objects", null, t);
        }
    }

    private void processChildJobs() throws WBEMException {
        int x = 0;
        Iterator<AbstractJobImpl> iter = this.getAbstractJobImpls().iterator();
        FCPort fcPort = null;
        RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
        ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>(this.getAbstractJobImpls().size());
        while (iter.hasNext()) {
            String msg;
            short portID;
            AbstractJobImpl childJob = iter.next();
            if (!(childJob instanceof DeleteProtocolController)) {
                String msg2 = "Expected all elements of the list to contain instances of DeleteProtocolController,  however this instance was a " + childJob.getClass().getSimpleName();
                this.markAndRemoveChildJobWithError(iter, childJob, msg2);
                continue;
            }
            DeleteProtocolController dpc = (DeleteProtocolController)childJob;
            PortandHostGroupInfo phg = null;
            ISCSITargetPort.ISCSITarget target = null;
            phg = dpc.getHostGroup();
            if (null != phg) {
                portID = phg.getPortID();
                target = null;
            } else {
                target = dpc.getiSCSITarget();
                if (null != target) {
                    portID = (short)target.getPortID();
                } else {
                    msg = String.format("Unable to find HostGroup or iSCSITarget: %d", dpc);
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    dpc.setRetVal(ProviderConstants.UINT32_TWO);
                    continue;
                }
            }
            fcPort = FCPort.find(portID, FCPort.PortTypeRequested.ALL, rmiObj);
            if (null == fcPort || null == rmiObj) {
                msg = String.format("Unable to find port for HostGroup: %s", dpc.getActionItem());
                dpc.setRetVal(ProviderConstants.UINT32_FIVE);
                this.markAndRemoveChildJobWithError(iter, childJob, msg);
                continue;
            }
            childJob.setResultIndex(x);
            this.processLUPaths(rmiObj, dpc);
            if (null == phg) {
                this.getKeyValueObjects(rmiObj, dpc, target);
            } else {
                PortandHostGroupInfo.deleteHostGroup(this.hostGroups, rmiObj.getSMISMappingContainer(), phg.getPortID(), phg.getHostgroupID(), mLogger);
            }
            if (5L == dpc.getRetVal().longValue()) {
                throw new WBEMException("Child job failed with code 5: " + dpc);
            }
            ++x;
            affectedElements.add(childJob.getJob().getCIMObjectPath(childJob.getOwningElement()));
        }
        this.setAffectedElements(affectedElements);
    }

    private UnsignedInteger32 processDeleteVolumes(RMIObjectCache rmiObj, LUPathObject lu, DeleteProtocolController dpc) throws WBEMException {
        long dnNum;
        DeviceNumber dn;
        UnsignedInteger32 retVal = ProviderConstants.UINT32_ZED;
        if (dpc.isDeleteVols() && null != (dn = DeviceNumber.find(Long.toString(dnNum = BaseDeviceNumber.makeUniqueDN(lu.getDKC(), lu.getCU(), lu.getLDEV())), rmiObj))) {
            if (dn.getILUPathNumber() > 1) {
                retVal = ProviderConstants.UINT32_4096;
            } else if (dn.isAOUVol()) {
                this.delThinVols = this.getDelThinVols(rmiObj);
                this.delThinVols.addDN(dn);
            } else if (dn.isQSVvol()) {
                mLogger.log(Level.SEVERE, "Can not delete QSVvol: {0}", dn.getDn());
                retVal = ProviderConstants.UINT32_4096;
            } else if (dn.isExternal()) {
                mLogger.log(Level.SEVERE, "Can not delete external volumes: {0}", dn.getDn());
                retVal = ProviderConstants.UINT32_4096;
            } else if (dn.isInternalVolume()) {
                this.delNormalVols = this.getDelNormalVols(rmiObj, dpc.getClientIP());
                this.delNormalVols.addDN(dn);
            } else {
                mLogger.log(Level.SEVERE, "Unsupported volume type: {0}, DN: {1}", new Object[]{dn.getVolType(), dn});
                retVal = ProviderConstants.UINT32_FIVE;
            }
        }
        return retVal;
    }

    private void processLUPaths(RMIObjectCache rmiObj, DeleteProtocolController dpc) throws WBEMException {
        short hostID;
        short portID;
        UnsignedInteger32 retVal = ProviderConstants.UINT32_ZED;
        PortandHostGroupInfo phg = dpc.getHostGroup();
        if (null != phg) {
            portID = phg.getPortID();
            hostID = phg.getHostgroupID();
        } else {
            ISCSITargetPort.ISCSITarget target = dpc.getiSCSITarget();
            portID = (short)target.getPortID();
            hostID = target.getId();
        }
        ClosableAddableIteratorCB<LUPathObject> callback = new ClosableAddableIteratorCB<LUPathObject>();
        LUPathObject.getLUPaths(rmiObj, callback, portID, hostID, -1L);
        CloseableAddableIterator<LUPathObject> iter = callback.getWrappedCloseableAddableIter();
        while (iter.hasNext() && 5L != retVal.longValue()) {
            LUPathObject lu = (LUPathObject)iter.next();
            try {
                if (0 != PortandHostGroupInfo.deleteLUPath(this.luPaths, rmiObj, portID, hostID, lu.getSLun())) {
                    retVal = ProviderConstants.UINT32_FIVE;
                    continue;
                }
                retVal = this.processDeleteVolumes(rmiObj, lu, dpc);
            }
            catch (WBEMException we) {
                mLogger.log(Level.SEVERE, "Error processing delete LU request", we);
                retVal = ProviderConstants.UINT32_FIVE;
            }
            catch (Throwable e) {
                mLogger.log(Level.SEVERE, "Unexpected error deleting LUPaths", e);
                retVal = ProviderConstants.UINT32_FIVE;
            }
        }
        dpc.setRetVal(retVal);
    }
}

