/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.ClosableAddableIteratorCB;
import com.hitachi.smi.common.CommonClassAsList;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.StorageVolumeInstrumentation;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.ModifyReplicaSynchronization;
import com.ws.wbem.CloseableAddableIterator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_MRCFsetQSPairDetail;
import sanproject.common.Robj_interface_MRCFsetQSPairDetail2;
import sanproject.common.Robj_interface_MRCFsetQSPairInfo_IN;
import sanproject.common.Robj_interface_MRCFsetQSPairInfo_OUT;
import sanproject.common.Robj_interface_MRCFsetQSPairMain;
import sanproject.serverux.data.SANRmiException;

public class CoalescedModifyReplicaSynchronization
extends Coalescable {
    private Robj_interface_MRCFsetQSPairInfo_IN createSetQSPairInfoINObjectSetPair() throws WBEMException {
        Robj_interface_MRCFsetQSPairInfo_IN ret = null;
        try {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            ArrayList<Robj_interface_MRCFsetQSPairDetail2> pairDetailList = new ArrayList<Robj_interface_MRCFsetQSPairDetail2>();
            List<AbstractJobImpl> childJobs = this.getAbstractJobImpls();
            Iterator<AbstractJobImpl> iter = childJobs.iterator();
            Hashtable<String, String> pairHash = new Hashtable<String, String>();
            ArrayList<DeviceNumber> sVolList = new ArrayList<DeviceNumber>();
            while (iter.hasNext()) {
                AbstractJobImpl childJob = iter.next();
                DeviceNumber[] dns = (DeviceNumber[])childJob.getActionItem();
                DeviceNumber dnPVol = dns[0];
                DeviceNumber dnSVol = dns[1];
                sVolList.add(dnSVol);
                pairHash.put(dnSVol.getDNAsString(), dnPVol.getDNAsString());
            }
            if (!sVolList.isEmpty()) {
                ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, sVolList, Boolean.FALSE);
                CloseableAddableIterator<SnapshotInfo2> snapshotInfos = callback.getWrappedCloseableAddableIter();
                Hashtable<String, String> badSVols = new Hashtable<String, String>();
                while (snapshotInfos.hasNext()) {
                    SnapshotInfo2 snapshotInfo = (SnapshotInfo2)snapshotInfos.next();
                    String sVolDNNum = snapshotInfo.getSVolDNString();
                    String pVolDNNum = (String)pairHash.get(sVolDNNum);
                    String snapshotInfoPVolDNNum = snapshotInfo.getPVolDNString();
                    if (null == pVolDNNum || !pVolDNNum.equals(snapshotInfoPVolDNNum)) {
                        String msg = "Invalid Synchroniation property";
                        badSVols.put(sVolDNNum, "Invalid Synchroniation property");
                        pairHash.remove(sVolDNNum);
                        continue;
                    }
                    Robj_interface_MRCFsetQSPairDetail2 setPairDetail = (Robj_interface_MRCFsetQSPairDetail2)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRDETAIL2);
                    setPairDetail.setRobjPVolIndex(ProviderLibs.getRJiLDEVIndex(rmiObj, snapshotInfo.getPVol()));
                    setPairDetail.setRobjSVolIndex(ProviderLibs.getRJiLDEVIndex(rmiObj, snapshotInfo.getSVol()));
                    setPairDetail.setSCmdKind((short)5);
                    setPairDetail.setSPairKind((short)0);
                    setPairDetail.setSSnapshotKind((short)1);
                    setPairDetail.setSCmdOpt((short)2);
                    pairDetailList.add(setPairDetail);
                    pairHash.remove(sVolDNNum);
                }
                if (!pairDetailList.isEmpty()) {
                    Robj_interface_MRCFsetQSPairDetail[] pairDetailArray = pairDetailList.toArray(new Robj_interface_MRCFsetQSPairDetail[pairDetailList.size()]);
                    Robj_interface_MRCFsetQSPairMain qsPairMain = (Robj_interface_MRCFsetQSPairMain)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRMAIN);
                    qsPairMain.setQSPairDetail(pairDetailArray);
                    qsPairMain.setIPairNum(pairDetailArray.length);
                    ret = (Robj_interface_MRCFsetQSPairInfo_IN)rmiObj.smisCreateHitachiRMIObj(RMIObjectCache.creationObjects.MRCFSETQSPAIRINFO_IN);
                    ret.setQSPairMain(qsPairMain);
                }
                if (!pairHash.isEmpty()) {
                    Set invalidSVols = pairHash.keySet();
                    String msg = "Invalid Synchroniation property";
                    for (String invalidSVol : invalidSVols) {
                        badSVols.put(invalidSVol, "Invalid Synchroniation property");
                    }
                }
                if (badSVols.isEmpty()) {
                    childJobs = this.getAbstractJobImpls();
                    iter = childJobs.iterator();
                    while (iter.hasNext()) {
                        AbstractJobImpl childJob = iter.next();
                        DeviceNumber[] dns = (DeviceNumber[])childJob.getActionItem();
                        DeviceNumber dnSVol = dns[1];
                        String msg = (String)badSVols.get(dnSVol.getDNAsString());
                        if (null == msg) continue;
                        this.markAndRemoveChildJobWithError(iter, childJob, msg);
                    }
                }
            }
        }
        catch (SANRmiException sre) {
            String msg = "Exception communicating with backend: " + sre.getErrMsgEn();
            mLogger.log(Level.SEVERE, msg, sre);
            throw new WBEMException(1, msg, null, (Throwable)sre);
        }
        catch (RemoteException re) {
            String msg = "Remote Exception with backend: " + re;
            mLogger.log(Level.SEVERE, msg, re);
            throw new WBEMException(1, msg, null, (Throwable)re);
        }
        return ret;
    }

    @Override
    protected void executeJob(List<AbstractJobImpl> abstractItems) throws WBEMException {
        this.setAbstractJobImpls(abstractItems);
        this.createConcreteJobFromAbstractJobs();
        mLogger.log(Level.INFO, "CoalescedJob {0} starting", this.getJob().getInstanceID());
        this.markServerJobStarted(0);
        Hashtable<String, Integer> pairStatus = this.validatePairAtrb();
        this.getHitachiJobServiceObject().updateServerJobPercentComplete(25, true);
        this.updateChildrenJobPercentComplete(25);
        if (pairStatus.isEmpty()) {
            mLogger.info("CoalescedModifyReplicaSynchronization " + this.getJob().getInstanceID() + ": could not validate any " + "of the Pair Attributes, skip trying to modify replica");
        } else {
            Robj_interface_MRCFsetQSPairInfo_IN rmiPairInfoIN = this.createSetQSPairInfoINObjectSetPair();
            LinkedList<Robj_interface_MRCFsetQSPairInfo_IN> rmiAction = new LinkedList<Robj_interface_MRCFsetQSPairInfo_IN>();
            rmiAction.add(rmiPairInfoIN);
            this.setItemQueue(rmiAction);
            this.apply2(false);
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(50, true);
            this.updateChildrenJobPercentComplete(50);
            Robj_interface_MRCFsetQSPairInfo_OUT pairInfoOut = (Robj_interface_MRCFsetQSPairInfo_OUT)this.getResult();
            Robj_interface_MRCFsetQSPairMain pairMain = pairInfoOut.getQSPairMain();
            if (pairMain.getIResult() != 0) {
                throw new WBEMException("Result from apply2 method was: " + pairMain.getIResult() + " when deleting snapshot " + " pairs but a value of 0 was expected");
            }
            this.getHitachiJobServiceObject().updateServerJobPercentComplete(75, true);
            this.updateChildrenJobPercentComplete(75);
            this.validatePairStatus(pairStatus);
        }
        this.markServerJobDone();
    }

    private void setChildAffectedElement(AbstractJobImpl childJob, DeviceNumber sVal) {
        ArrayList<CIMObjectPath> affectedElements = new ArrayList<CIMObjectPath>(1);
        if (null != sVal) {
            try {
                StorageVolumeInstrumentation svi = (StorageVolumeInstrumentation)BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageVolumeInstrumentation");
                CIMObjectPath opSyncedElement = svi.generateObjectPath(this.getOwningElement(), sVal);
                affectedElements.add(opSyncedElement);
            }
            catch (WBEMException e) {
                mLogger.severe("Failed to generate objectpath for StorageVolume with a DeviceID of: " + sVal.getDNAsString() + ".  Cannot set affected element for that " + "StorageVolume object");
            }
        }
        childJob.setAffectedElements(affectedElements.toArray(new CIMObjectPath[affectedElements.size()]));
    }

    private Hashtable<String, Integer> validatePairAtrb() throws WBEMException {
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>();
        ArrayList<DeviceNumber> sVolList = new ArrayList<DeviceNumber>();
        List<AbstractJobImpl> childJobs = this.getAbstractJobImpls();
        Iterator<AbstractJobImpl> iter = childJobs.iterator();
        while (iter.hasNext()) {
            AbstractJobImpl childJob = iter.next();
            if (!(childJob instanceof ModifyReplicaSynchronization)) {
                String msg = "Expected all elements of the list to contain instances of ModifyReplicaSynchronization, however at least one instance was a " + childJob.getClass().getSimpleName();
                this.markAndRemoveChildJobWithError(iter, childJob, msg);
                continue;
            }
            DeviceNumber[] dns = (DeviceNumber[])childJob.getActionItem();
            sVolList.add(dns[1]);
        }
        if (!sVolList.isEmpty()) {
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            ClosableAddableIteratorCB<SnapshotInfo2> callback = new ClosableAddableIteratorCB<SnapshotInfo2>();
            SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, sVolList, Boolean.FALSE);
            CloseableAddableIterator<SnapshotInfo2> snapshotInfos = callback.getWrappedCloseableAddableIter();
            Hashtable<String, Integer> invalidSVols = new Hashtable<String, Integer>();
            while (snapshotInfos.hasNext()) {
                SnapshotInfo2 snapshotInfo = (SnapshotInfo2)snapshotInfos.next();
                String sVolDNString = snapshotInfo.getSVolDNString();
                if (snapshotInfo.getPairStatus() != 544 && snapshotInfo.getPairStatus() != 560) {
                    invalidSVols.put(sVolDNString, new Integer(snapshotInfo.getPairStatus()));
                    continue;
                }
                ret.put(sVolDNString, new Integer(snapshotInfo.getPairStatus()));
            }
            if (!invalidSVols.isEmpty()) {
                childJobs = this.getAbstractJobImpls();
                iter = childJobs.iterator();
                while (iter.hasNext()) {
                    AbstractJobImpl childJob = iter.next();
                    DeviceNumber[] dns = (DeviceNumber[])childJob.getActionItem();
                    Integer volAttr = (Integer)invalidSVols.get(dns[1].getDNAsString());
                    if (null == volAttr) continue;
                    String msg = "Job " + this.getJob().getInstanceID() + "The status of the pair with " + "SVol number \"" + dns[1].getDNAsString() + "\" should have a value  of 0x220 or 0x230 " + "but is has a value of " + Integer.toHexString(volAttr);
                    mLogger.log(Level.SEVERE, msg);
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                }
            }
        }
        return ret;
    }

    private void validatePairStatus(Hashtable<String, Integer> previousPairStatusHash) throws WBEMException {
        List<AbstractJobImpl> childJobs = this.getAbstractJobImpls();
        ArrayList<DeviceNumber> sVolList = new ArrayList<DeviceNumber>();
        Iterator<AbstractJobImpl> iter = childJobs.iterator();
        for (int i = 0; i < childJobs.size(); ++i) {
            AbstractJobImpl childJob = childJobs.get(i);
            DeviceNumber[] dns = (DeviceNumber[])childJob.getActionItem();
            sVolList.add(dns[1]);
        }
        if (!sVolList.isEmpty()) {
            DeviceNumber[] dns;
            AbstractJobImpl childJob;
            boolean notDone = false;
            long WAIT_TIME = 600000L;
            long startTime = System.currentTimeMillis();
            long END_WAIT_TIME = startTime + 600000L;
            HashSet<String> completedSVols = new HashSet<String>();
            Hashtable<String, String> badSVolHash = new Hashtable<String, String>();
            RMIObjectCache rmiObj = RMIObjectMapping.getRMIObjectMapping(this.getDeviceSerialNumber()).getRMIObject();
            do {
                notDone = false;
                CommonClassAsList<SnapshotInfo2> callback = new CommonClassAsList<SnapshotInfo2>();
                SnapshotInfo2.getSnapshotInfo2(rmiObj, callback, sVolList, Boolean.FALSE);
                LinkedList<SnapshotInfo2> snapshotInfos = callback.getReturnValue();
                if (snapshotInfos.isEmpty()) {
                    for (DeviceNumber sVol : sVolList) {
                        completedSVols.add(sVol.getDNAsString());
                    }
                }
                for (SnapshotInfo2 snapshotInfo : snapshotInfos) {
                    String errorMsg;
                    String sVolDNNString = snapshotInfo.getSVolDNString();
                    if (completedSVols.contains(sVolDNNString)) continue;
                    Integer prevPairStatus = previousPairStatusHash.get(sVolDNNString);
                    if (null == prevPairStatus) {
                        errorMsg = "Could not get PairStatus for SVol (DN ID:" + sVolDNNString;
                        badSVolHash.put(sVolDNNString, errorMsg);
                        completedSVols.add(sVolDNNString);
                        continue;
                    }
                    if (prevPairStatus.intValue() != snapshotInfo.getPairStatus() && 513 != snapshotInfo.getPairStatus() && 544 != snapshotInfo.getPairStatus() && 0 != snapshotInfo.getPairStatus()) {
                        errorMsg = "The VolAtrb value on the SnapshotInfo for this SVol (DN ID:" + sVolDNNString + ") was not 0x00 (Not Paired) but the Pair " + "Status changed from \"" + prevPairStatus + "\" to \"" + snapshotInfo.getPairStatus() + "\"";
                        badSVolHash.put(sVolDNNString, errorMsg);
                        completedSVols.add(sVolDNNString);
                        continue;
                    }
                    if (0 == snapshotInfo.getPairStatus()) {
                        completedSVols.add(sVolDNNString);
                        continue;
                    }
                    long now = System.currentTimeMillis();
                    if (now > END_WAIT_TIME) {
                        String errorMsg2 = "Waited 600000 Milliseconds for the pair status of SVol " + sVolDNNString + " to change to 0x00 (Not Paired) but it " + "did not change.  Marking " + "this job as Failed (4)";
                        badSVolHash.put(sVolDNNString, errorMsg2);
                        completedSVols.add(sVolDNNString);
                        continue;
                    }
                    notDone = true;
                }
            } while (notDone);
            if (!badSVolHash.isEmpty()) {
                childJobs = this.getAbstractJobImpls();
                iter = childJobs.iterator();
                while (iter.hasNext()) {
                    childJob = iter.next();
                    dns = (DeviceNumber[])childJob.getActionItem();
                    DeviceNumber dnSVol = dns[1];
                    String msg = (String)badSVolHash.get(dnSVol.getDNAsString());
                    if (null == msg) continue;
                    mLogger.severe(msg);
                    this.markAndRemoveChildJobWithError(iter, childJob, msg);
                }
            }
            if (!completedSVols.isEmpty()) {
                childJobs = this.getAbstractJobImpls();
                iter = childJobs.iterator();
                while (iter.hasNext()) {
                    childJob = iter.next();
                    dns = (DeviceNumber[])childJob.getActionItem();
                    if (!completedSVols.contains(dns[1].getDNAsString())) {
                        String msg = "Could not get Pair Values for volume:" + dns[1].getDNAsString();
                        mLogger.severe(msg);
                        this.markAndRemoveChildJobWithError(iter, childJob, msg);
                        continue;
                    }
                    this.setChildAffectedElement(childJob, dns[1]);
                }
            } else {
                String msg = "Could not set affected elements because no jobs completed";
                mLogger.warning("Could not set affected elements because no jobs completed");
            }
        } else {
            String msg = "Could not validate pair status because all jobs were removed because of some type of error";
            mLogger.warning("Could not validate pair status because all jobs were removed because of some type of error");
        }
    }
}

