/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.common.AbstractBaseCommonObject;
import com.hitachi.smi.common.BaseDeviceNumber;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.ThinPool;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedCreateVolumeLabelJob;
import com.hitachi.smi.jobs.ElementNameData;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class CreateModifyVolumeLabel
extends AbstractJobImpl
implements HitachiJobCallbackIF {
    public CreateModifyVolumeLabel(String pUserName, String pIPAddress, CIMObjectPath owningService, DeviceNumber dn, String label, CIMObjectPath volume) throws WBEMException {
        super(dn.getSerialNumber(), "CreateOrModifyVolumeLabel", pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementStorageVolume", "HITACHI_StorageCSOwningJobElement", null);
        ElementNameData ld = new ElementNameData(dn, label);
        this.setActionItem(ld);
        this.setCallback(this);
        this.setAffectedElements(new CIMObjectPath[]{volume});
    }

    public CreateModifyVolumeLabel(String pUserName, String pIPAddress, CIMObjectPath owningService, String label, CIMObjectPath objPath, AbstractBaseCommonObject obj, String affectedJobElement, String owningJobElement) throws WBEMException {
        super(obj.getSerialNumber(), "CreateOrModifyVolumeLabel", pUserName, pIPAddress, owningService, affectedJobElement, owningJobElement, null);
        ElementNameData ld;
        if (obj instanceof ThinPool) {
            ld = new ElementNameData((ThinPool)obj, label);
        } else if (obj instanceof BaseDeviceNumber) {
            ld = new ElementNameData((BaseDeviceNumber)obj, label);
        } else {
            throw new WBEMException("Common object, \"" + obj.getClass().getSimpleName() + "\" is not supported by this class");
        }
        this.setActionItem(ld);
        this.setCallback(this);
        this.setAffectedElements(new CIMObjectPath[]{objPath});
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedCreateVolumeLabelJob();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    public void processResult() throws WBEMException {
        WBEMException we = null;
        try {
            ((ElementNameData)this.getActionItem()).processResult(this, this.getResultIndex());
        }
        catch (WBEMException e) {
            we = e;
        }
        catch (Throwable e) {
            we = new WBEMException(1, "Exception getting transaction result: " + e, null, e);
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateVolumeLabel ");
        builder.append(this.getActionItem());
        return builder.toString();
    }
}

