/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.jobs;

import com.hitachi.smi.cache.CacheUpdateNotifier;
import com.hitachi.smi.cache.CacheUpdater;
import com.hitachi.smi.common.DeviceNumber;
import com.hitachi.smi.common.SnapshotInfo2;
import com.hitachi.smi.jobs.AbstractJobImpl;
import com.hitachi.smi.jobs.Coalescable;
import com.hitachi.smi.jobs.CoalescedModifyReplicaSynchronization;
import com.hitachi.smi.jobs.HitachiJobCallbackIF;
import java.io.Serializable;
import java.util.Arrays;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;
import sanproject.common.Robj_interface_MRCFsetQSPairInfo_OUT;
import sanproject.common.Robj_interface_MRCFsetQSPairMain;

public class ModifyReplicaSynchronization
extends AbstractJobImpl
implements HitachiJobCallbackIF,
CacheUpdateNotifier {
    private static final String METHOD_NAME = "ModifyReplicaSynchronization";
    private boolean jobDone;
    private boolean registeredCallback = false;

    public ModifyReplicaSynchronization(String pUserName, String pIPAddress, CIMObjectPath owningService, DeviceNumber[] synchronizationDNs, CIMInstance instSnapshotSynchronized) throws WBEMException {
        super(synchronizationDNs[0].getSerialNumber(), METHOD_NAME, pUserName, pIPAddress, owningService, "HITACHI_AffectedJobElementStorageVolume", "HITACHI_ReplicationCSOwningJobElement", null);
        if (2 != synchronizationDNs.length) {
            throw new WBEMException("Must pass in a non-null DeviceNumber array");
        }
        this.jobDone = false;
        CacheUpdater.registerUpdateCallback(CacheUpdater.CallBackType.SNAPSHOT, this, null);
        this.registeredCallback = true;
        this.setCallback(this);
        this.setActionItem(synchronizationDNs);
    }

    @Override
    public <T extends Serializable> void cacheItemAdded(T pObj) {
    }

    @Override
    public <T extends Serializable> void cacheItemDeleted(T pObj) {
        SnapshotInfo2 si = (SnapshotInfo2)pObj;
        DeviceNumber[] actionDNs = (DeviceNumber[])this.getActionItem();
        DeviceNumber jobPVol = actionDNs[0];
        DeviceNumber jobSVol = actionDNs[1];
        mLogger.log(Level.FINE, "ModifyElementReplica Check if added pVol, {0}, matches the pVol, {1}, this job ({2}) wants", new Object[]{si.getPVolDNString(), jobPVol.getDNAsString(), this.getJobID()});
        if (si.getPVolDNString().equals(jobPVol.getDNAsString())) {
            mLogger.log(Level.FINE, "Check if updated cached sVol, {0}, matches the sVol, {1} this job ({2}) wants", new Object[]{si.getSVolDNString(), jobSVol.getDNAsString(), this.getJobID()});
            if (si.getSVolDNString().equals(jobSVol.getDNAsString())) {
                mLogger.log(Level.FINE, "Job {0}: cache has been updated.", this.getJobID());
                this.jobDone = true;
            } else {
                mLogger.log(Level.FINE, "Job {0}: Cache change did not not match - this is OK", this.getJobID());
            }
        } else {
            mLogger.log(Level.FINE, "Job {0}: pVol change did not match - this is OK", this.getJobID());
        }
    }

    @Override
    public <T extends Serializable> void cacheItemModified(T pObj) {
    }

    @Override
    protected Coalescable getCoalescableObject() {
        return new CoalescedModifyReplicaSynchronization();
    }

    @Override
    public void jobStateCallback(HitachiJobCallbackIF.CallBackType type) throws WBEMException {
        switch (type) {
            case BEFORE_TRANSACTION: {
                this.getHitachiJobServiceObject().markServerJobStarted();
                break;
            }
            case BEFORE_JOB_COMPLETE: {
                break;
            }
            case AFTER_TRANSACTION: {
                this.processResult();
                break;
            }
        }
        if (type != HitachiJobCallbackIF.CallBackType.AFTER_JOB_COMPLETE) {
            this.getHitachiJobServiceObject().updateJob(this.getJob().getCIMInstance(this.getOwningElement()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult() {
        WBEMException we;
        block15: {
            we = null;
            try {
                Object t = this.getRMIResult();
                Robj_interface_MRCFsetQSPairInfo_OUT jobRet = (Robj_interface_MRCFsetQSPairInfo_OUT)t;
                Robj_interface_MRCFsetQSPairMain data = jobRet.getQSPairMain();
                long result = data.getIResult();
                if (result != 0L) {
                    String msg = "Job ," + this.getJobID() + " received error: 7005 - " + result;
                    mLogger.log(Level.SEVERE, msg);
                    we = new WBEMException(msg);
                    break block15;
                }
                long current = System.currentTimeMillis();
                long end = current + 300000L;
                while (!this.jobDone && end > current) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        mLogger.log(Level.WARNING, "Job " + this.getJobID() + ": While waiting for cache update an " + "InterruptedException occurred (non-fatal)", ie);
                    }
                    current = System.currentTimeMillis();
                }
                if (!this.jobDone) {
                    we = new WBEMException("Job " + this.getJobID() + " completed successfully, however; we could " + "not detect any changes to the back end");
                }
            }
            catch (WBEMException e) {
                we = e;
            }
            catch (ClassCastException cce) {
                we = new WBEMException(1, cce.toString(), null, (Throwable)cce);
            }
            catch (Throwable t) {
                we = new WBEMException(1, t.toString(), null, t);
            }
            finally {
                if (this.registeredCallback) {
                    CacheUpdater.unregisterUpdateCallback(CacheUpdater.CallBackType.SNAPSHOT, this, null);
                }
            }
        }
        this.getHitachiJobServiceObject().markServerJobDone(we);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModifyReplicaSynchronization [");
        builder.append(this.getMethodName());
        builder.append("] Parameters:\nDeviceNumbers: ");
        Object[] dns = (DeviceNumber[])this.getActionItem();
        builder.append(Arrays.toString(dns));
        return builder.toString();
    }
}

