/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.paralleltasker;

import com.hitachi.smi.paralleltasker.Task;
import com.hitachi.smi.paralleltasker.TaskStop;
import com.ws.wbem.jserver.DaemonThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskProcessor
extends TaskStop {
    private static AtomicLong mSeqNum = new AtomicLong(0L);
    private final ExecutorService exec;
    private final String mName;
    private final AtomicInteger mNumberOfItemsToProcess;

    public TaskProcessor(String threadName, int numItems) {
        this.mName = threadName;
        this.mNumberOfItemsToProcess = new AtomicInteger(numItems);
        int numThreads = Runtime.getRuntime().availableProcessors() < 2 ? 2 : Runtime.getRuntime().availableProcessors();
        this.exec = Executors.newFixedThreadPool(numThreads, (ThreadFactory)new DaemonThreadFactory());
        Logger mLogger = Logger.getLogger("com.hitachi.smis.logger.cache");
        mLogger.fine("Created thread pool for " + this.mName);
    }

    public void addTask(final Task theTask) {
        if (!this.exec.isShutdown()) {
            Runnable worker = new Runnable(){

                @Override
                public void run() {
                    Thread thread = Thread.currentThread();
                    String tgName = thread.getThreadGroup().getName();
                    thread.setName(tgName + ":" + TaskProcessor.this.mName + " - " + mSeqNum.getAndAdd(1L));
                    theTask.doTask();
                }
            };
            try {
                this.exec.execute(worker);
            }
            catch (RejectedExecutionException ree) {
                Logger logger = Logger.getLogger("com.hitachi.smis.logger.cache");
                logger.log(Level.FINE, "Thread pool rejected task, could be shutting down.", ree);
            }
        }
    }

    @Override
    public synchronized void setStop(boolean stop) {
        if (stop) {
            this.mNumberOfItemsToProcess.set(0);
            this.exec.shutdown();
        }
        super.setStop(stop);
    }

    public int taskDone() {
        int ret = -1;
        ret = this.mNumberOfItemsToProcess.decrementAndGet();
        if (ret < 1) {
            this.setStop(true);
        }
        return ret;
    }
}

