/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.smi.providers;

import com.hitachi.smi.cache.RMIObjectCache;
import com.hitachi.smi.common.CustomCloseableIterator;
import com.hitachi.smi.common.ProviderLibs;
import com.hitachi.smi.common.RMIObjectMapping;
import com.hitachi.smi.instrumentation.BaseInstrumentation;
import com.hitachi.smi.instrumentation.StorageSystemInstrumentation;
import com.hitachi.smi.providers.BaseAssociatorProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import javax.wbem.WBEMException;

public class StorageSystemConformsToProfile
extends BaseAssociatorProvider {
    private static final String CLASSNAME = "HITACHI_StorageSystemConformsToProfile";
    private static final String CCN_REGISTERED_PROFILE = "HITACHI_Array%sProfile";
    private static final String CPV_RP_150 = "1.5.0";
    private static final String CPV_RP_160 = "1.6.0";
    private static final String CPV_RP_170 = "1.7.0";
    private final StorageSystemInstrumentation mSSInstrumentation = (StorageSystemInstrumentation)BaseInstrumentation.getInstrumentationInstance("com.hitachi.smi.instrumentation.StorageSystemInstrumentation");
    private static final String CPN_CONFORMANT_STANDARD = "ConformantStandard";
    private static final String CPN_MANAGED_ELEMENT = "ManagedElement";
    private static final String CPN_INSTANCE_ID = "InstanceID";
    private static final String CPV_RP_150_INSTANCE_ID = "Array:1.5.0";
    private static final String CPV_RP_160_INSTANCE_ID = "Array:1.6.0";
    private static final String CPV_RP_170_INSTANCE_ID = "Array:1.7.0";
    private static final String[] VALID_INSTANCE_IDS = new String[]{"Array:1.7.0", "Array:1.6.0", "Array:1.5.0"};

    @Override
    protected void assocEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String resultClass, String role, String resultRole, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != objectName && null != assocName && CLASSNAME.equalsIgnoreCase(assocName.getObjectName())) {
                if (this.isArrayProfile(objectName) && ProviderLibs.getInteropNamespace().equalsIgnoreCase(objectName.getNamespace()) && (null == role || role.equalsIgnoreCase(CPN_CONFORMANT_STANDARD)) && (null == resultRole || resultRole.equalsIgnoreCase(CPN_MANAGED_ELEMENT))) {
                    String cvRPInstanceID;
                    CIMProperty cpRPInstanceID = objectName.getKey(CPN_INSTANCE_ID);
                    String string = cvRPInstanceID = cpRPInstanceID != null ? (String)cpRPInstanceID.getValue() : null;
                    if (this.isValidInstanceID(cvRPInstanceID) && this.createRegisteredProfileOP(objectName, cvRPInstanceID).equalsModelPath(objectName)) {
                        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
                        CIMObjectPath ssImplOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), ProviderLibs.getImplementationNamespace(), "HITACHI_StorageSystem", null);
                        for (RMIObjectMapping device : devices) {
                            if (isObjectPath) {
                                iter.add(this.mSSInstrumentation.generateObjectPath(ssImplOP, device.getRMIObject()));
                                continue;
                            }
                            iter.add(this.mSSInstrumentation.generateInstance(ssImplOP, propertyList, device.getRMIObject()));
                        }
                    }
                } else if ("HITACHI_StorageSystem".equalsIgnoreCase(objectName.getObjectName()) && (null == role || role.equalsIgnoreCase(CPN_MANAGED_ELEMENT)) && (null == resultRole || resultRole.equalsIgnoreCase(CPN_CONFORMANT_STANDARD))) {
                    for (String rpInstanceID : VALID_INSTANCE_IDS) {
                        CIMObjectPath rpOP = this.createRegisteredProfileOP(objectName, rpInstanceID);
                        if (isObjectPath) {
                            iter.add(rpOP);
                            continue;
                        }
                        iter.add(mHandle.getInstance(rpOP, propertyList));
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    private CIMInstance createECTPInstance(CIMObjectPath objectName, String[] propertyList, String rpInstanceID, RMIObjectCache deviceRMIObject) throws WBEMException {
        CIMProperty[] props;
        CIMObjectPath impOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), ProviderLibs.getImplementationNamespace(), "HITACHI_StorageSystem", null);
        CIMObjectPath ssOP = this.mSSInstrumentation.generateObjectPath(impOP, deviceRMIObject);
        CIMObjectPath rpOP = this.createRegisteredProfileOP(objectName, rpInstanceID);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(CPN_CONFORMANT_STANDARD, new CIMDataType(rpOP.getObjectName()), (Object)rpOP, true), new CIMProperty(CPN_MANAGED_ELEMENT, new CIMDataType("HITACHI_StorageSystem"), (Object)ssOP, true)};
        CIMObjectPath retOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), CLASSNAME, keys);
        if (null == propertyList) {
            props = keys;
        } else {
            ArrayList<CIMProperty> propList = new ArrayList<CIMProperty>();
            Arrays.sort(propertyList);
            if (Arrays.binarySearch(propertyList, CPN_CONFORMANT_STANDARD) >= 0) {
                propList.add(keys[0]);
            }
            if (Arrays.binarySearch(propertyList, CPN_MANAGED_ELEMENT) >= 0) {
                propList.add(keys[1]);
            }
            props = propList.toArray(new CIMProperty[propList.size()]);
        }
        return new CIMInstance(retOP, props).filterProperties(propertyList);
    }

    private CIMObjectPath createECTPObjectPath(CIMObjectPath objectName, String rpInstanceID, RMIObjectCache deviceRMIObject) throws WBEMException {
        CIMObjectPath impOP = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), ProviderLibs.getImplementationNamespace(), "HITACHI_StorageSystem", null);
        CIMObjectPath ssOP = this.mSSInstrumentation.generateObjectPath(impOP, deviceRMIObject);
        CIMObjectPath rpOP = this.createRegisteredProfileOP(objectName, rpInstanceID);
        CIMProperty[] keys = new CIMProperty[]{new CIMProperty(CPN_CONFORMANT_STANDARD, new CIMDataType(rpOP.getObjectName()), (Object)rpOP, true), new CIMProperty(CPN_MANAGED_ELEMENT, new CIMDataType("HITACHI_StorageSystem"), (Object)ssOP, true)};
        return new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), objectName.getNamespace(), CLASSNAME, keys);
    }

    private CIMObjectPath createRegisteredProfileOP(CIMObjectPath objectName, String instanceID) throws WBEMException {
        CIMObjectPath ret = null;
        if (null != instanceID) {
            String profileName = this.getProfileName(instanceID);
            CIMProperty[] keys = new CIMProperty[]{new CIMProperty(CPN_INSTANCE_ID, CIMDataType.STRING_T, (Object)instanceID, true)};
            ret = new CIMObjectPath(objectName.getScheme(), objectName.getHost(), objectName.getPort(), ProviderLibs.getInteropNamespace(), profileName, keys);
        }
        return ret;
    }

    @Override
    protected void enumerate(CustomCloseableIterator<?> iter, CIMObjectPath op, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            for (String rpInstanceID : VALID_INSTANCE_IDS) {
                Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
                for (RMIObjectMapping device : devices) {
                    if (isObjectPath) {
                        iter.add(this.createECTPObjectPath(op, rpInstanceID, device.getRMIObject()));
                        continue;
                    }
                    iter.add(this.createECTPInstance(op, propertyList, rpInstanceID, device.getRMIObject()));
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }

    @Override
    public CIMInstance getInstance(CIMObjectPath objectName, String[] propertyList) throws WBEMException {
        this.authorizeGet();
        if (objectName.getObjectName().equalsIgnoreCase(CLASSNAME)) {
            CIMObjectPath ssOP;
            CIMObjectPath rpOP = null != objectName.getKey(CPN_CONFORMANT_STANDARD) ? (CIMObjectPath)objectName.getKey(CPN_CONFORMANT_STANDARD).getValue() : null;
            CIMObjectPath cIMObjectPath = ssOP = null != objectName.getKey(CPN_MANAGED_ELEMENT) ? (CIMObjectPath)objectName.getKey(CPN_MANAGED_ELEMENT).getValue() : null;
            if (null != rpOP && null != ssOP) {
                CIMProperty cpRPInstanceID = rpOP.getKey(CPN_INSTANCE_ID);
                String cvRPInstanceID = cpRPInstanceID != null ? (String)cpRPInstanceID.getValue() : null;
                RMIObjectCache cache = this.isValidSSID(ssOP);
                if (null != cvRPInstanceID && this.isValidInstanceID(cvRPInstanceID) && rpOP.equalsModelPath(this.createRegisteredProfileOP(objectName, cvRPInstanceID)) && null != cache) {
                    return this.createECTPInstance(objectName, propertyList, cvRPInstanceID, cache);
                }
            }
        }
        throw new WBEMException(6, objectName.toString());
    }

    private String getProfileName(String instanceID) throws WBEMException {
        String profileVersion;
        if (instanceID.endsWith(CPV_RP_150)) {
            profileVersion = "15";
        } else if (instanceID.endsWith(CPV_RP_160)) {
            profileVersion = "16";
        } else if (instanceID.endsWith(CPV_RP_170)) {
            profileVersion = "17";
        } else {
            throw new WBEMException(instanceID + " is an unknown profile");
        }
        String profileName = String.format(CCN_REGISTERED_PROFILE, profileVersion);
        return profileName;
    }

    private boolean isArrayProfile(CIMObjectPath objectName) {
        boolean ret = false;
        if ("HITACHI_Array15Profile".equalsIgnoreCase(objectName.getObjectName()) || "HITACHI_Array16Profile".equalsIgnoreCase(objectName.getObjectName()) || "HITACHI_Array17Profile".equalsIgnoreCase(objectName.getObjectName())) {
            ret = true;
        }
        return ret;
    }

    private boolean isValidInstanceID(String instanceID) {
        boolean ret = false;
        if (null != instanceID) {
            for (String validInstID : VALID_INSTANCE_IDS) {
                if (!instanceID.equals(validInstID)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private RMIObjectCache isValidSSID(CIMObjectPath ssOP) {
        try {
            Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
            for (RMIObjectMapping device : devices) {
                CIMObjectPath p = this.mSSInstrumentation.generateObjectPath(ssOP, device.getRMIObject());
                if (!p.equalsModelPath(ssOP)) continue;
                return device.getRMIObject();
            }
        }
        catch (WBEMException e) {
            return null;
        }
        return null;
    }

    @Override
    protected void refEnumerate(CustomCloseableIterator<?> iter, CIMObjectPath assocName, CIMObjectPath objectName, String role, String[] propertyList, String filterQueryLanguage, String filterQuery, boolean continueOnError, boolean isObjectPath) throws WBEMException {
        try {
            if (null != objectName && null != assocName && CLASSNAME.equalsIgnoreCase(assocName.getObjectName())) {
                if (this.isArrayProfile(objectName) && (null == role || role.equalsIgnoreCase(CPN_CONFORMANT_STANDARD))) {
                    String cvRPInstanceID;
                    CIMProperty cpRPInstanceID = objectName.getKey(CPN_INSTANCE_ID);
                    String string = cvRPInstanceID = cpRPInstanceID != null ? (String)cpRPInstanceID.getValue() : null;
                    if (this.isValidInstanceID(cvRPInstanceID) && this.createRegisteredProfileOP(objectName, cvRPInstanceID).equalsModelPath(objectName)) {
                        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
                        for (RMIObjectMapping device : devices) {
                            if (isObjectPath) {
                                iter.add(this.createECTPObjectPath(objectName, cvRPInstanceID, device.getRMIObject()));
                                continue;
                            }
                            iter.add(this.createECTPInstance(objectName, propertyList, cvRPInstanceID, device.getRMIObject()));
                        }
                    }
                } else if ("HITACHI_StorageSystem".equalsIgnoreCase(objectName.getObjectName()) && (null == role || role.equalsIgnoreCase(CPN_MANAGED_ELEMENT))) {
                    for (String rpInstanceID : VALID_INSTANCE_IDS) {
                        Collection<RMIObjectMapping> devices = RMIObjectMapping.getAllRMIObjectMappings();
                        for (RMIObjectMapping device : devices) {
                            if (isObjectPath) {
                                iter.add(this.createECTPObjectPath(objectName, rpInstanceID, device.getRMIObject()));
                                continue;
                            }
                            iter.add(this.createECTPInstance(objectName, propertyList, rpInstanceID, device.getRMIObject()));
                        }
                    }
                }
            }
        }
        catch (WBEMException we) {
            if (null != iter) {
                iter.setException(we);
                iter.close();
            }
            throw we;
        }
        if (null != iter) {
            iter.done();
        }
    }
}

