/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof.compiler;

import com.ws.cim.mof.compiler.CIMMutableQualifier;
import com.ws.cim.mof.compiler.CIMMutableValue;
import com.ws.cim.mof.compiler.CIMValue;
import java.util.ArrayList;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMQualifier;

public class CIMMutableClassProperty {
    private CIMMutableQualifier[] mQualifiers;
    private String mName;
    private Object mValue;
    private CIMDataType mType;
    private boolean mIsKey = false;
    private String mComment = "";

    public CIMMutableClassProperty() {
    }

    public CIMMutableClassProperty(CIMClassProperty<?> p) {
        this();
        CIMQualifier<?>[] propQuals;
        this.setName(p.getName());
        this.setType(p.getDataType());
        if (null != p.getValue() && !this.mType.isArray()) {
            this.setValue(new CIMMutableValue(p.getValue()));
        }
        this.setKey(p.isKey());
        ArrayList<CIMMutableQualifier> list = new ArrayList<CIMMutableQualifier>();
        for (CIMQualifier<?> prop : propQuals = p.getQualifiers()) {
            list.add(new CIMMutableQualifier(prop));
        }
        this.setQualifiers(list.toArray(new CIMMutableQualifier[list.size()]));
    }

    public void addComment(String comment) {
        if (comment != null) {
            this.mComment = this.mComment + comment;
        }
    }

    public CIMQualifier<?>[] getCIMQualifiers() {
        ArrayList l = new ArrayList();
        if (this.mQualifiers != null) {
            for (CIMMutableQualifier q : this.mQualifiers) {
                l.add(q.getCIMQualifier());
            }
        }
        return l.toArray(new CIMQualifier[l.size()]);
    }

    public String getComment() {
        return this.mComment;
    }

    public String getName() {
        return this.mName;
    }

    public CIMDataType getDataType() {
        return this.mType;
    }

    public Object getValue() {
        return this.mValue;
    }

    public boolean isKey() {
        return this.mIsKey;
    }

    public void setName(String pName) {
        this.mName = pName;
    }

    public void setKey(boolean pKey) {
        this.mIsKey = pKey;
    }

    public void setType(CIMDataType pType) {
        this.mType = pType;
    }

    public void setValue(Object pValue) {
        this.mValue = pValue;
    }

    public CIMMutableQualifier getQualifier(String name) {
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            if (!this.mQualifiers[i].getName().equalsIgnoreCase(name)) continue;
            return this.mQualifiers[i];
        }
        return null;
    }

    public CIMMutableQualifier[] getQualifiers() {
        return this.mQualifiers;
    }

    public void replaceQualifier(CIMMutableQualifier p) {
        for (int i = 0; i < this.mQualifiers.length; ++i) {
            CIMMutableQualifier prop = this.mQualifiers[i];
            if (null == prop || null == prop.getName() || null == p || null == p.getName()) {
                return;
            }
            if (!prop.getName().equals(p.getName())) continue;
            this.mQualifiers[i] = p;
            return;
        }
    }

    public void setQualifiers(CIMMutableQualifier[] pQualifiers) {
        this.mQualifiers = pQualifiers;
    }

    public CIMClassProperty<?> getCIMProperty() {
        if (this.mType.isArray()) {
            Object[] obj = null;
            if (null != this.mValue) {
                obj = CIMValue.getArrayValueFromMutableValue(this.mType.getType(), (CIMMutableValue[])this.mValue);
            }
            return new CIMClassProperty<Object[]>(this.getName(), this.getDataType(), obj, this.getCIMQualifiers(), this.mIsKey, false);
        }
        Object o = CIMValue.getValueFromMutableValue(this.mType.getType(), (CIMMutableValue)this.mValue);
        return new CIMClassProperty<Object>(this.getName(), this.getDataType(), o, this.getCIMQualifiers(), this.mIsKey, false);
    }
}

