/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof.compiler;

import com.ws.cim.mof.compiler.CIMMutableValue;
import com.ws.utilities.wbem.ValueHelper;
import java.util.ArrayList;
import javax.cim.CIMDataType;
import javax.cim.CIMQualifier;

public class CIMMutableQualifier {
    private String mComment = "";
    private int mFlavorList = 0;
    private String mName;
    private CIMDataType mType;
    private Object mValue;

    public CIMMutableQualifier() {
    }

    public CIMMutableQualifier(CIMQualifier<?> q) {
        this();
        if (null == q) {
            throw new IllegalArgumentException();
        }
        this.setName(q.getName());
        this.setType(q.getDataType());
        if (q.getValue() instanceof Object[]) {
            Object[] oArray = (Object[])q.getValue();
            CIMMutableValue[] cmValue = new CIMMutableValue[oArray.length];
            int i = 0;
            for (Object o : oArray) {
                cmValue[i++] = new CIMMutableValue(o);
            }
            this.setValue(cmValue);
        } else {
            this.setValue(new CIMMutableValue(q.getValue()));
        }
        this.addFlavor(q.getFlavor());
    }

    public void addComment(String comment) {
        if (comment != null) {
            this.mComment = this.mComment + comment;
        }
    }

    public void addFlavor(int f) {
        this.mFlavorList |= f;
    }

    public CIMQualifier<?> getCIMQualifier() {
        Object[] o = this.getValue();
        if (this.mType != null && this.mType.isArray() || o != null && o instanceof CIMMutableValue[]) {
            CIMMutableValue[] oArray = (CIMMutableValue[])this.mValue;
            ArrayList<Object> l = new ArrayList<Object>();
            for (CIMMutableValue value : oArray) {
                l.add(value.getValue());
            }
            o = this.mType != null ? ValueHelper.arrayConvert((int)this.mType.getType(), l) : l.toArray(new Object[l.size()]);
            return new CIMQualifier<Object[]>(this.mName, this.mType, o, this.mFlavorList);
        }
        o = this.getValue();
        o = ((CIMMutableValue)o).getValue();
        return new CIMQualifier<Object>(this.mName, this.mType, o, this.mFlavorList);
    }

    public String getComment() {
        return this.mComment;
    }

    public CIMDataType getDataType() {
        return this.mType;
    }

    public String getName() {
        return this.mName;
    }

    public Object getValue() {
        if (this.mValue == null) {
            this.mType = CIMDataType.BOOLEAN_T;
            CIMMutableValue val = new CIMMutableValue();
            val.setValue(Boolean.TRUE);
            return val;
        }
        return this.mValue;
    }

    public void setName(String n) {
        this.mName = n;
    }

    public void setType(CIMDataType cdt) {
        this.mType = cdt;
    }

    public void setValue(Object o) {
        if (!(o instanceof CIMMutableValue) && !(o instanceof CIMMutableValue[])) {
            throw new IllegalArgumentException("Must be of type CIMMutableValue");
        }
        this.mValue = o;
    }

    public String toString() {
        return this.getCIMQualifier().toString();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        CIMMutableQualifier q;
        return o instanceof CIMMutableQualifier && (q = (CIMMutableQualifier)o).getName().equalsIgnoreCase(this.getName());
    }
}

