/*
 * Decompiled with CFR 0.152.
 */
package com.ws.cim.mof.compiler;

import com.ws.cim.mof.compiler.CIMMutableClass;
import com.ws.cim.mof.compiler.CIMMutableClassProperty;
import com.ws.cim.mof.compiler.CIMMutableDataType;
import com.ws.cim.mof.compiler.CIMMutableInstance;
import com.ws.cim.mof.compiler.CIMMutableMethod;
import com.ws.cim.mof.compiler.CIMMutableParameter;
import com.ws.cim.mof.compiler.CIMMutablePragma;
import com.ws.cim.mof.compiler.CIMMutableProperty;
import com.ws.cim.mof.compiler.CIMMutableQualifier;
import com.ws.cim.mof.compiler.CIMMutableQualifierType;
import com.ws.cim.mof.compiler.CIMMutableValue;
import com.ws.cim.mof.compiler.JavaCharStream;
import com.ws.cim.mof.compiler.MOFParserConstants;
import com.ws.cim.mof.compiler.MOFParserHandler;
import com.ws.cim.mof.compiler.MOFParserTokenManager;
import com.ws.cim.mof.compiler.ParseException;
import com.ws.cim.mof.compiler.Token;
import com.ws.utilities.wbem.ValueHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.wbem.WBEMException;

public class MOFParser
implements MOFParserConstants {
    private MOFParserHandler comp = null;
    private boolean mIsInvoked;
    private String mPath;
    private String mFileName;
    private CIMMutableQualifierType mCIMQualifierType;
    private CIMMutableDataType mCIMDataType;
    private CIMMutableClassProperty mCIMClassProperty;
    private CIMMutableMethod mCIMMethod;
    private CIMMutableParameter mCIMParameter;
    private CIMMutableClass mCIMClass;
    private ArrayList<CIMMutableMethod> mMethodList;
    private ArrayList<CIMMutableClassProperty> mPropertyList;
    private static Hashtable<String, CIMObjectPath> instanceAliases;
    private String mNamespace;
    private String mAliasName;
    public QualifierList mQualifierList;
    public MOFParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private int jj_gen;
    private final int[] jj_la1 = new int[52];
    private final int[] jj_la1_0 = new int[]{604111744, 604111744, 0, 0x4020000, 604111744, 0, 384, 123904, 2910208, 0, 0, 0, 0, 33425408, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0x5000000, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 31, 0, 0, -2146959392, Integer.MIN_VALUE, 524256, 0, 0, 0, Integer.MIN_VALUE, 0x20000000, 524256, 0, 0, 0, 0, -2146959392, -2146959392, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x1000000, 524256, 8160, 24576, 2146959360, 0, 2146959360, 0xFC00000, 0x7000000, 0x20000000, 0x180000};
    private final int[] jj_la1_2 = new int[]{256, 256, 256, 0, 256, 0, 0, 0, 0, 256, 32, 32, 4, 0, 4, 4, 0, 4, 8, 1088, 0, 0, 8, 256, 256, 256, 256, 32, 32, 256, 1, 256, 1024, 4, 256, 256, 256, 0, 0, 256, 256, 0, 0, 0, 0, 65, 4, 1, 0, 0, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[3];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private final int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private String checkComments(Token t) {
        if (t == null || t.specialToken == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        Token tmp_t = t.specialToken;
        while (tmp_t.specialToken != null) {
            tmp_t = tmp_t.specialToken;
        }
        while (tmp_t != null) {
            String str = tmp_t.image;
            if (str.endsWith("\n")) {
                str = str.replace("\r", "").replace("\n", "");
                b.append(str);
                b.append(System.getProperty("line.separator"));
            } else {
                b.append(str);
            }
            tmp_t = tmp_t.next;
        }
        return b.toString();
    }

    public CIMObjectPath getInstanceName(String aliasName) throws WBEMException {
        CIMObjectPath op = instanceAliases.get(aliasName);
        if (op instanceof CIMObjectPath) {
            return op;
        }
        throw new WBEMException(1, "Invalid Alias: " + aliasName);
    }

    public int getCurrentLine() {
        int a = this.jj_input_stream.getEndLine();
        return a;
    }

    private char parseCharacter(String s) {
        String t = s.substring(1, s.length() - 1);
        if (t.charAt(0) == '\\') {
            switch (t.charAt(1)) {
                case 'n': {
                    return '\n';
                }
                case 't': {
                    return '\t';
                }
                case 'b': {
                    return '\b';
                }
                case 'r': {
                    return '\r';
                }
                case 'f': {
                    return '\f';
                }
                case '\\': {
                    return '\\';
                }
                case '\'': {
                    return '\'';
                }
                case '\"': {
                    return '\"';
                }
            }
            throw new IllegalArgumentException(s);
        }
        return t.charAt(0);
    }

    private String parseString(String s) {
        String t = s.substring(1, s.length() - 1);
        int i = t.length();
        StringBuilder b = new StringBuilder();
        block10: for (int j = 0; j < i; ++j) {
            if (t.charAt(j) == '\\') {
                switch (t.charAt(++j)) {
                    case 'n': {
                        b.append(System.getProperty("line.separator"));
                        continue block10;
                    }
                    case 't': {
                        b.append('\t');
                        continue block10;
                    }
                    case 'b': {
                        b.append('\b');
                        continue block10;
                    }
                    case 'r': {
                        b.append('\r');
                        continue block10;
                    }
                    case 'f': {
                        b.append('\f');
                        continue block10;
                    }
                    case '\\': {
                        b.append('\\');
                        continue block10;
                    }
                    case '\'': {
                        b.append('\'');
                        continue block10;
                    }
                    case '\"': {
                        b.append('\"');
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException(s);
                    }
                }
            }
            b.append(t.charAt(j));
        }
        return b.toString();
    }

    public final void mofSpecification() throws Exception {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 17: 
                case 26: 
                case 29: 
                case 72: {
                    this.mofProductions();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                }
            }
            this.jj_consume_token(0);
        }
        catch (ParseException e) {
            this.reportError(e);
        }
    }

    public final void mofProductions() throws Exception {
        block3: while (true) {
            this.mofProduction();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 9: 
                case 17: 
                case 26: 
                case 29: 
                case 72: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
    }

    public final void mofProduction() throws Exception {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.compilerDirective();
                break;
            }
            case 17: 
            case 26: 
            case 72: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.qualifierList();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 17: {
                        this.classDeclaration();
                        break block0;
                    }
                    case 26: {
                        this.instanceDeclaration(true);
                        break block0;
                    }
                }
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 29: {
                this.qualifierTypeDeclaration();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void compilerDirective() throws Exception {
        Token pragmaToken = this.jj_consume_token(9);
        String comments = this.checkComments(pragmaToken);
        Token tt = this.nameToken();
        if ("Namespace".equalsIgnoreCase(tt.image)) {
            this.namespacePragma(comments);
        } else if ("Include".equalsIgnoreCase(tt.image)) {
            this.jj_consume_token(74);
            Token t = this.jj_consume_token(61);
            this.jj_consume_token(75);
            String x = t.image;
            int FirstQuote = x.indexOf(34);
            int LastQuote = x.lastIndexOf(34);
            String Filename = x.substring(FirstQuote + 1, LastQuote);
            CIMMutablePragma p = new CIMMutablePragma("include", Filename, comments);
            if (this.comp.processPragma(p)) {
                if (this.mPath != null) {
                    Filename = this.mPath + File.separator + Filename;
                }
                new MOFParser(this.comp, Filename, this.mIsInvoked);
            }
        } else if ("locale".equalsIgnoreCase(tt.image)) {
            this.localePragma(comments);
        } else if ("instancelocale".equalsIgnoreCase(tt.image)) {
            this.instancelocalePragma();
        } else {
            this.jj_la1[7] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void namespacePragma(String comments) throws ParseException, WBEMException {
        this.jj_consume_token(74);
        Token t = this.jj_consume_token(61);
        this.jj_consume_token(75);
        this.mNamespace = t.image;
        CIMMutablePragma p = new CIMMutablePragma("namespace", this.parseString(this.mNamespace), comments);
        this.comp.processPragma(p);
    }

    public final void localePragma(String comments) throws ParseException, WBEMException {
        this.jj_consume_token(74);
        String value = this.multiStringValue(null);
        CIMMutablePragma p = new CIMMutablePragma("locale", value, comments);
        this.comp.processPragma(p);
        this.jj_consume_token(75);
    }

    public final void instancelocalePragma() throws ParseException {
        this.jj_consume_token(74);
        this.multiStringValue(null);
        this.jj_consume_token(75);
    }

    public final Token nameToken() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                t = this.jj_consume_token(63);
                break;
            }
            case 11: {
                t = this.jj_consume_token(11);
                break;
            }
            case 18: {
                t = this.jj_consume_token(18);
                break;
            }
            case 19: {
                t = this.jj_consume_token(19);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    private void qualifierTypeDeclaration() throws ParseException, WBEMException {
        this.mCIMQualifierType = new CIMMutableQualifierType();
        ArrayList<CIMMutableValue> currentValueArray = new ArrayList<CIMMutableValue>();
        this.mCIMDataType = new CIMMutableDataType();
        Token tHead = this.jj_consume_token(29);
        this.mCIMQualifierType.addComment(this.checkComments(tHead));
        Token tName = this.nameToken();
        this.mCIMQualifierType.addComment(this.checkComments(tName));
        this.mCIMQualifierType.setName(tName.image);
        this.jj_consume_token(67);
        this.dataType();
        this.qualifierTypeArray_Init(currentValueArray);
        this.qualifierTypeScope();
        this.qualifierTypeFlavor();
        this.jj_consume_token(68);
        this.mCIMQualifierType.setNamespace(this.comp.getNamespace(this.mNamespace));
        this.comp.processQualifierType(this.mCIMQualifierType);
    }

    private void qualifierTypeArray_Init(ArrayList<CIMMutableValue> pValueArray) throws ParseException, WBEMException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.qualifierTypeArray_ArrayInit(pValueArray);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.qualifierTypeSimpleInit(pValueArray);
            }
        }
    }

    private void qualifierTypeArray_ArrayInit(ArrayList<CIMMutableValue> valueArray) throws ParseException, WBEMException {
        this.array();
        int simpleType = this.mCIMDataType.getType();
        this.mCIMDataType.setDataType(this.getArrayDataType(simpleType));
        this.mCIMQualifierType.setType(this.mCIMDataType.getCIMDataType());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                this.arrayInitializer(valueArray);
                if (valueArray.isEmpty()) break;
                CIMMutableValue[] o = valueArray.toArray(new CIMMutableValue[valueArray.size()]);
                this.mCIMQualifierType.setValue(o);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
    }

    public final void qualifierTypeSimpleInit(ArrayList<CIMMutableValue> pValueArray) throws ParseException, WBEMException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                this.simpleInitializer(pValueArray);
                this.mCIMQualifierType.setType(this.mCIMDataType.getCIMDataType());
                if (pValueArray.isEmpty()) break;
                CIMMutableValue v = pValueArray.get(0);
                Object o = ValueHelper.typeConvert((CIMDataType)this.mCIMDataType.getCIMDataType(), (Object)v.getValue());
                v.setValue(o);
                this.mCIMQualifierType.setValue(v);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.mCIMQualifierType.setType(this.mCIMDataType.getCIMDataType());
            }
        }
    }

    private void qualifierTypeScope() throws ParseException {
        this.jj_consume_token(66);
        this.jj_consume_token(30);
        this.jj_consume_token(74);
        this.ScopeMetaElementList();
        this.jj_consume_token(75);
    }

    private void ScopeMetaElementList() throws ParseException {
        int s = this.ScopeMetaElement();
        this.mCIMQualifierType.addScope(s);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            s = this.ScopeMetaElement();
            this.mCIMQualifierType.addScope(s);
        }
    }

    public final int ScopeMetaElement() throws ParseException {
        int scope;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                scope = 1;
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                scope = 2;
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                scope = 4;
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                scope = 8;
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                scope = 16;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                scope = 32;
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                scope = 64;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                scope = 127;
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return scope;
    }

    public final void qualifierTypeFlavor() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(31);
                this.jj_consume_token(74);
                this.qualifierTypeFlavorList();
                this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
    }

    public final void qualifierTypeFlavorList() throws ParseException {
        int f = this.flavor();
        this.mCIMQualifierType.addFlavor(f);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            f = this.flavor();
            this.mCIMQualifierType.addFlavor(f);
        }
    }

    public final int flavor() throws ParseException {
        int flavor = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                flavor = 1;
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                flavor = 2;
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                flavor = 4;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return flavor;
    }

    public final QualifierList qualifierList() throws ParseException, WBEMException {
        this.mQualifierList = new QualifierList();
        this.mQualifierList.comment = this.qualifierListHead();
        ArrayList<CIMMutableQualifier> list = this.qualifierListBody();
        this.qualifierListTail();
        this.mQualifierList.qualifiers = list;
        return this.mQualifierList;
    }

    public final String qualifierListHead() throws ParseException {
        Token t = this.jj_consume_token(72);
        return this.checkComments(t);
    }

    public final ArrayList<CIMMutableQualifier> qualifierListBody() throws ParseException, WBEMException {
        ArrayList<CIMMutableQualifier> list = new ArrayList<CIMMutableQualifier>();
        list.add(this.qualifier());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            list.add(this.qualifier());
        }
        return list;
    }

    public final void qualifierListTail() throws ParseException, WBEMException {
        this.jj_consume_token(73);
    }

    private CIMMutableQualifier qualifier() throws ParseException, WBEMException {
        CIMMutableQualifier qualifier = new CIMMutableQualifier();
        this.mCIMDataType = new CIMMutableDataType();
        Token t = this.nameToken();
        qualifier.addComment(this.checkComments(t));
        qualifier.setName(t.image);
        this.qualifierParameter(qualifier);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                qualifier.addFlavor(this.qualifierFlavor());
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        return qualifier;
    }

    private void assignQualifierParameter(CIMMutableQualifier qualifier, boolean arrayType, ArrayList<CIMMutableValue> valueArray) throws WBEMException {
        if (!valueArray.isEmpty()) {
            if (arrayType) {
                if (this.mCIMDataType.getCIMDataType() != null) {
                    qualifier.setType(this.mCIMDataType.getCIMDataType());
                }
                qualifier.setValue(valueArray.toArray(new CIMMutableValue[valueArray.size()]));
            } else {
                qualifier.setValue(valueArray.get(0));
                if (this.mCIMDataType.getCIMDataType() != null) {
                    qualifier.setType(this.mCIMDataType.getCIMDataType());
                }
            }
        }
    }

    public final void qualifierParameter(CIMMutableQualifier qualifier) throws ParseException, WBEMException {
        ArrayList<CIMMutableValue> valueArray = new ArrayList<CIMMutableValue>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 74: {
                Token t = this.jj_consume_token(74);
                qualifier.addComment(this.checkComments(t));
                this.mCIMDataType.setDataType(this.comp.getQualifierTypeDataType(qualifier.getName()));
                if (this.mCIMDataType.getCIMDataType() != null && this.mCIMDataType.getCIMDataType().isArray()) {
                    this.reportError(new WBEMException(1, "The qualifiers data type is an array, but the value is using a paren (should be {})."));
                }
                this.simpleInitializer(valueArray);
                this.jj_consume_token(75);
                this.assignQualifierParameter(qualifier, false, valueArray);
                break;
            }
            case 70: {
                this.mCIMDataType.setDataType(this.comp.getQualifierTypeDataType(qualifier.getName()));
                this.arrayInitializer(valueArray);
                this.assignQualifierParameter(qualifier, true, valueArray);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.assignQualifierParameter(qualifier, false, valueArray);
            }
        }
    }

    private int qualifierFlavor() throws ParseException {
        this.jj_consume_token(67);
        return this.qualifierFlavorList();
    }

    private int qualifierFlavorList() throws ParseException {
        int f;
        block3: while (true) {
            f = this.flavor();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[20] = this.jj_gen;
        return f;
    }

    public void assignClassQualifiers() {
        if (this.mQualifierList == null || this.mQualifierList.qualifiers == null) {
            return;
        }
        CIMMutableQualifier qe = this.mQualifierList.getQualifier("association");
        if (qe != null) {
            Object value = qe.getValue();
            if (value != null && value instanceof CIMMutableValue) {
                CIMMutableValue v = (CIMMutableValue)value;
                if (v.getValue() != null && !v.getValue().equals(Boolean.FALSE)) {
                    this.mCIMClass.setIsAssociation(true);
                }
            } else {
                this.mCIMClass.setIsAssociation(true);
            }
        }
        this.mCIMClass.addQualifierComments(this.mQualifierList.comment);
        this.mCIMClass.setQualifiers(this.mQualifierList.qualifiers.toArray(new CIMMutableQualifier[this.mQualifierList.qualifiers.size()]));
        this.mQualifierList.qualifiers.clear();
    }

    public final void classDeclaration() throws ParseException, WBEMException {
        this.mCIMClass = new CIMMutableClass();
        this.mMethodList = new ArrayList();
        this.mPropertyList = new ArrayList();
        this.classHead();
        this.assignClassQualifiers();
        this.classBody();
        this.classTail();
        this.mCIMClass.setNamespace(this.comp.getNamespace(this.mNamespace));
        this.mCIMClass.setMethods(this.mMethodList.toArray(new CIMMutableMethod[this.mMethodList.size()]));
        this.mCIMClass.setProperties(this.mPropertyList.toArray(new CIMMutableClassProperty[this.mPropertyList.size()]));
        this.comp.processClass(this.mCIMClass);
    }

    public final void classHead() throws ParseException, WBEMException {
        Token t = this.jj_consume_token(17);
        this.mCIMClass.addComment(this.checkComments(t));
        this.mCIMClass.setName(this.className());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.classAlias();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.mCIMClass.setSuperClass(this.classSuperClassName());
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
    }

    public final void classBody() throws ParseException, WBEMException {
        Token t = this.jj_consume_token(70);
        this.mCIMClass.addComment(this.checkComments(t));
        this.classFeatureList();
        t = this.jj_consume_token(71);
        this.mCIMClass.addEndComment(this.checkComments(t));
    }

    public final void classTail() throws ParseException, WBEMException {
        this.jj_consume_token(68);
    }

    public final String className() throws ParseException, WBEMException {
        Token t = this.jj_consume_token(63);
        this.mCIMClass.addComment(this.checkComments(t));
        return t.image;
    }

    public final void classAlias() throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(64);
    }

    public final String classSuperClassName() throws ParseException {
        Token t = this.jj_consume_token(67);
        this.mCIMClass.addComment(this.checkComments(t));
        t = this.jj_consume_token(63);
        this.mCIMClass.addComment(this.checkComments(t));
        return t.image;
    }

    public final void classFeatureList() throws ParseException, WBEMException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 63: 
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block3;
                }
            }
            this.classFeature();
        }
    }

    public final void classFeature() throws ParseException, WBEMException {
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.propertyDeclaration();
        } else if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.methodDeclaration();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: 
                case 72: {
                    this.referenceDeclaration();
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void propertyDeclaration() throws ParseException, WBEMException {
        this.mCIMClassProperty = new CIMMutableClassProperty();
        this.mCIMDataType = new CIMMutableDataType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.propertyHead();
                this.propertyBody();
                this.propertyTail();
                break;
            }
            case 72: {
                this.qualifierList();
                this.propertyHead();
                this.propertyBody();
                this.propertyTail();
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private void assignPropertyQualifiers() {
        if (this.mQualifierList == null || this.mQualifierList.qualifiers == null) {
            return;
        }
        this.mCIMClassProperty.setQualifiers(this.mQualifierList.qualifiers.toArray(new CIMMutableQualifier[this.mQualifierList.qualifiers.size()]));
        CIMMutableQualifier cq = this.mCIMClassProperty.getQualifier("key");
        if (cq != null) {
            Object value = cq.getValue();
            if (value != null) {
                if ((value = ((CIMMutableValue)value).getValue()).equals(Boolean.TRUE)) {
                    this.mCIMClassProperty.setKey(true);
                    this.mCIMClass.setIsKeyed(true);
                }
            } else {
                this.mCIMClassProperty.setKey(true);
                this.mCIMClass.setIsKeyed(true);
            }
        }
        this.mQualifierList.qualifiers.clear();
    }

    private void propertyHead() throws ParseException, WBEMException {
        this.dataType();
        this.propertyName();
        this.assignPropertyQualifiers();
    }

    private void propertyBody() throws ParseException, WBEMException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.propertyArray_ArrayInit();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.propertySimpleInit();
            }
        }
    }

    private void propertyArray_ArrayInit() throws ParseException, WBEMException {
        ArrayList<CIMMutableValue> valueArray = new ArrayList<CIMMutableValue>();
        this.array();
        int simpleType = this.mCIMDataType.getType();
        this.mCIMDataType.setDataType(this.getArrayDataType(simpleType));
        this.mCIMClassProperty.setType(this.mCIMDataType.getCIMDataType());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                this.arrayInitializer(valueArray);
                if (valueArray.isEmpty()) break;
                this.mCIMClassProperty.setValue(valueArray.toArray(new CIMMutableValue[valueArray.size()]));
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
    }

    public final void propertySimpleInit() throws ParseException, WBEMException {
        ArrayList<CIMMutableValue> valueArray = new ArrayList<CIMMutableValue>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.jj_consume_token(69);
                this.simpleInitializer(valueArray);
                this.mCIMClassProperty.setType(this.mCIMDataType.getCIMDataType());
                if (valueArray.isEmpty()) break;
                CIMMutableValue o = valueArray.get(0);
                o.setValue(ValueHelper.typeConvert((CIMDataType)this.mCIMDataType.getCIMDataType(), (Object)o.getValue()));
                this.mCIMClassProperty.setValue(o);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.mCIMClassProperty.setType(this.mCIMDataType.getCIMDataType());
            }
        }
    }

    public final void propertyTail() throws ParseException, WBEMException {
        this.jj_consume_token(68);
        this.mPropertyList.add(this.mCIMClassProperty);
    }

    public final void propertyName() throws ParseException, WBEMException {
        Token t = this.nameToken();
        this.mCIMClassProperty.addComment(this.checkComments(t));
        this.mCIMClassProperty.setName(t.image);
    }

    private void referenceDeclaration() throws ParseException, WBEMException {
        this.mCIMClassProperty = new CIMMutableClassProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.referenceHead();
                this.referenceInitializer();
                this.referenceTail();
                break;
            }
            case 72: {
                this.qualifierList();
                this.referenceHead();
                this.referenceInitializer();
                this.referenceTail();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private void referenceHead() throws ParseException, WBEMException {
        this.referenceObject();
        this.referenceName();
        this.assignPropertyQualifiers();
    }

    private void referenceTail() throws ParseException {
        this.jj_consume_token(68);
        this.mPropertyList.add(this.mCIMClassProperty);
    }

    private void referenceName() throws ParseException, WBEMException {
        Token t = this.nameToken();
        this.mCIMClassProperty.addComment(this.checkComments(t));
        this.mCIMClassProperty.setName(t.image);
    }

    public final void referenceObject() throws ParseException {
        this.objectRef();
        this.mCIMClassProperty.setType(this.mCIMDataType.getCIMDataType());
    }

    public final void referenceInitializer() throws ParseException, WBEMException {
        ArrayList<CIMMutableValue> valueArray = new ArrayList<CIMMutableValue>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                Token t = this.jj_consume_token(64);
                CIMMutableValue val = new CIMMutableValue();
                val.setValue(this.getInstanceName(t.image));
                val.addComments(this.checkComments(t));
                valueArray.add(val);
                this.mCIMClassProperty.setValue(val);
                break;
            }
            case 61: {
                String s = this.objectPath();
                CIMMutableValue val = new CIMMutableValue();
                val.setValue(s);
                valueArray.add(val);
                this.mCIMClassProperty.setValue(val);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
    }

    public final void methodDeclaration() throws ParseException, WBEMException {
        this.mCIMMethod = new CIMMutableMethod();
        this.mCIMDataType = new CIMMutableDataType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.methodHead();
                this.methodBody();
                this.methodTail();
                break;
            }
            case 72: {
                this.qualifierList();
                this.methodHead();
                this.methodBody();
                this.methodTail();
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void methodHead() throws ParseException, WBEMException {
        this.mCIMMethod.addComment(this.dataType());
        this.methodName();
        this.mCIMMethod.setType(this.mCIMDataType.getCIMDataType());
        if (null != this.mQualifierList) {
            this.mCIMMethod.setQualifiers(this.mQualifierList.qualifiers.toArray(new CIMMutableQualifier[this.mQualifierList.qualifiers.size()]));
        }
    }

    public final void methodBody() throws ParseException, WBEMException {
        if (this.jj_2_3(2)) {
            this.jj_consume_token(74);
            CIMMutableParameter[] params = this.methodParameterList();
            this.jj_consume_token(75);
            this.mCIMMethod.setParameters(params);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 74: {
                    this.jj_consume_token(74);
                    this.jj_consume_token(75);
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void methodTail() throws ParseException {
        this.jj_consume_token(68);
        this.mMethodList.add(this.mCIMMethod);
    }

    public final void methodName() throws ParseException, WBEMException {
        Token t = this.nameToken();
        this.mCIMMethod.addComment(this.checkComments(t));
        this.mCIMMethod.setName(t.image);
    }

    public final CIMMutableParameter[] methodParameterList() throws ParseException, WBEMException {
        ArrayList<CIMMutableParameter> l = new ArrayList<CIMMutableParameter>();
        this.parameter();
        l.add(this.mCIMParameter);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            this.parameter();
            l.add(this.mCIMParameter);
        }
        return l.toArray(new CIMMutableParameter[l.size()]);
    }

    public final void parameter() throws ParseException, WBEMException {
        this.mCIMParameter = new CIMMutableParameter();
        this.mCIMDataType = new CIMMutableDataType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 63: {
                this.parameterHead();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.parameterBody();
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                    }
                }
                this.parameterTail();
                break;
            }
            case 72: {
                this.qualifierList();
                this.parameterHead();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 72: {
                        this.parameterBody();
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                    }
                }
                this.parameterTail();
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void parameterHead() throws ParseException, WBEMException {
        this.parameterDataType();
        this.parameterName();
        if (null != this.mQualifierList) {
            this.mCIMParameter.setQualifiers(this.mQualifierList.qualifiers.toArray(new CIMMutableQualifier[this.mQualifierList.qualifiers.size()]));
        }
    }

    public final void parameterBody() throws ParseException, WBEMException {
        this.array();
        int simpleType = this.mCIMDataType.getType();
        if (this.mCIMDataType.getSize() == 0 && simpleType == 14) {
            this.mCIMDataType.setDataType(new CIMDataType(this.mCIMDataType.getReferenceName(), 0));
        } else {
            this.mCIMDataType.setDataType(this.getArrayDataType(simpleType));
        }
        this.mCIMParameter.setType(this.mCIMDataType.getCIMDataType());
    }

    public final void parameterTail() throws ParseException {
    }

    public final void parameterDataType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                this.dataType();
                this.mCIMParameter.setType(this.mCIMDataType.getCIMDataType());
                break;
            }
            case 63: {
                this.objectRef();
                this.mCIMParameter.setType(this.mCIMDataType.getCIMDataType());
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void parameterName() throws ParseException, WBEMException {
        Token t = this.nameToken();
        this.mCIMParameter.addComment(this.checkComments(t));
        this.mCIMParameter.setName(t.image);
    }

    private CIMMutableInstance instanceDeclaration(boolean process) throws ParseException, WBEMException {
        CIMMutableInstance curInstanceEl = new CIMMutableInstance();
        ArrayList<CIMMutableProperty> mPropertyListI = new ArrayList<CIMMutableProperty>();
        this.jj_consume_token(26);
        this.jj_consume_token(27);
        Token tName = this.jj_consume_token(63);
        String className = tName.image;
        curInstanceEl.setClassName(className);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                Token tAlias = this.jj_consume_token(64);
                this.mAliasName = tAlias.image;
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.instanceBody(className, mPropertyListI);
        this.jj_consume_token(68);
        curInstanceEl.setProperties(mPropertyListI.toArray(new CIMMutableProperty[mPropertyListI.size()]));
        curInstanceEl.setNamespace(this.comp.getNamespace(this.mNamespace));
        if (this.mAliasName != null) {
            instanceAliases.put(this.mAliasName, curInstanceEl.getObjectPath());
            this.mAliasName = null;
        }
        if (process) {
            this.comp.processInstance(curInstanceEl);
        }
        return curInstanceEl;
    }

    private void instanceBody(String className, ArrayList<CIMMutableProperty> mPropertyListI) throws ParseException, WBEMException {
        this.jj_consume_token(70);
        block3: while (true) {
            this.instanceProperty(className, mPropertyListI);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: 
                case 72: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[39] = this.jj_gen;
        this.jj_consume_token(71);
    }

    public final void instanceProperty(String className, ArrayList<CIMMutableProperty> mPropertyListI) throws ParseException, WBEMException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.instancePropertyBody(className, mPropertyListI);
                break;
            }
            case 72: {
                this.qualifierList();
                this.instancePropertyBody(className, mPropertyListI);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private void instancePropertyBody(String className, ArrayList<CIMMutableProperty> mPropertyListI) throws ParseException, WBEMException {
        CIMMutableProperty newProp = new CIMMutableProperty();
        ArrayList<CIMMutableValue> valueArray = new ArrayList<CIMMutableValue>();
        this.mCIMDataType = new CIMMutableDataType();
        Token t = this.jj_consume_token(63);
        newProp.setName(t.image);
        this.jj_consume_token(69);
        newProp = this.initializer(className, newProp, valueArray);
        mPropertyListI.add(newProp);
        this.jj_consume_token(68);
    }

    public final void objectRef() throws ParseException {
        Token t = this.jj_consume_token(63);
        this.jj_consume_token(25);
        if (null == this.mCIMDataType) {
            this.mCIMDataType = new CIMMutableDataType();
        }
        this.mCIMDataType.setDataType(new CIMDataType(t.image));
        this.mCIMDataType.setReferenceName(t.image);
    }

    public final String objectPath() throws ParseException {
        String s = this.multiStringValue(null);
        return s;
    }

    public final void array() throws ParseException {
        this.jj_consume_token(72);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                Token t = this.jj_consume_token(56);
                this.mCIMDataType.setSize(Integer.parseInt(t.image));
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        this.jj_consume_token(73);
    }

    public final String dataType() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                t = this.intDataType();
                break;
            }
            case 45: 
            case 46: {
                t = this.realDataType();
                break;
            }
            case 47: {
                t = this.jj_consume_token(47);
                this.mCIMDataType.setDataType(CIMDataType.CHAR16_T);
                break;
            }
            case 48: {
                t = this.jj_consume_token(48);
                this.mCIMDataType.setDataType(CIMDataType.STRING_T);
                break;
            }
            case 49: {
                t = this.jj_consume_token(49);
                this.mCIMDataType.setDataType(CIMDataType.BOOLEAN_T);
                break;
            }
            case 50: {
                t = this.jj_consume_token(50);
                this.mCIMDataType.setDataType(CIMDataType.DATETIME_T);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.checkComments(t);
    }

    public final Token intDataType() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                t = this.jj_consume_token(37);
                this.mCIMDataType.setDataType(CIMDataType.UINT8_T);
                break;
            }
            case 38: {
                t = this.jj_consume_token(38);
                this.mCIMDataType.setDataType(CIMDataType.SINT8_T);
                break;
            }
            case 39: {
                t = this.jj_consume_token(39);
                this.mCIMDataType.setDataType(CIMDataType.UINT16_T);
                break;
            }
            case 40: {
                t = this.jj_consume_token(40);
                this.mCIMDataType.setDataType(CIMDataType.SINT16_T);
                break;
            }
            case 41: {
                t = this.jj_consume_token(41);
                this.mCIMDataType.setDataType(CIMDataType.UINT32_T);
                break;
            }
            case 42: {
                t = this.jj_consume_token(42);
                this.mCIMDataType.setDataType(CIMDataType.SINT32_T);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                this.mCIMDataType.setDataType(CIMDataType.UINT64_T);
                break;
            }
            case 44: {
                t = this.jj_consume_token(44);
                this.mCIMDataType.setDataType(CIMDataType.SINT64_T);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final Token realDataType() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                t = this.jj_consume_token(45);
                this.mCIMDataType.setDataType(CIMDataType.REAL32_T);
                break;
            }
            case 46: {
                t = this.jj_consume_token(46);
                this.mCIMDataType.setDataType(CIMDataType.REAL64_T);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    private CIMMutableProperty initializer(String className, CIMMutableProperty prop, ArrayList<CIMMutableValue> valueArray) throws ParseException, WBEMException {
        this.comp.fixInstanceProperty(className, prop);
        if (prop.getDataType() != null) {
            this.mCIMDataType.setDataType(prop.getDataType());
        } else {
            this.mCIMDataType = null;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: {
                this.simpleInitializer(valueArray);
                CIMMutableValue o = valueArray.get(0);
                if (this.mCIMDataType != null) {
                    CIMMutableValue v = new CIMMutableValue();
                    v.setValue(ValueHelper.typeConvert((CIMDataType)this.mCIMDataType.getCIMDataType(), (Object)o.getValue()));
                    prop.setValue(v);
                    break;
                }
                prop.setValue(o.getValue());
                break;
            }
            case 70: {
                this.arrayInitializer(valueArray);
                prop.setValue(valueArray.toArray(new CIMMutableValue[valueArray.size()]));
                break;
            }
            case 26: {
                CIMMutableInstance i = this.instanceDeclaration(false);
                if (null != this.mCIMDataType) {
                    this.mCIMDataType.setDataType(CIMDataType.OBJECT_T);
                    prop.setType(CIMDataType.OBJECT_T);
                }
                prop.setValue(new CIMMutableValue(i.getCIMInstance()));
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return prop;
    }

    private void arrayInitializer(ArrayList<CIMMutableValue> valueArray) throws ParseException, WBEMException {
        this.jj_consume_token(70);
        this.simpleInitializerList(valueArray);
        this.jj_consume_token(71);
    }

    private void simpleInitializerList(ArrayList<CIMMutableValue> valueArray) throws ParseException, WBEMException {
        this.simpleInitializer(valueArray);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            this.simpleInitializer(valueArray);
        }
    }

    private void simpleInitializer(ArrayList<CIMMutableValue> valueArray) throws ParseException, WBEMException {
        CIMMutableValue mCurrentValue = this.constantValue();
        valueArray.add(mCurrentValue);
    }

    private CIMMutableValue constantValue() throws ParseException, WBEMException {
        CIMMutableValue currentValue = new CIMMutableValue();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                String s = this.integerValue(currentValue);
                if (null != this.mCIMDataType && null != this.mCIMDataType.getCIMDataType()) {
                    currentValue.setValue(ValueHelper.intTypeConvert((int)this.mCIMDataType.getType(), (Object)s));
                    break;
                }
                currentValue.setValue(new Long(s));
                break;
            }
            case 59: {
                String s = this.integerValue(currentValue);
                if (null != this.mCIMDataType && null != this.mCIMDataType.getCIMDataType()) {
                    currentValue.setValue(ValueHelper.intTypeConvert((int)this.mCIMDataType.getType(), (Object)s));
                    break;
                }
                currentValue.setValue(s);
                break;
            }
            case 60: {
                Token t = this.jj_consume_token(60);
                currentValue.addComments(this.checkComments(t));
                if (null != this.mCIMDataType && null != this.mCIMDataType.getCIMDataType()) {
                    currentValue.setValue(ValueHelper.intTypeConvert((int)this.mCIMDataType.getType(), (Object)t.image));
                    break;
                }
                currentValue.setValue(t.image);
                break;
            }
            case 62: {
                Token t = this.jj_consume_token(62);
                currentValue.addComments(this.checkComments(t));
                Character ch = new Character(this.parseCharacter(t.image));
                currentValue.setValue(ch);
                break;
            }
            case 61: {
                String s = this.multiStringValue(currentValue);
                currentValue.setValue(s);
                break;
            }
            case 51: 
            case 52: {
                String s = this.booleanValue(currentValue);
                currentValue.setValue(new Boolean(s));
                break;
            }
            case 53: {
                Token t = this.jj_consume_token(53);
                currentValue.addComments(this.checkComments(t));
                currentValue.setValue(null);
                break;
            }
            case 64: {
                Token t = this.jj_consume_token(64);
                currentValue.addComments(this.checkComments(t));
                currentValue.setValue(this.getInstanceName(t.image));
                break;
            }
            case 26: {
                CIMMutableInstance i = this.instanceDeclaration(false);
                currentValue.setValue(i.getCIMInstance());
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return currentValue;
    }

    private String integerValue(CIMMutableValue currentValue) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                Token t = this.jj_consume_token(54);
                currentValue.addComments(this.checkComments(t));
                return t.image;
            }
            case 55: {
                Token t = this.jj_consume_token(55);
                currentValue.addComments(this.checkComments(t));
                return t.image;
            }
            case 56: 
            case 57: 
            case 58: {
                String s = this.decimalValue(currentValue);
                return s;
            }
            case 59: {
                Token t = this.jj_consume_token(59);
                currentValue.addComments(this.checkComments(t));
                return t.image;
            }
        }
        this.jj_la1[48] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private String decimalValue(CIMMutableValue currentValue) throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                t = this.jj_consume_token(56);
                currentValue.addComments(this.checkComments(t));
                break;
            }
            case 58: {
                t = this.jj_consume_token(58);
                currentValue.addComments(this.checkComments(t));
                break;
            }
            case 57: {
                t = this.jj_consume_token(57);
                currentValue.addComments(this.checkComments(t));
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    private String multiStringValue(CIMMutableValue currentValue) throws ParseException {
        String s = new String("");
        block3: while (true) {
            Token t = this.jj_consume_token(61);
            if (null != currentValue) {
                currentValue.addComments(this.checkComments(t));
            }
            s = s + this.parseString(t.image);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 61: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[50] = this.jj_gen;
        return s;
    }

    private String booleanValue(CIMMutableValue currentValue) throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                t = this.jj_consume_token(51);
                currentValue.addComments(this.checkComments(t));
                break;
            }
            case 52: {
                t = this.jj_consume_token(52);
                currentValue.addComments(this.checkComments(t));
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(44)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_19() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(42)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        Token xsp;
        block3: {
            if (this.jj_3R_47()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_48()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_15()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_114() {
        if (this.jj_scan_token(52)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_113() {
        if (this.jj_scan_token(51)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_106() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_114()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_112() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_102() {
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_105() {
        Token xsp;
        block3: {
            if (this.jj_3R_112()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_112()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_70()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_71()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_72()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_73()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_74()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_75()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_76()) {
                                        return true;
                                    }
                                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_3R_86()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_123() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_122() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_121() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_68()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(50)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_119() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_121()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_122()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_123()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_118() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_117() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(49)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_116() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        return false;
    }

    private final boolean jj_3R_115() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_111() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(48)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_110() {
        if (this.jj_3R_120()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_107() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_115()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_116()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_117()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_118()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_119()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_109() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_108() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_104() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_109()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_110()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_111()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(47)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_3R_50()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_40()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_41()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_42()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_43()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_103() {
        if (this.jj_3R_59()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_100() {
        if (this.jj_scan_token(64)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_99() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_79()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_3R_106()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        return false;
    }

    private final boolean jj_3R_57() {
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_3R_105()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_3R_49()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_102()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_53()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_54()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_55()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_56()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_57()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_58()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_92()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_91()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_3R_103()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_3R_37()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_91()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_3R_104()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_94()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_95()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_96()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_97()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_98()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_99()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_100()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_3R_88()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_81()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_13() {
        Token xsp;
        block3: {
            if (this.jj_3R_18()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_66()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_87() {
        Token xsp;
        block3: {
            if (this.jj_3R_81()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_93()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_101() {
        if (this.jj_3R_107()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        Token xsp;
        block3: {
            if (this.jj_3R_101()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_101()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_87()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_89()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(68)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_62()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_81()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_3R_80()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_13()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_3()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_36()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_80()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_81()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_82()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_83()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_84()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_59()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_3R_85()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_scan_token(46)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_3R_45()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_78()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_17() {
        if (this.jj_3R_22()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_17()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_16() {
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private MOFParser() {
        if (null == instanceAliases) {
            instanceAliases = new Hashtable();
        }
        this.mAliasName = null;
    }

    public MOFParser(MOFParserHandler handler, String pFilename, boolean isInvoked) throws Exception {
        this(handler, pFilename, isInvoked, false);
    }

    private MOFParser(MOFParserHandler handler, String pFilename, boolean isInvoked, boolean reentry) throws Exception {
        this();
        int i;
        String parent;
        File f = new File(pFilename);
        this.mPath = parent = new File(pFilename).getParent();
        if (!f.isAbsolute() && parent != null) {
            f = new File(parent, pFilename);
            pFilename = f.getAbsolutePath();
        }
        this.mIsInvoked = isInvoked;
        this.mFileName = pFilename;
        this.comp = handler;
        FileInputStream fis = new FileInputStream(pFilename);
        this.jj_input_stream = MOFParser.isASCII(pFilename) ? new JavaCharStream(fis, 1, 1) : new JavaCharStream(new InputStreamReader((InputStream)fis, "Unicode"), 1, 1);
        this.token_source = new MOFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
        this.mofSpecification();
    }

    public MOFParser(MOFParserHandler handler, String pMOF) throws Exception {
        this();
        int i;
        this.mPath = "";
        this.mIsInvoked = true;
        this.mFileName = null;
        this.comp = handler;
        StringBuilder StringBuffer1 = new StringBuilder(pMOF);
        ByteArrayInputStream bis = new ByteArrayInputStream(StringBuffer1.toString().getBytes("UTF-8"));
        this.jj_input_stream = new JavaCharStream(bis, 1, 1);
        this.token_source = new MOFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
        this.mofSpecification();
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public MOFParser(MOFParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(MOFParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 52; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enum_jj = this.jj_expentries.elements();
            while (enum_jj.hasMoreElements()) {
                int[] oldentry = (int[])enum_jj.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[76];
        for (i = 0; i < 76; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 52; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 76; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 3; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    public CIMDataType getArrayDataType(int type) {
        switch (type) {
            case 0: {
                return CIMDataType.UINT8_ARRAY_T;
            }
            case 1: {
                return CIMDataType.SINT8_ARRAY_T;
            }
            case 2: {
                return CIMDataType.UINT16_ARRAY_T;
            }
            case 3: {
                return CIMDataType.SINT16_ARRAY_T;
            }
            case 4: {
                return CIMDataType.UINT32_ARRAY_T;
            }
            case 5: {
                return CIMDataType.SINT32_ARRAY_T;
            }
            case 6: {
                return CIMDataType.UINT64_ARRAY_T;
            }
            case 7: {
                return CIMDataType.SINT64_ARRAY_T;
            }
            case 9: {
                return CIMDataType.BOOLEAN_ARRAY_T;
            }
            case 13: {
                return CIMDataType.CHAR16_ARRAY_T;
            }
            case 10: {
                return CIMDataType.REAL32_ARRAY_T;
            }
            case 11: {
                return CIMDataType.REAL64_ARRAY_T;
            }
            case 8: {
                return CIMDataType.STRING_ARRAY_T;
            }
            case 15: {
                return CIMDataType.OBJECT_ARRAY_T;
            }
            case 12: {
                return CIMDataType.DATETIME_ARRAY_T;
            }
        }
        return CIMDataType.INVALID_T;
    }

    private static boolean isASCII(String fileName) throws IOException {
        byte[] buf = new byte[4];
        FileInputStream in = new FileInputStream(fileName);
        in.read(buf);
        in.close();
        return !(buf[0] == -17 && buf[1] == -69 && buf[2] == -65 || buf[0] == -1 && buf[1] == -2 || buf[0] == -2 && buf[1] == -1) && (buf[0] != 0 || buf[1] != 0 || buf[2] != -2 || buf[3] != -1);
    }

    private void reportError(Exception e) throws WBEMException {
        String message = "Error at line " + this.getCurrentLine() + " in file " + this.mFileName + System.getProperty("line.separator") + e.getLocalizedMessage();
        if (this.mIsInvoked) {
            throw new WBEMException(1, message);
        }
        System.err.println(message);
        System.exit(1);
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private class QualifierList {
        public ArrayList<CIMMutableQualifier> qualifiers = new ArrayList();
        public String comment;

        public CIMMutableQualifier getQualifier(String pName) {
            for (CIMMutableQualifier q : this.qualifiers) {
                if (!q.getName().equalsIgnoreCase(pName)) continue;
                return q;
            }
            return null;
        }
    }
}

