/*
 * Decompiled with CFR 0.152.
 */
package javax.cim3;

import com.ws.cim3.mof.MOFStyle;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.cim.CIMDateTime;
import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import javax.cim3.CIMClass;
import javax.cim3.CIMInstance;
import javax.cim3.Messages;

public class CIMDataType
implements Serializable {
    private static final long serialVersionUID = -4117670221008320188L;
    private final int mType;
    private final boolean mIsArray;
    private final String mClassName;
    public static final int UINT8 = 0;
    public static final int SINT8 = 1;
    public static final int UINT16 = 2;
    public static final int SINT16 = 3;
    public static final int UINT32 = 4;
    public static final int SINT32 = 5;
    public static final int UINT64 = 6;
    public static final int SINT64 = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN = 9;
    public static final int REAL32 = 10;
    public static final int REAL64 = 11;
    public static final int DATETIME = 12;
    public static final int OCTETSTRING = 13;
    public static final int REFERENCE = 14;
    public static final int INSTANCE = 15;
    public static final int CLASS = 16;
    public static final int STRUCTURE = 17;
    public static final int ENUMERATION = 18;
    public static final int UNKNOWN = 20;
    public static final int VOID = 21;
    public static final CIMDataType UINT8_T = new CIMDataType(0);
    public static final CIMDataType UINT16_T = new CIMDataType(2);
    public static final CIMDataType UINT32_T = new CIMDataType(4);
    public static final CIMDataType UINT64_T = new CIMDataType(6);
    public static final CIMDataType SINT8_T = new CIMDataType(1);
    public static final CIMDataType SINT16_T = new CIMDataType(3);
    public static final CIMDataType SINT32_T = new CIMDataType(5);
    public static final CIMDataType SINT64_T = new CIMDataType(7);
    public static final CIMDataType STRING_T = new CIMDataType(8);
    public static final CIMDataType BOOLEAN_T = new CIMDataType(9);
    public static final CIMDataType REAL32_T = new CIMDataType(10);
    public static final CIMDataType REAL64_T = new CIMDataType(11);
    public static final CIMDataType DATETIME_T = new CIMDataType(12);
    public static final CIMDataType OCTETSTRING_T = new CIMDataType(13);
    public static final CIMDataType CLASS_T = new CIMDataType(16);
    public static final CIMDataType OBJECT_T = new CIMDataType(15);
    public static final CIMDataType UNKNOWN_T = new CIMDataType(20);
    public static final CIMDataType UINT8_ARRAY_T = new CIMDataType(0, true);
    public static final CIMDataType UINT16_ARRAY_T = new CIMDataType(2, true);
    public static final CIMDataType UINT32_ARRAY_T = new CIMDataType(4, true);
    public static final CIMDataType UINT64_ARRAY_T = new CIMDataType(6, true);
    public static final CIMDataType SINT8_ARRAY_T = new CIMDataType(1, true);
    public static final CIMDataType SINT16_ARRAY_T = new CIMDataType(3, true);
    public static final CIMDataType SINT32_ARRAY_T = new CIMDataType(5, true);
    public static final CIMDataType SINT64_ARRAY_T = new CIMDataType(7, true);
    public static final CIMDataType STRING_ARRAY_T = new CIMDataType(8, true);
    public static final CIMDataType BOOLEAN_ARRAY_T = new CIMDataType(9, true);
    public static final CIMDataType REAL32_ARRAY_T = new CIMDataType(10, true);
    public static final CIMDataType REAL64_ARRAY_T = new CIMDataType(11, true);
    public static final CIMDataType DATETIME_ARRAY_T = new CIMDataType(12, true);
    public static final CIMDataType OCTETSTRING_ARRAY_T = new CIMDataType(13, true);
    public static final CIMDataType OBJECT_ARRAY_T = new CIMDataType(15, true);
    public static final CIMDataType CLASS_ARRAY_T = new CIMDataType(16, true);

    public static final CIMDataType getDataType(Object o) {
        if (o instanceof String) {
            return STRING_T;
        }
        if (o instanceof UnsignedInteger8) {
            return UINT8_T;
        }
        if (o instanceof Byte) {
            return SINT8_T;
        }
        if (o instanceof UnsignedInteger16) {
            return UINT16_T;
        }
        if (o instanceof Short) {
            return SINT16_T;
        }
        if (o instanceof UnsignedInteger32) {
            return UINT32_T;
        }
        if (o instanceof Integer) {
            return SINT32_T;
        }
        if (o instanceof UnsignedInteger64) {
            return UINT64_T;
        }
        if (o instanceof Long) {
            return SINT64_T;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_T;
        }
        if (o instanceof Float) {
            return REAL32_T;
        }
        if (o instanceof Double) {
            return REAL64_T;
        }
        if (o instanceof Character) {
            return OCTETSTRING_T;
        }
        if (o instanceof CIMDateTime) {
            return DATETIME_T;
        }
        if (o instanceof String[]) {
            return STRING_ARRAY_T;
        }
        if (o instanceof Boolean[]) {
            return BOOLEAN_ARRAY_T;
        }
        if (o instanceof Character[]) {
            return OCTETSTRING_ARRAY_T;
        }
        if (o instanceof UnsignedInteger8[]) {
            return UINT8_ARRAY_T;
        }
        if (o instanceof Byte[]) {
            return SINT8_ARRAY_T;
        }
        if (o instanceof UnsignedInteger16[]) {
            return UINT16_ARRAY_T;
        }
        if (o instanceof Short[]) {
            return SINT16_ARRAY_T;
        }
        if (o instanceof UnsignedInteger32[]) {
            return UINT32_ARRAY_T;
        }
        if (o instanceof Integer[]) {
            return SINT32_ARRAY_T;
        }
        if (o instanceof UnsignedInteger64[]) {
            return UINT64_ARRAY_T;
        }
        if (o instanceof Long[]) {
            return SINT64_ARRAY_T;
        }
        if (o instanceof Float[]) {
            return REAL32_ARRAY_T;
        }
        if (o instanceof Double[]) {
            return REAL64_ARRAY_T;
        }
        if (o instanceof CIMDateTime[]) {
            return DATETIME_ARRAY_T;
        }
        if (o instanceof CIMInstance) {
            return OBJECT_T;
        }
        if (o instanceof CIMClass) {
            return CLASS_T;
        }
        if (o instanceof CIMInstance[]) {
            return OBJECT_ARRAY_T;
        }
        if (o instanceof CIMClass[]) {
            return CLASS_ARRAY_T;
        }
        Object[] oArray = new Object[]{o};
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CIMDataType.INVALID_DATATYPE"), oArray));
    }

    private CIMDataType(int type) {
        this(type, false);
    }

    private CIMDataType(int type, boolean isArray) {
        this.mType = type;
        this.mClassName = null;
        this.mIsArray = isArray;
    }

    public CIMDataType(int dataType, String classname, boolean isArray) {
        if (classname == null || classname.length() == 0) {
            throw new IllegalArgumentException("The class name can not be null for a complex type.");
        }
        if (dataType < 14 || dataType > 20) {
            throw new IllegalArgumentException("Illegal Type - must be a complex type");
        }
        this.mClassName = classname;
        this.mIsArray = isArray;
        this.mType = dataType;
    }

    public boolean equals(Object obj) {
        if (null == obj || !(obj instanceof CIMDataType)) {
            return false;
        }
        CIMDataType ct = (CIMDataType)obj;
        if (this.mClassName == null && ct.mClassName != null) {
            return false;
        }
        if (this.mClassName != null && !this.mClassName.equals(ct.mClassName)) {
            return false;
        }
        return this.mType == ct.mType;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public int hashCode() {
        int hash = this.mType;
        hash ^= this.mIsArray ? 0 : 1;
        return hash ^= this.mClassName.hashCode();
    }

    public int getType() {
        return this.mType;
    }

    public boolean isArray() {
        return this.mIsArray;
    }

    public String toString() {
        MOFStyle mf = new MOFStyle();
        return mf.generateMOF(this);
    }
}

