/*
 * Decompiled with CFR 0.152.
 */
package com.ws.logging;

import com.ws.logging.FailSafeLog;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.FileHandler;
import java.util.logging.LogRecord;

public class ThreadedFileHandler
extends FileHandler
implements Runnable {
    private static final AtomicInteger count = new AtomicInteger();
    private static boolean shutDown = false;
    private final BlockingQueue<LogRecord> logQ = new LinkedBlockingQueue<LogRecord>();
    private volatile Thread theThread = null;

    public ThreadedFileHandler() throws IOException, SecurityException {
    }

    public ThreadedFileHandler(String pattern) throws IOException, SecurityException {
        super(pattern);
    }

    public ThreadedFileHandler(String pattern, boolean append) throws IOException, SecurityException {
        super(pattern, append);
    }

    public ThreadedFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        super(pattern, limit, count);
    }

    public ThreadedFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(pattern, limit, count, append);
    }

    @Override
    public synchronized void close() throws SecurityException {
        shutDown = true;
        if (null != this.theThread) {
            this.theThread.interrupt();
        }
        super.close();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (null == this.theThread) {
            this.startThreadedLogger();
        }
        if (null != record && null == record.getMessage()) {
            if (null != record.getParameters() && record.getParameters().length > 0) {
                record.setMessage("NO MESSAGE SET: param 1: {0}");
            } else {
                record.setMessage("NO MESSAGE SET");
            }
        } else if (null == record) {
            record = new LogRecord(this.getLevel(), "NO RECORD SENT");
        }
        this.logQ.offer(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        LogRecord record = null;
        try {
            while (!this.isShuttingDown()) {
                try {
                    record = this.logQ.poll(5L, TimeUnit.MINUTES);
                    if (record == null) continue;
                    try {
                        super.publish(record);
                    }
                    catch (Throwable t) {
                        FailSafeLog.failSafe(t);
                    }
                }
                catch (InterruptedException ie) {}
            }
            return;
        }
        finally {
            ThreadedFileHandler ie = this;
        }
    }

    private synchronized boolean isShuttingDown() {
        return shutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreadedLogger() {
        Thread t = this.theThread;
        if (null == t) {
            ThreadedFileHandler threadedFileHandler = this;
            synchronized (threadedFileHandler) {
                t = this.theThread;
                if (null == t) {
                    t = new Thread(this);
                    t.setName("Threaded Logger - " + count.getAndIncrement());
                    t.setDaemon(true);
                    t.start();
                    this.theThread = t;
                }
            }
        }
    }
}

