/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.io.Serializable;
import java.math.BigInteger;
import javax.cim.UnsignedInteger;

public class UnsignedInteger64
extends UnsignedInteger
implements Serializable,
Comparable<UnsignedInteger64> {
    private static final long serialVersionUID = -3734165689168941119L;
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    public static final BigInteger MIN_VALUE = new BigInteger("0");

    public UnsignedInteger64(BigInteger value) {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null");
        }
        BigInteger bigInt = new BigInteger(value.toString());
        if (bigInt.compareTo(MIN_VALUE) < 0 || bigInt.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.mValue = bigInt;
    }

    public UnsignedInteger64(byte[] value) throws NumberFormatException {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null");
        }
        BigInteger bigInt = new BigInteger(value);
        if (bigInt.compareTo(MIN_VALUE) < 0 || bigInt.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.mValue = bigInt;
    }

    public UnsignedInteger64(String value) throws NumberFormatException, IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null");
        }
        BigInteger bigInt = new BigInteger(value);
        if (bigInt.compareTo(MIN_VALUE) < 0 || bigInt.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
        this.mValue = bigInt;
    }

    public BigInteger bigIntegerValue() {
        return (BigInteger)this.mValue;
    }

    @Override
    public int compareTo(UnsignedInteger64 value) throws ClassCastException, IllegalArgumentException {
        if (null == value) {
            throw new IllegalArgumentException("value shall not be null");
        }
        return ((BigInteger)this.mValue).compareTo((BigInteger)value.mValue);
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnsignedInteger64)) {
            return false;
        }
        return ((UnsignedInteger64)o).mValue.equals(this.mValue);
    }
}

