/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.repository;

import java.util.Collection;
import java.util.HashMap;
import org.wbemservices.wbem.repository.CIMClassRlogEntry;
import org.wbemservices.wbem.repository.CIMQualifierTypeRlogEntry;
import org.wbemservices.wbem.repository.CIMRlogEntry;

class CIMNameSpaceRlogEntry
extends CIMRlogEntry {
    private static final long serialVersionUID = 8598716484732411839L;
    private final HashMap<String, CIMQualifierTypeRlogEntry> qualifiers = new HashMap();
    private final HashMap<String, CIMClassRlogEntry> classes = new HashMap();

    public CIMNameSpaceRlogEntry(String namespace) {
        super(namespace);
    }

    public Collection<CIMQualifierTypeRlogEntry> getQualifierCollection() {
        return this.qualifiers.values();
    }

    public Collection<CIMClassRlogEntry> getClassCollection() {
        return this.classes.values();
    }

    public void addQualifierType(CIMQualifierTypeRlogEntry qtentry) {
        this.qualifiers.put(qtentry.getNameKey(), qtentry);
    }

    public CIMQualifierTypeRlogEntry removeQualifierType(String name) {
        CIMQualifierTypeRlogEntry qtentry = this.qualifiers.remove(CIMRlogEntry.toNameKey(name));
        qtentry.delete();
        return qtentry;
    }

    public CIMQualifierTypeRlogEntry getQualifierType(String name) {
        return this.qualifiers.get(CIMRlogEntry.toNameKey(name));
    }

    public void addClass(CIMClassRlogEntry cc) {
        this.classes.put(cc.getNameKey(), cc);
    }

    public CIMClassRlogEntry removeClass(String name) {
        CIMClassRlogEntry ccentry = this.classes.remove(CIMRlogEntry.toNameKey(name));
        ccentry.delete();
        return ccentry;
    }

    public CIMClassRlogEntry getClass(String name) {
        return this.classes.get(CIMRlogEntry.toNameKey(name));
    }

    @Override
    public void delete() {
        this.deleteEntries(this.classes);
        this.deleteEntries(this.qualifiers);
    }

    private void deleteEntries(HashMap<?, ?> map) {
        Collection<?> c = map.values();
        for (CIMRlogEntry entry : c) {
            if (entry instanceof CIMClassRlogEntry && entry.getName().equals("top")) continue;
            entry.delete();
        }
    }
}

