/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.sn2com.execapp;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import sanproject.sn2.sn2com.execapp.SJappDefConst;
import sanproject.sn2.sn2com.execapp.SJappStartApp_Interface;
import sanproject.sn2.sn2com.execapp.SJappWriteLog;

public class SJappLiveNotifier {
    private static final String LOG_FUNCTION = "SJappLiveNotifier";
    private static final String LOG_TITLE = "SJappLiveNotifier";
    private String szMsg;
    private String ticketID = null;
    private String globalSessionID = null;
    private String notifyLiveURL = null;
    private Timer timer = null;
    private SJappStartApp_Interface watchApp = null;

    public void init(SJappStartApp_Interface watchApp) throws Exception {
        this.watchApp = watchApp;
        this.initEnv();
        this.execNotity();
    }

    public void finish() {
        this.stopTimer();
        this.notifyEnd();
    }

    private void initEnv() throws Exception {
        String LOG_SUBTITLE = "initEnv";
        this.ticketID = SJappLiveNotifier.getProperty(SJappDefConst.SVP_APP_TICKETID);
        this.globalSessionID = SJappLiveNotifier.getProperty(SJappDefConst.SVP_APP_GLOBALID);
        this.notifyLiveURL = SJappLiveNotifier.getProperty(SJappDefConst.SVP_APP_LIVE_URL);
        if (this.isEmpty(this.ticketID) || this.isEmpty(this.globalSessionID) || this.isEmpty(this.notifyLiveURL)) {
            SJappWriteLog.error("SJappLiveNotifier", "SJappLiveNotifier", "initEnv", "param error.");
            throw new Exception();
        }
    }

    public static String getProperty(String key, String def) {
        String returnValue = SJappLiveNotifier.getProperty(key);
        if (returnValue == null) {
            returnValue = def;
        }
        return returnValue;
    }

    public static String getProperty(String key) {
        String returnValue = System.getProperty(key);
        if (returnValue == null) {
            returnValue = System.getProperty("jnlp." + key);
        }
        return returnValue;
    }

    private boolean isEmpty(String str) {
        boolean ret = false;
        if (str == null || str.equals("")) {
            ret = true;
        }
        return ret;
    }

    private void execNotity() throws Exception {
        String LOG_SUBTITLE = "execNotity";
        if (!this.notifyStart()) {
            SJappWriteLog.error("SJappLiveNotifier", "SJappLiveNotifier", "execNotity", "notify start error.");
            throw new Exception();
        }
        this.startTimer();
    }

    private boolean notifyStart() {
        String LOG_SUBTITLE = "notifyStart";
        SJappWriteLog.info("SJappLiveNotifier", "SJappLiveNotifier", "notifyStart", "Notify Start.");
        return this.notifySystem(SJappDefConst.SVP_STS_START);
    }

    private boolean notifyLife() {
        String LOG_SUBTITLE = "notifyLife";
        SJappWriteLog.info("SJappLiveNotifier", "SJappLiveNotifier", "notifyLife", "Notify Life.");
        return this.notifySystem(SJappDefConst.SVP_STS_LIVE);
    }

    private void notifyEnd() {
        String LOG_SUBTITLE = "notifyEnd";
        SJappWriteLog.info("SJappLiveNotifier", "SJappLiveNotifier", "notifyEnd", "Notify End.");
        this.notifySystem(SJappDefConst.SVP_STS_END);
    }

    private boolean notifySystem(String sts) {
        String LOG_SUBTITLE = "notifySystem";
        boolean result = true;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(SJappDefConst.SVP_APP_TICKETID, this.ticketID);
        map.put(SJappDefConst.SVP_APP_GLOBALID, this.globalSessionID);
        map.put(SJappDefConst.SVP_APP_STS, sts);
        String message = this.connectHttpServer(this.notifyLiveURL, map);
        if (message == null || message.equals("")) {
            SJappWriteLog.error("SJappLiveNotifier", "SJappLiveNotifier", "notifySystem", "Not Connection.");
            this.watchApp.forceAppFinish();
            this.stopTimer();
            result = false;
        } else if (SJappDefConst.SVP_STS_LIVE.equals(message)) {
            result = true;
        } else if (SJappDefConst.SVP_STS_END.equals(message)) {
            result = true;
        } else if (SJappDefConst.SVP_STS_LOGOUT.equals(message)) {
            SJappWriteLog.warn("SJappLiveNotifier", "SJappLiveNotifier", "notifySystem", "SN2 Logout.");
            this.watchApp.forceAppFinish();
            this.stopTimer();
            result = false;
        } else if (SJappDefConst.SVP_STS_EXCEPTION.equals(message)) {
            SJappWriteLog.error("SJappLiveNotifier", "SJappLiveNotifier", "notifySystem", "Servlet Error.");
            this.watchApp.forceAppFinish();
            this.stopTimer();
            result = false;
        } else {
            SJappWriteLog.error("SJappLiveNotifier", "SJappLiveNotifier", "notifySystem", "Unknown Status.");
            this.watchApp.forceAppFinish();
            this.stopTimer();
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String connectHttpServer(String url, HashMap requestMap) {
        String LOG_SUBTITLE = "connectHttpServer";
        String postStr = null;
        Set set = requestMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            postStr = postStr == null ? "" : postStr + "&";
            String key = (String)iterator.next();
            postStr = postStr + key + "=" + requestMap.get(key);
        }
        URLConnection urlCon = null;
        StringBuffer result = null;
        try {
            URI uriObj = new URI(url);
            urlCon = uriObj.toURL().openConnection();
            urlCon.setDoOutput(true);
            OutputStream os = urlCon.getOutputStream();
            PrintStream ps = new PrintStream(os);
            ps.print(postStr);
            ps.close();
            BufferedReader urlIn = null;
            try {
                urlIn = new BufferedReader(new InputStreamReader(urlCon.getInputStream()));
                String str = null;
                result = new StringBuffer();
                while ((str = urlIn.readLine()) != null) {
                    if (this.isEmpty(str) && str.equals("\n")) continue;
                    result.append(str);
                }
                this.szMsg = "servlet responce=" + result;
                SJappWriteLog.info("SJappLiveNotifier", "SJappLiveNotifier", "connectHttpServer", this.szMsg);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result = null;
            }
            finally {
                if (urlIn != null) {
                    urlIn.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            result = null;
        }
        String result_St = null;
        if (result != null) {
            result_St = result.toString();
        }
        return result_St;
    }

    private void startTimer() {
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new NotifyTask(this), 0L, SJappDefConst.Live_Period);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    class NotifyTask
    extends TimerTask {
        SJappLiveNotifier launcher;

        NotifyTask(SJappLiveNotifier launcher) {
            this.launcher = launcher;
        }

        public void run() {
            SJappLiveNotifier.this.notifyLife();
        }
    }
}

