/*
 * Decompiled with CFR 0.152.
 */
package com.hitachi.sanproject.util;

import com.hitachi.sanproject.util.SanProcessUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SanStatus {
    public static final String FILENAME_STATUS_BAT = "status.bat";
    public static final String FILENAME_STATUS_PROPERTIES = "status.properties";
    public static final int STATUS_CODE_STOPPED = 0;
    public static final int STATUS_CODE_READY = 1;
    public static final int STATUS_CODE_INITIALIZING = 2;
    public static final int STATUS_CODE_STOPPING = 3;
    public static final int STATUS_CODE_WARNING = 5;
    public static final int STATUS_CODE_FAILED = 8;
    public static final String STATUS_STR_STOPPED = "Stopped";
    public static final String STATUS_STR_READY = "Ready";
    public static final String STATUS_STR_INITIALIZING = "Initializing";
    public static final String STATUS_STR_STOPPING = "Stopping";
    public static final String STATUS_STR_WARNING = "Warning";
    public static final String STATUS_STR_FAILED = "Failed";
    public static final String STATUS_HEADER_DSIPLAYNAME = "DisplayName";
    public static final String STATUS_HEADER_STATUS = "Status";
    public static final String STATUS_HEADER_STATUSCODE = "StatusCode";
    public static final String STATUS_HEADER_TRBID = "TrbId";
    public static final String TRBID_CMN_STATUSGET_ERROR = "TRSDSL000013";
    private HashMap<String, String> statusInfo;
    private String rmiDirPath = null;

    public SanStatus(String string) {
        this.rmiDirPath = string;
        this.statusInfo = new HashMap();
        this.statusInfo.put(STATUS_HEADER_DSIPLAYNAME, "RMI-API Server[KeyValue]");
        this.statusInfo.put(STATUS_HEADER_STATUS, STATUS_STR_STOPPED);
        this.statusInfo.put(STATUS_HEADER_STATUSCODE, String.valueOf(0));
        this.statusInfo.put(STATUS_HEADER_TRBID, "");
    }

    public static boolean isStatusBat(String string) {
        File file = new File(String.format("%s%s%s", string, File.separator, FILENAME_STATUS_BAT));
        return file.exists();
    }

    public void refresh() {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = String.format("%s%s%s", this.rmiDirPath, File.separator, FILENAME_STATUS_BAT);
            int n = SanProcessUtility.execCmd(null, arrayList, string, new String[0]);
            if (n != 0) {
                this.statusInfo.put(STATUS_HEADER_STATUS, STATUS_STR_WARNING);
                this.statusInfo.put(STATUS_HEADER_STATUSCODE, String.valueOf(5));
                this.statusInfo.put(STATUS_HEADER_TRBID, TRBID_CMN_STATUSGET_ERROR);
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Pattern pattern = Pattern.compile("^\\[(.+\\].*)");
                Matcher matcher = pattern.matcher(arrayList.get(i));
                if (!matcher.find()) continue;
                String string2 = matcher.group(1);
                String[] stringArray = new String[]{"", ""};
                int n2 = string2.indexOf("]");
                stringArray[0] = string2.substring(0, n2);
                if (string2.length() > n2 + 1) {
                    stringArray[1] = string2.substring(n2 + 1);
                }
                this.statusInfo.put(stringArray[0], stringArray[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getStatusInfoValue(String string) {
        return this.statusInfo.get(string);
    }

    public static int getRMIStatusCodeFromStatusCode(int n) {
        int n2 = 0;
        switch (n) {
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }
}

