/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Window;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcEventQueue;

public class RJComWaitingDialog
extends JDialog
implements Runnable {
    private int openDelayTime = 600;
    private int delayTime = 600;
    private Runnable process;
    private boolean running = false;
    private Timer openDelayTimer;
    private Timer openTimer;
    private boolean openTimeout = true;
    private boolean closeReq = true;
    private int nestCount = 0;
    private static final String CATCHING_MSG = "Catching an Exception in when executing RJComWaitingDialog";
    private String windowName = "";
    private Object syncObj = new Boolean(false);
    private boolean showFlag = false;

    public RJComWaitingDialog(Frame frame, Icon icon, String string, String string2) {
        super(frame, string, false);
        this.init(icon, string2);
        this.windowName = frame.toString();
    }

    public RJComWaitingDialog(Dialog dialog, Icon icon, String string, String string2) {
        super(dialog, string, false);
        this.init(icon, string2);
        this.windowName = dialog.toString();
    }

    private void init(Icon icon, String string) {
        this.setSize(260, 120);
        this.setResizable(false);
        JPanel jPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel.setLayout(borderLayout);
        JLabel jLabel = new JLabel();
        jLabel.setIcon(icon);
        Font font = new Font("Dialog", 1, 14);
        jLabel.setFont(font);
        jLabel.setHorizontalAlignment(0);
        jLabel.setText(string);
        this.getContentPane().add(jPanel);
        this.disableEvents(64L);
        this.setDefaultCloseOperation(0);
        jPanel.add((Component)jLabel, "Center");
        this.setFocusableWindowState(false);
    }

    public int getOpenTimerValue() {
        return this.openDelayTime;
    }

    public void setOpenTimerValue(int n) {
        this.openDelayTime = n;
    }

    public int getTimerValue() {
        return this.delayTime;
    }

    public void setTimerValue(int n) {
        this.delayTime = n;
        if (this.delayTime < 600) {
            this.delayTime = 600;
        }
    }

    public void show() {
        this.show(null);
    }

    public void show(Runnable runnable) {
        Object object;
        RJCom.putLog("[Com]", "[Loading]", "[show]:" + this.windowName, 0);
        this.process = runnable;
        this.closeReq = false;
        if (!this.isShowing2()) {
            object = this.getOwner();
            Dimension dimension = ((Component)object).getSize();
            Dimension dimension2 = this.getSize();
            if (((Window)object).isShowing()) {
                Point point = ((Component)object).getLocationOnScreen();
                point.x += (dimension.width - dimension2.width) / 2;
                point.y += (dimension.height - dimension2.height) / 2;
                this.setLocation(point);
            }
            if (this.openDelayTimer == null) {
                this.startOpenDelayTimer();
            }
        } else {
            RJCom.putLog("[Com]", "[Loading]", "[CallShow]:" + this.windowName, 0);
            this.showDlg();
            this.openTimeout = false;
            this.startOpenTimer();
        }
        object = new Thread(this);
        this.running = true;
        ((Thread)object).start();
        this.waitEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actionPerformedOpenDelayTimer() {
        RJCom.putLog("[Com]", "[Loading]", "[OpenDelay Time Out]:" + this.windowName, 0);
        try {
            if (!this.closeReq) {
                RJCom.putLog("[Com]", "[Loading]", "[CallShow]:" + this.windowName, 0);
                this.showDlg();
                EventQueue eventQueue = RJcEventQueue.getEventQueue();
                if (eventQueue.isDispatchThread()) {
                    Graphics graphics = this.getGraphics();
                    this.paintAll(graphics);
                }
                this.openTimeout = false;
                this.startOpenTimer();
            }
        }
        finally {
            if (this.openDelayTimer != null) {
                this.openDelayTimer.cancel();
                this.openDelayTimer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDlg() {
        Object object = this.syncObj;
        synchronized (object) {
            Runnable runnable = new Runnable(){

                public void run() {
                    RJComWaitingDialog.this.showDlgImpl();
                }
            };
            SwingUtilities.invokeLater(runnable);
            this.showFlag = true;
        }
    }

    private void showDlgImpl() {
        RJCom.putLog("[Com]", "[Loading]", "[RealShow]:" + this.windowName, 0);
        super.show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeDlg() {
        Object object = this.syncObj;
        synchronized (object) {
            Runnable runnable = new Runnable(){

                public void run() {
                    RJComWaitingDialog.this.disposeDlgImpl();
                }
            };
            SwingUtilities.invokeLater(runnable);
            this.showFlag = false;
        }
    }

    private void disposeDlgImpl() {
        RJCom.putLog("[Com]", "[Loading]", "[RealDispose]:" + this.windowName, 0);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShowing2() {
        boolean bl = false;
        Object object = this.syncObj;
        synchronized (object) {
            bl = this.showFlag;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.process != null) {
            this.process.run();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            this.running = false;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                }
            });
            this.getTreeLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitEvent() {
        try {
            if (this.nestCount > 0) {
                System.out.println("WaitingDialog:>>>>>>>>>> Nest Count = " + this.nestCount + " <<<<<<<<<<");
            }
            ++this.nestCount;
            this.waitEventImpl();
        }
        finally {
            --this.nestCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitEventImpl() {
        block10: {
            EventQueue eventQueue = RJcEventQueue.getEventQueue();
            try {
                if (eventQueue.isDispatchThread()) {
                    while (this.running) {
                        AWTEvent aWTEvent = eventQueue.getNextEvent();
                        if (this.nestCount > 1) {
                            System.out.print("<" + aWTEvent + " : ");
                            this.dispatchEventEx(aWTEvent);
                            System.out.println(">");
                            continue;
                        }
                        this.dispatchEventEx(aWTEvent);
                    }
                    break block10;
                }
                Object object = this.getTreeLock();
                synchronized (object) {
                    while (this.running) {
                        this.getTreeLock().wait();
                    }
                }
            }
            catch (ThreadDeath threadDeath) {
                System.err.println(CATCHING_MSG);
                threadDeath.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                System.err.println(CATCHING_MSG);
                interruptedException.printStackTrace();
            }
        }
    }

    private void dispatchEventEx(AWTEvent aWTEvent) {
        try {
            Object object = aWTEvent.getSource();
            if (aWTEvent instanceof ActiveEvent) {
                ((ActiveEvent)((Object)aWTEvent)).dispatch();
            } else if (object instanceof Component) {
                ((Component)object).dispatchEvent(aWTEvent);
            } else if (object instanceof MenuComponent) {
                ((MenuComponent)object).dispatchEvent(aWTEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println(CATCHING_MSG);
            runtimeException.printStackTrace();
        }
    }

    public void dispose() {
        RJCom.putLog("[Com]", "[Loading]", "[dispose]:" + this.windowName, 0);
        this.closeReq = true;
        if (this.isShowing2() && this.openTimeout) {
            this.disposeDelay();
        }
    }

    private void actionPerformedOpenTimer() {
        this.openTimeout = true;
        if (this.isShowing2() && this.closeReq) {
            this.disposeDelay();
        }
    }

    private void disposeDelay() {
        System.out.println("[Com] [Loading] [Poling]:" + this.windowName);
        Window window = this.getOwner();
        boolean bl = false;
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] == this || !windowArray[i].isVisible()) continue;
            bl = true;
            break;
        }
        if (window.isEnabled() || bl) {
            RJCom.putLog("[Com]", "[Loading]", "[CallDispose]:" + this.windowName, 0);
            this.disposeDlg();
            if (this.openTimer != null) {
                this.openTimer.cancel();
            }
        } else {
            this.startOpenTimer();
        }
    }

    private void startOpenDelayTimer() {
        if (this.openDelayTimer != null) {
            this.openDelayTimer.cancel();
        }
        this.openDelayTimer = new Timer();
        this.openDelayTimer.schedule(new TimerTask(){

            public void run() {
                RJComWaitingDialog.this.actionPerformedOpenDelayTimer();
            }
        }, this.openDelayTime);
    }

    private void startOpenTimer() {
        if (this.openTimer != null) {
            this.openTimer.cancel();
        }
        this.openTimer = new Timer();
        this.openTimer.schedule(new TimerTask(){

            public void run() {
                RJComWaitingDialog.this.actionPerformedOpenTimer();
            }
        }, this.delayTime);
    }
}

