/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import sanproject.client.exdevice.data.ExternalVolumeInfo;
import sanproject.client.exdevice.data.ExternalVolumeManager;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PathGroupManager;
import sanproject.client.exdevice.data.PresetData;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.VpgInfo;
import sanproject.client.exdevice.data.VpgManager;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.EXDExternalVolume;
import sanproject.serverux.dataimpl.EXDPGOperation;
import sanproject.serverux.dataimpl.EXDVpg;

public class ExternalVolumeMaintenanceData
extends PresetData {
    public static final int OP_DELVOL = 0;
    public static final int OP_DISCONNECT = 1;
    public static final int OP_CHECKPATH = 2;
    public static final int OP_CHG_CACHE_MODE_ENABLE = 4;
    public static final int OP_CHG_CACHE_MODE_DISABLE = 3;
    public static final int OP_CHG_INFLOW_CTL_ENABLE = 6;
    public static final int OP_CHG_INFLOW_CTL_DISABLE = 5;
    private boolean mflgDeleteVolumeSuccess = false;
    VpgInfo mVpgInfo = null;
    private static int mOperation = -1;
    private static int mPresetEntryCount = 0;

    ExternalVolumeMaintenanceData(VpgInfo vpgInfo) {
        this.mVpgInfo = vpgInfo;
    }

    ExternalVolumeMaintenanceData(ExternalVolumeInfo externalVolumeInfo) {
        this(externalVolumeInfo.getVpgInfo());
    }

    Object getApplyData() {
        EXDPGOperation eXDPGOperation = new EXDPGOperation();
        EXDVpg eXDVpg = this.mVpgInfo.getEXDVpg();
        eXDPGOperation.setPGIndex(eXDVpg.getIFB4(), eXDVpg.getIPG());
        return eXDPGOperation;
    }

    protected int setApplyResult(Object object) {
        int n = ((EXDPGOperation)object).getResult();
        if (n == 0) {
            if (mOperation == 0) {
                EXDVpg eXDVpg = this.mVpgInfo.getEXDVpg();
                this.mflgDeleteVolumeSuccess = true;
                int n2 = eXDVpg.referPathGroupId();
                ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
                externalVolumeManager.clearCache(n2);
            } else if (mOperation == 4 || mOperation == 3) {
                EXDVpg eXDVpg = this.mVpgInfo.getEXDVpg();
                int n3 = eXDVpg.referPathGroupId();
                ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
                externalVolumeManager.clearCache(n3);
            } else if (mOperation == 6 || mOperation == 5) {
                EXDVpg eXDVpg = this.mVpgInfo.getEXDVpg();
                int n4 = eXDVpg.referPathGroupId();
                ExternalVolumeManager externalVolumeManager = ExternalVolumeManager.getInstance();
                externalVolumeManager.clearCache(n4);
            }
        }
        return n;
    }

    void enterPreset() {
        this.setModify(true);
        ++mPresetEntryCount;
    }

    void removePreset() {
        ExternalVolumeManager externalVolumeManager;
        ExternalVolumeInfo externalVolumeInfo;
        if ((mOperation == 4 || mOperation == 3 || mOperation == 6 || mOperation == 5) && (externalVolumeInfo = (externalVolumeManager = ExternalVolumeManager.getInstance()).getCachedVolume(this.mVpgInfo)) != null) {
            EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
            if (mOperation == 4) {
                eXDExternalVolume.setCacheMode(false);
            } else if (mOperation == 3) {
                eXDExternalVolume.setCacheMode(true);
            } else if (mOperation == 6) {
                eXDExternalVolume.setInflowControl(false);
            } else {
                eXDExternalVolume.setInflowControl(true);
            }
        }
        this.setModify(false);
        if (this.mflgDeleteVolumeSuccess && mOperation == 0) {
            VpgManager.getInstance().deleteVpgInfo(this.mVpgInfo);
        }
        if (--mPresetEntryCount == 0) {
            mOperation = -1;
        }
    }

    void setModify(boolean bl) {
        this.mVpgInfo.setModify(bl);
        EXDVpg eXDVpg = this.mVpgInfo.getEXDVpg();
        int n = eXDVpg.referPathGroupId();
        PathGroupManager pathGroupManager = PathGroupManager.getInstance();
        PathGroupInfo pathGroupInfo = pathGroupManager.getPathGroupInfo(n);
        pathGroupInfo.setModify(bl);
        ProductInfo productInfo = pathGroupInfo.getProductInfo();
        productInfo.setModify(bl);
    }

    public VpgInfo getVpgInfo() {
        return this.mVpgInfo;
    }

    private static Collection getVpgInfo(ProductInfo[] productInfoArray) {
        ArrayList arrayList = new ArrayList();
        VpgManager vpgManager = VpgManager.getInstance();
        for (int i = 0; i < productInfoArray.length; ++i) {
            Collection collection = vpgManager.getVpgInfo(productInfoArray[i]);
            arrayList.addAll(collection);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static boolean canDeleteVolume(ExternalVolumeInfo externalVolumeInfo) {
        return true;
    }

    public static void doDeleteVolume(ExternalVolumeInfo[] externalVolumeInfoArray) {
        mOperation = 0;
        ExternalVolumeMaintenanceData.setPreset(externalVolumeInfoArray);
    }

    public static boolean canDisconnectSubsystem(ProductInfo productInfo) {
        return true;
    }

    public static void doDisconnectSubsystem(ProductInfo[] productInfoArray) {
        mOperation = 1;
        ExternalVolumeMaintenanceData.setPreset(productInfoArray);
    }

    public static boolean canDisconnectVolume(ExternalVolumeInfo externalVolumeInfo) {
        return true;
    }

    public static void doDisconnectVolume(ExternalVolumeInfo[] externalVolumeInfoArray) {
        mOperation = 1;
        ExternalVolumeMaintenanceData.setPreset(externalVolumeInfoArray);
    }

    public static boolean canCheckPathAndRestoreVol(ProductInfo productInfo) {
        return true;
    }

    public static void doCheckPathAndRestoreVol(ProductInfo[] productInfoArray) {
        mOperation = 2;
        ExternalVolumeMaintenanceData.setPreset(productInfoArray);
    }

    public static boolean canCheckPathAndRestoreVol(ExternalVolumeInfo externalVolumeInfo) {
        return true;
    }

    public static void doCheckPathAndRestoreVol(ExternalVolumeInfo[] externalVolumeInfoArray) {
        mOperation = 2;
        ExternalVolumeMaintenanceData.setPreset(externalVolumeInfoArray);
    }

    public static boolean canChangeCacheMode(ExternalVolumeInfo externalVolumeInfo, boolean bl) {
        boolean bl2 = false;
        if (!externalVolumeInfo.isCmd()) {
            bl2 = externalVolumeInfo.isCacheModeEnable() != bl;
        }
        return bl2;
    }

    public static void doChangeCacheMode(ExternalVolumeInfo[] externalVolumeInfoArray, boolean bl) {
        ArrayList<ExternalVolumeInfo> arrayList = new ArrayList<ExternalVolumeInfo>(externalVolumeInfoArray.length);
        for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
            if (!ExternalVolumeMaintenanceData.canChangeCacheMode(externalVolumeInfoArray[i], bl)) continue;
            arrayList.add(externalVolumeInfoArray[i]);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        mOperation = bl ? 4 : 3;
        ExternalVolumeInfo[] externalVolumeInfoArray2 = new ExternalVolumeInfo[arrayList.size()];
        externalVolumeInfoArray2 = arrayList.toArray(externalVolumeInfoArray2);
        ExternalVolumeMaintenanceData.setPreset(externalVolumeInfoArray2);
        for (int i = 0; i < externalVolumeInfoArray2.length; ++i) {
            ExternalVolumeInfo externalVolumeInfo = externalVolumeInfoArray2[i];
            EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
            eXDExternalVolume.setCacheMode(bl);
        }
    }

    public static boolean canChangeInflowControl(ExternalVolumeInfo externalVolumeInfo, boolean bl) {
        return externalVolumeInfo.isInflowControlEnable() != bl;
    }

    public static void doChangeInflowControl(ExternalVolumeInfo[] externalVolumeInfoArray, boolean bl) {
        ArrayList<ExternalVolumeInfo> arrayList = new ArrayList<ExternalVolumeInfo>(externalVolumeInfoArray.length);
        for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
            if (!ExternalVolumeMaintenanceData.canChangeInflowControl(externalVolumeInfoArray[i], bl)) continue;
            arrayList.add(externalVolumeInfoArray[i]);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        mOperation = bl ? 6 : 5;
        ExternalVolumeInfo[] externalVolumeInfoArray2 = new ExternalVolumeInfo[arrayList.size()];
        externalVolumeInfoArray2 = arrayList.toArray(externalVolumeInfoArray2);
        ExternalVolumeMaintenanceData.setPreset(externalVolumeInfoArray2);
        for (int i = 0; i < externalVolumeInfoArray2.length; ++i) {
            ExternalVolumeInfo externalVolumeInfo = externalVolumeInfoArray2[i];
            EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
            eXDExternalVolume.setInflowControl(bl);
        }
    }

    private static void setPreset(ProductInfo[] productInfoArray) {
        PresetManager presetManager = PresetManager.getInstance();
        Iterator iterator = ExternalVolumeMaintenanceData.getVpgInfo(productInfoArray).iterator();
        while (iterator.hasNext()) {
            VpgInfo vpgInfo = (VpgInfo)iterator.next();
            if (vpgInfo.isModify()) continue;
            ExternalVolumeMaintenanceData externalVolumeMaintenanceData = new ExternalVolumeMaintenanceData(vpgInfo);
            presetManager.add(externalVolumeMaintenanceData, mOperation);
        }
    }

    private static void setPreset(ExternalVolumeInfo[] externalVolumeInfoArray) {
        PresetManager presetManager = PresetManager.getInstance();
        for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
            VpgInfo vpgInfo = externalVolumeInfoArray[i].getVpgInfo();
            if (vpgInfo.isModify()) continue;
            ExternalVolumeMaintenanceData externalVolumeMaintenanceData = new ExternalVolumeMaintenanceData(vpgInfo);
            presetManager.add(externalVolumeMaintenanceData, mOperation);
        }
    }

    static void refrectModifyValue(ExternalVolumeInfo[] externalVolumeInfoArray) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (mOperation != 4) break block4;
                        for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
                            ExternalVolumeInfo externalVolumeInfo = externalVolumeInfoArray[i];
                            if (!externalVolumeInfo.isModify()) continue;
                            EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
                            eXDExternalVolume.setCacheMode(true);
                        }
                        break block5;
                    }
                    if (mOperation != 3) break block6;
                    for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
                        ExternalVolumeInfo externalVolumeInfo = externalVolumeInfoArray[i];
                        if (!externalVolumeInfo.isModify()) continue;
                        EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
                        eXDExternalVolume.setCacheMode(false);
                    }
                    break block5;
                }
                if (mOperation != 6) break block7;
                for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
                    ExternalVolumeInfo externalVolumeInfo = externalVolumeInfoArray[i];
                    if (!externalVolumeInfo.isModify()) continue;
                    EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
                    eXDExternalVolume.setInflowControl(true);
                }
                break block5;
            }
            if (mOperation != 5) break block5;
            for (int i = 0; i < externalVolumeInfoArray.length; ++i) {
                ExternalVolumeInfo externalVolumeInfo = externalVolumeInfoArray[i];
                if (!externalVolumeInfo.isModify()) continue;
                EXDExternalVolume eXDExternalVolume = externalVolumeInfo.getEXDExternalVolume();
                eXDExternalVolume.setInflowControl(false);
            }
        }
    }

    public int compareTo(Object object) {
        RJiPGIndex rJiPGIndex = ExternalVolumeMaintenanceData.getCompValue(this);
        RJiPGIndex rJiPGIndex2 = ExternalVolumeMaintenanceData.getCompValue(object);
        return rJiPGIndex.compareTo((Object)rJiPGIndex2);
    }

    public boolean equals(Object object) {
        try {
            RJiPGIndex rJiPGIndex = ExternalVolumeMaintenanceData.getCompValue(this);
            RJiPGIndex rJiPGIndex2 = ExternalVolumeMaintenanceData.getCompValue(object);
            return rJiPGIndex.equals((Object)rJiPGIndex2);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String toString() {
        return this.mVpgInfo.toString();
    }

    private static RJiPGIndex getCompValue(Object object) {
        Object object2 = object instanceof ExternalVolumeMaintenanceData ? ((ExternalVolumeMaintenanceData)object).getVpgInfo().getEXDVpg() : (RJiPGIndex)object;
        return object2;
    }
}

