/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.luoperation;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.Operation;
import sanproject.client.exdevice.com.TableColumnInfo;
import sanproject.client.exdevice.data.AbstractDataControl;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.PathDirector;
import sanproject.client.exdevice.data.PathGroupInfo;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.client.exdevice.luoperation.ExternalPortColumnInfo;
import sanproject.client.exdevice.luoperation.LocalGuidance;
import sanproject.client.exdevice.luoperation.LocalOperation;
import sanproject.client.exdevice.luoperation.PathConfigurationPanel;
import sanproject.client.exdevice.luoperation.PathGroupElement;
import sanproject.client.exdevice.luoperation.PhysicalPathDirectorElement;
import sanproject.client.exdevice.luoperation.PhysicalPathElement;
import sanproject.client.exdevice.luoperation.PriorityColumnInfo;
import sanproject.client.exdevice.luoperation.TargetPortColumnInfo;

public class PhysicalPathTableDataModel
extends AbstractTableDataModel {
    private TableColumnInfo[] headers;
    private PathGroupElement pathGroup;
    private RJcMenuAction pathConfigAction;

    public PhysicalPathTableDataModel(PathGroupElement pathGroupElement) {
        this.pathGroup = pathGroupElement;
        String string = LocalGuidance.MENU_PATHCONFIG.getItemID();
        this.pathConfigAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_LU]", "PhysicalPathDataModel", "[PhysicalPathDataModel] Path Configuration Open.", 0);
                PhysicalPathTableDataModel.this.onSelectedPathConfiguration(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        this.setHeaderPush(false);
    }

    public TableColumnInfo[] getColumnInfos() {
        if (this.headers == null) {
            this.headers = new TableColumnInfo[]{new PriorityColumnInfo(), new ExternalPortColumnInfo(), new TargetPortColumnInfo()};
        }
        TableColumnInfo[] tableColumnInfoArray = this.headers;
        return tableColumnInfoArray;
    }

    protected JPopupMenu createPopupMenu() {
        RJcPopupMenu rJcPopupMenu = null;
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{this.pathConfigAction};
        rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        return rJcPopupMenu;
    }

    private void updateActionsStatus() {
        boolean bl = PhysicalPathTableDataModel.isEditable(13, 1);
        if (bl) {
            PresetManager presetManager = PresetManager.getInstance();
            bl = Operation.isPossibleTo(presetManager, LocalOperation.PATH_CONFIG);
        }
        this.pathConfigAction.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSelectedPathConfiguration(ActionEvent actionEvent) {
        Object object = this.pathGroup.getGroupInfo();
        Object object2 = VolumeOperationDataControl.getInstance();
        Object object3 = new PathDirector((AbstractDataControl)object2, (PathGroupInfo)object);
        PhysicalPathDirectorElement physicalPathDirectorElement = new PhysicalPathDirectorElement((PathDirector)object3);
        object = this.getPopupMenuOwnerFrame(actionEvent);
        RJCom.waitCursor((Component)object);
        object2 = new PathConfigurationPanel(physicalPathDirectorElement);
        object3 = ((DialogContentsPanel)object2).createDialogWindow((JFrame)object, RJComDef.DlgTitle);
        ((Dialog)object3).setVisible(true);
        DialogContentsPanel.DialogState dialogState = ((DialogContentsPanel)object2).getDialogStatus();
        try {
            if (dialogState.equals(DialogContentsPanel.APPLY_STATUS)) {
                physicalPathDirectorElement.commit();
                this.pathGroup.requestContentsRefresh();
            }
        }
        catch (EXDException eXDException) {
            this.pathGroup.requestTransferException(eXDException);
        }
        finally {
            RJCom.defCursor((Component)object);
        }
    }

    public PhysicalPathElement[] getSelectedPhysicalPathElements() {
        int[] nArray = this.getSelectedRows();
        PhysicalPathElement[] physicalPathElementArray = this.getPhysicalPathElements(nArray);
        return physicalPathElementArray;
    }

    public PhysicalPathElement[] getPhysicalPathElements(int[] nArray) {
        RJcElement[] rJcElementArray = this.getElements(nArray);
        int n = rJcElementArray.length;
        ArrayList<RJcElement> arrayList = new ArrayList<RJcElement>();
        arrayList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            RJcElement rJcElement = rJcElementArray[i];
            if (!(rJcElement instanceof PhysicalPathElement)) continue;
            arrayList.add(rJcElement);
        }
        PhysicalPathElement[] physicalPathElementArray = new PhysicalPathElement[]{};
        physicalPathElementArray = arrayList.toArray(physicalPathElementArray);
        return physicalPathElementArray;
    }

    public boolean isAllowedSort() {
        boolean bl = false;
        return bl;
    }
}

