/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.lunm.data;

import java.awt.Color;
import javax.swing.Icon;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJIconTBL;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.data.RJDataChange;
import sanproject.client.lunm.RJLunConstants;
import sanproject.client.lunm.RJLunGdata;
import sanproject.client.lunm.RJLunMngr;
import sanproject.client.lunm.RJLunTreePanel;
import sanproject.client.lunm.data.RJLunDataSupplier;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.DKCgetScatteredPGInfo;

public class RJLunElement
extends RJcElement
implements RJLunConstants {
    protected RJLunDataSupplier supplier;
    protected RJLunTreePanel TreePanel = null;
    protected RJLunMngr LUNMPanel;
    protected RJDataChange DataChange;
    public boolean bModify = false;
    public boolean bCopy = false;

    public RJLunElement() {
        this("???", null);
    }

    public RJLunElement(String string) {
        super(string, null);
    }

    public RJLunElement(String string, RJcTreePanel rJcTreePanel) {
        super(string, rJcTreePanel);
    }

    public void setTreePanel(RJcTreePanel rJcTreePanel) {
        super.setTreePanel(rJcTreePanel);
        if (rJcTreePanel != null) {
            this.setSupplier((RJLunDataSupplier)rJcTreePanel.getUserObject());
        }
        super.setTableModel(this.model);
    }

    public void setSupplier(RJLunDataSupplier rJLunDataSupplier) {
        this.supplier = rJLunDataSupplier;
    }

    public Icon getIcon(boolean bl) {
        Icon icon = RJIconTBL.getIcon(1);
        if (!bl) {
            icon = RJIconTBL.getIcon(2);
        }
        return icon;
    }

    public Color getForeground() {
        Color color = null;
        if (this.isCopy()) {
            color = new Color(0, 128, 0);
        } else if (this.isModify()) {
            color = RJcConst.modifyColor;
        } else if (this.isWarning()) {
            color = RJcConst.warningColor;
        }
        return color;
    }

    public Integer getFontStyle() {
        Integer n = null;
        if (this.isCopy()) {
            n = new Integer(1);
        } else if (this.isModify()) {
            n = new Integer(3);
        } else if (this.isWarning()) {
            n = new Integer(2);
        }
        return n;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isExpandMode() {
        return true;
    }

    public boolean isCopy() {
        return this.bCopy;
    }

    public void setCopy(boolean bl) {
        this.bCopy = bl;
    }

    public boolean isModify() {
        return this.bModify;
    }

    public void setModify(boolean bl) {
        this.bModify = bl;
    }

    public String getLDEVGuardStr(byte by, byte by2) {
        String string = "";
        if (by != 0) {
            switch ((byte)(by & 0xC3)) {
                case -128: {
                    string = RJLunGdata.GD_READ_WRITE;
                    break;
                }
                case -127: {
                    string = RJLunGdata.GD_PROTECT;
                    break;
                }
                case -126: {
                    string = RJLunGdata.GD_READ_ONLY;
                    break;
                }
                case -64: {
                    string = RJLunGdata.GD_S_READ_WRITE;
                    break;
                }
                case -63: {
                    string = RJLunGdata.GD_S_PROTECT;
                    break;
                }
                case -62: {
                    string = RJLunGdata.GD_S_READ_ONLY;
                    break;
                }
                default: {
                    string = "-";
                }
            }
            if (by2 == 1) {
                string = RJLunGdata.GD_VMA + ":" + string;
            } else if (by2 == 2) {
                string = RJLunGdata.GD_VMA + RJLunGdata.GD_EXTENT + ":" + string;
            }
        }
        return string;
    }

    public String getEmulationDispData(short s, int n) {
        String string = "";
        if (n != 0) {
            if (s > 1) {
                string = this.DataChange.getEmulationTypeName(n);
                string = string + " *" + s;
            } else {
                string = this.DataChange.getEmulationTypeName(n);
            }
        }
        return string;
    }

    public String getRaidLevelDispData(int n, int n2, int n3) {
        String string = this.DataChange.getRAIDLevelName(n);
        DKCgetScatteredPGInfo dKCgetScatteredPGInfo = this.supplier.getScatteredPGInfo(n2, n3);
        if (dKCgetScatteredPGInfo != null) {
            int n4 = 1;
            string = string + " * " + (n4 += dKCgetScatteredPGInfo.getObjPGIndex().length);
        }
        return string;
    }

    public String getPGDispData(int n, int n2) {
        String string = "";
        RJiPGIndex rJiPGIndex = new RJiPGIndex();
        rJiPGIndex.setPGIndex(n, n2);
        string = RJComUty.getPGDisplayName((Robj_interface_RJiPGIndex)rJiPGIndex);
        DKCgetScatteredPGInfo dKCgetScatteredPGInfo = this.supplier.getScatteredPGInfo(n, n2);
        if (dKCgetScatteredPGInfo != null) {
            rJiPGIndex = new RJiPGIndex();
            rJiPGIndex.setPGIndex(dKCgetScatteredPGInfo.getIFB4(), dKCgetScatteredPGInfo.getIPG());
            string = RJComUty.getPGDisplayName((Robj_interface_RJiPGIndex)rJiPGIndex) + "[";
            Robj_interface_RJiPGIndex[] robj_interface_RJiPGIndexArray = dKCgetScatteredPGInfo.getObjPGIndex();
            for (int i = 0; i < robj_interface_RJiPGIndexArray.length; ++i) {
                if (!string.endsWith("[")) {
                    string = string + ":";
                }
                rJiPGIndex = new RJiPGIndex();
                rJiPGIndex.setPGIndex(robj_interface_RJiPGIndexArray[i].getIFB4(), robj_interface_RJiPGIndexArray[i].getIPG());
                string = string + RJComUty.getPGDisplayName((Robj_interface_RJiPGIndex)rJiPGIndex);
            }
            string = string + "]";
        }
        return string;
    }

    public String getLDEVDispData(Robj_interface_RJiLDEVInfoDetail robj_interface_RJiLDEVInfoDetail) {
        String string = "";
        if (robj_interface_RJiLDEVInfoDetail != null) {
            string = RJComUty.getLDEVDisplayName(robj_interface_RJiLDEVInfoDetail);
        }
        return string;
    }
}

