/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import sanproject.client.monitor.com.RJHihTimePair;

public class RJHihChartData {
    public static final int CV_MiB = 1;
    public static final int CV_Sec = 2;
    private RJHihTimePair drawTerm;
    private String[] labels;
    private String axisYTitle = null;
    private String axisXTitle = null;
    private double[][] plotValues = null;
    private double[][] barValues = null;
    private ArrayList labelList = new ArrayList(16);
    private ArrayList colorList = new ArrayList(16);
    private ArrayList plotList = new ArrayList(16);
    private ArrayList barList = new ArrayList(16);

    public void setDrawTerm(RJHihTimePair rJHihTimePair) {
        this.drawTerm = rJHihTimePair;
    }

    public void setLabels(String[] stringArray) {
        this.labels = stringArray;
    }

    public void addLabel(String string) {
        if (string != null) {
            this.labelList.add(string);
        }
    }

    public void completeLabels() {
        this.labels = null;
        if (this.labelList.size() > 0) {
            this.setLabels(this.labelList.toArray(new String[0]));
        }
    }

    public void addChartValues(Object object) {
        this.addChartValues(object, null, null, 0);
    }

    public void addChartValues(Object object, int[] nArray) {
        this.addChartValues(object, nArray, null, 0);
    }

    public void addChartValues(Object object, int n) {
        this.addChartValues(object, null, null, n);
    }

    public void addChartValues(Object object, int[] nArray, Color color) {
        this.addChartValues(object, nArray, color, 0);
    }

    public void addChartValues(Object object, int[] nArray, Color color, int n) {
        if (object != null) {
            int n2 = Array.getLength(object);
            double[] dArray = new double[n2];
            long l = 1L;
            if (n == 1) {
                l = 1024L;
            } else if (n == 2) {
                l = 1000L;
            }
            for (int i = 0; i < n2; ++i) {
                long l2 = Array.getLong(object, i);
                if (l2 < 0L) {
                    l2 = -50000L;
                }
                dArray[i] = (double)l2 / (double)l;
            }
            this.plotList.add(dArray);
            if (nArray != null) {
                double[] dArray2 = new double[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    dArray2[i] = 0.0;
                    if (nArray[i] != 1) continue;
                    dArray2[i] = Array.getDouble(object, i);
                }
                this.barList.add(dArray2);
            }
            this.colorList.add(color);
        }
    }

    public void completeChartValues() {
        this.plotValues = null;
        this.barValues = null;
        if (this.plotList.size() > 0) {
            this.plotValues = (double[][])this.plotList.toArray((T[])new double[0][]);
            if (this.barList.size() > 0) {
                this.barValues = (double[][])this.barList.toArray((T[])new double[0][]);
            }
        }
    }

    public RJHihTimePair getDrawTerm() {
        return this.drawTerm;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public String getAxisYTitle() {
        return this.axisYTitle;
    }

    public void setAxisYTitle(String string) {
        this.axisYTitle = string;
    }

    public String getAxisXTitle() {
        return this.axisXTitle;
    }

    public void setAxisXTitle(String string) {
        this.axisXTitle = string;
    }

    public double[][] getPlotValues() {
        return this.plotValues;
    }

    public int getPlotCount() {
        return this.plotValues[0].length;
    }

    public double[][] getBarValues() {
        return this.barValues;
    }

    public boolean isValues() {
        boolean bl = false;
        if (this.getPlotValues() != null || this.getBarValues() != null) {
            bl = true;
        }
        return bl;
    }

    public ArrayList getColorList() {
        return this.colorList;
    }
}

