/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.com;

import java.util.Date;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihMonitoringTermInfo;
import sanproject.client.monitor.com.RJHihTimePair;

public abstract class RJHihMonitoringInfo {
    public static final int MINUTE15 = 15;
    public static final int MINUTE1 = 1;
    public static final int MINUTE_DAY = 1440;
    public static final int MODE_FROMTO = 0;
    public static final int MODE_REALTIME = 1;
    protected String identifier;
    protected RJHihDataSupplier supplier;
    protected RJHihMonitoringTermInfo termInfo = null;

    public RJHihMonitoringInfo(String string, RJHihDataSupplier rJHihDataSupplier) {
        this.identifier = string;
        this.supplier = rJHihDataSupplier;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    public abstract void init();

    public Date getStartTime() {
        return this.termInfo.getStartTime();
    }

    public Date getEndTime() {
        return this.termInfo.getEndTime();
    }

    public boolean isErrorShow() {
        return this.termInfo.isErrorShow();
    }

    public void setErrorShow(boolean bl) {
        this.termInfo.setErrorShow(bl);
    }

    public int getIntervalTime() {
        return this.termInfo.getIntervalTime();
    }

    public void setMonitoringTime(Date date, Date date2) {
        this.termInfo.setMonitoringTime(date, date2);
    }

    public void setMonitoringTime(RJHihTimePair rJHihTimePair) {
        this.setMonitoringTime(rJHihTimePair.getFromTime(), rJHihTimePair.getToTime());
    }

    public RJHihTimePair getMonitoringTime() {
        return this.termInfo.getMonitoringTime();
    }

    public RJHihTimePair getMonitoringCurrentTime() {
        RJHihTimePair rJHihTimePair = null;
        Date date = this.termInfo.getStartTime();
        Date date2 = this.termInfo.getEndTime();
        if (date != null && date2 != null) {
            Date date3 = date2;
            long l = this.termInfo.getIntervalTime() * 1 * 60 * 1000;
            Date date4 = new Date(Math.max(date.getTime(), date3.getTime() - l));
            rJHihTimePair = new RJHihTimePair(date4, date3, this.termInfo.getIntervalTime());
            System.out.println("####### " + rJHihTimePair);
        }
        return rJHihTimePair;
    }

    public Date getFromTime() {
        return this.termInfo.getFromTime();
    }

    public Date getToTime() {
        return this.termInfo.getToTime();
    }

    public int getSpinTickSpacing() {
        return this.termInfo.getSpinTickSpacing();
    }

    public int getSliderTickSpacing() {
        return this.termInfo.getSliderTickSpacing();
    }

    public int getLabelTickSpacing() {
        return this.termInfo.getLabelTickSpacing();
    }

    public boolean isRealTimeEnabled() {
        return this.termInfo.isRealTimeEnabled();
    }

    public int getMode() {
        return this.termInfo.getMode();
    }

    public void setMode(int n) {
        this.termInfo.setMode(n);
    }

    public int getRealTimeInterval() {
        return this.termInfo.getRealTimeInterval();
    }

    public void setRealTimeInterval(int n) {
        this.termInfo.setRealTimeInterval(n);
    }

    public Object[] getRealTimeItems() {
        return this.termInfo.getRealTimeItems();
    }

    public void updateTime() {
        this.supplier.updateMonitoringInfo();
    }

    public int getRangeKind() {
        return this.termInfo.getRangeKind();
    }
}

