/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.option;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcConst;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.data.RJDataMsg;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDef;
import sanproject.client.monitor.com.RJHihMonitoringOptionInfo;
import sanproject.client.monitor.com.RJHihMonitoringShort;
import sanproject.client.monitor.com.RJHihPanel;
import sanproject.client.monitor.option.RJHihMonitoringOptionPanel;
import sanproject.client.monitor.option.RJHihMonitoringSelectCUPanel;

public class RJHihMonitoringSwitchPanel
extends RJHihPanel
implements RJHihDef {
    private BorderLayout thisLayout = new BorderLayout();
    private Border thisBorder;
    private RJcHeaderPanel headerPanel = new RJcHeaderPanel();
    private JPanel centerPanel = new JPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private Border centerBorder;
    private JLabel dmyLeftLabel = new JLabel();
    private JPanel switchPanel = new JPanel();
    private GridBagLayout switchLayout = new GridBagLayout();
    private JLabel statusLabel = new JLabel();
    private JRadioButton onRadioButton = new JRadioButton();
    private JRadioButton offRadioButton = new JRadioButton();
    private ButtonGroup group = new ButtonGroup();
    private JLabel intervalLabel = new JLabel();
    private DefaultComboBoxModel model64 = new DefaultComboBoxModel<Object>(items);
    private DefaultComboBoxModel model512 = new DefaultComboBoxModel<Object>(items128);
    private JComboBox intervalComboBox = new JComboBox(this.model64);
    private JLabel minLabel = new JLabel();
    private JLabel dmyRightLabel = new JLabel();
    private boolean mSwitch = false;
    private int interval = 1;
    private static final Object[] items = new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15)};
    private static final Object[] items128 = new Object[]{new Integer(5), new Integer(10), new Integer(15)};
    private RJHihMonitoringOptionPanel parentPanel;
    private RJHihMonitoringSelectCUPanel selectCUPanel;
    public static final int MON_CU_SEGMENT = 65;

    public RJHihMonitoringSwitchPanel() {
        super((RJHihDataSupplier)null);
    }

    public RJHihMonitoringSwitchPanel(RJHihDataSupplier rJHihDataSupplier) {
        super(rJHihDataSupplier);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.thisBorder = BorderFactory.createEmptyBorder(0, 0, 8, 0);
        this.centerBorder = BorderFactory.createEmptyBorder(0, 0, 8, 0);
        this.setLayout(this.thisLayout);
        this.setBorder(this.thisBorder);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(10, 120));
        this.thisLayout.setHgap(4);
        this.thisLayout.setVgap(4);
        this.headerPanel.setHeader("MonitoringOption/MonitoringSwitchTitle");
        this.centerPanel.setLayout(this.centerLayout);
        this.centerPanel.setBackground(RJcGuide.color("MonitoringOption/MonitoringSwitchPanelBgClr"));
        this.centerPanel.setBorder(this.centerBorder);
        this.switchPanel.setLayout(this.switchLayout);
        this.switchPanel.setOpaque(false);
        this.statusLabel.setFont(RJcConst.normalFont);
        this.statusLabel.setPreferredSize(new Dimension(85, 25));
        this.statusLabel.setText(RJcGuide.text("MonitoringOption/CurrentStatusLbl"));
        this.statusLabel.setForeground(RJcGuide.color("MonitoringOption/CurrentStatusLbl"));
        this.onRadioButton.setSelected(true);
        this.group.add(this.onRadioButton);
        this.group.add(this.offRadioButton);
        this.onRadioButton.setFont(RJcConst.normalFont);
        this.onRadioButton.setOpaque(false);
        this.onRadioButton.setText(RJcGuide.text("MonitoringOption/EnableRadioBtn"));
        this.onRadioButton.setForeground(RJcGuide.color("MonitoringOption/EnableRadioBtn"));
        this.onRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihMonitoringSwitchPanel.this.setEnabledByRadioButton(true);
            }
        });
        this.offRadioButton.setFont(RJcConst.normalFont);
        this.offRadioButton.setOpaque(false);
        this.offRadioButton.setText(RJcGuide.text("MonitoringOption/DisableRadioBtn"));
        this.offRadioButton.setForeground(RJcGuide.color("MonitoringOption/DisableRadioBtn"));
        this.offRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihMonitoringSwitchPanel.this.setEnabledByRadioButton(false);
            }
        });
        this.intervalLabel.setFont(RJcConst.normalFont);
        this.intervalLabel.setText(RJcGuide.text("MonitoringOption/GatheringIntervalLbl"));
        this.intervalLabel.setForeground(RJcGuide.color("MonitoringOption/GatheringIntervalLbl"));
        this.intervalLabel.setPreferredSize(new Dimension(110, 15));
        this.intervalLabel.setMinimumSize(new Dimension(110, 15));
        this.intervalComboBox.setFont(RJcConst.normalFont);
        this.intervalComboBox.setPreferredSize(new Dimension(80, 21));
        this.intervalComboBox.setMinimumSize(new Dimension(80, 21));
        this.minLabel.setHorizontalAlignment(0);
        this.minLabel.setPreferredSize(new Dimension(80, 15));
        this.minLabel.setMinimumSize(new Dimension(80, 15));
        this.minLabel.setFont(RJcConst.normalFont);
        this.minLabel.setText(RJcGuide.text("MonitoringOption/IntervalMinuteLbl"));
        this.minLabel.setForeground(RJcGuide.color("MonitoringOption/IntervalMinuteLbl"));
        this.add((Component)this.headerPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.dmyLeftLabel, new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.switchPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.switchPanel.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.switchPanel.add((Component)this.onRadioButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.switchPanel.add((Component)this.offRadioButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.switchPanel.add((Component)this.intervalLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.switchPanel.add((Component)this.intervalComboBox, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.switchPanel.add((Component)this.minLabel, new GridBagConstraints(5, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.dmyRightLabel, new GridBagConstraints(2, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(boolean bl) {
        this.mSwitch = false;
        this.interval = 1;
        RJHihMonitoringOptionInfo rJHihMonitoringOptionInfo = this.supplier.getMonitoringOption();
        if (rJHihMonitoringOptionInfo != null) {
            this.mSwitch = rJHihMonitoringOptionInfo.getMonitoringSwitch();
            RJHihMonitoringShort rJHihMonitoringShort = this.supplier.getMonitoringShort();
            if (rJHihMonitoringShort != null && rJHihMonitoringShort.getIntervalTime() > 0) {
                this.interval = rJHihMonitoringShort.getIntervalTime();
            }
            if (this.mSwitch) {
                this.interval = rJHihMonitoringOptionInfo.getIntervalTime();
            }
        }
        this.onRadioButton.setSelected(this.mSwitch);
        this.offRadioButton.setSelected(!this.mSwitch);
        this.intervalComboBox.setSelectedItem(new Integer(this.interval));
        this.onRadioButton.setEnabled(bl);
        this.offRadioButton.setEnabled(bl);
        this.intervalComboBox.setEnabled(bl & this.mSwitch);
    }

    public boolean isChange() {
        boolean bl = false;
        int n = (Integer)this.intervalComboBox.getSelectedItem();
        if (this.onRadioButton.isSelected() != this.mSwitch || n != this.interval) {
            bl = true;
        }
        return bl;
    }

    public boolean isChangeOntoOn() {
        boolean bl = false;
        if (this.onRadioButton.isSelected() && this.mSwitch) {
            int n = this.selectCUPanel.getTargetCount();
            int n2 = this.selectCUPanel.getTargetInitCount();
            if (n < 65 && n2 >= 65) {
                return true;
            }
            if (n >= 65 && n2 < 65) {
                return true;
            }
        }
        return bl;
    }

    public void setEnabledByRadioButton(boolean bl) {
        this.intervalComboBox.setEnabled(bl);
        this.parentPanel.setComboMode();
    }

    public boolean isSwitch() {
        return this.onRadioButton.isSelected();
    }

    public int getInterval() {
        return (Integer)this.intervalComboBox.getSelectedItem();
    }

    public boolean showInfomation() {
        boolean bl = true;
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        if (this.isChangeOntoOn()) {
            RJDataMsg rJDataMsg = this.supplier.getMessage(511059030);
            int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            if (n != 0) {
                bl = false;
            }
            return bl;
        }
        if (this.isChange()) {
            RJDataMsg rJDataMsg = this.supplier.getMessage(this.onRadioButton.isSelected() ? 511059030 : 511059031);
            int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            if (n != 0) {
                bl = false;
            }
            this.supplier.putLog("[MonSwitch]", "[ShowMsg]", "status = " + bl + ", sw = " + this.onRadioButton.isSelected() + ", interval = " + (Integer)this.intervalComboBox.getSelectedItem());
        }
        return bl;
    }

    public void setParentPanel(RJHihMonitoringOptionPanel rJHihMonitoringOptionPanel) {
        this.parentPanel = rJHihMonitoringOptionPanel;
    }

    public void setComboMode(int n) {
        if (n >= 0 && n <= 64) {
            this.intervalComboBox.setModel(this.model64);
        }
        if (n > 64 && n <= 510) {
            this.intervalComboBox.setModel(this.model512);
        }
    }

    public void setCUPanel(RJHihMonitoringSelectCUPanel rJHihMonitoringSelectCUPanel) {
        this.selectCUPanel = rJHihMonitoringSelectCUPanel;
    }
}

