/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.utility.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import sanproject.client.openldevguard.utility.sort.DataSorter;
import sanproject.client.openldevguard.utility.sort.DefaultStringDataSorter;
import sanproject.client.openldevguard.utility.sort.NumericalDivisionDataSorter;
import sanproject.client.openldevguard.utility.sort.SortTarget;

abstract class StringDataSorter
implements DataSorter {
    public static final String CHARACTER_SORTER = "Character";
    public static final String NUMERICALDIVISION_SORTER = "NumerialDivision";
    private final Object mobjOperationLock = new Object();
    private final List mlstPutedDataList = new ArrayList();

    StringDataSorter() {
    }

    protected abstract String createSortKey(Object var1);

    public static final StringDataSorter createDataSorter(String string) {
        StringDataSorter stringDataSorter = null;
        if (string.equals(CHARACTER_SORTER)) {
            stringDataSorter = new DefaultStringDataSorter();
        } else if (string.equals(NUMERICALDIVISION_SORTER)) {
            stringDataSorter = new NumericalDivisionDataSorter();
        } else {
            String string2 = "Unsupported sorter. key = [" + string + "]";
            throw new RuntimeException(string2);
        }
        return stringDataSorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Object object, Object object2) {
        String string = this.createSortKey(object);
        SortTarget sortTarget = new SortTarget(string, object2);
        Object object3 = this.mobjOperationLock;
        synchronized (object3) {
            this.mlstPutedDataList.add(sortTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(Object object) {
        String string = this.createSortKey(object);
        Object object2 = this.mobjOperationLock;
        synchronized (object2) {
            this.mlstPutedDataList.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.mobjOperationLock;
        synchronized (object) {
            this.mlstPutedDataList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int n;
        Object object = this.mobjOperationLock;
        synchronized (object) {
            n = this.mlstPutedDataList.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getOriginalDataList() {
        ArrayList arrayList;
        ArrayList<Object> arrayList2 = this.mobjOperationLock;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.mlstPutedDataList);
        }
        arrayList2 = new ArrayList<Object>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SortTarget sortTarget = (SortTarget)iterator.next();
            Object object = sortTarget.getValueObject();
            arrayList2.add(object);
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getSortedDataList() {
        ArrayList arrayList;
        ArrayList<Object> arrayList2 = this.mobjOperationLock;
        synchronized (arrayList2) {
            arrayList = new ArrayList(this.mlstPutedDataList);
        }
        Collections.sort(arrayList);
        arrayList2 = new ArrayList<Object>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SortTarget sortTarget = (SortTarget)iterator.next();
            Object object = sortTarget.getValueObject();
            arrayList2.add(object);
        }
        return arrayList2;
    }
}

