/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.pool;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcTreePanel;
import sanproject.client.com.abs.RJaContainMenu;
import sanproject.client.com.abs.RJaMenuItemActionListener;
import sanproject.client.com.abs.RJaPopupMenuSTD;
import sanproject.client.com.abs.RJaTreeNode;
import sanproject.client.data.RJDataMsg;
import sanproject.client.pool.RJPoolApplyData;
import sanproject.client.pool.RJPoolApplyItem;
import sanproject.client.pool.RJPoolDataSupplier;
import sanproject.client.pool.RJPoolElement;
import sanproject.client.pool.RJPoolIconTable;
import sanproject.client.pool.RJPoolInfoDialog;
import sanproject.client.pool.RJPoolLdevElement;
import sanproject.client.pool.RJPoolPoolLdevTableModel;
import sanproject.client.pool.RJPoolPoolTablePanel;
import sanproject.client.pool.RJPoolTreePanel;
import sanproject.common.Robj_interface_POOLInfoDetail;
import sanproject.common.Robj_interface_RJiLDEVInfoDetailEUx;
import sanproject.serverux.dataimpl.POOLIndex;

public class RJPoolPoolElement
extends RJPoolElement
implements RJaContainMenu,
RJaMenuItemActionListener {
    public static final int POOL_STS_BLKINSID = 4096;
    public static final int POOL_STS_BLKINOUTSID = 4097;
    public static final int POOL_STS_PFULL = 4098;
    public static final int POOL_STS_POOLNCRT = 4099;
    public static final int POOL_STS_POOLCRT = 4100;
    public static final int POOL_STS_NORMAL = 4101;
    public static final int POOL_STS_PFUS = 4102;
    public static final int POOL_STS_POOLEXT = 4103;
    public static final int POOL_STS_POOLFREE = 4104;
    public static final int POOL_STS_TOPPVBLK = 65536;
    public static final int POOL_STS_STSMASK = 65535;
    public static final int POOL_STS_TOPMASK = -65536;
    private int poolIdInit = -1;
    private int poolId = -1;
    private boolean deletePool = false;
    private int thresholdInit = 0;
    private int threshold = 0;
    private int threshold2 = 0;
    private int grainSizeInit = 1;
    private int grainSize = 1;
    private int poolKindInit = 1;
    private int poolKind = 1;
    private long capacity = 0L;
    private long used = 0L;
    private int usedPercent = 0;
    private long status = 0L;
    private boolean blockedInit = false;
    private boolean blocked = false;
    private boolean warning = false;
    private int poolVolCountInit = 0;
    private int poolVolCount = 0;
    private int clprNo = -1;
    private String clprName = null;
    private String[] menuItems = new String[]{RJcGuide.text("Pool/PopupChangePoolInfo"), RJcGuide.text("Pool/PopupDeletePoolInfo"), RJcGuide.text("Pool/PopupRestorePoolInfo")};
    private Component parent = null;
    private JComponent invoker;
    private DefaultTreeModel treeModel = null;
    private RJaTreeNode node = null;
    private boolean initFlag = true;
    private int intVOLCount = 0;
    private int extVOLCount = 0;
    private int cacheEnableCount = 0;
    private int cacheDisableCount = 0;
    private int intFCDriveCount = 0;
    private int intSATADriveCount = 0;
    private int intSSDDriveCount = 0;
    private int encEnableCount = 0;
    private int encDisableCount = 0;
    private int raidLevel = -1;

    public RJPoolPoolElement(int n) {
        this(n, null, null);
    }

    public RJPoolPoolElement(int n, RJPoolDataSupplier rJPoolDataSupplier, RJcTreePanel rJcTreePanel) {
        super(String.valueOf(n), rJPoolDataSupplier, rJcTreePanel);
        this.poolId = n;
        this.children = new ArrayList();
        if (rJcTreePanel != null) {
            this.treeModel = (DefaultTreeModel)rJcTreePanel.getTreeModel();
        }
    }

    public void initDetail(Robj_interface_POOLInfoDetail robj_interface_POOLInfoDetail) {
        this.poolIdInit = this.poolId;
        if (robj_interface_POOLInfoDetail != null) {
            short s = robj_interface_POOLInfoDetail.getSPoolThreshold();
            this.threshold = s;
            this.thresholdInit = s;
            this.threshold2 = robj_interface_POOLInfoDetail.getSPoolFixThreshold();
            short s2 = robj_interface_POOLInfoDetail.getSPoolGrainSize();
            this.grainSize = s2;
            this.grainSizeInit = s2;
            byte by = robj_interface_POOLInfoDetail.getByPoolKind();
            this.poolKind = by;
            this.poolKindInit = by;
            this.capacity = robj_interface_POOLInfoDetail.getLPoolCapa() * 1024L;
            this.used = robj_interface_POOLInfoDetail.getLPoolUsed() * 1024L;
            this.status = robj_interface_POOLInfoDetail.getLPoolStatus();
            this.initUsedPercent();
            this.supplier.putLog("[Pool]", "[QSPoolInfo]", "ID=" + this.poolId + ", Threshold1=" + robj_interface_POOLInfoDetail.getSPoolThreshold() + ", Threshold2=" + robj_interface_POOLInfoDetail.getSPoolFixThreshold() + ", Kind=" + robj_interface_POOLInfoDetail.getByPoolKind() + ", Status=" + "[0x" + this.supplier.toHexString2(this.status, 8) + "]" + ", Capa=[" + robj_interface_POOLInfoDetail.getLPoolCapa() + ", " + robj_interface_POOLInfoDetail.getLPoolUsed() + "]" + ", LDEVCount=[" + robj_interface_POOLInfoDetail.getIPoolVolNum() + "]");
            if ((this.status & 0xFFFFL) == 4096L || (this.status & 0xFFFFL) == 4097L || (this.status & 0xFFFFL) == 4098L) {
                this.blocked = true;
                this.blockedInit = true;
            }
            if ((this.status & 0xFFFFFFFFFFFF0000L) == 65536L) {
                this.warning = true;
            }
            this.poolVolCountInit = this.poolVolCount = robj_interface_POOLInfoDetail.getIPoolVolNum();
        }
    }

    private void initUsedPercent() {
        this.calcUsedPercent();
        int n = this.threshold;
        if (this.poolKind == 2) {
            int n2 = n = this.threshold < this.threshold2 ? this.threshold : this.threshold2;
        }
        if ((this.status & 0xFFFFL) == 4101L && this.usedPercent >= n) {
            this.usedPercent = n - 1;
        } else if ((this.status & 0xFFFFL) == 4102L && this.usedPercent < n) {
            this.usedPercent = n;
        } else if ((this.status & 0xFFFFL) == 4102L && this.usedPercent == 100) {
            this.usedPercent = 99;
        } else if ((this.status & 0xFFFFL) == 4098L) {
            this.usedPercent = 100;
        }
    }

    private void calcUsedPercent() {
        double d = (double)(this.used * 100L) / (double)this.capacity;
        this.usedPercent = (int)(d > 0.0 && d < 1.0 ? Math.ceil(d) : Math.floor(d));
    }

    public void initDetail(RJPoolApplyItem rJPoolApplyItem) {
        if (rJPoolApplyItem != null) {
            this.threshold = rJPoolApplyItem.getThreshold();
            this.threshold2 = rJPoolApplyItem.getFixThreshold();
            this.grainSize = rJPoolApplyItem.getGrainSize();
            this.poolKind = rJPoolApplyItem.getKind();
        }
    }

    public void selectNode(RJaTreeNode rJaTreeNode) {
        RJPoolTreePanel rJPoolTreePanel;
        this.node = rJaTreeNode;
        RJPoolPoolTablePanel rJPoolPoolTablePanel = (RJPoolPoolTablePanel)this.treePanel.getTablePanel();
        if (this.model == null) {
            this.intVOLCount = 0;
            this.extVOLCount = 0;
            this.cacheEnableCount = 0;
            this.cacheDisableCount = 0;
            this.intFCDriveCount = 0;
            this.intSATADriveCount = 0;
            this.intSSDDriveCount = 0;
            this.encEnableCount = 0;
            this.encDisableCount = 0;
            this.raidLevel = -1;
            this.model = this.saveModel;
            if (this.model == null) {
                this.model = new RJPoolPoolLdevTableModel(this.supplier);
            }
            this.model.beginSetting();
            rJPoolPoolTablePanel.createTable(this, this.model);
            rJPoolTreePanel = new POOLIndex();
            ((POOLIndex)rJPoolTreePanel).sPoolId = (short)this.poolId;
            ArrayList arrayList = this.supplier.getPoolLDEV((POOLIndex)rJPoolTreePanel);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Robj_interface_RJiLDEVInfoDetailEUx robj_interface_RJiLDEVInfoDetailEUx = (Robj_interface_RJiLDEVInfoDetailEUx)iterator.next();
                RJPoolLdevElement rJPoolLdevElement = new RJPoolLdevElement(robj_interface_RJiLDEVInfoDetailEUx.getSLDKC(), robj_interface_RJiLDEVInfoDetailEUx.getSCU(), robj_interface_RJiLDEVInfoDetailEUx.getSLDEV(), this.supplier, this.treePanel);
                rJPoolLdevElement.initDetail(this.poolId, robj_interface_RJiLDEVInfoDetailEUx);
                this.setClprNo(rJPoolLdevElement.getClprNo());
                this.setClprName(rJPoolLdevElement.getClprName());
                if (rJPoolLdevElement.isExternal()) {
                    this.incrementExtVOLCount();
                    if (rJPoolLdevElement.isCacheMode()) {
                        this.incrementCacheEnableCount();
                    } else {
                        this.incrementCacheDisableCount();
                    }
                } else {
                    this.incrementIntVOLCount();
                    this.incrementCacheEnableCount();
                }
                switch (rJPoolLdevElement.getHDDType()) {
                    case 0: {
                        this.incrementIntFCDriveCount();
                        break;
                    }
                    case 5: {
                        this.incrementIntSSDDriveCount();
                        break;
                    }
                    default: {
                        this.incrementIntSATADriveCount();
                    }
                }
                if (rJPoolLdevElement.isEncryption()) {
                    this.incrementEncEnableCount();
                } else {
                    this.incrementEncDisableCount();
                }
                this.setRaidLevel(rJPoolLdevElement.getRaidLevel());
                this.model.addRow(rJPoolLdevElement);
            }
            this.model.completeSetting();
            rJPoolPoolTablePanel.completedTable();
        } else {
            rJPoolPoolTablePanel.createTable(this, this.model);
        }
        this.supplier.putLog("[Pool]", "[POOLgetPoolVolInfo]", "ID=" + this.poolId + ", LDEVCount=[" + this.model.getRowCount() + "]");
        rJPoolTreePanel = (RJPoolTreePanel)this.treePanel;
        if (rJPoolTreePanel != null) {
            rJPoolTreePanel.getPoolInfoPanel().setElement(this);
            rJPoolTreePanel.getFreeTablePanel().setClprNo(this.clprNo);
            rJPoolTreePanel.getFreeTablePanel().setPoolKind(this.poolKind);
            rJPoolTreePanel.getFreeTablePanel().setIntVOLInfo(this.intVOLCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setExtVOLInfo(this.extVOLCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setCacheModeEnable(this.cacheEnableCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setCacheModeDisable(this.cacheDisableCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setIntFCDrive(this.intFCDriveCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setIntSATADrive(this.intSATADriveCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setIntSSDDrive(this.intSSDDriveCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setEncEnable(this.encEnableCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setEncDisable(this.encDisableCount > 0);
            rJPoolTreePanel.getFreeTablePanel().setRaidLevel(this.raidLevel);
            rJPoolTreePanel.getCenterPanel().initLdkcComboBox(this.supplier.getLDKCIndex());
        }
    }

    public Icon getIcon(boolean bl) {
        int n = 7;
        int n2 = this.threshold;
        if (this.poolKind == 2) {
            int n3 = n2 = this.threshold < this.threshold2 ? this.threshold : this.threshold2;
        }
        if (n2 != 0 && this.usedPercent >= n2) {
            n = 9;
        }
        if (this.blocked || this.warning) {
            n = 8;
        }
        if (this.deletePool) {
            n += 3;
        }
        Icon icon = RJPoolIconTable.getIcon(n);
        return icon;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof RJPoolPoolElement && this.poolId == ((RJPoolPoolElement)object).getPoolId()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n = this.poolId;
        return n;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof RJPoolPoolElement) {
            n = this.poolId - ((RJPoolPoolElement)object).getPoolId();
        }
        return n;
    }

    public String toString() {
        String string = RJcGuide.text("Pool/NodePool");
        Object[] objectArray = new Object[]{new Integer(this.poolId)};
        MessageFormat messageFormat = new MessageFormat(string);
        String string2 = messageFormat.format(objectArray);
        return string2;
    }

    public void setTreeNode(RJaTreeNode rJaTreeNode) {
        this.node = rJaTreeNode;
    }

    protected boolean isModify() {
        boolean bl = this.poolIdInit != this.poolId || this.thresholdInit != this.threshold || this.grainSizeInit != this.grainSize || this.poolKindInit != this.poolKind || this.blockedInit != this.blocked || this.poolVolCountInit != this.poolVolCount || this.deletePool;
        return bl;
    }

    public int getPoolId() {
        return this.poolId;
    }

    public boolean isNewPool() {
        return this.poolIdInit != this.poolId;
    }

    public boolean isDeletePool() {
        return this.deletePool;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public int getThreshold2() {
        return this.threshold2;
    }

    public boolean isModifyThreshold() {
        return this.thresholdInit != this.threshold;
    }

    public int getGrainSize() {
        return this.grainSize;
    }

    public int getPoolKind() {
        return this.poolKind;
    }

    public boolean isModifyPoolKind() {
        return this.poolKindInit != this.poolKind;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void addCapacity(long l) {
        this.capacity += l - l % 256L;
        this.calcUsedPercent();
        this.blocked = this.usedPercent >= 100;
    }

    public String toCapacityString() {
        String string = RJComUty.ktoGSlong(this.capacity) + " " + RJcGuide.text("Pool/CapacityGB");
        return string;
    }

    public long getUsed() {
        return this.used;
    }

    public String toUsedString() {
        String string = RJComUty.ktoGSlong(this.used) + " " + RJcGuide.text("Pool/CapacityGB");
        return string;
    }

    public int getUsedPercent() {
        return this.usedPercent;
    }

    public long getStatus() {
        return this.status;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isModifyBlocked() {
        return this.blockedInit != this.blocked;
    }

    public boolean isTopVOLWarning() {
        return this.warning;
    }

    public int getPoolVolCount() {
        return this.poolVolCount;
    }

    public boolean isModifyPoolVolCount() {
        return this.poolVolCountInit != this.poolVolCount;
    }

    public void incrementPoolVolCount() {
        ++this.poolVolCount;
        ((DefaultTreeModel)this.treePanel.getTreeModel()).nodeChanged(this.node);
        this.treePanel.refresh();
    }

    public void decrementPoolVolCount() {
        --this.poolVolCount;
        if (this.poolVolCount <= 0) {
            this.clprNo = -1;
            this.clprName = null;
            this.raidLevel = -1;
        }
        ((DefaultTreeModel)this.treePanel.getTreeModel()).nodeChanged(this.node);
        this.treePanel.refresh();
    }

    public int getClprNo() {
        return this.clprNo;
    }

    public void setClprNo(int n) {
        this.clprNo = n;
    }

    public String getClprName() {
        return this.clprName;
    }

    public void setClprName(String string) {
        this.clprName = string;
    }

    public String toClprString() {
        String string = "";
        if (this.clprNo >= 0) {
            string = RJcElement.toClprString(new Integer(this.clprNo), this.clprName);
        }
        return string;
    }

    public void incrementIntVOLCount() {
        ++this.intVOLCount;
    }

    public void decrementIntVOLCount() {
        --this.intVOLCount;
    }

    public void incrementExtVOLCount() {
        ++this.extVOLCount;
    }

    public void decrementExtVOLCount() {
        --this.extVOLCount;
    }

    public void incrementCacheEnableCount() {
        ++this.cacheEnableCount;
    }

    public void decrementCacheEnableCount() {
        --this.cacheEnableCount;
    }

    public void incrementCacheDisableCount() {
        ++this.cacheDisableCount;
    }

    public void decrementCacheDisableCount() {
        --this.cacheDisableCount;
    }

    public void incrementIntFCDriveCount() {
        ++this.intFCDriveCount;
    }

    public void decrementIntFCDriveCount() {
        --this.intFCDriveCount;
    }

    public void incrementIntSATADriveCount() {
        ++this.intSATADriveCount;
    }

    public void decrementIntSATADriveCount() {
        --this.intSATADriveCount;
    }

    public void incrementIntSSDDriveCount() {
        ++this.intSSDDriveCount;
    }

    public void decrementIntSSDDriveCount() {
        --this.intSSDDriveCount;
    }

    public void incrementEncEnableCount() {
        ++this.encEnableCount;
    }

    public void decrementEncEnableCount() {
        --this.encEnableCount;
    }

    public void incrementEncDisableCount() {
        ++this.encDisableCount;
    }

    public void decrementEncDisableCount() {
        --this.encDisableCount;
    }

    public void showMenu(JComponent jComponent, int n, int n2, DefaultTreeModel defaultTreeModel, RJaTreeNode rJaTreeNode) {
        this.treeModel = defaultTreeModel;
        this.node = rJaTreeNode;
        this.invoker = jComponent;
        RJaPopupMenuSTD rJaPopupMenuSTD = null;
        if (this.menuItems != null) {
            if (rJaPopupMenuSTD == null) {
                rJaPopupMenuSTD = new RJaPopupMenuSTD(this, this.menuItems);
            }
            if ((rJaPopupMenuSTD = (RJaPopupMenuSTD)this.checkMenu(rJaPopupMenuSTD)) != null) {
                Container container;
                int n3 = n;
                int n4 = n2;
                for (container = jComponent.getParent(); container != null; container = container.getParent()) {
                    n3 += container.getX();
                    n4 += container.getY();
                    if (container instanceof Frame) break;
                }
                this.parent = container;
                rJaPopupMenuSTD.show(jComponent, n, n2);
            }
        }
    }

    private JPopupMenu checkMenu(JPopupMenu jPopupMenu) {
        JPopupMenu jPopupMenu2 = null;
        ((JMenuItem)jPopupMenu.getComponent(0)).setEnabled(false);
        ((JMenuItem)jPopupMenu.getComponent(1)).setEnabled(false);
        ((JMenuItem)jPopupMenu.getComponent(2)).setEnabled(false);
        RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
        if (rJPoolApplyData.isOK(4) && this.usedPercent < 95 && !this.isBlocked() && !this.isTopVOLWarning() && this.supplier.isPPCheck(this.poolKind)) {
            ((JMenuItem)jPopupMenu.getComponent(0)).setEnabled(true);
            jPopupMenu2 = jPopupMenu;
        }
        if (rJPoolApplyData.isOK(16) && this.isDeleteCondition() || this.poolIdInit < 0 && this.poolVolCount == 0) {
            ((JMenuItem)jPopupMenu.getComponent(1)).setEnabled(true);
            jPopupMenu2 = jPopupMenu;
        }
        if (rJPoolApplyData.isOK(8) && this.isRestoreCondition()) {
            ((JMenuItem)jPopupMenu.getComponent(2)).setEnabled(true);
            jPopupMenu2 = jPopupMenu;
        }
        return jPopupMenu2;
    }

    public boolean isDeleteCondition() {
        boolean bl = false;
        if (this.poolKind == 1) {
            bl = this.used == 0L && !this.deletePool;
        } else if (this.poolKind == 2) {
            POOLIndex pOOLIndex = new POOLIndex();
            pOOLIndex.setSPoolId((short)this.poolId);
            bl = !this.supplier.isRelation(pOOLIndex) && !this.deletePool;
        }
        return bl;
    }

    public boolean isRestoreCondition() {
        boolean bl = this.isBlocked() && !this.isTopVOLWarning() && (this.status & 0xFFFFL) != 4098L && this.supplier.isPPCheck(this.poolKind);
        return bl;
    }

    public void menuItemActionPerformed(ActionEvent actionEvent, int n) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        switch (n) {
            case 0: {
                this.actionChange();
                break;
            }
            case 1: {
                this.actionDelete();
                break;
            }
            case 2: {
                this.actionRestore();
            }
        }
        this.invoker.revalidate();
        this.invoker.repaint(1L);
        RJPoolTreePanel rJPoolTreePanel = (RJPoolTreePanel)this.treePanel;
        if (rJPoolTreePanel != null) {
            rJPoolTreePanel.getPoolInfoPanel().setElement(this);
            rJPoolTreePanel.getFreeTablePanel().valueChanged(null);
        }
    }

    private void actionChange() {
        RJPoolInfoDialog rJPoolInfoDialog = new RJPoolInfoDialog((Frame)this.parent);
        RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem(this.poolId);
        rJPoolApplyItem.setThreshold(this.threshold);
        rJPoolApplyItem.setUsedPercent(this.usedPercent);
        rJPoolApplyItem.setGrainSize(this.grainSize);
        rJPoolApplyItem.setKind(this.poolKind);
        rJPoolInfoDialog.show(rJPoolApplyItem, this.poolKind);
        rJPoolApplyItem = rJPoolInfoDialog.getResult();
        if (rJPoolApplyItem != null && this.threshold != rJPoolApplyItem.getThreshold()) {
            this.threshold = rJPoolApplyItem.getThreshold();
            rJPoolApplyItem.setThreshold(this.threshold);
            if (this.threshold == this.thresholdInit) {
                rJPoolApplyItem.setInvalidity(true);
            }
            RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
            rJPoolApplyData.changePoolInfo(rJPoolApplyItem);
            this.treeModel.nodeChanged(this.node);
        }
    }

    private void actionDelete() {
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        RJDataMsg rJDataMsg = this.supplier.getMessage(311059602);
        int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        if (n == 0) {
            if (this.poolIdInit < 0) {
                this.deleteNewPool();
            } else {
                this.deletePool();
            }
        }
    }

    public void deletePool() {
        RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem(this.poolId);
        RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
        rJPoolApplyData.deletePoolInfo(rJPoolApplyItem);
        this.deletePool = true;
        this.treeModel.nodeChanged(this.node);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJPoolLdevElement rJPoolLdevElement = (RJPoolLdevElement)iterator.next();
            rJPoolLdevElement.setPoolId(-1);
        }
    }

    private void deleteNewPool() {
        RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem(this.poolId);
        rJPoolApplyItem.setInvalidity(true);
        RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
        rJPoolApplyData.deletePoolInfo(rJPoolApplyItem);
        this.treePanel.removeNode(this.node);
        RJaTreeNode rJaTreeNode = this.treePanel.getRootNode();
        int n = 0;
        for (int i = 0; i < rJaTreeNode.getChildCount(); ++i) {
            n += rJaTreeNode.getChildAt(i).getChildCount();
        }
        RJPoolTreePanel rJPoolTreePanel = (RJPoolTreePanel)this.treePanel;
        if (n == 0) {
            rJPoolTreePanel.getCenterPanel().initLdkcComboBox(null);
            rJPoolTreePanel.getCenterPanel().initCuComboBox(null);
        }
    }

    private void actionRestore() {
        Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK, RJComUty.CAPTION_MSG_CANCEL};
        RJDataMsg rJDataMsg = this.supplier.getMessage(311059603);
        int n = this.supplier.showMessage(this.supplier.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
        if (n == 0) {
            this.restorePool();
        }
    }

    public void restorePool() {
        this.blocked = false;
        RJPoolApplyItem rJPoolApplyItem = new RJPoolApplyItem(this.poolId);
        RJPoolApplyData rJPoolApplyData = this.supplier.getApplyData();
        rJPoolApplyData.restorePoolInfo(rJPoolApplyItem);
        this.treeModel.nodeChanged(this.node);
    }

    public void setRaidLevel(int n) {
        this.raidLevel = n;
    }
}

