/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.spread;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFont;
import sanproject.client.com.RJComUty;
import sanproject.client.com.RJcListPanel;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataMsg;
import sanproject.client.spread.RJSPDFTCDialog;
import sanproject.client.spread.RJSPDFTCException;
import sanproject.client.spread.RJSPDFileFilter;
import sanproject.client.spread.RJSPDGuideDef;

public class RJSPDFilterCompo
extends RJcListPanel
implements RJSPDGuideDef {
    protected static int KIND_MAX = 2;
    protected int CWIDTH = 540;
    protected int CHEIGHT = 140;
    protected RJSPDFTCDialog m_FTCDialog = null;
    protected RJDataControl m_dc = null;
    protected JButton m_ReferenceBtn = null;
    protected String referenceTitle;
    protected JTextField m_FilePathText = null;
    protected JPanel m_RefPanel = null;
    protected short[] m_filter = new short[KIND_MAX];
    protected String m_DefaultFileName;

    public RJSPDFilterCompo(RJDataControl rJDataControl, RJSPDFTCDialog rJSPDFTCDialog) {
        this.m_FTCDialog = rJSPDFTCDialog;
        this.m_dc = rJDataControl;
        this.setFilter(0, (short)-1);
        this.setFilter(1, (short)-1);
        this.jbInit();
    }

    private void jbInit() {
        this.m_FilePathText = new JTextField();
        this.m_FilePathText.setPreferredSize(new Dimension(350, 24));
        this.m_FilePathText.setMinimumSize(new Dimension(240, 24));
        this.m_FilePathText.setMaximumSize(new Dimension(400, 24));
        this.m_FilePathText.setFont(RJComFont.itemFont);
        this.m_FilePathText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                RJSPDFilterCompo.this.onClientFileChanged(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                RJSPDFilterCompo.this.onClientFileChanged(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RJSPDFilterCompo.this.onClientFileChanged(documentEvent);
            }
        });
        this.m_ReferenceBtn = this.m_FTCDialog.newButton("SPREAD/ReferenceBtn");
        this.m_ReferenceBtn.setBackground(this.m_FTCDialog.getBackgroundColor());
        this.m_ReferenceBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJSPDFilterCompo.this.onReference(actionEvent);
            }
        });
        this.referenceTitle = "SPREAD/DlgFilePath";
        this.m_RefPanel = new JPanel(new GridBagLayout());
        this.m_RefPanel.add((Component)this.m_FilePathText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 2, 0));
        this.m_RefPanel.add((Component)this.m_ReferenceBtn, new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 2, 0));
        this.addEntry(this.referenceTitle, this.m_RefPanel);
        this.addOptionComponent();
        this.completed();
    }

    public boolean setFilter(int n, short s) {
        boolean bl = false;
        if (n >= 0 && n < KIND_MAX) {
            this.m_filter[n] = s;
            bl = true;
        }
        return bl;
    }

    public short[] getFilter() {
        return this.m_filter;
    }

    protected Dimension getDimension() {
        return new Dimension(this.CWIDTH, this.CHEIGHT);
    }

    protected String getDialogName() {
        return "";
    }

    public void addOptionComponent() {
    }

    protected void onReference(ActionEvent actionEvent) {
        boolean bl = true;
        this.setCursor(new Cursor(3));
        String string = this.m_FTCDialog.getClientFilePath();
        JFileChooser jFileChooser = null;
        int n = -1;
        try {
            jFileChooser = new JFileChooser(string);
            String string2 = "spd";
            String string3 = "Spreadsheet File";
            RJSPDFileFilter rJSPDFileFilter = new RJSPDFileFilter(string2, string3);
            jFileChooser.addChoosableFileFilter(rJSPDFileFilter);
            if (this.m_FTCDialog.m_Kind == 1) {
                int n2 = string.lastIndexOf("\\");
                String string4 = string.substring(0, n2 + 1);
                string4 = this.setDefaultFileName(string4);
                File file = new File(string4);
                String string5 = file.getName();
                jFileChooser.setSelectedFile(file);
            }
            n = this.m_FTCDialog.m_Kind == 2 ? jFileChooser.showOpenDialog(null) : jFileChooser.showSaveDialog(null);
        }
        catch (Exception exception) {
            this.setCursor(new Cursor(0));
            System.out.println("[SPREAD]:onReference()ERROR:" + exception.getMessage());
            RJDataMsg rJDataMsg = RJCom.getMsg(this.m_dc, 8110, 5775);
            Object[] objectArray = new Object[]{RJComUty.CAPTION_MSG_OK};
            RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
            this.m_FTCDialog.setClientFilePath("");
        }
        if (n == 0) {
            try {
                string = jFileChooser.getSelectedFile().getAbsolutePath();
                if (this.m_FTCDialog.m_Kind == 1) {
                    this.m_FTCDialog.ExportCheck(string);
                } else {
                    this.m_FTCDialog.ImportCheck(string);
                }
                this.m_FTCDialog.setClientFilePath(this.m_FTCDialog.m_strFilePath);
                RJSPDFTCDialog.WriteSetting(this.m_FTCDialog.m_strFilePath);
            }
            catch (RJSPDFTCException rJSPDFTCException) {
                this.onReference(actionEvent);
            }
        }
        this.setCursor(new Cursor(0));
    }

    protected void onClientFileChanged(DocumentEvent documentEvent) {
        this.setCursor(new Cursor(3));
        this.m_FTCDialog.setBtnEnabled();
        this.setCursor(new Cursor(0));
    }

    protected String setDefaultFileName(String string) {
        String string2 = string;
        if (string2 == null) {
            string2 = this.m_DefaultFileName;
            return string2;
        }
        int n = 0;
        if (this.m_FTCDialog.m_Kind == 1) {
            String string3 = System.getProperty("os.name");
            n = string3.indexOf("Windows") == -1 ? string2.lastIndexOf("/") : string2.lastIndexOf("\\");
            string2 = string2.substring(0, n + 1);
            string2 = string2 + this.m_DefaultFileName;
        }
        return string2;
    }
}

