/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.rptdt.csv.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import sanproject.sn2.rptdt.csv.wrapper.SJdtCSVWrapperBase;

public class SJdtWwnInfoCSVWrapper
extends SJdtCSVWrapperBase {
    private static final String csvName = "WwnInfo";
    private Map<String, List<String[]>> hostMapByPortHostGroup = null;

    @Override
    public String getCsvName() {
        return csvName;
    }

    @Override
    public void init() {
        this.hostMapByPortHostGroup = this.getHostMapByPortHostGroup();
    }

    private Map<String, List<String[]>> getHostMapByPortHostGroup() {
        Map<String, List<String[]>> map = this.getDefaultMatchedExistsRecordMap();
        for (String[] record : this.csvDataList) {
            if (StringUtils.isEmpty((String)this.getValue(record, "WWN")) || StringUtils.isEmpty((String)this.getValue(record, "Port")) || StringUtils.isEmpty((String)this.getValue(record, "Host Group"))) continue;
            String portHostGroup = this.getValue(record, "Port") + "," + this.getValue(record, "Host Group");
            List<Object> machedList = null;
            if (!map.containsKey(portHostGroup)) {
                machedList = new ArrayList();
                map.put(portHostGroup, machedList);
            } else {
                machedList = map.get(portHostGroup);
            }
            machedList.add(record);
        }
        return map;
    }

    public int getNumberOfHosts(String portSearchStr) {
        int result = 0;
        boolean loopFlg = true;
        for (String[] record : this.csvDataList) {
            if (portSearchStr.equals(this.getValue(record, "Port"))) {
                loopFlg = false;
                if (!StringUtils.isNotEmpty((String)this.getValue(record, "WWN"))) continue;
                ++result;
                continue;
            }
            if (loopFlg) continue;
            break;
        }
        return result;
    }

    public int getNumberOfHosts(String portSearchStr, String hostGroupSearchStr) {
        String portHostGroup = portSearchStr + "," + hostGroupSearchStr;
        List<String[]> hostRecordList = this.hostMapByPortHostGroup.get(portHostGroup);
        return hostRecordList.size();
    }

    public String getHostGroupNumber(String portSearchStr, String hostGroup) {
        String result = "";
        for (String[] record : this.csvDataList) {
            if (!portSearchStr.equals(this.getValue(record, "Port")) || !hostGroup.equals(this.getValue(record, "Host Group"))) continue;
            result = this.getValue(record, "Host Group#");
            break;
        }
        return result;
    }
}

