/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.file;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.file.SJbaseExternalFileCom;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfiguration;
import sanproject.sn2.base.authentication.module.external.kerberos.SJbaseKerberosConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfiguration;
import sanproject.sn2.base.authentication.module.external.ldapgetgroup.SJbaseLdapGroupConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfiguration;
import sanproject.sn2.base.authentication.module.external.radius.SJbaseRadiusConfigurationFactory;
import sanproject.sn2.com.SJcConst;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.tools.SetExAuthKeyStoreUty;

public class SJbaseExternalFile {
    private static final String LOG_FUNCTION = "SJbaseExternalFile";
    private static final String LOG_TITLE = "SJbaseExternalFile";
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private Properties properties = null;
    private static String[] confname = new String[]{"PrimaryServer", "SecondaryServer"};

    public SJbaseExternalFile() {
        String LOG_SUBTITLE = "SJbaseExternalFile";
        try {
            this.properties = SJbaseExternalFileCom.loadProperties();
        }
        catch (Exception ex) {
            logger.warn("SJbaseExternalFile", "SJbaseExternalFile", "SJbaseExternalFile", "loadProperties failed.");
        }
    }

    public String getType() {
        String ret = "Nothing";
        try {
            if (this.properties == null) {
                return ret;
            }
            ret = this.properties.getProperty("auth.server.type");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public HashMap<String, SJbaseConfiguration> getConfiguration(String type) {
        String LOG_SUBTITLE = "getConfiguration";
        SJbaseConfigurationFactory ConfFact = null;
        SJbaseConfiguration[] ConfAry = null;
        HashMap<String, SJbaseConfiguration> ret = null;
        try {
            String authServerType = this.getType();
            if (this.properties == null) {
                return null;
            }
            if (!SJbaseExternalFileCom.chkServerType(type)) {
                throw new SJcException();
            }
            if (!type.equals(authServerType)) {
                return null;
            }
            if (authServerType.equalsIgnoreCase("ldap")) {
                ConfFact = new SJbaseLdapConfigurationFactory(this.properties);
            } else if (authServerType.equalsIgnoreCase("radius")) {
                ConfFact = new SJbaseRadiusConfigurationFactory(this.properties);
            } else if (authServerType.equalsIgnoreCase("kerberos")) {
                ConfFact = new SJbaseKerberosConfigurationFactory(this.properties);
            }
            ConfAry = ((SJbaseConfigurationFactory)ConfFact).getConfigurations();
            if (ConfAry == null || ConfAry.length <= 0) {
                throw new SJcException();
            }
            ret = new HashMap<String, SJbaseConfiguration>();
            for (int i = 0; i < confname.length && ConfAry.length > i; ++i) {
                if (ConfAry[i] == null) {
                    throw new SJcException();
                }
                if (ConfAry[i].getServerErrCode() != 0) {
                    throw new SJcException();
                }
                ret.put(confname[i], ConfAry[i]);
            }
        }
        catch (Exception ex) {
            logger.error("SJbaseExternalFile", "SJbaseExternalFile", "getConfiguration", "failed", ex);
            ret = null;
        }
        return ret;
    }

    public HashMap<String, SJbaseGroupConfiguration> getGroupConfiguration(String type) {
        String LOG_SUBTITLE = "getGroupConfiguration";
        HashMap<String, SJbaseLdapGroupConfiguration> ret = null;
        try {
            if (this.properties == null) {
                return null;
            }
            SJbaseExternalAccountInfo account = new SJbaseExternalAccountInfo(null);
            SJbaseParamater paramater = new SJbaseParamater(account);
            paramater.setProperties(this.properties);
            paramater.setAuthServerType(type);
            HashMap<String, SJbaseConfiguration> conf = this.getConfiguration(type);
            if (conf == null || conf.size() <= 0) {
                return null;
            }
            ret = new HashMap<String, SJbaseLdapGroupConfiguration>();
            for (int i = 0; i < confname.length; ++i) {
                if (!conf.containsKey(confname[i])) continue;
                if (type.equalsIgnoreCase("ldap")) {
                    paramater.setLdapConf((SJbaseLdapConfiguration)conf.get(confname[i]));
                } else if (type.equalsIgnoreCase("radius")) {
                    paramater.setRadiusConf((SJbaseRadiusConfiguration)conf.get(confname[i]));
                } else if (type.equalsIgnoreCase("kerberos")) {
                    paramater.setKerberosConf((SJbaseKerberosConfiguration)conf.get(confname[i]));
                }
                SJbaseLdapGroupConfiguration data = new SJbaseLdapGroupConfigurationFactory(paramater).getGroupConfigurations();
                if (Boolean.parseBoolean(data.getGrpMapping())) {
                    if (data == null) {
                        throw new SJcException();
                    }
                    if (data.getServerErrCode() != 0) {
                        throw new SJcException();
                    }
                    ret.put(confname[i], data);
                    if (!type.equalsIgnoreCase("radius")) continue;
                } else {
                    ret = null;
                }
                break;
            }
        }
        catch (Exception ex) {
            logger.error("SJbaseExternalFile", "SJbaseExternalFile", "getGroupConfiguration", "failed", ex);
            ret = null;
        }
        return ret;
    }

    public void setConfiguration(String type, HashMap<String, SJbaseConfiguration> confmap) {
        String LOG_SUBTITLE = "setConfiguration";
        if (!SJbaseExternalFileCom.chkServerType(type)) {
            throw new SJcException();
        }
        if (!SJbaseExternalFileCom.chkConfiguration(confmap)) {
            throw new SJcException();
        }
        try {
            Properties data = null;
            if (type.equalsIgnoreCase("ldap")) {
                data = SJbaseExternalFile.setLdapConfiguration(confmap, null, false);
            } else if (type.equalsIgnoreCase("radius")) {
                data = SJbaseExternalFile.setRadiusConfiguration(confmap, null, false);
            } else if (type.equalsIgnoreCase("kerberos")) {
                data = SJbaseExternalFile.setKerberosConfiguration(confmap, null, false);
            }
            SJbaseExternalFileCom.saveProperties(data);
            this.properties = data;
        }
        catch (SJcException ex) {
            logger.error("SJbaseExternalFile", "SJbaseExternalFile", "setConfiguration", "failed", ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error("SJbaseExternalFile", "SJbaseExternalFile", "setConfiguration", "failed", ex);
            throw new SJcException();
        }
    }

    public void setConfiguration(String type, HashMap<String, SJbaseConfiguration> confmap, HashMap<String, SJbaseGroupConfiguration> gconfmap) {
        String LOG_SUBTITLE = "setConfiguration";
        if (!SJbaseExternalFileCom.chkServerType(type)) {
            throw new SJcException();
        }
        if (!SJbaseExternalFileCom.chkConfiguration(confmap)) {
            throw new SJcException();
        }
        if (!type.equalsIgnoreCase("ldap") && !SJbaseExternalFileCom.chkGroupConfiguration(gconfmap)) {
            throw new SJcException();
        }
        if (type.equalsIgnoreCase("kerberos") && !SJbaseExternalFileCom.chkMatchConfiguration(confmap, gconfmap)) {
            throw new SJcException();
        }
        try {
            Properties data = null;
            if (type.equalsIgnoreCase("ldap")) {
                data = SJbaseExternalFile.setLdapConfiguration(confmap, gconfmap, true);
            } else if (type.equalsIgnoreCase("radius")) {
                data = SJbaseExternalFile.setRadiusConfiguration(confmap, gconfmap, true);
            } else if (type.equalsIgnoreCase("kerberos")) {
                data = SJbaseExternalFile.setKerberosConfiguration(confmap, gconfmap, true);
            }
            SJbaseExternalFileCom.saveProperties(data);
            this.properties = data;
        }
        catch (SJcException ex) {
            logger.error("SJbaseExternalFile", "SJbaseExternalFile", "setConfiguration", "failed", ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error("SJbaseExternalFile", "SJbaseExternalFile", "setConfiguration", "failed", ex);
            throw new SJcException();
        }
    }

    public void deleteConfiguration() {
        SJcFileUty.deleteFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config.properties");
        SJcFileUty.deleteFile("base\\setting\\extAuth\\", "ExtarnalAuth_Config_dec.properties");
    }

    public static Properties setLdapConfiguration(HashMap confmap, HashMap gconfmap, boolean group) {
        Properties ret = new Properties();
        ret.setProperty("auth.server.type", "ldap");
        if (group) {
            ret.setProperty("auth.group.mapping", "true");
        } else {
            ret.setProperty("auth.group.mapping", "false");
        }
        String basekey = "";
        String key = "";
        String ServerName = "";
        for (int i = 0; i < confname.length; ++i) {
            SJbaseLdapConfiguration conf = (SJbaseLdapConfiguration)confmap.get(confname[i]);
            if (conf == null) continue;
            ServerName = ServerName + conf.getSearverName() + ",";
            basekey = "auth.ldap." + conf.getSearverName() + ".";
            String dnslook = conf.getDnsLookup();
            if (dnslook == null || !dnslook.equalsIgnoreCase("true")) {
                key = basekey + "host";
                ret.setProperty(key, conf.getHost());
                key = basekey + "port";
                ret.setProperty(key, String.valueOf(conf.getPort()));
            }
            key = basekey + "protocol";
            ret.setProperty(key, conf.getProtocol());
            key = basekey + "timeout";
            ret.setProperty(key, String.valueOf(conf.getTimeout()));
            key = basekey + "attr";
            ret.setProperty(key, conf.getUserAttr());
            key = basekey + "searchdn";
            ret.setProperty(key, conf.getSearchUserDN());
            key = basekey + "searchpw";
            ret.setProperty(key, conf.getSearchUserPassword());
            key = basekey + "basedn";
            ret.setProperty(key, conf.getSearchDN());
            key = basekey + "retry.interval";
            ret.setProperty(key, String.valueOf(conf.getRetryInterval()));
            key = basekey + "retry.times";
            ret.setProperty(key, String.valueOf(conf.getRetryTimes()));
            key = basekey + "dns_lookup";
            ret.setProperty(key, dnslook);
            key = basekey + "domain.name";
            ret.setProperty(key, conf.getDomainName());
        }
        ret.setProperty("auth.server.name", ServerName.substring(0, ServerName.length() - 1));
        return ret;
    }

    public static Properties setRadiusConfiguration(HashMap confmap, HashMap gconfmap, boolean group) {
        Properties ret = new Properties();
        ret.setProperty("auth.server.type", "radius");
        if (group) {
            ret.setProperty("auth.group.mapping", "true");
        } else {
            ret.setProperty("auth.group.mapping", "false");
        }
        String basekey = "";
        String groupkey = "";
        String key = "";
        String ServerName = "";
        for (int i = 0; i < confname.length; ++i) {
            SJbaseRadiusConfiguration conf = (SJbaseRadiusConfiguration)confmap.get(confname[i]);
            if (conf == null) continue;
            ServerName = ServerName + conf.getSearverName() + ",";
            basekey = "auth.radius." + conf.getSearverName() + ".";
            key = basekey + "protocol";
            ret.setProperty(key, conf.getProtocol());
            key = basekey + "host";
            ret.setProperty(key, conf.getHost());
            key = basekey + "port";
            ret.setProperty(key, String.valueOf(conf.getPort()));
            key = basekey + "timeout";
            ret.setProperty(key, String.valueOf(conf.getTimeout()));
            key = basekey + "retry.times";
            ret.setProperty(key, String.valueOf(conf.getRetryTimes()));
            key = basekey + "secret";
            ret.setProperty(key, new String(conf.getSecret()));
            Map<String, String> attributes = conf.getAttributes();
            for (String name : attributes.keySet()) {
                String value = attributes.get(name);
                key = basekey + "attr" + "." + name;
                ret.setProperty(key, value);
            }
        }
        if (group) {
            SJbaseRadiusConfiguration conf = (SJbaseRadiusConfiguration)confmap.get(confname[0]);
            if (conf == null) {
                throw new SJcException();
            }
            SJbaseLdapGroupConfiguration gconf = (SJbaseLdapGroupConfiguration)gconfmap.get(confname[0]);
            if (gconf == null) {
                throw new SJcException();
            }
            basekey = "auth.radius." + conf.getSearverName() + ".";
            key = basekey + "domain.name";
            ret.setProperty(key, gconf.getDomainName());
            key = basekey + "dns_lookup";
            ret.setProperty(key, gconf.getDnsLookup());
            groupkey = "auth.group." + gconf.getDomainName() + ".";
            String dnslook = gconf.getDnsLookup();
            if (dnslook == null || !dnslook.equalsIgnoreCase("true")) {
                key = groupkey + "host";
                ret.setProperty(key, gconf.getHost());
                key = groupkey + "port";
                ret.setProperty(key, String.valueOf(gconf.getPort()));
            }
            key = groupkey + "protocol";
            ret.setProperty(key, gconf.getProtocol());
            key = groupkey + "timeout";
            ret.setProperty(key, String.valueOf(gconf.getTimeout()));
            key = groupkey + "retry.interval";
            ret.setProperty(key, String.valueOf(gconf.getRetryInterval()));
            key = groupkey + "retry.times";
            ret.setProperty(key, String.valueOf(gconf.getRetryTimes()));
            key = groupkey + "searchdn";
            ret.setProperty(key, gconf.getSearchUserDN());
            key = groupkey + "searchpw";
            ret.setProperty(key, gconf.getSearchUserPassword());
            key = groupkey + "basedn";
            ret.setProperty(key, gconf.getSearchDN());
        }
        ret.setProperty("auth.server.name", ServerName.substring(0, ServerName.length() - 1));
        return ret;
    }

    public static Properties setKerberosConfiguration(HashMap confmap, HashMap gconfmap, boolean group) {
        Properties ret = new Properties();
        ret.setProperty("auth.server.type", "kerberos");
        if (group) {
            ret.setProperty("auth.group.mapping", "true");
        } else {
            ret.setProperty("auth.group.mapping", "false");
        }
        String basekey = "";
        String groupkey = "";
        String relmkey = "";
        String key = "";
        String ServerName = "";
        SJbaseKerberosConfiguration conf = (SJbaseKerberosConfiguration)confmap.get(confname[0]);
        basekey = "auth.kerberos.";
        key = basekey + "default_realm";
        ret.setProperty(key, conf.getDefaul_Realm());
        key = basekey + "clockskew";
        ret.setProperty(key, String.valueOf(conf.getClockskew()));
        key = basekey + "timeout";
        ret.setProperty(key, String.valueOf(conf.getTimeout()));
        key = basekey + "dns_lookup_kdc";
        ret.setProperty(key, conf.getDns_Lookup_Kdc());
        for (int i = 0; i < confname.length; ++i) {
            conf = (SJbaseKerberosConfiguration)confmap.get(confname[i]);
            if (conf == null) continue;
            ServerName = ServerName + conf.getRealm_Name() + ",";
            relmkey = "auth.kerberos." + conf.getRealm_Name() + ".";
            String dnslook = conf.getDns_Lookup_Kdc();
            if (dnslook == null || !dnslook.equalsIgnoreCase("true")) {
                key = relmkey + "kdc";
                ret.setProperty(key, conf.getKdc());
            }
            key = relmkey + "realm";
            ret.setProperty(key, conf.getRealm());
            if (!group) continue;
            SJbaseLdapGroupConfiguration gconf = (SJbaseLdapGroupConfiguration)gconfmap.get(confname[i]);
            if (gconf == null) {
                throw new SJcException();
            }
            groupkey = "auth.group." + conf.getRealm_Name() + ".";
            key = groupkey + "protocol";
            ret.setProperty(key, gconf.getProtocol());
            key = groupkey + "host";
            ret.setProperty(key, gconf.getHost());
            key = groupkey + "port";
            ret.setProperty(key, String.valueOf(gconf.getPort()));
            key = groupkey + "timeout";
            ret.setProperty(key, String.valueOf(gconf.getTimeout()));
            key = groupkey + "retry.interval";
            ret.setProperty(key, String.valueOf(gconf.getRetryInterval()));
            key = groupkey + "retry.times";
            ret.setProperty(key, String.valueOf(gconf.getRetryTimes()));
            key = groupkey + "searchdn";
            ret.setProperty(key, gconf.getSearchUserDN());
            key = groupkey + "searchpw";
            ret.setProperty(key, gconf.getSearchUserPassword());
            key = groupkey + "basedn";
            ret.setProperty(key, gconf.getSearchDN());
        }
        key = basekey + "realm_name";
        ret.setProperty(key, ServerName.substring(0, ServerName.length() - 1));
        return ret;
    }

    public boolean setKeyStoreFile(String cerfile) {
        boolean bret = true;
        String keystore_file = "";
        String certification_file = "";
        try {
            SJcFileUty.copyFile("base\\init\\", "ExternalAuth.keystore", "base\\setting\\extAuth\\", "ExternalAuth.keystore");
            String dataPath = System.getProperty("SN_DataPath") + SJcConst.sjc_PathSeparator + "data" + SJcConst.sjc_PathSeparator;
            keystore_file = dataPath + "base\\setting\\extAuth\\" + "ExternalAuth.keystore";
            KeyStore key_store = SetExAuthKeyStoreUty.readKeyStore(keystore_file);
            certification_file = cerfile;
            Certificate cert = SetExAuthKeyStoreUty.readCertificate(certification_file);
            SetExAuthKeyStoreUty.updateKeyStore(keystore_file, key_store, cert);
        }
        catch (Exception ex) {
            return false;
        }
        return bret;
    }
}

