/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.authentication.module.external.ldap;

import java.util.Properties;
import sanproject.sn2.base.authentication.module.external.common.SJbaseExternalAccountInfo;
import sanproject.sn2.base.authentication.module.external.common.SJbaseLoginModule;
import sanproject.sn2.base.authentication.module.external.common.SJbaseParamater;
import sanproject.sn2.base.authentication.module.external.common.SJbaseSrvRecord;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExAuthenticationException;
import sanproject.sn2.base.authentication.module.external.exception.SJbaseExCommunicationException;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfiguration;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapConfigurationFactory;
import sanproject.sn2.base.authentication.module.external.ldap.SJbaseLdapLoginModuleThread;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJbaseLdapLoginModule
implements SJbaseLoginModule {
    private static SJcLoggerInterface logger = SJcLogUty.getLogger();
    private static final String module = "SJbaseLdapLoginModule";
    private SJbaseLdapConfiguration[] ldapConfAry = null;
    private String userId;
    private String password;
    private Properties properties;

    public SJbaseLdapLoginModule(String userId, String password, Properties properties) {
        String method = "constructor";
        logger.info(module, method, "", "start");
        this.userId = userId;
        this.password = password;
        this.properties = properties;
        logger.info(module, method, "", "end");
    }

    @Override
    public SJbaseParamater authenticate() throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "authenticate";
        logger.info(module, method, "", "srart");
        if (this.userId == null || this.userId.length() == 0) {
            logger.error(module, method, "check the user id", "invalid");
            throw new SJbaseExAuthenticationException();
        }
        if (this.password == null) {
            logger.error(module, method, "check the password", "invalid");
            throw new SJbaseExAuthenticationException();
        }
        this.ldapConfAry = new SJbaseLdapConfigurationFactory(this.properties).getConfigurations();
        if (this.ldapConfAry == null) {
            logger.error(module, method, "check the configuration objectes", "invalid");
            SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
            et.setErrCode(9999);
            throw et;
        }
        String[] hostList = null;
        for (int i = 0; i < this.ldapConfAry.length; ++i) {
            SJbaseLdapConfiguration tmpConf = this.ldapConfAry[i];
            logger.info(module, method, "start the authentication process", "server :[" + i + "]");
            try {
                if (tmpConf.getDnsLookup().equalsIgnoreCase("true")) {
                    hostList = new SJbaseSrvRecord(tmpConf.getProtocol(), tmpConf.getDomainName()).getServerList();
                    for (int j = 0; j < hostList.length; ++j) {
                        String[] tmpList = hostList[j].split(",");
                        tmpConf.setPort(Integer.parseInt(tmpList[2]));
                        tmpConf.setHost(tmpList[3].substring(0, tmpList[3].length() - 1));
                        try {
                            SJbaseParamater paramater = this.authenticate(tmpConf);
                            logger.info(module, method, "authenticate the user", "succeeded, server :[" + i + "]");
                            logger.info(module, method, "", "end");
                            return paramater;
                        }
                        catch (SJbaseExCommunicationException e) {
                            logger.error(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                            continue;
                        }
                    }
                    continue;
                }
                try {
                    logger.info(module, method, "", "unuse dns look up");
                    SJbaseParamater paramater = this.authenticate(tmpConf);
                    return paramater;
                }
                catch (SJbaseExCommunicationException e) {
                    logger.error(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                    continue;
                }
            }
            catch (SJbaseExAuthenticationException e) {
                logger.error(module, method, "authenticate the user", "failed, server :[" + i + "]", e);
                throw e;
            }
        }
        logger.error(module, method, "authentication the user", "failed at all servers");
        throw new SJbaseExCommunicationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SJbaseParamater authenticate(SJbaseLdapConfiguration ldapConf) throws SJbaseExAuthenticationException, SJbaseExCommunicationException {
        String method = "authenticate";
        logger.info(module, method, "", "start");
        int timeoutCount = -1;
        int retryTimes = ldapConf.getRetryTimes();
        int retryInterval = ldapConf.getRetryInterval();
        do {
            logger.info(module, method, "start the authentication process", "retry times :" + Integer.toString(timeoutCount + 1));
            if (ldapConf.getServerErrCode() == 10) {
                logger.error(module, method, "check the configuration object", "invalid");
                SJbaseExAuthenticationException et = new SJbaseExAuthenticationException();
                et.setErrCode(9999);
                throw et;
            }
            SJbaseLdapLoginModuleThread ldapModuleThread = null;
            try {
                ldapModuleThread = new SJbaseLdapLoginModuleThread(ldapConf, this.userId, this.password);
                ldapModuleThread.setDaemon(true);
                ldapModuleThread.start();
                try {
                    int timeout = ldapConf.getTimeout();
                    if (timeout == 0) {
                        logger.info(module, method, "set timeout", Integer.toString(120));
                        ldapModuleThread.join(120000L);
                    } else {
                        logger.info(module, method, "set timeout", Integer.toString(timeout));
                        ldapModuleThread.join(timeout * 1000);
                    }
                }
                catch (InterruptedException e) {
                    logger.error(module, method, "", "interrupted", e);
                }
                if (ldapModuleThread.isAlive()) {
                    logger.error(module, method, "", "no response from the server -timeout");
                    throw new SJbaseExCommunicationException();
                }
                SJbaseExternalAccountInfo account = ldapModuleThread.getAuthenticationResult();
                SJbaseParamater paramater = new SJbaseParamater(account);
                paramater.setLdapConf(ldapConf);
                logger.info(module, method, "authenticate the user", "succeeded");
                logger.info(module, method, "", "end");
                SJbaseParamater e = paramater;
                return e;
            }
            catch (SJbaseExCommunicationException e) {
                logger.error(module, method, "failed in the authentication process", "retry times :" + Integer.toString(timeoutCount + 1));
                if (++timeoutCount >= retryTimes) continue;
                try {
                    Thread.sleep(retryInterval * 1000);
                }
                catch (InterruptedException ie) {
                    logger.info(module, method, "", "interrupted", e);
                }
            }
            finally {
                if (ldapModuleThread != null) {
                    ldapModuleThread = null;
                }
            }
        } while (timeoutCount < retryTimes);
        logger.error(module, method, "authenticate the user", "failed scheduled times");
        throw new SJbaseExCommunicationException();
    }
}

