/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.base.session;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import sanproject.sn2.base.SJbaseConst;
import sanproject.sn2.base.session.SJbaseUserSessionManager;
import sanproject.sn2.base.session.exception.SJbaseSessionInitRequestSystemException;
import sanproject.sn2.base.session.exception.SJbaseSessionInitUserDirException;
import sanproject.sn2.base.session.exception.SJbaseSessionInterruptedException;
import sanproject.sn2.base.session.exception.SJbaseSessionMemoryOverException;
import sanproject.sn2.base.session.exception.SJbaseSessionRequestSystemNotFoundException;
import sanproject.sn2.base.session.exception.SJbaseUserSessionFinalizeException;
import sanproject.sn2.base.session.inf.SJbaseUserCtrInterface;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterfaceInternal;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.plugin.SJcPluginItem;
import sanproject.sn2.com.plugin.SJcPluginList;
import sanproject.sn2.com.utility.Logger.inf.SJcAuditLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcCustomLoggerInterface;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcEnvUty;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.com.utility.SJcInstanceCreateUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.SJcSingletonManagerUty;
import sanproject.sn2.com.utility.SJcSystemUty;
import sanproject.sn2.com.utility.SJcWordUty;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.guidance.inf.SJcGuidanceHandleInterface;
import sanproject.sn2.com.utility.message.inf.SJcMessageHandleInterface;
import sanproject.sn2.controller.com.data.SJctrRequestDataObject;

public class SJbaseUserSession
implements SJbaseUserSessionInterfaceInternal,
HttpSessionBindingListener {
    private final String LOG_FUNCTION = "SessionManager";
    private final String LOG_TITLE = this.getClass().getSimpleName();
    private static final String REQ_KEY_STANDBY = "Standby";
    private String languageType;
    private String userName;
    private String userID;
    private String password;
    private String sessionID;
    private long loginTime;
    private long logoutTime;
    private long lastAccessTime;
    private InetAddress address;
    private HttpSession tomcatSession;
    private String loginType;
    private HashMap<String, Object> m_userInfoMap = null;
    private SJcRoleResourceContainer roleResourceInfo;
    private String[] groupIDs;
    private String authSystemName;
    private String userUniqID;
    private SJctrRequestDataObject requestDataObject;
    private SJcCustomLoggerInterface logger;
    private SJcGuidanceHandleInterface guidanceInf = null;
    private SJcMessageHandleInterface messageInf = null;
    private String userDataPath;
    private String userUniqDirPath;
    private String userSessionPath;
    private String userSessionDirPath;
    private String userSessionUniqDirPath;
    private HashMap<String, SJbaseUserCtrInterface> requestSystemMap = new HashMap();
    private List<String> requestSystemNameList = new ArrayList<String>();
    private long limitMemSizePost;
    private List<String> userFileList = new ArrayList<String>();
    private String reqSystemFileName;
    private boolean finished = false;
    private SJcLoggerInterface stdLogger = SJcLogUty.getLogger();
    private SJcAuditLoggerInterface adtLogger = null;
    private int sessionIdentificationID;

    @Override
    public String getLanguageType() {
        return this.languageType;
    }

    @Override
    public void setLanguageType(String lang) {
        this.languageType = lang;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    @Override
    public HttpSession getHttpSession() {
        return this.tomcatSession;
    }

    @Override
    public void setHttpSession(HttpSession session) {
        this.tomcatSession = session;
    }

    @Override
    public SJcRoleResourceContainer getRoleResourceInfo() {
        return this.roleResourceInfo;
    }

    @Override
    public void setRoleResourceInfo(SJcRoleResourceContainer roleRsrcContainer) {
        this.roleResourceInfo = roleRsrcContainer;
    }

    @Override
    public String[] getGroupID() {
        return this.groupIDs;
    }

    @Override
    public void setGroupID(String[] groupIDs) {
        if (groupIDs != null) {
            this.groupIDs = new String[groupIDs.length];
            System.arraycopy(groupIDs, 0, this.groupIDs, 0, groupIDs.length);
        } else {
            this.groupIDs = null;
        }
    }

    @Override
    public void setAuthSystemName(String authSystemName) {
        this.authSystemName = authSystemName;
    }

    @Override
    public void setUserUniqID(String uniqID) {
        this.userUniqID = uniqID;
    }

    @Override
    public String getUserUniqID() {
        return this.userUniqID;
    }

    @Override
    public void setRequestDataObject(SJctrRequestDataObject dataObject) {
        this.requestDataObject = dataObject;
    }

    @Override
    public long getLoginTime() {
        return this.loginTime;
    }

    @Override
    public void setLoginTime(long loginTime) {
        this.loginTime = loginTime;
    }

    @Override
    public void setLogoutTime(long logoutTime) {
        this.logoutTime = logoutTime;
    }

    @Override
    public void setLastAccessTime(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public SJcAuditLoggerInterface getAuditLogger() {
        return this.adtLogger;
    }

    @Override
    public void setAuditLogger(SJcAuditLoggerInterface adtLogger) {
        this.adtLogger = adtLogger;
    }

    @Override
    public void initialize() throws SJcException {
        String LOG_SUBTITLE = "initialize";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initialize", "Start.");
        try {
            this.initEnvironment();
            this.makeUserDirectory();
            this.initRequestSystems();
            SJbaseUserSessionManager man = this.getUserSessionManager();
            if (null == man) {
                this.finish_InitializeFaild();
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "initialize", "SJbaseUserSessionManager is null");
                return;
            }
            String GlobalID = man.getUserSessionkey(this.sessionID);
            this.tomcatSession.setAttribute(GlobalID, (Object)this);
            this.initLogger();
        }
        catch (SJcException sjex) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "initialize", "Failed to initialize. - sessionID:" + this.sessionID, sjex);
            this.finish_InitializeFaild();
            throw sjex;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initialize", "End.");
    }

    @Override
    public void initializeForRegularBackup() throws SJcException {
        String LOG_SUBTITLE = "initializeForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initializeForRegularBackup", "Start.");
        try {
            this.initEnvironment();
            this.makeUserDirectory();
            this.initRequestSystems();
            SJbaseUserSessionManager man = this.getUserSessionManager();
            if (null == man) {
                this.finish_InitializeFaildForRegularBackup();
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "initializeForRegularBackup", "SJbaseUserSessionManager is null");
                return;
            }
            this.initLogger();
        }
        catch (SJcException sjex) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "initializeForRegularBackup", "Failed to initializeForRegularBackup. - sessionID:" + this.sessionID, sjex);
            this.finish_InitializeFaildForRegularBackup();
            throw sjex;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initializeForRegularBackup", "End.");
    }

    private void finish_InitializeFaild() {
        String LOG_SUBTITLE = "finish_LoginFaild";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaild", "Start. - sessionID:" + this.sessionID);
        SJbaseUserSessionManager man = this.getUserSessionManager();
        if (null == man) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaild", "SJbaseUserSessionManager is null");
        } else {
            try {
                String GlobalID = man.getUserSessionkey(this.sessionID);
                this.tomcatSession.removeAttribute(GlobalID);
            }
            catch (IllegalStateException e) {
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaild", "The user session has already been deleted.");
            }
        }
        ListIterator<String> iterator = this.requestSystemNameList.listIterator(this.requestSystemNameList.size());
        while (iterator.hasPrevious()) {
            String systemKey = iterator.previous();
            SJbaseUserCtrInterface system = this.requestSystemMap.get(systemKey);
            try {
                system.finish();
            }
            catch (Throwable ex) {
                this.stdLogger.warn("SessionManager", this.LOG_TITLE, "finish_LoginFaild", "Failed to finish system. - sessionID:" + this.sessionID, ex);
            }
        }
        try {
            SJcFileUty.deleteFile(this.userSessionPath, this.sessionID);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "finish_LoginFaild", "Failed to clear user session directory. - sessionID:" + this.sessionID, e);
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaild", "End.");
    }

    private void finish_InitializeFaildForRegularBackup() {
        String LOG_SUBTITLE = "finish_LoginFaildForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaildForRegularBackup", "Start. - sessionID:" + this.sessionID);
        SJbaseUserSessionManager man = this.getUserSessionManager();
        if (null == man) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaildForRegularBackup", "SJbaseUserSessionManager is null");
        }
        ListIterator<String> iterator = this.requestSystemNameList.listIterator(this.requestSystemNameList.size());
        while (iterator.hasPrevious()) {
            String systemKey = iterator.previous();
            SJbaseUserCtrInterface system = this.requestSystemMap.get(systemKey);
            try {
                system.finish();
            }
            catch (Throwable ex) {
                this.stdLogger.warn("SessionManager", this.LOG_TITLE, "finish_LoginFaildForRegularBackup", "Failed to finish system. - sessionID:" + this.sessionID, ex);
            }
        }
        try {
            SJcFileUty.deleteFile(this.userSessionPath, this.sessionID);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "finish_LoginFaildForRegularBackup", "Failed to clear user session directory. - sessionID:" + this.sessionID, e);
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish_LoginFaildForRegularBackup", "End.");
    }

    @Override
    public synchronized void finish() throws SJcException {
        String LOG_SUBTITLE = "finish";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "Start. - sessionID:" + this.sessionID);
        if (this.finished) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "End. (*** Already done finish process ***)");
            return;
        }
        SJbaseUserSessionManager man = this.getUserSessionManager();
        if (null == man) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "SJbaseUserSessionManager is null");
            return;
        }
        try {
            String GlobalID = man.getUserSessionkey(this.sessionID);
            this.tomcatSession.removeAttribute(GlobalID);
        }
        catch (IllegalStateException e) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "The user session has already been deleted.");
        }
        try {
            String lastResponseKey = man.getLastResponseKey(this.sessionID);
            this.tomcatSession.removeAttribute(lastResponseKey);
        }
        catch (IllegalStateException e) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "The last response key has already been deleted.");
        }
        try {
            String threadMapKey = man.getThreadMapKey(this.sessionID);
            this.tomcatSession.removeAttribute(threadMapKey);
        }
        catch (IllegalStateException e) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "The thread map key has already been deleted.");
        }
        ListIterator<String> iterator = this.requestSystemNameList.listIterator(this.requestSystemNameList.size());
        while (iterator.hasPrevious()) {
            String systemKey = iterator.previous();
            SJbaseUserCtrInterface system = this.requestSystemMap.get(systemKey);
            try {
                system.finish();
            }
            catch (Throwable ex) {
                this.stdLogger.warn("SessionManager", this.LOG_TITLE, "finish", "Failed to finish system. - sessionID:" + this.sessionID, ex);
            }
        }
        try {
            if (SJcFileUty.exists(this.userSessionUniqDirPath) && SJcFileUty.exists(this.userUniqDirPath)) {
                String[] flist = SJcFileUty.getFileList(this.userSessionUniqDirPath);
                for (int i = 0; i < flist.length; ++i) {
                    String fname = flist[i];
                    if (SJcFileUty.getFileSize(this.userSessionUniqDirPath, fname) > 0L) {
                        SJcFileUty.copyFile(this.userSessionUniqDirPath, fname, this.userUniqDirPath, fname);
                        continue;
                    }
                    SJcFileUty.deleteFile(this.userUniqDirPath, fname);
                }
            }
            SJcFileUty.deleteFile(this.userSessionPath, this.sessionID);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "finish", "Failed to clear user session directory. - sessionID:" + this.sessionID, e);
            throw new SJbaseUserSessionFinalizeException("107043");
        }
        finally {
            this.finished = true;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finish", "End.");
    }

    @Override
    public synchronized void finishForRegularBackup() throws SJcException {
        String LOG_SUBTITLE = "finishForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finishForRegularBackup", "Start. - sessionID:" + this.sessionID);
        if (this.finished) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finishForRegularBackup", "End. (*** Already done finish process ***)");
            return;
        }
        SJbaseUserSessionManager man = this.getUserSessionManager();
        if (null == man) {
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "finishForRegularBackup", "SJbaseUserSessionManager is null");
            return;
        }
        ListIterator<String> iterator = this.requestSystemNameList.listIterator(this.requestSystemNameList.size());
        while (iterator.hasPrevious()) {
            String systemKey = iterator.previous();
            SJbaseUserCtrInterface system = this.requestSystemMap.get(systemKey);
            try {
                system.finish();
            }
            catch (Throwable ex) {
                this.stdLogger.warn("SessionManager", this.LOG_TITLE, "finishForRegularBackup", "Failed to finish system. - sessionID:" + this.sessionID, ex);
            }
        }
        try {
            if (SJcFileUty.exists(this.userSessionUniqDirPath) && SJcFileUty.exists(this.userUniqDirPath)) {
                String[] flist = SJcFileUty.getFileList(this.userSessionUniqDirPath);
                for (int i = 0; i < flist.length; ++i) {
                    String fname = flist[i];
                    if (SJcFileUty.getFileSize(this.userSessionUniqDirPath, fname) > 0L) {
                        SJcFileUty.copyFile(this.userSessionUniqDirPath, fname, this.userUniqDirPath, fname);
                        continue;
                    }
                    SJcFileUty.deleteFile(this.userUniqDirPath, fname);
                }
            }
            SJcFileUty.deleteFile(this.userSessionPath, this.sessionID);
        }
        catch (Exception e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "finishForRegularBackup", "Failed to clear user session directory. - sessionID:" + this.sessionID, e);
            throw new SJbaseUserSessionFinalizeException("107043");
        }
        finally {
            this.finished = true;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "finishForRegularBackup", "End.");
    }

    @Override
    public void logout() {
        String LOG_SUBTITLE = "logout";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logout", "Start.");
        SJbaseUserSessionManager man = this.getUserSessionManager();
        if (null != man) {
            try {
                man.logout(this.sessionID);
            }
            catch (SJcException sjex) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "logout", "Failed to logout. - sessionID:" + this.sessionID, sjex);
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logout", "End.");
    }

    @Override
    public void logoutForRegularBackup() {
        String LOG_SUBTITLE = "logoutForRegularBackup";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutForRegularBackup", "Start.");
        SJbaseUserSessionManager man = this.getUserSessionManager();
        if (null != man) {
            try {
                man.logoutForRegularBackup(this.sessionID);
            }
            catch (SJcException sjex) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "logoutForRegularBackup", "Failed to logout. - sessionID:" + this.sessionID, sjex);
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "logoutForRegularBackup", "End.");
    }

    @Override
    public void alive() {
        long currentTime = System.nanoTime() / 1000000L;
        this.setLastAccessTime(currentTime);
    }

    @Override
    public SJcGuidanceHandleInterface getGuidanceInfo() {
        if (null == this.guidanceInf) {
            this.guidanceInf = SJcWordUty.getGuidanceInfo(this.languageType);
        }
        return this.guidanceInf;
    }

    @Override
    public SJcMessageHandleInterface getMessageInfo() {
        if (null == this.messageInf) {
            this.messageInf = SJcWordUty.getMessageInfo(this.languageType);
        }
        return this.messageInf;
    }

    @Override
    public Serializable getUserProperty(String key) {
        String LOG_SUBTITLE = "getUserProperty";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserProperty", "Start. - key:" + key);
        Serializable ret = null;
        String filename = key.toLowerCase();
        try {
            String filePath = SJcFileUty.concatFolderPath(this.userSessionUniqDirPath, filename);
            if (SJcFileUty.exists(filePath)) {
                ret = SJcFileUty.loadSerialize(this.userSessionUniqDirPath, filename);
            } else {
                ret = SJcFileUty.loadSerialize(this.userUniqDirPath, filename);
                SJcFileUty.copyFile(this.userUniqDirPath, filename, this.userSessionUniqDirPath, filename);
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "getUserProperty", "load user property and copy it to sessionDir. - filename:" + filename);
            }
        }
        catch (SJcException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "getUserProperty", "Failed to load user property. - filename:" + filename);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserProperty", "End. - return:" + ret);
        return ret;
    }

    @Override
    public String getUserPropertyText(String key) {
        String LOG_SUBTITLE = "getUserPropertyText";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserPropertyText", "Start. - key:" + key);
        String ret = null;
        String filename = key.toLowerCase();
        try {
            String filePath = SJcFileUty.concatFolderPath(this.userSessionUniqDirPath, filename);
            if (SJcFileUty.exists(filePath)) {
                ret = SJcFileUty.loadText(this.userSessionUniqDirPath, filename);
            } else {
                ret = SJcFileUty.loadText(this.userUniqDirPath, filename);
                SJcFileUty.copyFile(this.userUniqDirPath, filename, this.userSessionUniqDirPath, filename);
                this.stdLogger.info("SessionManager", this.LOG_TITLE, "getUserPropertyText", "load user property and copy it to sessionDir. - filename:" + filename);
            }
        }
        catch (SJcException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "getUserPropertyText", "Failed to load user property. - filename:" + filename);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserPropertyText", "End. - return:" + ret);
        return ret;
    }

    @Override
    public void setUserProperty(String key, Serializable obj) {
        String LOG_SUBTITLE = "setUserProperty";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setUserProperty", "Start. - key:" + key);
        String filename = key.toLowerCase();
        try {
            if (obj == null) {
                SJcFileUty.saveText(this.userSessionUniqDirPath, filename, "");
            } else {
                SJcFileUty.saveSerialize(this.userSessionUniqDirPath, filename, obj);
            }
        }
        catch (SJcException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "setUserProperty", "Failed to save user property. - filename:" + filename);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setUserProperty", "End.");
    }

    @Override
    public void setUserPropertyText(String key, String text) {
        String LOG_SUBTITLE = "setUserPropertyText";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setUserPropertyText", "Start. - key:" + key);
        String filename = key.toLowerCase();
        try {
            if (text == null) {
                SJcFileUty.saveText(this.userSessionUniqDirPath, filename, "");
            } else {
                SJcFileUty.saveText(this.userSessionUniqDirPath, filename, text);
            }
        }
        catch (SJcException e) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "setUserPropertyText", "Failed to save user property. - filename:" + filename);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setUserPropertyText", "End.");
    }

    @Override
    public SJctrRequestDataObject getStartInfo4Client() throws SJcException {
        return this.requestDataObject;
    }

    @Override
    public SJctrRequestDataObject post(SJctrRequestDataObject dataObj) throws Exception {
        String LOG_SUBTITLE = "post";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "post", "Start. - dataObj:" + dataObj);
        SJctrRequestDataObject ret = this.post(REQ_KEY_STANDBY, dataObj);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "post", "End. - return:" + ret);
        return ret;
    }

    @Override
    public SJctrRequestDataObject post(String key, SJctrRequestDataObject dataObj) throws Exception {
        long freeMemSize;
        String LOG_SUBTITLE = "post";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "post", "Start. - key:" + key);
        SJctrRequestDataObject ret = null;
        if (this.finished) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "post", "End. (*** Already done finish process ***)");
            throw new SJbaseSessionInterruptedException("107102");
        }
        if (this.limitMemSizePost > -1L && this.limitMemSizePost >= (freeMemSize = SJcSystemUty.getFreeMemory())) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "post", "Not enough free memory:" + freeMemSize + "=<" + this.limitMemSizePost);
            throw new SJbaseSessionMemoryOverException("107048");
        }
        String getkey = key;
        if (!this.requestSystemMap.containsKey(getkey)) {
            this.stdLogger.trace("SessionManager", this.LOG_TITLE, "post", "Not found specified request sytem:" + getkey);
            getkey = REQ_KEY_STANDBY;
            if (!this.requestSystemMap.containsKey(getkey)) {
                this.stdLogger.warn("SessionManager", this.LOG_TITLE, "post", "Not found standby request sytem.");
                throw new SJbaseSessionRequestSystemNotFoundException("107049");
            }
        }
        SJbaseUserCtrInterface system = this.requestSystemMap.get(getkey);
        this.alive();
        ret = system.post(dataObj);
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "post", "End.");
        return ret;
    }

    @Override
    public SJcLoggerInterface getLogger() {
        return this.stdLogger;
    }

    @Override
    public void putLog4Client(String log, int level) {
        this.logger.putLog(log, level);
    }

    public void valueBound(HttpSessionBindingEvent httpsessionbindingevent) {
        String LOG_SUBTITLE = "valueBound";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "valueBound", "Start. - httpsessionbindingevent:" + httpsessionbindingevent);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "valueBound", "End.");
    }

    public void valueUnbound(HttpSessionBindingEvent httpsessionbindingevent) {
        String LOG_SUBTITLE = "valueUnbound";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "valueUnbound", "Start. - httpsessionbindingevent:" + httpsessionbindingevent);
        Thread worker = new Thread(){

            @Override
            public void run() {
                SJbaseUserSession.this.stdLogger.info("SessionManager", SJbaseUserSession.this.LOG_TITLE, "valueUnbound", "[TomcatUnbound][LogoutThread] Start.");
                SJbaseUserSession.this.logout();
                SJbaseUserSession.this.stdLogger.info("SessionManager", SJbaseUserSession.this.LOG_TITLE, "valueUnbound", "[TomcatUnbound][LogoutThread] End.");
            }
        };
        worker.start();
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "valueUnbound", "End.");
    }

    private void initEnvironment() {
        String LOG_SUBTITLE = "initEnvironment";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "Start.");
        this.userDataPath = SJbaseConst.SN_DIRECTORY_BASE_USERDATA;
        this.userUniqDirPath = SJcFileUty.concatFolderPath(this.userDataPath, this.userUniqID);
        this.userSessionPath = SJbaseConst.SN_DIRECTORY_BASE_TMP_USERSESSION;
        this.userSessionDirPath = SJcFileUty.concatFolderPath(this.userSessionPath, this.sessionID);
        this.userSessionUniqDirPath = SJcFileUty.concatFolderPath(this.userSessionDirPath, "param");
        String key = "SN_Base_LimitMemPost";
        String val = SJcEnvUty.getProperty(key);
        if (null != val) {
            try {
                this.limitMemSizePost = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_UserRequestSystemFile";
        val = SJcEnvUty.getProperty(key);
        if (null != val) {
            this.reqSystemFileName = val;
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        key = "SN_Base_CopyUserFileList";
        val = SJcEnvUty.getProperty(key);
        if (null != val && !val.trim().equals("")) {
            String[] list = val.split(",");
            for (int i = 0; i < list.length; ++i) {
                this.userFileList.add(list[i].trim());
            }
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "initEnvironment", key + ":" + val);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "initEnvironment", "End.");
    }

    private void makeUserDirectory() throws SJcException {
        block8: {
            String LOG_SUBTITLE = "makeUserDirectory";
            this.stdLogger.trace("SessionManager", this.LOG_TITLE, "makeUserDirectory", "Start.");
            try {
                if (!SJcFileUty.exists(this.userSessionDirPath)) {
                    boolean result = SJcFileUty.makeDirectory(this.userSessionDirPath);
                    if (result) {
                        result = SJcFileUty.makeDirectory(this.userSessionUniqDirPath);
                    }
                    if (!result) {
                        this.stdLogger.error("SessionManager", this.LOG_TITLE, "makeUserDirectory", "Failed to make usersession direcotry:" + this.userSessionDirPath + "," + this.userSessionUniqDirPath);
                        throw new SJbaseSessionInitUserDirException("107044");
                    }
                    ListIterator<String> iterator = this.userFileList.listIterator();
                    while (iterator.hasNext()) {
                        String file = iterator.next();
                        String filePath = SJcFileUty.concatFolderPath(this.userUniqDirPath, file);
                        if (SJcFileUty.exists(filePath)) {
                            SJcFileUty.copyFile(this.userUniqDirPath, file, this.userSessionUniqDirPath, file);
                            continue;
                        }
                        this.stdLogger.error("SessionManager", this.LOG_TITLE, "makeUserDirectory", "Not found user file:" + file);
                    }
                    break block8;
                }
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "makeUserDirectory", "Already user session directory:" + this.userSessionDirPath);
                throw new SJbaseSessionInitUserDirException("107045");
            }
            catch (SJbaseSessionInitUserDirException ex) {
                throw ex;
            }
            catch (SJcException sjex) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "makeUserDirectory", "Failed to make user directory.");
                throw new SJbaseSessionInitUserDirException(sjex, "107044");
            }
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "makeUserDirectory", "End.");
    }

    private void initRequestSystems() throws SJcException {
        String LOG_SUBTITLE = "initRequestSystems";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "initRequestSystems", "Start.");
        String dataPath = SJcFileUty.concatFolderPath(SJcEnvUty.getProperty("SN_DataPath"), "data");
        String systemPath = SJcFileUty.concatFolderPath(dataPath, SJbaseConst.SN_DIRECTORY_BASE_SETTING_SYSTEM);
        String filePath = SJcFileUty.concatFolderPath(systemPath, this.reqSystemFileName);
        SJcPluginList pluginList = new SJcPluginList();
        pluginList.loadFile(filePath);
        this.checkRequestSystems(pluginList);
        ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJcPluginItem item = null;
            try {
                item = iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "initRequestSystems", "Item class is invald.", cce);
                continue;
            }
            if (item == null || item.getClassName() == null) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "initRequestSystems", "Item class is invald.");
                continue;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(item.getClassName());
            }
            catch (ClassNotFoundException cnfe) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "initRequestSystems", "Class is not found.", cnfe);
                continue;
            }
            SJbaseUserCtrInterface reqSystem = null;
            try {
                reqSystem = (SJbaseUserCtrInterface)SJcInstanceCreateUty.newInstance(clazz);
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "initRequestSystems", "Class is invalid. - class:" + clazz, cce);
                continue;
            }
            try {
                reqSystem.initialize(this);
                this.requestSystemMap.put(item.getKey(), reqSystem);
                this.requestSystemNameList.add(item.getKey());
            }
            catch (Throwable e) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "initRequestSystems", "Failed to initialize request system. item:" + item.getKey(), e);
            }
        }
        if (!this.requestSystemMap.containsKey(REQ_KEY_STANDBY)) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "initRequestSystems", "Failed to initialize standby request system.");
            throw new SJbaseSessionInitRequestSystemException("107046");
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "initRequestSystems", "End.");
    }

    private void checkRequestSystems(SJcPluginList pluginList) throws SJcException {
        String LOG_SUBTITLE = "checkRequestSystems";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkRequestSystems", "Start.");
        boolean standby = false;
        ListIterator<SJcPluginItem> iterator = pluginList.getPluginList().listIterator();
        while (iterator.hasNext()) {
            SJcPluginItem item = null;
            try {
                item = iterator.next();
            }
            catch (ClassCastException cce) {
                this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkRequestSystems", "Item class is invald.", cce);
                continue;
            }
            if (!item.getKey().equals(REQ_KEY_STANDBY)) continue;
            standby = true;
        }
        if (!standby) {
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "checkRequestSystems", "Invalid request system setting. [standby:" + standby + "]");
            throw new SJbaseSessionInitRequestSystemException("107046");
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "checkRequestSystems", "End.");
    }

    private void initLogger() {
        String LOG_SUBTITLE = "initLogger";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "initLogger", "Start.");
        this.stdLogger.setUserInfo(this.getUserName(), this.getSessionID());
        this.logger = SJcLogUty.getClientLogger();
        if (this.logger != null) {
            this.logger.setUserInfo(this.getUserName(), this.getSessionID());
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "initLogger", "End.");
    }

    private SJbaseUserSessionManager getUserSessionManager() {
        SJbaseUserSessionManager man = null;
        try {
            man = (SJbaseUserSessionManager)SJcSingletonManagerUty.getInstance(SJbaseUserSessionManager.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return man;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        String LOG_SUBTITLE = "finalize";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "finalize", "Called.");
    }

    @Override
    public SJbaseUserCtrInterface getUserController() {
        String LOG_SUBTITLE = "getUserController";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserController", "Start.");
        SJbaseUserCtrInterface ret = null;
        String key = REQ_KEY_STANDBY;
        if (!this.requestSystemMap.containsKey(key)) {
            this.stdLogger.warn("SessionManager", this.LOG_TITLE, "getUserController", "Not found standby request sytem.");
            key = null;
        }
        if (key != null) {
            ret = this.requestSystemMap.get(key);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserController", "End. - return:" + ret);
        return ret;
    }

    @Override
    public SJbaseUserCtrInterface getUserController(String key) {
        String LOG_SUBTITLE = "getUserController";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserController", "Start. - key:" + key);
        SJbaseUserCtrInterface ret = null;
        if (!this.requestSystemMap.containsKey(key)) {
            this.stdLogger.warn("SessionManager", this.LOG_TITLE, "getUserController", "Not found request sytem. - key:" + key);
            ret = null;
        } else {
            ret = this.requestSystemMap.get(key);
        }
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserController", "End. - return:" + ret);
        return ret;
    }

    @Override
    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    @Override
    public String getLoginType() {
        return this.loginType;
    }

    @Override
    public HashMap<String, Object> getAuthObject() {
        String LOG_SUBTITLE = "getAuthObject";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getAuthObject", "Start.");
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getAuthObject", "End.");
        return this.m_userInfoMap;
    }

    @Override
    public String getUserID() {
        String LOG_SUBTITLE = "getUserID";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserID", "Start. - userID:" + this.userID);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getUserID", "End. - userID:" + this.userID);
        return this.userID;
    }

    @Override
    public void setAuthObject(HashMap<String, Object> infoMap) {
        String LOG_SUBTITLE = "setAuthObject";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setAuthObject", "Start.");
        this.m_userInfoMap = infoMap;
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setAuthObject", "End.");
    }

    @Override
    public void setUserID(String userID) {
        String LOG_SUBTITLE = "setUserID";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setUserID", "Start. - userID:" + userID);
        this.userID = userID;
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setUserID", "End. - this.userID:" + this.userID);
    }

    @Override
    public void setSessionIdentificationID(int sessionIdentificationID) {
        String LOG_SUBTITLE = "setSessionIdentificationID";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setSessionIdentificationID", "Start. - sessionIdentificationID:" + sessionIdentificationID);
        this.sessionIdentificationID = sessionIdentificationID;
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "setSessionIdentificationID", "End. - this.sessionIdentificationID:" + this.sessionIdentificationID);
    }

    @Override
    public Integer getSessionIdentificationID() {
        String LOG_SUBTITLE = "getSessionIdentificationID";
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getSessionIdentificationID", "Start. - sessionIdentificationID:" + this.sessionIdentificationID);
        this.stdLogger.trace("SessionManager", this.LOG_TITLE, "getSessionIdentificationID", "End. - this.sessionIdentificationID:" + this.sessionIdentificationID);
        return this.sessionIdentificationID;
    }

    @Override
    public boolean resetUserProperty(String key) {
        String LOG_SUBTITLE = "resetUserProperty";
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "resetUserProperty", "Start. - key:" + key);
        boolean rtnResult = false;
        if (key == null) {
            rtnResult = false;
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "resetUserProperty", "Parameter is null.");
            this.stdLogger.info("SessionManager", this.LOG_TITLE, "resetUserProperty", "End. - " + rtnResult);
            return rtnResult;
        }
        String filename = key.toLowerCase();
        String initialFilePath = SJcFileUty.setEndPathSeparator(SJbaseConst.SN_DIRECTORY_BASE_USERDATA_INIT) + filename;
        try {
            if (SJcFileUty.exists(initialFilePath)) {
                SJcFileUty.copyFile("", initialFilePath, this.userSessionUniqDirPath, filename);
            } else {
                this.setUserProperty(key, null);
            }
            rtnResult = true;
        }
        catch (SJcException e) {
            rtnResult = false;
            this.stdLogger.error("SessionManager", this.LOG_TITLE, "resetUserProperty", "Failed to reset user property. - filename:" + filename);
        }
        this.stdLogger.info("SessionManager", this.LOG_TITLE, "resetUserProperty", "End. - " + rtnResult);
        return rtnResult;
    }
}

