/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sanproject.sn2.com.utility.Logger.inf.SJcLoggerInterface;
import sanproject.sn2.com.utility.SJcLogUty;

public class SJcInstanceCreateUty {
    private static final String LOG_FUNCTION = "InstanceCreate";
    private static final String LOG_TITLE = "SJcInstanceCreateUty";

    public static Object newInstance(String name) {
        String LOG_SUBTYTLE = "newInstance";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "Start.");
        if (name == null || name.equals("")) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "Parameter is null.");
            return null;
        }
        Object result = null;
        try {
            Class<?> compo = Class.forName(name);
            result = SJcInstanceCreateUty.newInstance(compo);
        }
        catch (ClassNotFoundException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "ClassNotFoundException.", ex);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "End.");
        return result;
    }

    public static Object newInstance(Class<?> compo) {
        String LOG_SUBTYTLE = "newInstance";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "Start.");
        if (compo == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "Parameter is null.");
            return null;
        }
        Object result = null;
        try {
            result = compo.newInstance();
            STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "New Instance : " + compo.getName());
        }
        catch (IllegalAccessException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "IllegalAccessException.", ex);
        }
        catch (InstantiationException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "InstantiationException.", ex);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "End.");
        return result;
    }

    public static Object newInstance(String name, Class<?>[] constType, Object[] constParam) {
        String LOG_SUBTYTLE = "newInstance";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "Start.");
        if (name == null || constType == null || constParam == null || name.equals("")) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "Parameter is null.");
            return null;
        }
        Object result = null;
        try {
            Class<?> compo = Class.forName(name);
            result = SJcInstanceCreateUty.newInstance(compo, constType, constParam);
        }
        catch (ClassNotFoundException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "ClassNotFoundException.", ex);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "End.");
        return result;
    }

    public static Object newInstance(Class<?> compo, Class<?>[] constType, Object[] constParam) {
        String LOG_SUBTYTLE = "newInstance";
        SJcLoggerInterface STD_LOGGER = SJcLogUty.getLogger();
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "Start.");
        if (compo == null || constType == null || constParam == null) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "Parameter is null.");
            return null;
        }
        Object result = null;
        try {
            Constructor<?> c = compo.getConstructor(constType);
            result = c.newInstance(constParam);
        }
        catch (NoSuchMethodException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "NoSuchMethodException.", ex);
        }
        catch (IllegalAccessException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "IllegalAccessException.", ex);
        }
        catch (InstantiationException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "InstantiationException.", ex);
        }
        catch (InvocationTargetException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "InvocationTargetException.", ex);
        }
        catch (IllegalArgumentException ex) {
            STD_LOGGER.error(LOG_FUNCTION, LOG_TITLE, "newInstance", "IllegalArgumentException.", ex);
        }
        STD_LOGGER.trace(LOG_FUNCTION, LOG_TITLE, "newInstance", "End.");
        return result;
    }
}

