/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility;

import java.util.ArrayList;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.SJcAccountChkUty;
import sanproject.sn2.com.utility.SJcBitSetUty;
import sanproject.sn2.com.utility.SJcLogUty;
import sanproject.sn2.com.utility.account.SJcAccountFileGroupInfo;
import sanproject.sn2.com.utility.account.SJcAccountFileRoleInfo;
import sanproject.sn2.com.utility.account.SJcRoleInfoContainer;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.com.utility.account.SJcUserGroupInfoContainer;
import sanproject.sn2.com.utility.account.exception.SJcFailDataException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundGroupException;
import sanproject.sn2.com.utility.account.exception.SJcNotFoundRoleException;

public class SJcUserGroupInfoUty {
    private static final String LOG_FUNCTION = "SJcUserGroupInfoUty";
    private static final String LOG_TITLE = "SJcUserGroupInfoUty";
    private static String szMsg;

    private SJcUserGroupInfoUty() {
    }

    public static synchronized void createUserGroup(String szGrpName, String[] szRoleName, int[] iRsrcGpID, boolean bAllRsrc, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "createUserGroup";
        try {
            szMsg = "Start. <Key = " + szGrpName + ">";
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "createUserGroup", szMsg);
            SJcAccountChkUty.chkGrpName(szGrpName);
            SJcAccountChkUty.chkRoleName(szRoleName);
            if (iRsrcGpID != null) {
                for (int i = 0; i < iRsrcGpID.length; ++i) {
                    SJcAccountChkUty.chkRsrcGpID(iRsrcGpID[i]);
                }
            }
            SJcAccountFileGroupInfo.createUserGroup(szGrpName, szRoleName, iRsrcGpID, bAllRsrc, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "createUserGroup", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "createUserGroup", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "createUserGroup", "End.");
        }
    }

    public static synchronized void setUserGroupName(String szNowGrpName, String szNewGrpName, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setUserGroupName";
        try {
            szMsg = "Start. <Key = " + szNowGrpName + ">";
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupName", szMsg);
            SJcAccountChkUty.chkGrpName(szNowGrpName);
            SJcAccountChkUty.chkGrpName(szNewGrpName);
            SJcAccountFileGroupInfo.setUserGroupName(szNowGrpName, szNewGrpName, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupName", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupName", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupName", "End.");
        }
    }

    public static synchronized void setUserGroupRole(String szGrpName, String[] szRoleName, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setUserGroupRole";
        try {
            szMsg = "Start. <Key = " + szGrpName + ">";
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupRole", szMsg);
            SJcAccountChkUty.chkGrpName(szGrpName);
            SJcAccountChkUty.chkRoleName(szRoleName);
            SJcAccountFileGroupInfo.setUserGroupRole(szGrpName, szRoleName, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupRole", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupRole", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupRole", "End.");
        }
    }

    public static synchronized void setUserGroupResourceGrpMap(String szGrpName, int[] iRsrcGpID, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setUserGroupResourceGrpMap";
        try {
            szMsg = "Start. <Key = " + szGrpName + ">";
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupResourceGrpMap", szMsg);
            SJcAccountChkUty.chkGrpName(szGrpName);
            if (iRsrcGpID != null) {
                for (int i = 0; i < iRsrcGpID.length; ++i) {
                    SJcAccountChkUty.chkRsrcGpID(iRsrcGpID[i]);
                }
            }
            SJcAccountFileGroupInfo.setUserGroupResourceGrpMap(szGrpName, iRsrcGpID, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupResourceGrpMap", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupResourceGrpMap", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupResourceGrpMap", "End.");
        }
    }

    public static synchronized void setUserGroupAllResourceGrp(String szGrpName, boolean bAllRsrc, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "setUserGroupAllResourceGrp";
        try {
            szMsg = "Start. <Key = " + szGrpName + ">";
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupAllResourceGrp", szMsg);
            SJcAccountChkUty.chkGrpName(szGrpName);
            SJcAccountFileGroupInfo.setUserGroupAllResourceGrp(szGrpName, bAllRsrc, lRscLockID);
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupAllResourceGrp", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupAllResourceGrp", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "setUserGroupAllResourceGrp", "End.");
        }
    }

    public static synchronized void deleteUserGroup(String[] szGrpName, long lRscLockID) throws SJcException {
        String LOG_SUBTITLE = "deleteUserGroup";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szGrpName) + ">";
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "deleteUserGroup", szMsg);
            SJcAccountChkUty.chkEmptyException(szGrpName);
            SJcAccountFileGroupInfo.deleteUserGroup(szGrpName, lRscLockID);
        }
        catch (SJcFailDataException e) {
            Object[] szFail = e.getFailData();
            szMsg = "<Key = " + SJcAccountChkUty.chgArray2Str(szFail) + ">";
            SJcLogUty.getLogger().warn("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "deleteUserGroup", szMsg);
            SJcLogUty.getLogger().warn("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "deleteUserGroup", "SJcFailDataException.", e);
            throw e;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "deleteUserGroup", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "deleteUserGroup", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().info("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "deleteUserGroup", "End.");
        }
    }

    public static String[] getUserGroupList() throws SJcException {
        String LOG_SUBTITLE = "getUserGroupList";
        try {
            String[] szRet;
            szMsg = "Start.";
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupList", szMsg);
            String[] stringArray = szRet = SJcAccountFileGroupInfo.getUserGroupList();
            return stringArray;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupList", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupList", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupList", "End.");
        }
    }

    public static SJcUserGroupInfoContainer[] getUserGroupInfo(String[] szGrpName) throws SJcException {
        String LOG_SUBTITLE = "getUserGroupInfo";
        try {
            SJcUserGroupInfoContainer[] clsRet;
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szGrpName) + ">";
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupInfo", szMsg);
            SJcAccountChkUty.chkEmptyException(szGrpName);
            SJcUserGroupInfoContainer[] sJcUserGroupInfoContainerArray = clsRet = SJcAccountFileGroupInfo.getUserGroupInfo(szGrpName);
            return sJcUserGroupInfoContainerArray;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupInfo", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupInfo", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupInfo", "End.");
        }
    }

    public static ArrayList<String[]> getUserInUserGroup(String[] szGrpName) throws SJcException {
        String LOG_SUBTITLE = "getUserInUserGroup";
        try {
            ArrayList<String[]> alRet;
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szGrpName) + ">";
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserInUserGroup", szMsg);
            SJcAccountChkUty.chkEmptyException(szGrpName);
            ArrayList<String[]> arrayList = alRet = SJcAccountFileGroupInfo.getUserInUserGroup(szGrpName);
            return arrayList;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserInUserGroup", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserInUserGroup", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserInUserGroup", "End.");
        }
    }

    public static SJcRoleResourceContainer getUserGroupObject(String[] szGrpName) throws SJcException {
        String LOG_SUBTITLE = "getUserGroupObject";
        try {
            szMsg = "Start. <Key = " + SJcAccountChkUty.chgArray2Str(szGrpName) + ">";
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupObject", szMsg);
            SJcAccountChkUty.chkEmptyException(szGrpName);
            SJcRoleResourceContainer clsRet = new SJcRoleResourceContainer(szGrpName.length);
            boolean[] bAllOrRsrc = new boolean[1024];
            SJcUserGroupInfoContainer[] clsData = SJcAccountFileGroupInfo.getUserGroupInfo(szGrpName);
            SJcAccountFileRoleInfo clsRoleFile = new SJcAccountFileRoleInfo();
            clsRoleFile.read();
            String szAuthBit_All = "";
            for (int i = 0; i < szGrpName.length; ++i) {
                SJcAccountChkUty.chkGrpName(szGrpName[i]);
                if (clsData[i] == null) {
                    throw new SJcNotFoundGroupException();
                }
                clsRet.setGrpName(i, szGrpName[i]);
                String[] szRoleName = clsData[i].getRoleName();
                if (SJcAccountChkUty.chkEmpty(szRoleName)) {
                    SJcRoleInfoContainer[] clsRole = clsRoleFile.getRoleInfoData(szRoleName);
                    String szBitmap = "";
                    for (int j = 0; j < clsRole.length; ++j) {
                        if (clsRole[j] == null) {
                            throw new SJcNotFoundRoleException();
                        }
                        szBitmap = SJcAccountChkUty.getOrStr(szBitmap, clsRole[j].getBitmap());
                    }
                    if (SJcAccountChkUty.chkEmpty(szBitmap)) {
                        clsRet.setAuthBit(i, szBitmap);
                    }
                    szAuthBit_All = SJcAccountChkUty.getOrStr(szAuthBit_All, szBitmap);
                }
                boolean[] bRsrcMap = clsData[i].getRsrcGroupMap();
                clsRet.setRsrcMap(i, clsData[i].getRsrcGroupMap());
                bAllOrRsrc = SJcAccountChkUty.getOrBool(bAllOrRsrc, bRsrcMap);
                clsRet.setAllRsrcFlg(clsData[i].getAllRsrcGroup());
            }
            if (SJcAccountChkUty.chkEmpty(szAuthBit_All)) {
                clsRet.setAllAuthBit(szAuthBit_All);
            }
            clsRet.setAllRsrcMap(bAllOrRsrc);
            SJcRoleResourceContainer sJcRoleResourceContainer = clsRet;
            return sJcRoleResourceContainer;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupObject", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupObject", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getUserGroupObject", "End.");
        }
    }

    public static SJcRoleResourceContainer getRoleResourceObject(String[] szRoleName, boolean[] bRsrcMap, boolean allRsg) throws SJcException {
        String LOG_SUBTITLE = "getRoleResourceObject";
        try {
            szMsg = "Start. <Key = Role:" + SJcAccountChkUty.chgArray2Str(szRoleName) + " RSG:" + SJcBitSetUty.booolean2bitset(bRsrcMap).toString() + ">";
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getRoleResourceObject", szMsg);
            SJcAccountChkUty.chkEmptyException(szRoleName);
            SJcRoleResourceContainer clsRet = new SJcRoleResourceContainer(1);
            boolean[] bAllOrRsrc = new boolean[1024];
            SJcAccountFileRoleInfo clsRoleFile = new SJcAccountFileRoleInfo();
            clsRoleFile.read();
            clsRet.setGrpName(0, "");
            String szAuthBit_All = "";
            if (SJcAccountChkUty.chkEmpty(szRoleName)) {
                SJcRoleInfoContainer[] clsRole = clsRoleFile.getRoleInfoData(szRoleName);
                String szBitmap = "";
                for (int j = 0; j < clsRole.length; ++j) {
                    if (clsRole[j] == null) {
                        throw new SJcNotFoundRoleException();
                    }
                    szBitmap = SJcAccountChkUty.getOrStr(szBitmap, clsRole[j].getBitmap());
                }
                if (SJcAccountChkUty.chkEmpty(szBitmap)) {
                    clsRet.setAuthBit(0, szBitmap);
                }
                szAuthBit_All = SJcAccountChkUty.getOrStr(szAuthBit_All, szBitmap);
            }
            if (allRsg) {
                bRsrcMap = new boolean[bRsrcMap.length];
                for (int i = 0; i < bRsrcMap.length; ++i) {
                    bRsrcMap[i] = true;
                }
            }
            clsRet.setRsrcMap(0, bRsrcMap);
            bAllOrRsrc = SJcAccountChkUty.getOrBool(bAllOrRsrc, bRsrcMap);
            clsRet.setAllRsrcFlg(allRsg);
            if (SJcAccountChkUty.chkEmpty(szAuthBit_All)) {
                clsRet.setAllAuthBit(szAuthBit_All);
            }
            clsRet.setAllRsrcMap(bAllOrRsrc);
            SJcRoleResourceContainer sJcRoleResourceContainer = clsRet;
            return sJcRoleResourceContainer;
        }
        catch (SJcException e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getRoleResourceObject", "SJcException.", e);
            throw e;
        }
        catch (Exception e) {
            SJcLogUty.getLogger().error("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getRoleResourceObject", "Exception.", e);
            throw new SJcException();
        }
        finally {
            SJcLogUty.getLogger().debug("SJcUserGroupInfoUty", "SJcUserGroupInfoUty", "getRoleResourceObject", "End.");
        }
    }

    @Deprecated
    public static synchronized void createUserGroup(String szGrpName, String[] szRoleName, int[] iRsrcGpID, boolean bAllRsrc) throws SJcException {
    }

    @Deprecated
    public static synchronized void setUserGroupName(String szNowGrpName, String szNewGrpName) throws SJcException {
    }

    @Deprecated
    public static synchronized void setUserGroupRole(String szGrpName, String[] szRoleName) throws SJcException {
    }

    @Deprecated
    public static synchronized void setUserGroupResourceGrpMap(String szGrpName, int[] iRsrcGpID) throws SJcException {
    }

    @Deprecated
    public static synchronized void setUserGroupAllResourceGrp(String szGrpName, boolean bAllRsrc) throws SJcException {
    }

    @Deprecated
    public static synchronized void deleteUserGroup(String[] szGrpName) throws SJcException {
    }

    @Deprecated
    public static boolean isExistGroup(String szGroupName) throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isMaximumGroup() throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isExistBuildinGroup(String[] szGroupName) throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isTypeBuildin(String szGroupName) throws SJcException {
        return false;
    }

    @Deprecated
    public static boolean isTypeUser(String szGroupName) throws SJcException {
        return false;
    }
}

