/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.com.utility.fileuty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sanproject.sn2.com.utility.fileuty.SJcFileUtyMemFile;
import sanproject.sn2.com.utility.fileuty.inf.SJcFileInterface;

public class SJcFileOnMemory
implements SJcFileInterface {
    static final long serialVersionUID = 0L;
    private String path;
    private HashMap<String, SJcFileUtyMemFile> memFileMap;

    public SJcFileOnMemory(String path, HashMap<String, SJcFileUtyMemFile> memFileMap) {
        this.path = path;
        this.memFileMap = memFileMap;
    }

    @Override
    public String getFilename() {
        String ret = this.path.substring(this.path.lastIndexOf(SJcFileInterface.separator) + 1, this.path.length());
        return ret;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public long getLength() {
        int ret = 0;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            ret = memFile.getDataLength();
        }
        return ret;
    }

    @Override
    public boolean createNewFile() throws IOException {
        String parentPath;
        boolean ret = false;
        SJcFileUtyMemFile target = this.getMemFile(this.path);
        if (null == target && null != (parentPath = SJcFileOnMemory.getParentPath(this.path))) {
            SJcFileUtyMemFile memFile = this.getMemFile(parentPath);
            if (null == memFile) {
                SJcFileOnMemory parentDir = new SJcFileOnMemory(parentPath, this.memFileMap);
                if (!parentDir.mkdirs()) {
                    return false;
                }
                memFile = this.getMemFile(parentPath);
            }
            if (memFile.isDirectory()) {
                SJcFileUtyMemFile file = new SJcFileUtyMemFile(this.path, memFile, false);
                memFile.addChild(file);
                memFile.setLastModifiedNow();
                String key = this.path.toUpperCase();
                this.memFileMap.put(key, file);
                ret = true;
            }
        }
        return ret;
    }

    @Override
    public boolean delete() {
        boolean ret = false;
        SJcFileUtyMemFile target = this.getMemFile(this.path);
        if (null != target && target.getChildren().size() == 0) {
            target.getParent().removeChild(target);
            target.getParent().setLastModifiedNow();
            String key = this.path.toUpperCase();
            this.memFileMap.remove(key);
            ret = true;
        }
        return ret;
    }

    @Override
    public void deleteAll() {
        this.deleteContainsAll(this);
    }

    private void deleteContainsAll(SJcFileOnMemory file) {
        if (null == file) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            SJcFileInterface[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.deleteContainsAll((SJcFileOnMemory)files[i]);
            }
            file.delete();
        }
    }

    @Override
    public boolean equals(Object obj) {
        boolean ret = false;
        if (obj instanceof SJcFileOnMemory && this.path != null) {
            ret = this.path.toUpperCase().equals(((SJcFileOnMemory)obj).path.toUpperCase());
        }
        return ret;
    }

    @Override
    public boolean exists() {
        boolean ret = false;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            ret = true;
        }
        return ret;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        InputStream ret = null;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null == memFile) {
            throw new FileNotFoundException(this.path);
        }
        ret = memFile.getInputStream();
        return ret;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        OutputStream ret = null;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null == memFile) {
            boolean result = false;
            SJcFileOnMemory file = new SJcFileOnMemory(this.path, this.memFileMap);
            try {
                result = file.createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!result) {
                throw new FileNotFoundException(this.path);
            }
            memFile = this.getMemFile(this.path);
        }
        ret = memFile.getOutputStream();
        return ret;
    }

    @Override
    public boolean isDirectory() {
        boolean ret = false;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            ret = memFile.isDirectory();
        }
        return ret;
    }

    @Override
    public boolean isFile() {
        boolean ret = false;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            ret = !memFile.isDirectory();
        }
        return ret;
    }

    @Override
    public SJcFileInterface getParent() {
        SJcFileOnMemory ret = null;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            SJcFileUtyMemFile parentMemFile = memFile.getParent();
            if (null != parentMemFile) {
                String parentPath = parentMemFile.getOriginalFilePath();
                ret = new SJcFileOnMemory(parentPath, this.memFileMap);
            }
        } else {
            String parentPath = SJcFileOnMemory.getParentPath(this.path);
            ret = new SJcFileOnMemory(parentPath, this.memFileMap);
        }
        return ret;
    }

    @Override
    public long lastModified() {
        long ret = 0L;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            ret = memFile.getLastModified();
        }
        return ret;
    }

    @Override
    public SJcFileInterface[] listFiles() {
        SJcFileInterface[] ret = null;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            List<SJcFileUtyMemFile> childMemFileList = memFile.getChildren();
            if (null != childMemFileList) {
                ret = new SJcFileInterface[childMemFileList.size()];
                ListIterator<SJcFileUtyMemFile> iterator = childMemFileList.listIterator();
                int index = 0;
                while (iterator.hasNext()) {
                    SJcFileUtyMemFile childMemFile = iterator.next();
                    String childPath = childMemFile.getOriginalFilePath();
                    SJcFileOnMemory child = new SJcFileOnMemory(childPath, this.memFileMap);
                    ret[index] = child;
                    ++index;
                }
            } else {
                ret = new SJcFileInterface[]{};
            }
        }
        return ret;
    }

    @Override
    public boolean mkdir() {
        SJcFileUtyMemFile memFile;
        String parentPath;
        boolean ret = false;
        SJcFileUtyMemFile target = this.getMemFile(this.path);
        if (null == target && null != (parentPath = SJcFileOnMemory.getParentPath(this.path)) && null != (memFile = this.getMemFile(parentPath)) && memFile.isDirectory()) {
            SJcFileUtyMemFile dir = new SJcFileUtyMemFile(this.path, memFile, true);
            memFile.addChild(dir);
            memFile.setLastModifiedNow();
            String key = this.path.toUpperCase();
            this.memFileMap.put(key, dir);
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean mkdirs() {
        boolean ret = false;
        String[] dirs = this.path.split("\\" + SJcFileInterface.separator);
        String wkPath = "";
        for (int i = 0; i < dirs.length; ++i) {
            wkPath = 0 == i ? dirs[i] : wkPath + SJcFileInterface.separator + dirs[i];
            String key = wkPath.toUpperCase();
            if (!this.memFileMap.containsKey(key)) {
                SJcFileOnMemory parent = new SJcFileOnMemory(wkPath, this.memFileMap);
                parent.mkdir();
                if (i != dirs.length - 1) continue;
                ret = true;
                continue;
            }
            SJcFileUtyMemFile memFile = this.memFileMap.get(key);
            if (!memFile.isDirectory()) break;
        }
        return ret;
    }

    @Override
    public boolean renameTo(String newName) {
        boolean ret = false;
        if (!this.path.equals(newName)) {
            String oldParentPath = SJcFileOnMemory.getParentPath(this.path);
            String newParentPath = SJcFileOnMemory.getParentPath(newName);
            if (null != oldParentPath && null != newParentPath && oldParentPath.equals(newParentPath)) {
                SJcFileUtyMemFile parent;
                SJcFileUtyMemFile target = this.getMemFile(this.path);
                SJcFileUtyMemFile newTarget = this.getMemFile(newName);
                if (null != target && null == newTarget && target.getChildren().size() == 0 && null != (parent = this.getMemFile(oldParentPath))) {
                    parent.removeChild(target);
                    String targetKey = this.path.toUpperCase();
                    this.memFileMap.remove(targetKey);
                    target.setOriginalFilePath(newName);
                    parent.addChild(target);
                    parent.setLastModifiedNow();
                    String newTargetKey = newName.toUpperCase();
                    this.memFileMap.put(newTargetKey, target);
                    ret = true;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean setLastModified(long timeInMillis) {
        boolean ret = false;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            memFile.setLastModified(timeInMillis);
            ret = true;
        }
        return ret;
    }

    @Override
    public byte[] readBytes(int offset, int length) throws FileNotFoundException, IOException {
        byte[] data;
        byte[] ret = null;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null != memFile) {
            data = memFile.getData();
            if (length + offset > data.length) {
                throw new IOException();
            }
        } else {
            throw new FileNotFoundException();
        }
        ret = new byte[length];
        System.arraycopy(data, offset, ret, 0, length);
        return ret;
    }

    @Override
    public void writeBytes(byte[] data, int offset) throws FileNotFoundException, IOException {
        byte[] src;
        int endpos;
        SJcFileUtyMemFile memFile = this.getMemFile(this.path);
        if (null == memFile) {
            boolean ret = this.createNewFile();
            if (!ret) {
                throw new IOException();
            }
            memFile = this.getMemFile(this.path);
        }
        int count = (endpos = offset + data.length) > (src = memFile.getData()).length ? endpos : src.length;
        byte[] dest = new byte[count];
        System.arraycopy(src, 0, dest, 0, src.length);
        System.arraycopy(data, 0, dest, offset, data.length);
        memFile.setData(dest);
    }

    private SJcFileUtyMemFile getMemFile(String filepath) {
        SJcFileUtyMemFile ret = null;
        String key = filepath.toUpperCase();
        if (this.memFileMap.containsKey(key)) {
            ret = this.memFileMap.get(key);
        }
        return ret;
    }

    private static String getParentPath(String filepath) {
        int sepPoint = filepath.lastIndexOf(SJcFileInterface.separator);
        String parentPath = null;
        if (-1 != sepPoint) {
            parentPath = filepath.substring(0, sepPoint);
        }
        return parentPath;
    }

    @Override
    public boolean containPath(SJcFileInterface inf) {
        boolean ret = false;
        if (inf != null) {
            String ownPath = this.path.toUpperCase();
            String otherPath = inf.getPath().toUpperCase();
            ret = ownPath.contains(otherPath);
        }
        return ret;
    }
}

